/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.timestreaminfluxdb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.timestreaminfluxdb.model.DbInstanceType;
import software.amazon.awssdk.services.timestreaminfluxdb.model.DbStorageType;
import software.amazon.awssdk.services.timestreaminfluxdb.model.DeploymentType;
import software.amazon.awssdk.services.timestreaminfluxdb.model.InstanceMode;
import software.amazon.awssdk.services.timestreaminfluxdb.model.InstanceModeListCopier;
import software.amazon.awssdk.services.timestreaminfluxdb.model.LogDeliveryConfiguration;
import software.amazon.awssdk.services.timestreaminfluxdb.model.NetworkType;
import software.amazon.awssdk.services.timestreaminfluxdb.model.Status;
import software.amazon.awssdk.services.timestreaminfluxdb.model.TimestreamInfluxDbResponse;
import software.amazon.awssdk.services.timestreaminfluxdb.model.VpcSecurityGroupIdListCopier;
import software.amazon.awssdk.services.timestreaminfluxdb.model.VpcSubnetIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteDbInstanceResponse
extends TimestreamInfluxDbResponse
implements ToCopyableBuilder<Builder, DeleteDbInstanceResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(DeleteDbInstanceResponse.getter(DeleteDbInstanceResponse::id)).setter(DeleteDbInstanceResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(DeleteDbInstanceResponse.getter(DeleteDbInstanceResponse::name)).setter(DeleteDbInstanceResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(DeleteDbInstanceResponse.getter(DeleteDbInstanceResponse::arn)).setter(DeleteDbInstanceResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(DeleteDbInstanceResponse.getter(DeleteDbInstanceResponse::statusAsString)).setter(DeleteDbInstanceResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("endpoint").getter(DeleteDbInstanceResponse.getter(DeleteDbInstanceResponse::endpoint)).setter(DeleteDbInstanceResponse.setter(Builder::endpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpoint").build()}).build();
    private static final SdkField<Integer> PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("port").getter(DeleteDbInstanceResponse.getter(DeleteDbInstanceResponse::port)).setter(DeleteDbInstanceResponse.setter(Builder::port)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("port").build()}).build();
    private static final SdkField<String> NETWORK_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("networkType").getter(DeleteDbInstanceResponse.getter(DeleteDbInstanceResponse::networkTypeAsString)).setter(DeleteDbInstanceResponse.setter(Builder::networkType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkType").build()}).build();
    private static final SdkField<String> DB_INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dbInstanceType").getter(DeleteDbInstanceResponse.getter(DeleteDbInstanceResponse::dbInstanceTypeAsString)).setter(DeleteDbInstanceResponse.setter(Builder::dbInstanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbInstanceType").build()}).build();
    private static final SdkField<String> DB_STORAGE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dbStorageType").getter(DeleteDbInstanceResponse.getter(DeleteDbInstanceResponse::dbStorageTypeAsString)).setter(DeleteDbInstanceResponse.setter(Builder::dbStorageType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbStorageType").build()}).build();
    private static final SdkField<Integer> ALLOCATED_STORAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("allocatedStorage").getter(DeleteDbInstanceResponse.getter(DeleteDbInstanceResponse::allocatedStorage)).setter(DeleteDbInstanceResponse.setter(Builder::allocatedStorage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allocatedStorage").build()}).build();
    private static final SdkField<String> DEPLOYMENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("deploymentType").getter(DeleteDbInstanceResponse.getter(DeleteDbInstanceResponse::deploymentTypeAsString)).setter(DeleteDbInstanceResponse.setter(Builder::deploymentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentType").build()}).build();
    private static final SdkField<List<String>> VPC_SUBNET_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("vpcSubnetIds").getter(DeleteDbInstanceResponse.getter(DeleteDbInstanceResponse::vpcSubnetIds)).setter(DeleteDbInstanceResponse.setter(Builder::vpcSubnetIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcSubnetIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> PUBLICLY_ACCESSIBLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("publiclyAccessible").getter(DeleteDbInstanceResponse.getter(DeleteDbInstanceResponse::publiclyAccessible)).setter(DeleteDbInstanceResponse.setter(Builder::publiclyAccessible)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publiclyAccessible").build()}).build();
    private static final SdkField<List<String>> VPC_SECURITY_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("vpcSecurityGroupIds").getter(DeleteDbInstanceResponse.getter(DeleteDbInstanceResponse::vpcSecurityGroupIds)).setter(DeleteDbInstanceResponse.setter(Builder::vpcSecurityGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcSecurityGroupIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DB_PARAMETER_GROUP_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dbParameterGroupIdentifier").getter(DeleteDbInstanceResponse.getter(DeleteDbInstanceResponse::dbParameterGroupIdentifier)).setter(DeleteDbInstanceResponse.setter(Builder::dbParameterGroupIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbParameterGroupIdentifier").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("availabilityZone").getter(DeleteDbInstanceResponse.getter(DeleteDbInstanceResponse::availabilityZone)).setter(DeleteDbInstanceResponse.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZone").build()}).build();
    private static final SdkField<String> SECONDARY_AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("secondaryAvailabilityZone").getter(DeleteDbInstanceResponse.getter(DeleteDbInstanceResponse::secondaryAvailabilityZone)).setter(DeleteDbInstanceResponse.setter(Builder::secondaryAvailabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secondaryAvailabilityZone").build()}).build();
    private static final SdkField<LogDeliveryConfiguration> LOG_DELIVERY_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("logDeliveryConfiguration").getter(DeleteDbInstanceResponse.getter(DeleteDbInstanceResponse::logDeliveryConfiguration)).setter(DeleteDbInstanceResponse.setter(Builder::logDeliveryConfiguration)).constructor(LogDeliveryConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logDeliveryConfiguration").build()}).build();
    private static final SdkField<String> INFLUX_AUTH_PARAMETERS_SECRET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("influxAuthParametersSecretArn").getter(DeleteDbInstanceResponse.getter(DeleteDbInstanceResponse::influxAuthParametersSecretArn)).setter(DeleteDbInstanceResponse.setter(Builder::influxAuthParametersSecretArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("influxAuthParametersSecretArn").build()}).build();
    private static final SdkField<String> DB_CLUSTER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dbClusterId").getter(DeleteDbInstanceResponse.getter(DeleteDbInstanceResponse::dbClusterId)).setter(DeleteDbInstanceResponse.setter(Builder::dbClusterId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbClusterId").build()}).build();
    private static final SdkField<String> INSTANCE_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("instanceMode").getter(DeleteDbInstanceResponse.getter(DeleteDbInstanceResponse::instanceModeAsString)).setter(DeleteDbInstanceResponse.setter(Builder::instanceMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceMode").build()}).build();
    private static final SdkField<List<String>> INSTANCE_MODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("instanceModes").getter(DeleteDbInstanceResponse.getter(DeleteDbInstanceResponse::instanceModesAsStrings)).setter(DeleteDbInstanceResponse.setter(Builder::instanceModesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceModes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD, ARN_FIELD, STATUS_FIELD, ENDPOINT_FIELD, PORT_FIELD, NETWORK_TYPE_FIELD, DB_INSTANCE_TYPE_FIELD, DB_STORAGE_TYPE_FIELD, ALLOCATED_STORAGE_FIELD, DEPLOYMENT_TYPE_FIELD, VPC_SUBNET_IDS_FIELD, PUBLICLY_ACCESSIBLE_FIELD, VPC_SECURITY_GROUP_IDS_FIELD, DB_PARAMETER_GROUP_IDENTIFIER_FIELD, AVAILABILITY_ZONE_FIELD, SECONDARY_AVAILABILITY_ZONE_FIELD, LOG_DELIVERY_CONFIGURATION_FIELD, INFLUX_AUTH_PARAMETERS_SECRET_ARN_FIELD, DB_CLUSTER_ID_FIELD, INSTANCE_MODE_FIELD, INSTANCE_MODES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeleteDbInstanceResponse.memberNameToFieldInitializer();
    private final String id;
    private final String name;
    private final String arn;
    private final String status;
    private final String endpoint;
    private final Integer port;
    private final String networkType;
    private final String dbInstanceType;
    private final String dbStorageType;
    private final Integer allocatedStorage;
    private final String deploymentType;
    private final List<String> vpcSubnetIds;
    private final Boolean publiclyAccessible;
    private final List<String> vpcSecurityGroupIds;
    private final String dbParameterGroupIdentifier;
    private final String availabilityZone;
    private final String secondaryAvailabilityZone;
    private final LogDeliveryConfiguration logDeliveryConfiguration;
    private final String influxAuthParametersSecretArn;
    private final String dbClusterId;
    private final String instanceMode;
    private final List<String> instanceModes;

    private DeleteDbInstanceResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.name = builder.name;
        this.arn = builder.arn;
        this.status = builder.status;
        this.endpoint = builder.endpoint;
        this.port = builder.port;
        this.networkType = builder.networkType;
        this.dbInstanceType = builder.dbInstanceType;
        this.dbStorageType = builder.dbStorageType;
        this.allocatedStorage = builder.allocatedStorage;
        this.deploymentType = builder.deploymentType;
        this.vpcSubnetIds = builder.vpcSubnetIds;
        this.publiclyAccessible = builder.publiclyAccessible;
        this.vpcSecurityGroupIds = builder.vpcSecurityGroupIds;
        this.dbParameterGroupIdentifier = builder.dbParameterGroupIdentifier;
        this.availabilityZone = builder.availabilityZone;
        this.secondaryAvailabilityZone = builder.secondaryAvailabilityZone;
        this.logDeliveryConfiguration = builder.logDeliveryConfiguration;
        this.influxAuthParametersSecretArn = builder.influxAuthParametersSecretArn;
        this.dbClusterId = builder.dbClusterId;
        this.instanceMode = builder.instanceMode;
        this.instanceModes = builder.instanceModes;
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public final String arn() {
        return this.arn;
    }

    public final Status status() {
        return Status.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String endpoint() {
        return this.endpoint;
    }

    public final Integer port() {
        return this.port;
    }

    public final NetworkType networkType() {
        return NetworkType.fromValue(this.networkType);
    }

    public final String networkTypeAsString() {
        return this.networkType;
    }

    public final DbInstanceType dbInstanceType() {
        return DbInstanceType.fromValue(this.dbInstanceType);
    }

    public final String dbInstanceTypeAsString() {
        return this.dbInstanceType;
    }

    public final DbStorageType dbStorageType() {
        return DbStorageType.fromValue(this.dbStorageType);
    }

    public final String dbStorageTypeAsString() {
        return this.dbStorageType;
    }

    public final Integer allocatedStorage() {
        return this.allocatedStorage;
    }

    public final DeploymentType deploymentType() {
        return DeploymentType.fromValue(this.deploymentType);
    }

    public final String deploymentTypeAsString() {
        return this.deploymentType;
    }

    public final boolean hasVpcSubnetIds() {
        return this.vpcSubnetIds != null && !(this.vpcSubnetIds instanceof SdkAutoConstructList);
    }

    public final List<String> vpcSubnetIds() {
        return this.vpcSubnetIds;
    }

    public final Boolean publiclyAccessible() {
        return this.publiclyAccessible;
    }

    public final boolean hasVpcSecurityGroupIds() {
        return this.vpcSecurityGroupIds != null && !(this.vpcSecurityGroupIds instanceof SdkAutoConstructList);
    }

    public final List<String> vpcSecurityGroupIds() {
        return this.vpcSecurityGroupIds;
    }

    public final String dbParameterGroupIdentifier() {
        return this.dbParameterGroupIdentifier;
    }

    public final String availabilityZone() {
        return this.availabilityZone;
    }

    public final String secondaryAvailabilityZone() {
        return this.secondaryAvailabilityZone;
    }

    public final LogDeliveryConfiguration logDeliveryConfiguration() {
        return this.logDeliveryConfiguration;
    }

    public final String influxAuthParametersSecretArn() {
        return this.influxAuthParametersSecretArn;
    }

    public final String dbClusterId() {
        return this.dbClusterId;
    }

    public final InstanceMode instanceMode() {
        return InstanceMode.fromValue(this.instanceMode);
    }

    public final String instanceModeAsString() {
        return this.instanceMode;
    }

    public final List<InstanceMode> instanceModes() {
        return InstanceModeListCopier.copyStringToEnum(this.instanceModes);
    }

    public final boolean hasInstanceModes() {
        return this.instanceModes != null && !(this.instanceModes instanceof SdkAutoConstructList);
    }

    public final List<String> instanceModesAsStrings() {
        return this.instanceModes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbInstanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbStorageTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.allocatedStorage());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVpcSubnetIds() ? this.vpcSubnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.publiclyAccessible());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVpcSecurityGroupIds() ? this.vpcSecurityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dbParameterGroupIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.secondaryAvailabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.logDeliveryConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.influxAuthParametersSecretArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbClusterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstanceModes() ? this.instanceModesAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteDbInstanceResponse)) {
            return false;
        }
        DeleteDbInstanceResponse other = (DeleteDbInstanceResponse)((Object)obj);
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.endpoint(), other.endpoint()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.networkTypeAsString(), other.networkTypeAsString()) && Objects.equals(this.dbInstanceTypeAsString(), other.dbInstanceTypeAsString()) && Objects.equals(this.dbStorageTypeAsString(), other.dbStorageTypeAsString()) && Objects.equals(this.allocatedStorage(), other.allocatedStorage()) && Objects.equals(this.deploymentTypeAsString(), other.deploymentTypeAsString()) && this.hasVpcSubnetIds() == other.hasVpcSubnetIds() && Objects.equals(this.vpcSubnetIds(), other.vpcSubnetIds()) && Objects.equals(this.publiclyAccessible(), other.publiclyAccessible()) && this.hasVpcSecurityGroupIds() == other.hasVpcSecurityGroupIds() && Objects.equals(this.vpcSecurityGroupIds(), other.vpcSecurityGroupIds()) && Objects.equals(this.dbParameterGroupIdentifier(), other.dbParameterGroupIdentifier()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.secondaryAvailabilityZone(), other.secondaryAvailabilityZone()) && Objects.equals(this.logDeliveryConfiguration(), other.logDeliveryConfiguration()) && Objects.equals(this.influxAuthParametersSecretArn(), other.influxAuthParametersSecretArn()) && Objects.equals(this.dbClusterId(), other.dbClusterId()) && Objects.equals(this.instanceModeAsString(), other.instanceModeAsString()) && this.hasInstanceModes() == other.hasInstanceModes() && Objects.equals(this.instanceModesAsStrings(), other.instanceModesAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteDbInstanceResponse").add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("Arn", (Object)this.arn()).add("Status", (Object)this.statusAsString()).add("Endpoint", (Object)this.endpoint()).add("Port", (Object)this.port()).add("NetworkType", (Object)this.networkTypeAsString()).add("DbInstanceType", (Object)this.dbInstanceTypeAsString()).add("DbStorageType", (Object)this.dbStorageTypeAsString()).add("AllocatedStorage", (Object)this.allocatedStorage()).add("DeploymentType", (Object)this.deploymentTypeAsString()).add("VpcSubnetIds", this.hasVpcSubnetIds() ? this.vpcSubnetIds() : null).add("PubliclyAccessible", (Object)this.publiclyAccessible()).add("VpcSecurityGroupIds", this.hasVpcSecurityGroupIds() ? this.vpcSecurityGroupIds() : null).add("DbParameterGroupIdentifier", (Object)this.dbParameterGroupIdentifier()).add("AvailabilityZone", (Object)this.availabilityZone()).add("SecondaryAvailabilityZone", (Object)this.secondaryAvailabilityZone()).add("LogDeliveryConfiguration", (Object)this.logDeliveryConfiguration()).add("InfluxAuthParametersSecretArn", (Object)this.influxAuthParametersSecretArn()).add("DbClusterId", (Object)this.dbClusterId()).add("InstanceMode", (Object)this.instanceModeAsString()).add("InstanceModes", this.hasInstanceModes() ? this.instanceModesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "endpoint": {
                return Optional.ofNullable(clazz.cast(this.endpoint()));
            }
            case "port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "networkType": {
                return Optional.ofNullable(clazz.cast(this.networkTypeAsString()));
            }
            case "dbInstanceType": {
                return Optional.ofNullable(clazz.cast(this.dbInstanceTypeAsString()));
            }
            case "dbStorageType": {
                return Optional.ofNullable(clazz.cast(this.dbStorageTypeAsString()));
            }
            case "allocatedStorage": {
                return Optional.ofNullable(clazz.cast(this.allocatedStorage()));
            }
            case "deploymentType": {
                return Optional.ofNullable(clazz.cast(this.deploymentTypeAsString()));
            }
            case "vpcSubnetIds": {
                return Optional.ofNullable(clazz.cast(this.vpcSubnetIds()));
            }
            case "publiclyAccessible": {
                return Optional.ofNullable(clazz.cast(this.publiclyAccessible()));
            }
            case "vpcSecurityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.vpcSecurityGroupIds()));
            }
            case "dbParameterGroupIdentifier": {
                return Optional.ofNullable(clazz.cast(this.dbParameterGroupIdentifier()));
            }
            case "availabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "secondaryAvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.secondaryAvailabilityZone()));
            }
            case "logDeliveryConfiguration": {
                return Optional.ofNullable(clazz.cast(this.logDeliveryConfiguration()));
            }
            case "influxAuthParametersSecretArn": {
                return Optional.ofNullable(clazz.cast(this.influxAuthParametersSecretArn()));
            }
            case "dbClusterId": {
                return Optional.ofNullable(clazz.cast(this.dbClusterId()));
            }
            case "instanceMode": {
                return Optional.ofNullable(clazz.cast(this.instanceModeAsString()));
            }
            case "instanceModes": {
                return Optional.ofNullable(clazz.cast(this.instanceModesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("endpoint", ENDPOINT_FIELD);
        map.put("port", PORT_FIELD);
        map.put("networkType", NETWORK_TYPE_FIELD);
        map.put("dbInstanceType", DB_INSTANCE_TYPE_FIELD);
        map.put("dbStorageType", DB_STORAGE_TYPE_FIELD);
        map.put("allocatedStorage", ALLOCATED_STORAGE_FIELD);
        map.put("deploymentType", DEPLOYMENT_TYPE_FIELD);
        map.put("vpcSubnetIds", VPC_SUBNET_IDS_FIELD);
        map.put("publiclyAccessible", PUBLICLY_ACCESSIBLE_FIELD);
        map.put("vpcSecurityGroupIds", VPC_SECURITY_GROUP_IDS_FIELD);
        map.put("dbParameterGroupIdentifier", DB_PARAMETER_GROUP_IDENTIFIER_FIELD);
        map.put("availabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("secondaryAvailabilityZone", SECONDARY_AVAILABILITY_ZONE_FIELD);
        map.put("logDeliveryConfiguration", LOG_DELIVERY_CONFIGURATION_FIELD);
        map.put("influxAuthParametersSecretArn", INFLUX_AUTH_PARAMETERS_SECRET_ARN_FIELD);
        map.put("dbClusterId", DB_CLUSTER_ID_FIELD);
        map.put("instanceMode", INSTANCE_MODE_FIELD);
        map.put("instanceModes", INSTANCE_MODES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteDbInstanceResponse, T> g) {
        return obj -> g.apply((DeleteDbInstanceResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TimestreamInfluxDbResponse.BuilderImpl
    implements Builder {
        private String id;
        private String name;
        private String arn;
        private String status;
        private String endpoint;
        private Integer port;
        private String networkType;
        private String dbInstanceType;
        private String dbStorageType;
        private Integer allocatedStorage;
        private String deploymentType;
        private List<String> vpcSubnetIds = DefaultSdkAutoConstructList.getInstance();
        private Boolean publiclyAccessible;
        private List<String> vpcSecurityGroupIds = DefaultSdkAutoConstructList.getInstance();
        private String dbParameterGroupIdentifier;
        private String availabilityZone;
        private String secondaryAvailabilityZone;
        private LogDeliveryConfiguration logDeliveryConfiguration;
        private String influxAuthParametersSecretArn;
        private String dbClusterId;
        private String instanceMode;
        private List<String> instanceModes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteDbInstanceResponse model) {
            super(model);
            this.id(model.id);
            this.name(model.name);
            this.arn(model.arn);
            this.status(model.status);
            this.endpoint(model.endpoint);
            this.port(model.port);
            this.networkType(model.networkType);
            this.dbInstanceType(model.dbInstanceType);
            this.dbStorageType(model.dbStorageType);
            this.allocatedStorage(model.allocatedStorage);
            this.deploymentType(model.deploymentType);
            this.vpcSubnetIds(model.vpcSubnetIds);
            this.publiclyAccessible(model.publiclyAccessible);
            this.vpcSecurityGroupIds(model.vpcSecurityGroupIds);
            this.dbParameterGroupIdentifier(model.dbParameterGroupIdentifier);
            this.availabilityZone(model.availabilityZone);
            this.secondaryAvailabilityZone(model.secondaryAvailabilityZone);
            this.logDeliveryConfiguration(model.logDeliveryConfiguration);
            this.influxAuthParametersSecretArn(model.influxAuthParametersSecretArn);
            this.dbClusterId(model.dbClusterId);
            this.instanceMode(model.instanceMode);
            this.instanceModesWithStrings(model.instanceModes);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getEndpoint() {
            return this.endpoint;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        @Override
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final Integer getPort() {
            return this.port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getNetworkType() {
            return this.networkType;
        }

        public final void setNetworkType(String networkType) {
            this.networkType = networkType;
        }

        @Override
        public final Builder networkType(String networkType) {
            this.networkType = networkType;
            return this;
        }

        @Override
        public final Builder networkType(NetworkType networkType) {
            this.networkType(networkType == null ? null : networkType.toString());
            return this;
        }

        public final String getDbInstanceType() {
            return this.dbInstanceType;
        }

        public final void setDbInstanceType(String dbInstanceType) {
            this.dbInstanceType = dbInstanceType;
        }

        @Override
        public final Builder dbInstanceType(String dbInstanceType) {
            this.dbInstanceType = dbInstanceType;
            return this;
        }

        @Override
        public final Builder dbInstanceType(DbInstanceType dbInstanceType) {
            this.dbInstanceType(dbInstanceType == null ? null : dbInstanceType.toString());
            return this;
        }

        public final String getDbStorageType() {
            return this.dbStorageType;
        }

        public final void setDbStorageType(String dbStorageType) {
            this.dbStorageType = dbStorageType;
        }

        @Override
        public final Builder dbStorageType(String dbStorageType) {
            this.dbStorageType = dbStorageType;
            return this;
        }

        @Override
        public final Builder dbStorageType(DbStorageType dbStorageType) {
            this.dbStorageType(dbStorageType == null ? null : dbStorageType.toString());
            return this;
        }

        public final Integer getAllocatedStorage() {
            return this.allocatedStorage;
        }

        public final void setAllocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
        }

        @Override
        public final Builder allocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
            return this;
        }

        public final String getDeploymentType() {
            return this.deploymentType;
        }

        public final void setDeploymentType(String deploymentType) {
            this.deploymentType = deploymentType;
        }

        @Override
        public final Builder deploymentType(String deploymentType) {
            this.deploymentType = deploymentType;
            return this;
        }

        @Override
        public final Builder deploymentType(DeploymentType deploymentType) {
            this.deploymentType(deploymentType == null ? null : deploymentType.toString());
            return this;
        }

        public final Collection<String> getVpcSubnetIds() {
            if (this.vpcSubnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.vpcSubnetIds;
        }

        public final void setVpcSubnetIds(Collection<String> vpcSubnetIds) {
            this.vpcSubnetIds = VpcSubnetIdListCopier.copy(vpcSubnetIds);
        }

        @Override
        public final Builder vpcSubnetIds(Collection<String> vpcSubnetIds) {
            this.vpcSubnetIds = VpcSubnetIdListCopier.copy(vpcSubnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSubnetIds(String ... vpcSubnetIds) {
            this.vpcSubnetIds(Arrays.asList(vpcSubnetIds));
            return this;
        }

        public final Boolean getPubliclyAccessible() {
            return this.publiclyAccessible;
        }

        public final void setPubliclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
        }

        @Override
        public final Builder publiclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        public final Collection<String> getVpcSecurityGroupIds() {
            if (this.vpcSecurityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.vpcSecurityGroupIds;
        }

        public final void setVpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupIds);
        }

        @Override
        public final Builder vpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroupIds(String ... vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds(Arrays.asList(vpcSecurityGroupIds));
            return this;
        }

        public final String getDbParameterGroupIdentifier() {
            return this.dbParameterGroupIdentifier;
        }

        public final void setDbParameterGroupIdentifier(String dbParameterGroupIdentifier) {
            this.dbParameterGroupIdentifier = dbParameterGroupIdentifier;
        }

        @Override
        public final Builder dbParameterGroupIdentifier(String dbParameterGroupIdentifier) {
            this.dbParameterGroupIdentifier = dbParameterGroupIdentifier;
            return this;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final String getSecondaryAvailabilityZone() {
            return this.secondaryAvailabilityZone;
        }

        public final void setSecondaryAvailabilityZone(String secondaryAvailabilityZone) {
            this.secondaryAvailabilityZone = secondaryAvailabilityZone;
        }

        @Override
        public final Builder secondaryAvailabilityZone(String secondaryAvailabilityZone) {
            this.secondaryAvailabilityZone = secondaryAvailabilityZone;
            return this;
        }

        public final LogDeliveryConfiguration.Builder getLogDeliveryConfiguration() {
            return this.logDeliveryConfiguration != null ? this.logDeliveryConfiguration.toBuilder() : null;
        }

        public final void setLogDeliveryConfiguration(LogDeliveryConfiguration.BuilderImpl logDeliveryConfiguration) {
            this.logDeliveryConfiguration = logDeliveryConfiguration != null ? logDeliveryConfiguration.build() : null;
        }

        @Override
        public final Builder logDeliveryConfiguration(LogDeliveryConfiguration logDeliveryConfiguration) {
            this.logDeliveryConfiguration = logDeliveryConfiguration;
            return this;
        }

        public final String getInfluxAuthParametersSecretArn() {
            return this.influxAuthParametersSecretArn;
        }

        public final void setInfluxAuthParametersSecretArn(String influxAuthParametersSecretArn) {
            this.influxAuthParametersSecretArn = influxAuthParametersSecretArn;
        }

        @Override
        public final Builder influxAuthParametersSecretArn(String influxAuthParametersSecretArn) {
            this.influxAuthParametersSecretArn = influxAuthParametersSecretArn;
            return this;
        }

        public final String getDbClusterId() {
            return this.dbClusterId;
        }

        public final void setDbClusterId(String dbClusterId) {
            this.dbClusterId = dbClusterId;
        }

        @Override
        public final Builder dbClusterId(String dbClusterId) {
            this.dbClusterId = dbClusterId;
            return this;
        }

        public final String getInstanceMode() {
            return this.instanceMode;
        }

        public final void setInstanceMode(String instanceMode) {
            this.instanceMode = instanceMode;
        }

        @Override
        public final Builder instanceMode(String instanceMode) {
            this.instanceMode = instanceMode;
            return this;
        }

        @Override
        public final Builder instanceMode(InstanceMode instanceMode) {
            this.instanceMode(instanceMode == null ? null : instanceMode.toString());
            return this;
        }

        public final Collection<String> getInstanceModes() {
            if (this.instanceModes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.instanceModes;
        }

        public final void setInstanceModes(Collection<String> instanceModes) {
            this.instanceModes = InstanceModeListCopier.copy(instanceModes);
        }

        @Override
        public final Builder instanceModesWithStrings(Collection<String> instanceModes) {
            this.instanceModes = InstanceModeListCopier.copy(instanceModes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceModesWithStrings(String ... instanceModes) {
            this.instanceModesWithStrings(Arrays.asList(instanceModes));
            return this;
        }

        @Override
        public final Builder instanceModes(Collection<InstanceMode> instanceModes) {
            this.instanceModes = InstanceModeListCopier.copyEnumToString(instanceModes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceModes(InstanceMode ... instanceModes) {
            this.instanceModes(Arrays.asList(instanceModes));
            return this;
        }

        @Override
        public DeleteDbInstanceResponse build() {
            return new DeleteDbInstanceResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends TimestreamInfluxDbResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteDbInstanceResponse> {
        public Builder id(String var1);

        public Builder name(String var1);

        public Builder arn(String var1);

        public Builder status(String var1);

        public Builder status(Status var1);

        public Builder endpoint(String var1);

        public Builder port(Integer var1);

        public Builder networkType(String var1);

        public Builder networkType(NetworkType var1);

        public Builder dbInstanceType(String var1);

        public Builder dbInstanceType(DbInstanceType var1);

        public Builder dbStorageType(String var1);

        public Builder dbStorageType(DbStorageType var1);

        public Builder allocatedStorage(Integer var1);

        public Builder deploymentType(String var1);

        public Builder deploymentType(DeploymentType var1);

        public Builder vpcSubnetIds(Collection<String> var1);

        public Builder vpcSubnetIds(String ... var1);

        public Builder publiclyAccessible(Boolean var1);

        public Builder vpcSecurityGroupIds(Collection<String> var1);

        public Builder vpcSecurityGroupIds(String ... var1);

        public Builder dbParameterGroupIdentifier(String var1);

        public Builder availabilityZone(String var1);

        public Builder secondaryAvailabilityZone(String var1);

        public Builder logDeliveryConfiguration(LogDeliveryConfiguration var1);

        default public Builder logDeliveryConfiguration(Consumer<LogDeliveryConfiguration.Builder> logDeliveryConfiguration) {
            return this.logDeliveryConfiguration((LogDeliveryConfiguration)((LogDeliveryConfiguration.Builder)LogDeliveryConfiguration.builder().applyMutation(logDeliveryConfiguration)).build());
        }

        public Builder influxAuthParametersSecretArn(String var1);

        public Builder dbClusterId(String var1);

        public Builder instanceMode(String var1);

        public Builder instanceMode(InstanceMode var1);

        public Builder instanceModesWithStrings(Collection<String> var1);

        public Builder instanceModesWithStrings(String ... var1);

        public Builder instanceModes(Collection<InstanceMode> var1);

        public Builder instanceModes(InstanceMode ... var1);
    }
}

