/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.timestreaminfluxdb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * All the customer-modifiable InfluxDB v2 parameters in Timestream for InfluxDB.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InfluxDBv2Parameters implements SdkPojo, Serializable,
        ToCopyableBuilder<InfluxDBv2Parameters.Builder, InfluxDBv2Parameters> {
    private static final SdkField<Boolean> FLUX_LOG_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("fluxLogEnabled").getter(getter(InfluxDBv2Parameters::fluxLogEnabled))
            .setter(setter(Builder::fluxLogEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fluxLogEnabled").build()).build();

    private static final SdkField<String> LOG_LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("logLevel").getter(getter(InfluxDBv2Parameters::logLevelAsString)).setter(setter(Builder::logLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logLevel").build()).build();

    private static final SdkField<Boolean> NO_TASKS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("noTasks").getter(getter(InfluxDBv2Parameters::noTasks)).setter(setter(Builder::noTasks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("noTasks").build()).build();

    private static final SdkField<Integer> QUERY_CONCURRENCY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("queryConcurrency").getter(getter(InfluxDBv2Parameters::queryConcurrency))
            .setter(setter(Builder::queryConcurrency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryConcurrency").build()).build();

    private static final SdkField<Integer> QUERY_QUEUE_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("queryQueueSize").getter(getter(InfluxDBv2Parameters::queryQueueSize))
            .setter(setter(Builder::queryQueueSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryQueueSize").build()).build();

    private static final SdkField<String> TRACING_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("tracingType").getter(getter(InfluxDBv2Parameters::tracingTypeAsString))
            .setter(setter(Builder::tracingType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tracingType").build()).build();

    private static final SdkField<Boolean> METRICS_DISABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("metricsDisabled").getter(getter(InfluxDBv2Parameters::metricsDisabled))
            .setter(setter(Builder::metricsDisabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricsDisabled").build()).build();

    private static final SdkField<Duration> HTTP_IDLE_TIMEOUT_FIELD = SdkField.<Duration> builder(MarshallingType.SDK_POJO)
            .memberName("httpIdleTimeout").getter(getter(InfluxDBv2Parameters::httpIdleTimeout))
            .setter(setter(Builder::httpIdleTimeout)).constructor(Duration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("httpIdleTimeout").build()).build();

    private static final SdkField<Duration> HTTP_READ_HEADER_TIMEOUT_FIELD = SdkField
            .<Duration> builder(MarshallingType.SDK_POJO).memberName("httpReadHeaderTimeout")
            .getter(getter(InfluxDBv2Parameters::httpReadHeaderTimeout)).setter(setter(Builder::httpReadHeaderTimeout))
            .constructor(Duration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("httpReadHeaderTimeout").build())
            .build();

    private static final SdkField<Duration> HTTP_READ_TIMEOUT_FIELD = SdkField.<Duration> builder(MarshallingType.SDK_POJO)
            .memberName("httpReadTimeout").getter(getter(InfluxDBv2Parameters::httpReadTimeout))
            .setter(setter(Builder::httpReadTimeout)).constructor(Duration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("httpReadTimeout").build()).build();

    private static final SdkField<Duration> HTTP_WRITE_TIMEOUT_FIELD = SdkField.<Duration> builder(MarshallingType.SDK_POJO)
            .memberName("httpWriteTimeout").getter(getter(InfluxDBv2Parameters::httpWriteTimeout))
            .setter(setter(Builder::httpWriteTimeout)).constructor(Duration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("httpWriteTimeout").build()).build();

    private static final SdkField<Long> INFLUXQL_MAX_SELECT_BUCKETS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("influxqlMaxSelectBuckets").getter(getter(InfluxDBv2Parameters::influxqlMaxSelectBuckets))
            .setter(setter(Builder::influxqlMaxSelectBuckets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("influxqlMaxSelectBuckets").build())
            .build();

    private static final SdkField<Long> INFLUXQL_MAX_SELECT_POINT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("influxqlMaxSelectPoint").getter(getter(InfluxDBv2Parameters::influxqlMaxSelectPoint))
            .setter(setter(Builder::influxqlMaxSelectPoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("influxqlMaxSelectPoint").build())
            .build();

    private static final SdkField<Long> INFLUXQL_MAX_SELECT_SERIES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("influxqlMaxSelectSeries").getter(getter(InfluxDBv2Parameters::influxqlMaxSelectSeries))
            .setter(setter(Builder::influxqlMaxSelectSeries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("influxqlMaxSelectSeries").build())
            .build();

    private static final SdkField<Boolean> PPROF_DISABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("pprofDisabled").getter(getter(InfluxDBv2Parameters::pprofDisabled))
            .setter(setter(Builder::pprofDisabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pprofDisabled").build()).build();

    private static final SdkField<Long> QUERY_INITIAL_MEMORY_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("queryInitialMemoryBytes").getter(getter(InfluxDBv2Parameters::queryInitialMemoryBytes))
            .setter(setter(Builder::queryInitialMemoryBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryInitialMemoryBytes").build())
            .build();

    private static final SdkField<Long> QUERY_MAX_MEMORY_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("queryMaxMemoryBytes").getter(getter(InfluxDBv2Parameters::queryMaxMemoryBytes))
            .setter(setter(Builder::queryMaxMemoryBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryMaxMemoryBytes").build())
            .build();

    private static final SdkField<Long> QUERY_MEMORY_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("queryMemoryBytes").getter(getter(InfluxDBv2Parameters::queryMemoryBytes))
            .setter(setter(Builder::queryMemoryBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryMemoryBytes").build()).build();

    private static final SdkField<Integer> SESSION_LENGTH_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("sessionLength").getter(getter(InfluxDBv2Parameters::sessionLength))
            .setter(setter(Builder::sessionLength))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionLength").build()).build();

    private static final SdkField<Boolean> SESSION_RENEW_DISABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("sessionRenewDisabled").getter(getter(InfluxDBv2Parameters::sessionRenewDisabled))
            .setter(setter(Builder::sessionRenewDisabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionRenewDisabled").build())
            .build();

    private static final SdkField<Long> STORAGE_CACHE_MAX_MEMORY_SIZE_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("storageCacheMaxMemorySize").getter(getter(InfluxDBv2Parameters::storageCacheMaxMemorySize))
            .setter(setter(Builder::storageCacheMaxMemorySize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageCacheMaxMemorySize").build())
            .build();

    private static final SdkField<Long> STORAGE_CACHE_SNAPSHOT_MEMORY_SIZE_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("storageCacheSnapshotMemorySize")
            .getter(getter(InfluxDBv2Parameters::storageCacheSnapshotMemorySize))
            .setter(setter(Builder::storageCacheSnapshotMemorySize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageCacheSnapshotMemorySize")
                    .build()).build();

    private static final SdkField<Duration> STORAGE_CACHE_SNAPSHOT_WRITE_COLD_DURATION_FIELD = SdkField
            .<Duration> builder(MarshallingType.SDK_POJO)
            .memberName("storageCacheSnapshotWriteColdDuration")
            .getter(getter(InfluxDBv2Parameters::storageCacheSnapshotWriteColdDuration))
            .setter(setter(Builder::storageCacheSnapshotWriteColdDuration))
            .constructor(Duration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("storageCacheSnapshotWriteColdDuration").build()).build();

    private static final SdkField<Duration> STORAGE_COMPACT_FULL_WRITE_COLD_DURATION_FIELD = SdkField
            .<Duration> builder(MarshallingType.SDK_POJO)
            .memberName("storageCompactFullWriteColdDuration")
            .getter(getter(InfluxDBv2Parameters::storageCompactFullWriteColdDuration))
            .setter(setter(Builder::storageCompactFullWriteColdDuration))
            .constructor(Duration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("storageCompactFullWriteColdDuration").build()).build();

    private static final SdkField<Long> STORAGE_COMPACT_THROUGHPUT_BURST_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("storageCompactThroughputBurst")
            .getter(getter(InfluxDBv2Parameters::storageCompactThroughputBurst))
            .setter(setter(Builder::storageCompactThroughputBurst))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageCompactThroughputBurst")
                    .build()).build();

    private static final SdkField<Integer> STORAGE_MAX_CONCURRENT_COMPACTIONS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("storageMaxConcurrentCompactions")
            .getter(getter(InfluxDBv2Parameters::storageMaxConcurrentCompactions))
            .setter(setter(Builder::storageMaxConcurrentCompactions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageMaxConcurrentCompactions")
                    .build()).build();

    private static final SdkField<Long> STORAGE_MAX_INDEX_LOG_FILE_SIZE_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("storageMaxIndexLogFileSize")
            .getter(getter(InfluxDBv2Parameters::storageMaxIndexLogFileSize))
            .setter(setter(Builder::storageMaxIndexLogFileSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageMaxIndexLogFileSize").build())
            .build();

    private static final SdkField<Boolean> STORAGE_NO_VALIDATE_FIELD_SIZE_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("storageNoValidateFieldSize")
            .getter(getter(InfluxDBv2Parameters::storageNoValidateFieldSize))
            .setter(setter(Builder::storageNoValidateFieldSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageNoValidateFieldSize").build())
            .build();

    private static final SdkField<Duration> STORAGE_RETENTION_CHECK_INTERVAL_FIELD = SdkField
            .<Duration> builder(MarshallingType.SDK_POJO)
            .memberName("storageRetentionCheckInterval")
            .getter(getter(InfluxDBv2Parameters::storageRetentionCheckInterval))
            .setter(setter(Builder::storageRetentionCheckInterval))
            .constructor(Duration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageRetentionCheckInterval")
                    .build()).build();

    private static final SdkField<Integer> STORAGE_SERIES_FILE_MAX_CONCURRENT_SNAPSHOT_COMPACTIONS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("storageSeriesFileMaxConcurrentSnapshotCompactions")
            .getter(getter(InfluxDBv2Parameters::storageSeriesFileMaxConcurrentSnapshotCompactions))
            .setter(setter(Builder::storageSeriesFileMaxConcurrentSnapshotCompactions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("storageSeriesFileMaxConcurrentSnapshotCompactions").build()).build();

    private static final SdkField<Long> STORAGE_SERIES_ID_SET_CACHE_SIZE_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("storageSeriesIdSetCacheSize")
            .getter(getter(InfluxDBv2Parameters::storageSeriesIdSetCacheSize))
            .setter(setter(Builder::storageSeriesIdSetCacheSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageSeriesIdSetCacheSize")
                    .build()).build();

    private static final SdkField<Integer> STORAGE_WAL_MAX_CONCURRENT_WRITES_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("storageWalMaxConcurrentWrites")
            .getter(getter(InfluxDBv2Parameters::storageWalMaxConcurrentWrites))
            .setter(setter(Builder::storageWalMaxConcurrentWrites))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageWalMaxConcurrentWrites")
                    .build()).build();

    private static final SdkField<Duration> STORAGE_WAL_MAX_WRITE_DELAY_FIELD = SdkField
            .<Duration> builder(MarshallingType.SDK_POJO).memberName("storageWalMaxWriteDelay")
            .getter(getter(InfluxDBv2Parameters::storageWalMaxWriteDelay)).setter(setter(Builder::storageWalMaxWriteDelay))
            .constructor(Duration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageWalMaxWriteDelay").build())
            .build();

    private static final SdkField<Boolean> UI_DISABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("uiDisabled").getter(getter(InfluxDBv2Parameters::uiDisabled)).setter(setter(Builder::uiDisabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uiDisabled").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLUX_LOG_ENABLED_FIELD,
            LOG_LEVEL_FIELD, NO_TASKS_FIELD, QUERY_CONCURRENCY_FIELD, QUERY_QUEUE_SIZE_FIELD, TRACING_TYPE_FIELD,
            METRICS_DISABLED_FIELD, HTTP_IDLE_TIMEOUT_FIELD, HTTP_READ_HEADER_TIMEOUT_FIELD, HTTP_READ_TIMEOUT_FIELD,
            HTTP_WRITE_TIMEOUT_FIELD, INFLUXQL_MAX_SELECT_BUCKETS_FIELD, INFLUXQL_MAX_SELECT_POINT_FIELD,
            INFLUXQL_MAX_SELECT_SERIES_FIELD, PPROF_DISABLED_FIELD, QUERY_INITIAL_MEMORY_BYTES_FIELD,
            QUERY_MAX_MEMORY_BYTES_FIELD, QUERY_MEMORY_BYTES_FIELD, SESSION_LENGTH_FIELD, SESSION_RENEW_DISABLED_FIELD,
            STORAGE_CACHE_MAX_MEMORY_SIZE_FIELD, STORAGE_CACHE_SNAPSHOT_MEMORY_SIZE_FIELD,
            STORAGE_CACHE_SNAPSHOT_WRITE_COLD_DURATION_FIELD, STORAGE_COMPACT_FULL_WRITE_COLD_DURATION_FIELD,
            STORAGE_COMPACT_THROUGHPUT_BURST_FIELD, STORAGE_MAX_CONCURRENT_COMPACTIONS_FIELD,
            STORAGE_MAX_INDEX_LOG_FILE_SIZE_FIELD, STORAGE_NO_VALIDATE_FIELD_SIZE_FIELD, STORAGE_RETENTION_CHECK_INTERVAL_FIELD,
            STORAGE_SERIES_FILE_MAX_CONCURRENT_SNAPSHOT_COMPACTIONS_FIELD, STORAGE_SERIES_ID_SET_CACHE_SIZE_FIELD,
            STORAGE_WAL_MAX_CONCURRENT_WRITES_FIELD, STORAGE_WAL_MAX_WRITE_DELAY_FIELD, UI_DISABLED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean fluxLogEnabled;

    private final String logLevel;

    private final Boolean noTasks;

    private final Integer queryConcurrency;

    private final Integer queryQueueSize;

    private final String tracingType;

    private final Boolean metricsDisabled;

    private final Duration httpIdleTimeout;

    private final Duration httpReadHeaderTimeout;

    private final Duration httpReadTimeout;

    private final Duration httpWriteTimeout;

    private final Long influxqlMaxSelectBuckets;

    private final Long influxqlMaxSelectPoint;

    private final Long influxqlMaxSelectSeries;

    private final Boolean pprofDisabled;

    private final Long queryInitialMemoryBytes;

    private final Long queryMaxMemoryBytes;

    private final Long queryMemoryBytes;

    private final Integer sessionLength;

    private final Boolean sessionRenewDisabled;

    private final Long storageCacheMaxMemorySize;

    private final Long storageCacheSnapshotMemorySize;

    private final Duration storageCacheSnapshotWriteColdDuration;

    private final Duration storageCompactFullWriteColdDuration;

    private final Long storageCompactThroughputBurst;

    private final Integer storageMaxConcurrentCompactions;

    private final Long storageMaxIndexLogFileSize;

    private final Boolean storageNoValidateFieldSize;

    private final Duration storageRetentionCheckInterval;

    private final Integer storageSeriesFileMaxConcurrentSnapshotCompactions;

    private final Long storageSeriesIdSetCacheSize;

    private final Integer storageWalMaxConcurrentWrites;

    private final Duration storageWalMaxWriteDelay;

    private final Boolean uiDisabled;

    private InfluxDBv2Parameters(BuilderImpl builder) {
        this.fluxLogEnabled = builder.fluxLogEnabled;
        this.logLevel = builder.logLevel;
        this.noTasks = builder.noTasks;
        this.queryConcurrency = builder.queryConcurrency;
        this.queryQueueSize = builder.queryQueueSize;
        this.tracingType = builder.tracingType;
        this.metricsDisabled = builder.metricsDisabled;
        this.httpIdleTimeout = builder.httpIdleTimeout;
        this.httpReadHeaderTimeout = builder.httpReadHeaderTimeout;
        this.httpReadTimeout = builder.httpReadTimeout;
        this.httpWriteTimeout = builder.httpWriteTimeout;
        this.influxqlMaxSelectBuckets = builder.influxqlMaxSelectBuckets;
        this.influxqlMaxSelectPoint = builder.influxqlMaxSelectPoint;
        this.influxqlMaxSelectSeries = builder.influxqlMaxSelectSeries;
        this.pprofDisabled = builder.pprofDisabled;
        this.queryInitialMemoryBytes = builder.queryInitialMemoryBytes;
        this.queryMaxMemoryBytes = builder.queryMaxMemoryBytes;
        this.queryMemoryBytes = builder.queryMemoryBytes;
        this.sessionLength = builder.sessionLength;
        this.sessionRenewDisabled = builder.sessionRenewDisabled;
        this.storageCacheMaxMemorySize = builder.storageCacheMaxMemorySize;
        this.storageCacheSnapshotMemorySize = builder.storageCacheSnapshotMemorySize;
        this.storageCacheSnapshotWriteColdDuration = builder.storageCacheSnapshotWriteColdDuration;
        this.storageCompactFullWriteColdDuration = builder.storageCompactFullWriteColdDuration;
        this.storageCompactThroughputBurst = builder.storageCompactThroughputBurst;
        this.storageMaxConcurrentCompactions = builder.storageMaxConcurrentCompactions;
        this.storageMaxIndexLogFileSize = builder.storageMaxIndexLogFileSize;
        this.storageNoValidateFieldSize = builder.storageNoValidateFieldSize;
        this.storageRetentionCheckInterval = builder.storageRetentionCheckInterval;
        this.storageSeriesFileMaxConcurrentSnapshotCompactions = builder.storageSeriesFileMaxConcurrentSnapshotCompactions;
        this.storageSeriesIdSetCacheSize = builder.storageSeriesIdSetCacheSize;
        this.storageWalMaxConcurrentWrites = builder.storageWalMaxConcurrentWrites;
        this.storageWalMaxWriteDelay = builder.storageWalMaxWriteDelay;
        this.uiDisabled = builder.uiDisabled;
    }

    /**
     * <p>
     * Include option to show detailed logs for Flux queries.
     * </p>
     * <p>
     * Default: false
     * </p>
     * 
     * @return Include option to show detailed logs for Flux queries.</p>
     *         <p>
     *         Default: false
     */
    public final Boolean fluxLogEnabled() {
        return fluxLogEnabled;
    }

    /**
     * <p>
     * Log output level. InfluxDB outputs log entries with severity levels greater than or equal to the level specified.
     * </p>
     * <p>
     * Default: info
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logLevel} will
     * return {@link LogLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #logLevelAsString}.
     * </p>
     * 
     * @return Log output level. InfluxDB outputs log entries with severity levels greater than or equal to the level
     *         specified.</p>
     *         <p>
     *         Default: info
     * @see LogLevel
     */
    public final LogLevel logLevel() {
        return LogLevel.fromValue(logLevel);
    }

    /**
     * <p>
     * Log output level. InfluxDB outputs log entries with severity levels greater than or equal to the level specified.
     * </p>
     * <p>
     * Default: info
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logLevel} will
     * return {@link LogLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #logLevelAsString}.
     * </p>
     * 
     * @return Log output level. InfluxDB outputs log entries with severity levels greater than or equal to the level
     *         specified.</p>
     *         <p>
     *         Default: info
     * @see LogLevel
     */
    public final String logLevelAsString() {
        return logLevel;
    }

    /**
     * <p>
     * Disable the task scheduler. If problematic tasks prevent InfluxDB from starting, use this option to start
     * InfluxDB without scheduling or executing tasks.
     * </p>
     * <p>
     * Default: false
     * </p>
     * 
     * @return Disable the task scheduler. If problematic tasks prevent InfluxDB from starting, use this option to start
     *         InfluxDB without scheduling or executing tasks.</p>
     *         <p>
     *         Default: false
     */
    public final Boolean noTasks() {
        return noTasks;
    }

    /**
     * <p>
     * Number of queries allowed to execute concurrently. Setting to 0 allows an unlimited number of concurrent queries.
     * </p>
     * <p>
     * Default: 0
     * </p>
     * 
     * @return Number of queries allowed to execute concurrently. Setting to 0 allows an unlimited number of concurrent
     *         queries.</p>
     *         <p>
     *         Default: 0
     */
    public final Integer queryConcurrency() {
        return queryConcurrency;
    }

    /**
     * <p>
     * Maximum number of queries allowed in execution queue. When queue limit is reached, new queries are rejected.
     * Setting to 0 allows an unlimited number of queries in the queue.
     * </p>
     * <p>
     * Default: 0
     * </p>
     * 
     * @return Maximum number of queries allowed in execution queue. When queue limit is reached, new queries are
     *         rejected. Setting to 0 allows an unlimited number of queries in the queue.</p>
     *         <p>
     *         Default: 0
     */
    public final Integer queryQueueSize() {
        return queryQueueSize;
    }

    /**
     * <p>
     * Enable tracing in InfluxDB and specifies the tracing type. Tracing is disabled by default.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tracingType} will
     * return {@link TracingType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #tracingTypeAsString}.
     * </p>
     * 
     * @return Enable tracing in InfluxDB and specifies the tracing type. Tracing is disabled by default.
     * @see TracingType
     */
    public final TracingType tracingType() {
        return TracingType.fromValue(tracingType);
    }

    /**
     * <p>
     * Enable tracing in InfluxDB and specifies the tracing type. Tracing is disabled by default.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tracingType} will
     * return {@link TracingType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #tracingTypeAsString}.
     * </p>
     * 
     * @return Enable tracing in InfluxDB and specifies the tracing type. Tracing is disabled by default.
     * @see TracingType
     */
    public final String tracingTypeAsString() {
        return tracingType;
    }

    /**
     * <p>
     * Disable the HTTP /metrics endpoint which exposes <a
     * href="https://docs.influxdata.com/influxdb/v2/reference/internals/metrics/">internal InfluxDB metrics</a>.
     * </p>
     * <p>
     * Default: false
     * </p>
     * 
     * @return Disable the HTTP /metrics endpoint which exposes <a
     *         href="https://docs.influxdata.com/influxdb/v2/reference/internals/metrics/">internal InfluxDB
     *         metrics</a>.</p>
     *         <p>
     *         Default: false
     */
    public final Boolean metricsDisabled() {
        return metricsDisabled;
    }

    /**
     * <p>
     * Maximum duration the server should keep established connections alive while waiting for new requests. Set to 0
     * for no timeout.
     * </p>
     * <p>
     * Default: 3 minutes
     * </p>
     * 
     * @return Maximum duration the server should keep established connections alive while waiting for new requests. Set
     *         to 0 for no timeout.</p>
     *         <p>
     *         Default: 3 minutes
     */
    public final Duration httpIdleTimeout() {
        return httpIdleTimeout;
    }

    /**
     * <p>
     * Maximum duration the server should try to read HTTP headers for new requests. Set to 0 for no timeout.
     * </p>
     * <p>
     * Default: 10 seconds
     * </p>
     * 
     * @return Maximum duration the server should try to read HTTP headers for new requests. Set to 0 for no
     *         timeout.</p>
     *         <p>
     *         Default: 10 seconds
     */
    public final Duration httpReadHeaderTimeout() {
        return httpReadHeaderTimeout;
    }

    /**
     * <p>
     * Maximum duration the server should try to read the entirety of new requests. Set to 0 for no timeout.
     * </p>
     * <p>
     * Default: 0
     * </p>
     * 
     * @return Maximum duration the server should try to read the entirety of new requests. Set to 0 for no timeout.</p>
     *         <p>
     *         Default: 0
     */
    public final Duration httpReadTimeout() {
        return httpReadTimeout;
    }

    /**
     * <p>
     * Maximum duration the server should spend processing and responding to write requests. Set to 0 for no timeout.
     * </p>
     * <p>
     * Default: 0
     * </p>
     * 
     * @return Maximum duration the server should spend processing and responding to write requests. Set to 0 for no
     *         timeout.</p>
     *         <p>
     *         Default: 0
     */
    public final Duration httpWriteTimeout() {
        return httpWriteTimeout;
    }

    /**
     * <p>
     * Maximum number of group by time buckets a SELECT statement can create. 0 allows an unlimited number of buckets.
     * </p>
     * <p>
     * Default: 0
     * </p>
     * 
     * @return Maximum number of group by time buckets a SELECT statement can create. 0 allows an unlimited number of
     *         buckets.</p>
     *         <p>
     *         Default: 0
     */
    public final Long influxqlMaxSelectBuckets() {
        return influxqlMaxSelectBuckets;
    }

    /**
     * <p>
     * Maximum number of points a SELECT statement can process. 0 allows an unlimited number of points. InfluxDB checks
     * the point count every second (so queries exceeding the maximum aren’t immediately aborted).
     * </p>
     * <p>
     * Default: 0
     * </p>
     * 
     * @return Maximum number of points a SELECT statement can process. 0 allows an unlimited number of points. InfluxDB
     *         checks the point count every second (so queries exceeding the maximum aren’t immediately aborted).</p>
     *         <p>
     *         Default: 0
     */
    public final Long influxqlMaxSelectPoint() {
        return influxqlMaxSelectPoint;
    }

    /**
     * <p>
     * Maximum number of series a SELECT statement can return. 0 allows an unlimited number of series.
     * </p>
     * <p>
     * Default: 0
     * </p>
     * 
     * @return Maximum number of series a SELECT statement can return. 0 allows an unlimited number of series.</p>
     *         <p>
     *         Default: 0
     */
    public final Long influxqlMaxSelectSeries() {
        return influxqlMaxSelectSeries;
    }

    /**
     * <p>
     * Disable the /debug/pprof HTTP endpoint. This endpoint provides runtime profiling data and can be helpful when
     * debugging.
     * </p>
     * <p>
     * Default: true
     * </p>
     * 
     * @return Disable the /debug/pprof HTTP endpoint. This endpoint provides runtime profiling data and can be helpful
     *         when debugging.</p>
     *         <p>
     *         Default: true
     */
    public final Boolean pprofDisabled() {
        return pprofDisabled;
    }

    /**
     * <p>
     * Initial bytes of memory allocated for a query.
     * </p>
     * <p>
     * Default: 0
     * </p>
     * 
     * @return Initial bytes of memory allocated for a query.</p>
     *         <p>
     *         Default: 0
     */
    public final Long queryInitialMemoryBytes() {
        return queryInitialMemoryBytes;
    }

    /**
     * <p>
     * Maximum number of queries allowed in execution queue. When queue limit is reached, new queries are rejected.
     * Setting to 0 allows an unlimited number of queries in the queue.
     * </p>
     * <p>
     * Default: 0
     * </p>
     * 
     * @return Maximum number of queries allowed in execution queue. When queue limit is reached, new queries are
     *         rejected. Setting to 0 allows an unlimited number of queries in the queue.</p>
     *         <p>
     *         Default: 0
     */
    public final Long queryMaxMemoryBytes() {
        return queryMaxMemoryBytes;
    }

    /**
     * <p>
     * Maximum bytes of memory allowed for a single query. Must be greater or equal to queryInitialMemoryBytes.
     * </p>
     * <p>
     * Default: 0
     * </p>
     * 
     * @return Maximum bytes of memory allowed for a single query. Must be greater or equal to
     *         queryInitialMemoryBytes.</p>
     *         <p>
     *         Default: 0
     */
    public final Long queryMemoryBytes() {
        return queryMemoryBytes;
    }

    /**
     * <p>
     * Specifies the Time to Live (TTL) in minutes for newly created user sessions.
     * </p>
     * <p>
     * Default: 60
     * </p>
     * 
     * @return Specifies the Time to Live (TTL) in minutes for newly created user sessions.</p>
     *         <p>
     *         Default: 60
     */
    public final Integer sessionLength() {
        return sessionLength;
    }

    /**
     * <p>
     * Disables automatically extending a user’s session TTL on each request. By default, every request sets the
     * session’s expiration time to five minutes from now. When disabled, sessions expire after the specified <a
     * href="https://docs.influxdata.com/influxdb/v2/reference/config-options/#session-length">session length</a> and
     * the user is redirected to the login page, even if recently active.
     * </p>
     * <p>
     * Default: false
     * </p>
     * 
     * @return Disables automatically extending a user’s session TTL on each request. By default, every request sets the
     *         session’s expiration time to five minutes from now. When disabled, sessions expire after the specified <a
     *         href="https://docs.influxdata.com/influxdb/v2/reference/config-options/#session-length">session
     *         length</a> and the user is redirected to the login page, even if recently active.</p>
     *         <p>
     *         Default: false
     */
    public final Boolean sessionRenewDisabled() {
        return sessionRenewDisabled;
    }

    /**
     * <p>
     * Maximum size (in bytes) a shard’s cache can reach before it starts rejecting writes. Must be greater than
     * storageCacheSnapShotMemorySize and lower than instance’s total memory capacity. We recommend setting it to below
     * 15% of the total memory capacity.
     * </p>
     * <p>
     * Default: 1073741824
     * </p>
     * 
     * @return Maximum size (in bytes) a shard’s cache can reach before it starts rejecting writes. Must be greater than
     *         storageCacheSnapShotMemorySize and lower than instance’s total memory capacity. We recommend setting it
     *         to below 15% of the total memory capacity.</p>
     *         <p>
     *         Default: 1073741824
     */
    public final Long storageCacheMaxMemorySize() {
        return storageCacheMaxMemorySize;
    }

    /**
     * <p>
     * Size (in bytes) at which the storage engine will snapshot the cache and write it to a TSM file to make more
     * memory available. Must not be greater than storageCacheMaxMemorySize.
     * </p>
     * <p>
     * Default: 26214400
     * </p>
     * 
     * @return Size (in bytes) at which the storage engine will snapshot the cache and write it to a TSM file to make
     *         more memory available. Must not be greater than storageCacheMaxMemorySize.</p>
     *         <p>
     *         Default: 26214400
     */
    public final Long storageCacheSnapshotMemorySize() {
        return storageCacheSnapshotMemorySize;
    }

    /**
     * <p>
     * Duration at which the storage engine will snapshot the cache and write it to a new TSM file if the shard hasn’t
     * received writes or deletes.
     * </p>
     * <p>
     * Default: 10 minutes
     * </p>
     * 
     * @return Duration at which the storage engine will snapshot the cache and write it to a new TSM file if the shard
     *         hasn’t received writes or deletes.</p>
     *         <p>
     *         Default: 10 minutes
     */
    public final Duration storageCacheSnapshotWriteColdDuration() {
        return storageCacheSnapshotWriteColdDuration;
    }

    /**
     * <p>
     * Duration at which the storage engine will compact all TSM files in a shard if it hasn't received writes or
     * deletes.
     * </p>
     * <p>
     * Default: 4 hours
     * </p>
     * 
     * @return Duration at which the storage engine will compact all TSM files in a shard if it hasn't received writes
     *         or deletes.</p>
     *         <p>
     *         Default: 4 hours
     */
    public final Duration storageCompactFullWriteColdDuration() {
        return storageCompactFullWriteColdDuration;
    }

    /**
     * <p>
     * Rate limit (in bytes per second) that TSM compactions can write to disk.
     * </p>
     * <p>
     * Default: 50331648
     * </p>
     * 
     * @return Rate limit (in bytes per second) that TSM compactions can write to disk.</p>
     *         <p>
     *         Default: 50331648
     */
    public final Long storageCompactThroughputBurst() {
        return storageCompactThroughputBurst;
    }

    /**
     * <p>
     * Maximum number of full and level compactions that can run concurrently. A value of 0 results in 50% of
     * runtime.GOMAXPROCS(0) used at runtime. Any number greater than zero limits compactions to that value. This
     * setting does not apply to cache snapshotting.
     * </p>
     * <p>
     * Default: 0
     * </p>
     * 
     * @return Maximum number of full and level compactions that can run concurrently. A value of 0 results in 50% of
     *         runtime.GOMAXPROCS(0) used at runtime. Any number greater than zero limits compactions to that value.
     *         This setting does not apply to cache snapshotting.</p>
     *         <p>
     *         Default: 0
     */
    public final Integer storageMaxConcurrentCompactions() {
        return storageMaxConcurrentCompactions;
    }

    /**
     * <p>
     * Size (in bytes) at which an index write-ahead log (WAL) file will compact into an index file. Lower sizes will
     * cause log files to be compacted more quickly and result in lower heap usage at the expense of write throughput.
     * </p>
     * <p>
     * Default: 1048576
     * </p>
     * 
     * @return Size (in bytes) at which an index write-ahead log (WAL) file will compact into an index file. Lower sizes
     *         will cause log files to be compacted more quickly and result in lower heap usage at the expense of write
     *         throughput.</p>
     *         <p>
     *         Default: 1048576
     */
    public final Long storageMaxIndexLogFileSize() {
        return storageMaxIndexLogFileSize;
    }

    /**
     * <p>
     * Skip field size validation on incoming write requests.
     * </p>
     * <p>
     * Default: false
     * </p>
     * 
     * @return Skip field size validation on incoming write requests.</p>
     *         <p>
     *         Default: false
     */
    public final Boolean storageNoValidateFieldSize() {
        return storageNoValidateFieldSize;
    }

    /**
     * <p>
     * Interval of retention policy enforcement checks. Must be greater than 0.
     * </p>
     * <p>
     * Default: 30 minutes
     * </p>
     * 
     * @return Interval of retention policy enforcement checks. Must be greater than 0.</p>
     *         <p>
     *         Default: 30 minutes
     */
    public final Duration storageRetentionCheckInterval() {
        return storageRetentionCheckInterval;
    }

    /**
     * <p>
     * Maximum number of snapshot compactions that can run concurrently across all series partitions in a database.
     * </p>
     * <p>
     * Default: 0
     * </p>
     * 
     * @return Maximum number of snapshot compactions that can run concurrently across all series partitions in a
     *         database.</p>
     *         <p>
     *         Default: 0
     */
    public final Integer storageSeriesFileMaxConcurrentSnapshotCompactions() {
        return storageSeriesFileMaxConcurrentSnapshotCompactions;
    }

    /**
     * <p>
     * Size of the internal cache used in the TSI index to store previously calculated series results. Cached results
     * are returned quickly rather than needing to be recalculated when a subsequent query with the same tag key/value
     * predicate is executed. Setting this value to 0 will disable the cache and may decrease query performance.
     * </p>
     * <p>
     * Default: 100
     * </p>
     * 
     * @return Size of the internal cache used in the TSI index to store previously calculated series results. Cached
     *         results are returned quickly rather than needing to be recalculated when a subsequent query with the same
     *         tag key/value predicate is executed. Setting this value to 0 will disable the cache and may decrease
     *         query performance.</p>
     *         <p>
     *         Default: 100
     */
    public final Long storageSeriesIdSetCacheSize() {
        return storageSeriesIdSetCacheSize;
    }

    /**
     * <p>
     * Maximum number writes to the WAL directory to attempt at the same time. Setting this value to 0 results in number
     * of processing units available x2.
     * </p>
     * <p>
     * Default: 0
     * </p>
     * 
     * @return Maximum number writes to the WAL directory to attempt at the same time. Setting this value to 0 results
     *         in number of processing units available x2.</p>
     *         <p>
     *         Default: 0
     */
    public final Integer storageWalMaxConcurrentWrites() {
        return storageWalMaxConcurrentWrites;
    }

    /**
     * <p>
     * Maximum amount of time a write request to the WAL directory will wait when the <a
     * href="https://docs.influxdata.com/influxdb/v2/reference/config-options/#storage-wal-max-concurrent-writes"
     * >maximum number of concurrent active writes to the WAL directory has been met</a>. Set to 0 to disable the
     * timeout.
     * </p>
     * <p>
     * Default: 10 minutes
     * </p>
     * 
     * @return Maximum amount of time a write request to the WAL directory will wait when the <a
     *         href="https://docs.influxdata.com/influxdb/v2/reference/config-options/#storage-wal-max-concurrent-writes"
     *         >maximum number of concurrent active writes to the WAL directory has been met</a>. Set to 0 to disable
     *         the timeout.</p>
     *         <p>
     *         Default: 10 minutes
     */
    public final Duration storageWalMaxWriteDelay() {
        return storageWalMaxWriteDelay;
    }

    /**
     * <p>
     * Disable the InfluxDB user interface (UI). The UI is enabled by default.
     * </p>
     * <p>
     * Default: false
     * </p>
     * 
     * @return Disable the InfluxDB user interface (UI). The UI is enabled by default.</p>
     *         <p>
     *         Default: false
     */
    public final Boolean uiDisabled() {
        return uiDisabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fluxLogEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(logLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(noTasks());
        hashCode = 31 * hashCode + Objects.hashCode(queryConcurrency());
        hashCode = 31 * hashCode + Objects.hashCode(queryQueueSize());
        hashCode = 31 * hashCode + Objects.hashCode(tracingTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(metricsDisabled());
        hashCode = 31 * hashCode + Objects.hashCode(httpIdleTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(httpReadHeaderTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(httpReadTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(httpWriteTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(influxqlMaxSelectBuckets());
        hashCode = 31 * hashCode + Objects.hashCode(influxqlMaxSelectPoint());
        hashCode = 31 * hashCode + Objects.hashCode(influxqlMaxSelectSeries());
        hashCode = 31 * hashCode + Objects.hashCode(pprofDisabled());
        hashCode = 31 * hashCode + Objects.hashCode(queryInitialMemoryBytes());
        hashCode = 31 * hashCode + Objects.hashCode(queryMaxMemoryBytes());
        hashCode = 31 * hashCode + Objects.hashCode(queryMemoryBytes());
        hashCode = 31 * hashCode + Objects.hashCode(sessionLength());
        hashCode = 31 * hashCode + Objects.hashCode(sessionRenewDisabled());
        hashCode = 31 * hashCode + Objects.hashCode(storageCacheMaxMemorySize());
        hashCode = 31 * hashCode + Objects.hashCode(storageCacheSnapshotMemorySize());
        hashCode = 31 * hashCode + Objects.hashCode(storageCacheSnapshotWriteColdDuration());
        hashCode = 31 * hashCode + Objects.hashCode(storageCompactFullWriteColdDuration());
        hashCode = 31 * hashCode + Objects.hashCode(storageCompactThroughputBurst());
        hashCode = 31 * hashCode + Objects.hashCode(storageMaxConcurrentCompactions());
        hashCode = 31 * hashCode + Objects.hashCode(storageMaxIndexLogFileSize());
        hashCode = 31 * hashCode + Objects.hashCode(storageNoValidateFieldSize());
        hashCode = 31 * hashCode + Objects.hashCode(storageRetentionCheckInterval());
        hashCode = 31 * hashCode + Objects.hashCode(storageSeriesFileMaxConcurrentSnapshotCompactions());
        hashCode = 31 * hashCode + Objects.hashCode(storageSeriesIdSetCacheSize());
        hashCode = 31 * hashCode + Objects.hashCode(storageWalMaxConcurrentWrites());
        hashCode = 31 * hashCode + Objects.hashCode(storageWalMaxWriteDelay());
        hashCode = 31 * hashCode + Objects.hashCode(uiDisabled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InfluxDBv2Parameters)) {
            return false;
        }
        InfluxDBv2Parameters other = (InfluxDBv2Parameters) obj;
        return Objects.equals(fluxLogEnabled(), other.fluxLogEnabled())
                && Objects.equals(logLevelAsString(), other.logLevelAsString())
                && Objects.equals(noTasks(), other.noTasks())
                && Objects.equals(queryConcurrency(), other.queryConcurrency())
                && Objects.equals(queryQueueSize(), other.queryQueueSize())
                && Objects.equals(tracingTypeAsString(), other.tracingTypeAsString())
                && Objects.equals(metricsDisabled(), other.metricsDisabled())
                && Objects.equals(httpIdleTimeout(), other.httpIdleTimeout())
                && Objects.equals(httpReadHeaderTimeout(), other.httpReadHeaderTimeout())
                && Objects.equals(httpReadTimeout(), other.httpReadTimeout())
                && Objects.equals(httpWriteTimeout(), other.httpWriteTimeout())
                && Objects.equals(influxqlMaxSelectBuckets(), other.influxqlMaxSelectBuckets())
                && Objects.equals(influxqlMaxSelectPoint(), other.influxqlMaxSelectPoint())
                && Objects.equals(influxqlMaxSelectSeries(), other.influxqlMaxSelectSeries())
                && Objects.equals(pprofDisabled(), other.pprofDisabled())
                && Objects.equals(queryInitialMemoryBytes(), other.queryInitialMemoryBytes())
                && Objects.equals(queryMaxMemoryBytes(), other.queryMaxMemoryBytes())
                && Objects.equals(queryMemoryBytes(), other.queryMemoryBytes())
                && Objects.equals(sessionLength(), other.sessionLength())
                && Objects.equals(sessionRenewDisabled(), other.sessionRenewDisabled())
                && Objects.equals(storageCacheMaxMemorySize(), other.storageCacheMaxMemorySize())
                && Objects.equals(storageCacheSnapshotMemorySize(), other.storageCacheSnapshotMemorySize())
                && Objects.equals(storageCacheSnapshotWriteColdDuration(), other.storageCacheSnapshotWriteColdDuration())
                && Objects.equals(storageCompactFullWriteColdDuration(), other.storageCompactFullWriteColdDuration())
                && Objects.equals(storageCompactThroughputBurst(), other.storageCompactThroughputBurst())
                && Objects.equals(storageMaxConcurrentCompactions(), other.storageMaxConcurrentCompactions())
                && Objects.equals(storageMaxIndexLogFileSize(), other.storageMaxIndexLogFileSize())
                && Objects.equals(storageNoValidateFieldSize(), other.storageNoValidateFieldSize())
                && Objects.equals(storageRetentionCheckInterval(), other.storageRetentionCheckInterval())
                && Objects.equals(storageSeriesFileMaxConcurrentSnapshotCompactions(),
                        other.storageSeriesFileMaxConcurrentSnapshotCompactions())
                && Objects.equals(storageSeriesIdSetCacheSize(), other.storageSeriesIdSetCacheSize())
                && Objects.equals(storageWalMaxConcurrentWrites(), other.storageWalMaxConcurrentWrites())
                && Objects.equals(storageWalMaxWriteDelay(), other.storageWalMaxWriteDelay())
                && Objects.equals(uiDisabled(), other.uiDisabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InfluxDBv2Parameters").add("FluxLogEnabled", fluxLogEnabled())
                .add("LogLevel", logLevelAsString()).add("NoTasks", noTasks()).add("QueryConcurrency", queryConcurrency())
                .add("QueryQueueSize", queryQueueSize()).add("TracingType", tracingTypeAsString())
                .add("MetricsDisabled", metricsDisabled()).add("HttpIdleTimeout", httpIdleTimeout())
                .add("HttpReadHeaderTimeout", httpReadHeaderTimeout()).add("HttpReadTimeout", httpReadTimeout())
                .add("HttpWriteTimeout", httpWriteTimeout()).add("InfluxqlMaxSelectBuckets", influxqlMaxSelectBuckets())
                .add("InfluxqlMaxSelectPoint", influxqlMaxSelectPoint())
                .add("InfluxqlMaxSelectSeries", influxqlMaxSelectSeries()).add("PprofDisabled", pprofDisabled())
                .add("QueryInitialMemoryBytes", queryInitialMemoryBytes()).add("QueryMaxMemoryBytes", queryMaxMemoryBytes())
                .add("QueryMemoryBytes", queryMemoryBytes()).add("SessionLength", sessionLength())
                .add("SessionRenewDisabled", sessionRenewDisabled())
                .add("StorageCacheMaxMemorySize", storageCacheMaxMemorySize())
                .add("StorageCacheSnapshotMemorySize", storageCacheSnapshotMemorySize())
                .add("StorageCacheSnapshotWriteColdDuration", storageCacheSnapshotWriteColdDuration())
                .add("StorageCompactFullWriteColdDuration", storageCompactFullWriteColdDuration())
                .add("StorageCompactThroughputBurst", storageCompactThroughputBurst())
                .add("StorageMaxConcurrentCompactions", storageMaxConcurrentCompactions())
                .add("StorageMaxIndexLogFileSize", storageMaxIndexLogFileSize())
                .add("StorageNoValidateFieldSize", storageNoValidateFieldSize())
                .add("StorageRetentionCheckInterval", storageRetentionCheckInterval())
                .add("StorageSeriesFileMaxConcurrentSnapshotCompactions", storageSeriesFileMaxConcurrentSnapshotCompactions())
                .add("StorageSeriesIdSetCacheSize", storageSeriesIdSetCacheSize())
                .add("StorageWalMaxConcurrentWrites", storageWalMaxConcurrentWrites())
                .add("StorageWalMaxWriteDelay", storageWalMaxWriteDelay()).add("UiDisabled", uiDisabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "fluxLogEnabled":
            return Optional.ofNullable(clazz.cast(fluxLogEnabled()));
        case "logLevel":
            return Optional.ofNullable(clazz.cast(logLevelAsString()));
        case "noTasks":
            return Optional.ofNullable(clazz.cast(noTasks()));
        case "queryConcurrency":
            return Optional.ofNullable(clazz.cast(queryConcurrency()));
        case "queryQueueSize":
            return Optional.ofNullable(clazz.cast(queryQueueSize()));
        case "tracingType":
            return Optional.ofNullable(clazz.cast(tracingTypeAsString()));
        case "metricsDisabled":
            return Optional.ofNullable(clazz.cast(metricsDisabled()));
        case "httpIdleTimeout":
            return Optional.ofNullable(clazz.cast(httpIdleTimeout()));
        case "httpReadHeaderTimeout":
            return Optional.ofNullable(clazz.cast(httpReadHeaderTimeout()));
        case "httpReadTimeout":
            return Optional.ofNullable(clazz.cast(httpReadTimeout()));
        case "httpWriteTimeout":
            return Optional.ofNullable(clazz.cast(httpWriteTimeout()));
        case "influxqlMaxSelectBuckets":
            return Optional.ofNullable(clazz.cast(influxqlMaxSelectBuckets()));
        case "influxqlMaxSelectPoint":
            return Optional.ofNullable(clazz.cast(influxqlMaxSelectPoint()));
        case "influxqlMaxSelectSeries":
            return Optional.ofNullable(clazz.cast(influxqlMaxSelectSeries()));
        case "pprofDisabled":
            return Optional.ofNullable(clazz.cast(pprofDisabled()));
        case "queryInitialMemoryBytes":
            return Optional.ofNullable(clazz.cast(queryInitialMemoryBytes()));
        case "queryMaxMemoryBytes":
            return Optional.ofNullable(clazz.cast(queryMaxMemoryBytes()));
        case "queryMemoryBytes":
            return Optional.ofNullable(clazz.cast(queryMemoryBytes()));
        case "sessionLength":
            return Optional.ofNullable(clazz.cast(sessionLength()));
        case "sessionRenewDisabled":
            return Optional.ofNullable(clazz.cast(sessionRenewDisabled()));
        case "storageCacheMaxMemorySize":
            return Optional.ofNullable(clazz.cast(storageCacheMaxMemorySize()));
        case "storageCacheSnapshotMemorySize":
            return Optional.ofNullable(clazz.cast(storageCacheSnapshotMemorySize()));
        case "storageCacheSnapshotWriteColdDuration":
            return Optional.ofNullable(clazz.cast(storageCacheSnapshotWriteColdDuration()));
        case "storageCompactFullWriteColdDuration":
            return Optional.ofNullable(clazz.cast(storageCompactFullWriteColdDuration()));
        case "storageCompactThroughputBurst":
            return Optional.ofNullable(clazz.cast(storageCompactThroughputBurst()));
        case "storageMaxConcurrentCompactions":
            return Optional.ofNullable(clazz.cast(storageMaxConcurrentCompactions()));
        case "storageMaxIndexLogFileSize":
            return Optional.ofNullable(clazz.cast(storageMaxIndexLogFileSize()));
        case "storageNoValidateFieldSize":
            return Optional.ofNullable(clazz.cast(storageNoValidateFieldSize()));
        case "storageRetentionCheckInterval":
            return Optional.ofNullable(clazz.cast(storageRetentionCheckInterval()));
        case "storageSeriesFileMaxConcurrentSnapshotCompactions":
            return Optional.ofNullable(clazz.cast(storageSeriesFileMaxConcurrentSnapshotCompactions()));
        case "storageSeriesIdSetCacheSize":
            return Optional.ofNullable(clazz.cast(storageSeriesIdSetCacheSize()));
        case "storageWalMaxConcurrentWrites":
            return Optional.ofNullable(clazz.cast(storageWalMaxConcurrentWrites()));
        case "storageWalMaxWriteDelay":
            return Optional.ofNullable(clazz.cast(storageWalMaxWriteDelay()));
        case "uiDisabled":
            return Optional.ofNullable(clazz.cast(uiDisabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("fluxLogEnabled", FLUX_LOG_ENABLED_FIELD);
        map.put("logLevel", LOG_LEVEL_FIELD);
        map.put("noTasks", NO_TASKS_FIELD);
        map.put("queryConcurrency", QUERY_CONCURRENCY_FIELD);
        map.put("queryQueueSize", QUERY_QUEUE_SIZE_FIELD);
        map.put("tracingType", TRACING_TYPE_FIELD);
        map.put("metricsDisabled", METRICS_DISABLED_FIELD);
        map.put("httpIdleTimeout", HTTP_IDLE_TIMEOUT_FIELD);
        map.put("httpReadHeaderTimeout", HTTP_READ_HEADER_TIMEOUT_FIELD);
        map.put("httpReadTimeout", HTTP_READ_TIMEOUT_FIELD);
        map.put("httpWriteTimeout", HTTP_WRITE_TIMEOUT_FIELD);
        map.put("influxqlMaxSelectBuckets", INFLUXQL_MAX_SELECT_BUCKETS_FIELD);
        map.put("influxqlMaxSelectPoint", INFLUXQL_MAX_SELECT_POINT_FIELD);
        map.put("influxqlMaxSelectSeries", INFLUXQL_MAX_SELECT_SERIES_FIELD);
        map.put("pprofDisabled", PPROF_DISABLED_FIELD);
        map.put("queryInitialMemoryBytes", QUERY_INITIAL_MEMORY_BYTES_FIELD);
        map.put("queryMaxMemoryBytes", QUERY_MAX_MEMORY_BYTES_FIELD);
        map.put("queryMemoryBytes", QUERY_MEMORY_BYTES_FIELD);
        map.put("sessionLength", SESSION_LENGTH_FIELD);
        map.put("sessionRenewDisabled", SESSION_RENEW_DISABLED_FIELD);
        map.put("storageCacheMaxMemorySize", STORAGE_CACHE_MAX_MEMORY_SIZE_FIELD);
        map.put("storageCacheSnapshotMemorySize", STORAGE_CACHE_SNAPSHOT_MEMORY_SIZE_FIELD);
        map.put("storageCacheSnapshotWriteColdDuration", STORAGE_CACHE_SNAPSHOT_WRITE_COLD_DURATION_FIELD);
        map.put("storageCompactFullWriteColdDuration", STORAGE_COMPACT_FULL_WRITE_COLD_DURATION_FIELD);
        map.put("storageCompactThroughputBurst", STORAGE_COMPACT_THROUGHPUT_BURST_FIELD);
        map.put("storageMaxConcurrentCompactions", STORAGE_MAX_CONCURRENT_COMPACTIONS_FIELD);
        map.put("storageMaxIndexLogFileSize", STORAGE_MAX_INDEX_LOG_FILE_SIZE_FIELD);
        map.put("storageNoValidateFieldSize", STORAGE_NO_VALIDATE_FIELD_SIZE_FIELD);
        map.put("storageRetentionCheckInterval", STORAGE_RETENTION_CHECK_INTERVAL_FIELD);
        map.put("storageSeriesFileMaxConcurrentSnapshotCompactions",
                STORAGE_SERIES_FILE_MAX_CONCURRENT_SNAPSHOT_COMPACTIONS_FIELD);
        map.put("storageSeriesIdSetCacheSize", STORAGE_SERIES_ID_SET_CACHE_SIZE_FIELD);
        map.put("storageWalMaxConcurrentWrites", STORAGE_WAL_MAX_CONCURRENT_WRITES_FIELD);
        map.put("storageWalMaxWriteDelay", STORAGE_WAL_MAX_WRITE_DELAY_FIELD);
        map.put("uiDisabled", UI_DISABLED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InfluxDBv2Parameters, T> g) {
        return obj -> g.apply((InfluxDBv2Parameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InfluxDBv2Parameters> {
        /**
         * <p>
         * Include option to show detailed logs for Flux queries.
         * </p>
         * <p>
         * Default: false
         * </p>
         * 
         * @param fluxLogEnabled
         *        Include option to show detailed logs for Flux queries.</p>
         *        <p>
         *        Default: false
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fluxLogEnabled(Boolean fluxLogEnabled);

        /**
         * <p>
         * Log output level. InfluxDB outputs log entries with severity levels greater than or equal to the level
         * specified.
         * </p>
         * <p>
         * Default: info
         * </p>
         * 
         * @param logLevel
         *        Log output level. InfluxDB outputs log entries with severity levels greater than or equal to the level
         *        specified.</p>
         *        <p>
         *        Default: info
         * @see LogLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogLevel
         */
        Builder logLevel(String logLevel);

        /**
         * <p>
         * Log output level. InfluxDB outputs log entries with severity levels greater than or equal to the level
         * specified.
         * </p>
         * <p>
         * Default: info
         * </p>
         * 
         * @param logLevel
         *        Log output level. InfluxDB outputs log entries with severity levels greater than or equal to the level
         *        specified.</p>
         *        <p>
         *        Default: info
         * @see LogLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogLevel
         */
        Builder logLevel(LogLevel logLevel);

        /**
         * <p>
         * Disable the task scheduler. If problematic tasks prevent InfluxDB from starting, use this option to start
         * InfluxDB without scheduling or executing tasks.
         * </p>
         * <p>
         * Default: false
         * </p>
         * 
         * @param noTasks
         *        Disable the task scheduler. If problematic tasks prevent InfluxDB from starting, use this option to
         *        start InfluxDB without scheduling or executing tasks.</p>
         *        <p>
         *        Default: false
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder noTasks(Boolean noTasks);

        /**
         * <p>
         * Number of queries allowed to execute concurrently. Setting to 0 allows an unlimited number of concurrent
         * queries.
         * </p>
         * <p>
         * Default: 0
         * </p>
         * 
         * @param queryConcurrency
         *        Number of queries allowed to execute concurrently. Setting to 0 allows an unlimited number of
         *        concurrent queries.</p>
         *        <p>
         *        Default: 0
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryConcurrency(Integer queryConcurrency);

        /**
         * <p>
         * Maximum number of queries allowed in execution queue. When queue limit is reached, new queries are rejected.
         * Setting to 0 allows an unlimited number of queries in the queue.
         * </p>
         * <p>
         * Default: 0
         * </p>
         * 
         * @param queryQueueSize
         *        Maximum number of queries allowed in execution queue. When queue limit is reached, new queries are
         *        rejected. Setting to 0 allows an unlimited number of queries in the queue.</p>
         *        <p>
         *        Default: 0
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryQueueSize(Integer queryQueueSize);

        /**
         * <p>
         * Enable tracing in InfluxDB and specifies the tracing type. Tracing is disabled by default.
         * </p>
         * 
         * @param tracingType
         *        Enable tracing in InfluxDB and specifies the tracing type. Tracing is disabled by default.
         * @see TracingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TracingType
         */
        Builder tracingType(String tracingType);

        /**
         * <p>
         * Enable tracing in InfluxDB and specifies the tracing type. Tracing is disabled by default.
         * </p>
         * 
         * @param tracingType
         *        Enable tracing in InfluxDB and specifies the tracing type. Tracing is disabled by default.
         * @see TracingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TracingType
         */
        Builder tracingType(TracingType tracingType);

        /**
         * <p>
         * Disable the HTTP /metrics endpoint which exposes <a
         * href="https://docs.influxdata.com/influxdb/v2/reference/internals/metrics/">internal InfluxDB metrics</a>.
         * </p>
         * <p>
         * Default: false
         * </p>
         * 
         * @param metricsDisabled
         *        Disable the HTTP /metrics endpoint which exposes <a
         *        href="https://docs.influxdata.com/influxdb/v2/reference/internals/metrics/">internal InfluxDB
         *        metrics</a>.</p>
         *        <p>
         *        Default: false
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricsDisabled(Boolean metricsDisabled);

        /**
         * <p>
         * Maximum duration the server should keep established connections alive while waiting for new requests. Set to
         * 0 for no timeout.
         * </p>
         * <p>
         * Default: 3 minutes
         * </p>
         * 
         * @param httpIdleTimeout
         *        Maximum duration the server should keep established connections alive while waiting for new requests.
         *        Set to 0 for no timeout.</p>
         *        <p>
         *        Default: 3 minutes
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder httpIdleTimeout(Duration httpIdleTimeout);

        /**
         * <p>
         * Maximum duration the server should keep established connections alive while waiting for new requests. Set to
         * 0 for no timeout.
         * </p>
         * <p>
         * Default: 3 minutes
         * </p>
         * This is a convenience method that creates an instance of the {@link Duration.Builder} avoiding the need to
         * create one manually via {@link Duration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Duration.Builder#build()} is called immediately and its result is
         * passed to {@link #httpIdleTimeout(Duration)}.
         * 
         * @param httpIdleTimeout
         *        a consumer that will call methods on {@link Duration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #httpIdleTimeout(Duration)
         */
        default Builder httpIdleTimeout(Consumer<Duration.Builder> httpIdleTimeout) {
            return httpIdleTimeout(Duration.builder().applyMutation(httpIdleTimeout).build());
        }

        /**
         * <p>
         * Maximum duration the server should try to read HTTP headers for new requests. Set to 0 for no timeout.
         * </p>
         * <p>
         * Default: 10 seconds
         * </p>
         * 
         * @param httpReadHeaderTimeout
         *        Maximum duration the server should try to read HTTP headers for new requests. Set to 0 for no
         *        timeout.</p>
         *        <p>
         *        Default: 10 seconds
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder httpReadHeaderTimeout(Duration httpReadHeaderTimeout);

        /**
         * <p>
         * Maximum duration the server should try to read HTTP headers for new requests. Set to 0 for no timeout.
         * </p>
         * <p>
         * Default: 10 seconds
         * </p>
         * This is a convenience method that creates an instance of the {@link Duration.Builder} avoiding the need to
         * create one manually via {@link Duration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Duration.Builder#build()} is called immediately and its result is
         * passed to {@link #httpReadHeaderTimeout(Duration)}.
         * 
         * @param httpReadHeaderTimeout
         *        a consumer that will call methods on {@link Duration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #httpReadHeaderTimeout(Duration)
         */
        default Builder httpReadHeaderTimeout(Consumer<Duration.Builder> httpReadHeaderTimeout) {
            return httpReadHeaderTimeout(Duration.builder().applyMutation(httpReadHeaderTimeout).build());
        }

        /**
         * <p>
         * Maximum duration the server should try to read the entirety of new requests. Set to 0 for no timeout.
         * </p>
         * <p>
         * Default: 0
         * </p>
         * 
         * @param httpReadTimeout
         *        Maximum duration the server should try to read the entirety of new requests. Set to 0 for no
         *        timeout.</p>
         *        <p>
         *        Default: 0
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder httpReadTimeout(Duration httpReadTimeout);

        /**
         * <p>
         * Maximum duration the server should try to read the entirety of new requests. Set to 0 for no timeout.
         * </p>
         * <p>
         * Default: 0
         * </p>
         * This is a convenience method that creates an instance of the {@link Duration.Builder} avoiding the need to
         * create one manually via {@link Duration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Duration.Builder#build()} is called immediately and its result is
         * passed to {@link #httpReadTimeout(Duration)}.
         * 
         * @param httpReadTimeout
         *        a consumer that will call methods on {@link Duration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #httpReadTimeout(Duration)
         */
        default Builder httpReadTimeout(Consumer<Duration.Builder> httpReadTimeout) {
            return httpReadTimeout(Duration.builder().applyMutation(httpReadTimeout).build());
        }

        /**
         * <p>
         * Maximum duration the server should spend processing and responding to write requests. Set to 0 for no
         * timeout.
         * </p>
         * <p>
         * Default: 0
         * </p>
         * 
         * @param httpWriteTimeout
         *        Maximum duration the server should spend processing and responding to write requests. Set to 0 for no
         *        timeout.</p>
         *        <p>
         *        Default: 0
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder httpWriteTimeout(Duration httpWriteTimeout);

        /**
         * <p>
         * Maximum duration the server should spend processing and responding to write requests. Set to 0 for no
         * timeout.
         * </p>
         * <p>
         * Default: 0
         * </p>
         * This is a convenience method that creates an instance of the {@link Duration.Builder} avoiding the need to
         * create one manually via {@link Duration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Duration.Builder#build()} is called immediately and its result is
         * passed to {@link #httpWriteTimeout(Duration)}.
         * 
         * @param httpWriteTimeout
         *        a consumer that will call methods on {@link Duration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #httpWriteTimeout(Duration)
         */
        default Builder httpWriteTimeout(Consumer<Duration.Builder> httpWriteTimeout) {
            return httpWriteTimeout(Duration.builder().applyMutation(httpWriteTimeout).build());
        }

        /**
         * <p>
         * Maximum number of group by time buckets a SELECT statement can create. 0 allows an unlimited number of
         * buckets.
         * </p>
         * <p>
         * Default: 0
         * </p>
         * 
         * @param influxqlMaxSelectBuckets
         *        Maximum number of group by time buckets a SELECT statement can create. 0 allows an unlimited number of
         *        buckets.</p>
         *        <p>
         *        Default: 0
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder influxqlMaxSelectBuckets(Long influxqlMaxSelectBuckets);

        /**
         * <p>
         * Maximum number of points a SELECT statement can process. 0 allows an unlimited number of points. InfluxDB
         * checks the point count every second (so queries exceeding the maximum aren’t immediately aborted).
         * </p>
         * <p>
         * Default: 0
         * </p>
         * 
         * @param influxqlMaxSelectPoint
         *        Maximum number of points a SELECT statement can process. 0 allows an unlimited number of points.
         *        InfluxDB checks the point count every second (so queries exceeding the maximum aren’t immediately
         *        aborted).</p>
         *        <p>
         *        Default: 0
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder influxqlMaxSelectPoint(Long influxqlMaxSelectPoint);

        /**
         * <p>
         * Maximum number of series a SELECT statement can return. 0 allows an unlimited number of series.
         * </p>
         * <p>
         * Default: 0
         * </p>
         * 
         * @param influxqlMaxSelectSeries
         *        Maximum number of series a SELECT statement can return. 0 allows an unlimited number of series.</p>
         *        <p>
         *        Default: 0
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder influxqlMaxSelectSeries(Long influxqlMaxSelectSeries);

        /**
         * <p>
         * Disable the /debug/pprof HTTP endpoint. This endpoint provides runtime profiling data and can be helpful when
         * debugging.
         * </p>
         * <p>
         * Default: true
         * </p>
         * 
         * @param pprofDisabled
         *        Disable the /debug/pprof HTTP endpoint. This endpoint provides runtime profiling data and can be
         *        helpful when debugging.</p>
         *        <p>
         *        Default: true
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pprofDisabled(Boolean pprofDisabled);

        /**
         * <p>
         * Initial bytes of memory allocated for a query.
         * </p>
         * <p>
         * Default: 0
         * </p>
         * 
         * @param queryInitialMemoryBytes
         *        Initial bytes of memory allocated for a query.</p>
         *        <p>
         *        Default: 0
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryInitialMemoryBytes(Long queryInitialMemoryBytes);

        /**
         * <p>
         * Maximum number of queries allowed in execution queue. When queue limit is reached, new queries are rejected.
         * Setting to 0 allows an unlimited number of queries in the queue.
         * </p>
         * <p>
         * Default: 0
         * </p>
         * 
         * @param queryMaxMemoryBytes
         *        Maximum number of queries allowed in execution queue. When queue limit is reached, new queries are
         *        rejected. Setting to 0 allows an unlimited number of queries in the queue.</p>
         *        <p>
         *        Default: 0
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryMaxMemoryBytes(Long queryMaxMemoryBytes);

        /**
         * <p>
         * Maximum bytes of memory allowed for a single query. Must be greater or equal to queryInitialMemoryBytes.
         * </p>
         * <p>
         * Default: 0
         * </p>
         * 
         * @param queryMemoryBytes
         *        Maximum bytes of memory allowed for a single query. Must be greater or equal to
         *        queryInitialMemoryBytes.</p>
         *        <p>
         *        Default: 0
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryMemoryBytes(Long queryMemoryBytes);

        /**
         * <p>
         * Specifies the Time to Live (TTL) in minutes for newly created user sessions.
         * </p>
         * <p>
         * Default: 60
         * </p>
         * 
         * @param sessionLength
         *        Specifies the Time to Live (TTL) in minutes for newly created user sessions.</p>
         *        <p>
         *        Default: 60
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionLength(Integer sessionLength);

        /**
         * <p>
         * Disables automatically extending a user’s session TTL on each request. By default, every request sets the
         * session’s expiration time to five minutes from now. When disabled, sessions expire after the specified <a
         * href="https://docs.influxdata.com/influxdb/v2/reference/config-options/#session-length">session length</a>
         * and the user is redirected to the login page, even if recently active.
         * </p>
         * <p>
         * Default: false
         * </p>
         * 
         * @param sessionRenewDisabled
         *        Disables automatically extending a user’s session TTL on each request. By default, every request sets
         *        the session’s expiration time to five minutes from now. When disabled, sessions expire after the
         *        specified <a
         *        href="https://docs.influxdata.com/influxdb/v2/reference/config-options/#session-length">session
         *        length</a> and the user is redirected to the login page, even if recently active.</p>
         *        <p>
         *        Default: false
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionRenewDisabled(Boolean sessionRenewDisabled);

        /**
         * <p>
         * Maximum size (in bytes) a shard’s cache can reach before it starts rejecting writes. Must be greater than
         * storageCacheSnapShotMemorySize and lower than instance’s total memory capacity. We recommend setting it to
         * below 15% of the total memory capacity.
         * </p>
         * <p>
         * Default: 1073741824
         * </p>
         * 
         * @param storageCacheMaxMemorySize
         *        Maximum size (in bytes) a shard’s cache can reach before it starts rejecting writes. Must be greater
         *        than storageCacheSnapShotMemorySize and lower than instance’s total memory capacity. We recommend
         *        setting it to below 15% of the total memory capacity.</p>
         *        <p>
         *        Default: 1073741824
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageCacheMaxMemorySize(Long storageCacheMaxMemorySize);

        /**
         * <p>
         * Size (in bytes) at which the storage engine will snapshot the cache and write it to a TSM file to make more
         * memory available. Must not be greater than storageCacheMaxMemorySize.
         * </p>
         * <p>
         * Default: 26214400
         * </p>
         * 
         * @param storageCacheSnapshotMemorySize
         *        Size (in bytes) at which the storage engine will snapshot the cache and write it to a TSM file to make
         *        more memory available. Must not be greater than storageCacheMaxMemorySize.</p>
         *        <p>
         *        Default: 26214400
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageCacheSnapshotMemorySize(Long storageCacheSnapshotMemorySize);

        /**
         * <p>
         * Duration at which the storage engine will snapshot the cache and write it to a new TSM file if the shard
         * hasn’t received writes or deletes.
         * </p>
         * <p>
         * Default: 10 minutes
         * </p>
         * 
         * @param storageCacheSnapshotWriteColdDuration
         *        Duration at which the storage engine will snapshot the cache and write it to a new TSM file if the
         *        shard hasn’t received writes or deletes.</p>
         *        <p>
         *        Default: 10 minutes
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageCacheSnapshotWriteColdDuration(Duration storageCacheSnapshotWriteColdDuration);

        /**
         * <p>
         * Duration at which the storage engine will snapshot the cache and write it to a new TSM file if the shard
         * hasn’t received writes or deletes.
         * </p>
         * <p>
         * Default: 10 minutes
         * </p>
         * This is a convenience method that creates an instance of the {@link Duration.Builder} avoiding the need to
         * create one manually via {@link Duration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Duration.Builder#build()} is called immediately and its result is
         * passed to {@link #storageCacheSnapshotWriteColdDuration(Duration)}.
         * 
         * @param storageCacheSnapshotWriteColdDuration
         *        a consumer that will call methods on {@link Duration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #storageCacheSnapshotWriteColdDuration(Duration)
         */
        default Builder storageCacheSnapshotWriteColdDuration(Consumer<Duration.Builder> storageCacheSnapshotWriteColdDuration) {
            return storageCacheSnapshotWriteColdDuration(Duration.builder().applyMutation(storageCacheSnapshotWriteColdDuration)
                    .build());
        }

        /**
         * <p>
         * Duration at which the storage engine will compact all TSM files in a shard if it hasn't received writes or
         * deletes.
         * </p>
         * <p>
         * Default: 4 hours
         * </p>
         * 
         * @param storageCompactFullWriteColdDuration
         *        Duration at which the storage engine will compact all TSM files in a shard if it hasn't received
         *        writes or deletes.</p>
         *        <p>
         *        Default: 4 hours
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageCompactFullWriteColdDuration(Duration storageCompactFullWriteColdDuration);

        /**
         * <p>
         * Duration at which the storage engine will compact all TSM files in a shard if it hasn't received writes or
         * deletes.
         * </p>
         * <p>
         * Default: 4 hours
         * </p>
         * This is a convenience method that creates an instance of the {@link Duration.Builder} avoiding the need to
         * create one manually via {@link Duration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Duration.Builder#build()} is called immediately and its result is
         * passed to {@link #storageCompactFullWriteColdDuration(Duration)}.
         * 
         * @param storageCompactFullWriteColdDuration
         *        a consumer that will call methods on {@link Duration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #storageCompactFullWriteColdDuration(Duration)
         */
        default Builder storageCompactFullWriteColdDuration(Consumer<Duration.Builder> storageCompactFullWriteColdDuration) {
            return storageCompactFullWriteColdDuration(Duration.builder().applyMutation(storageCompactFullWriteColdDuration)
                    .build());
        }

        /**
         * <p>
         * Rate limit (in bytes per second) that TSM compactions can write to disk.
         * </p>
         * <p>
         * Default: 50331648
         * </p>
         * 
         * @param storageCompactThroughputBurst
         *        Rate limit (in bytes per second) that TSM compactions can write to disk.</p>
         *        <p>
         *        Default: 50331648
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageCompactThroughputBurst(Long storageCompactThroughputBurst);

        /**
         * <p>
         * Maximum number of full and level compactions that can run concurrently. A value of 0 results in 50% of
         * runtime.GOMAXPROCS(0) used at runtime. Any number greater than zero limits compactions to that value. This
         * setting does not apply to cache snapshotting.
         * </p>
         * <p>
         * Default: 0
         * </p>
         * 
         * @param storageMaxConcurrentCompactions
         *        Maximum number of full and level compactions that can run concurrently. A value of 0 results in 50% of
         *        runtime.GOMAXPROCS(0) used at runtime. Any number greater than zero limits compactions to that value.
         *        This setting does not apply to cache snapshotting.</p>
         *        <p>
         *        Default: 0
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageMaxConcurrentCompactions(Integer storageMaxConcurrentCompactions);

        /**
         * <p>
         * Size (in bytes) at which an index write-ahead log (WAL) file will compact into an index file. Lower sizes
         * will cause log files to be compacted more quickly and result in lower heap usage at the expense of write
         * throughput.
         * </p>
         * <p>
         * Default: 1048576
         * </p>
         * 
         * @param storageMaxIndexLogFileSize
         *        Size (in bytes) at which an index write-ahead log (WAL) file will compact into an index file. Lower
         *        sizes will cause log files to be compacted more quickly and result in lower heap usage at the expense
         *        of write throughput.</p>
         *        <p>
         *        Default: 1048576
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageMaxIndexLogFileSize(Long storageMaxIndexLogFileSize);

        /**
         * <p>
         * Skip field size validation on incoming write requests.
         * </p>
         * <p>
         * Default: false
         * </p>
         * 
         * @param storageNoValidateFieldSize
         *        Skip field size validation on incoming write requests.</p>
         *        <p>
         *        Default: false
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageNoValidateFieldSize(Boolean storageNoValidateFieldSize);

        /**
         * <p>
         * Interval of retention policy enforcement checks. Must be greater than 0.
         * </p>
         * <p>
         * Default: 30 minutes
         * </p>
         * 
         * @param storageRetentionCheckInterval
         *        Interval of retention policy enforcement checks. Must be greater than 0.</p>
         *        <p>
         *        Default: 30 minutes
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageRetentionCheckInterval(Duration storageRetentionCheckInterval);

        /**
         * <p>
         * Interval of retention policy enforcement checks. Must be greater than 0.
         * </p>
         * <p>
         * Default: 30 minutes
         * </p>
         * This is a convenience method that creates an instance of the {@link Duration.Builder} avoiding the need to
         * create one manually via {@link Duration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Duration.Builder#build()} is called immediately and its result is
         * passed to {@link #storageRetentionCheckInterval(Duration)}.
         * 
         * @param storageRetentionCheckInterval
         *        a consumer that will call methods on {@link Duration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #storageRetentionCheckInterval(Duration)
         */
        default Builder storageRetentionCheckInterval(Consumer<Duration.Builder> storageRetentionCheckInterval) {
            return storageRetentionCheckInterval(Duration.builder().applyMutation(storageRetentionCheckInterval).build());
        }

        /**
         * <p>
         * Maximum number of snapshot compactions that can run concurrently across all series partitions in a database.
         * </p>
         * <p>
         * Default: 0
         * </p>
         * 
         * @param storageSeriesFileMaxConcurrentSnapshotCompactions
         *        Maximum number of snapshot compactions that can run concurrently across all series partitions in a
         *        database.</p>
         *        <p>
         *        Default: 0
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageSeriesFileMaxConcurrentSnapshotCompactions(Integer storageSeriesFileMaxConcurrentSnapshotCompactions);

        /**
         * <p>
         * Size of the internal cache used in the TSI index to store previously calculated series results. Cached
         * results are returned quickly rather than needing to be recalculated when a subsequent query with the same tag
         * key/value predicate is executed. Setting this value to 0 will disable the cache and may decrease query
         * performance.
         * </p>
         * <p>
         * Default: 100
         * </p>
         * 
         * @param storageSeriesIdSetCacheSize
         *        Size of the internal cache used in the TSI index to store previously calculated series results. Cached
         *        results are returned quickly rather than needing to be recalculated when a subsequent query with the
         *        same tag key/value predicate is executed. Setting this value to 0 will disable the cache and may
         *        decrease query performance.</p>
         *        <p>
         *        Default: 100
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageSeriesIdSetCacheSize(Long storageSeriesIdSetCacheSize);

        /**
         * <p>
         * Maximum number writes to the WAL directory to attempt at the same time. Setting this value to 0 results in
         * number of processing units available x2.
         * </p>
         * <p>
         * Default: 0
         * </p>
         * 
         * @param storageWalMaxConcurrentWrites
         *        Maximum number writes to the WAL directory to attempt at the same time. Setting this value to 0
         *        results in number of processing units available x2.</p>
         *        <p>
         *        Default: 0
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageWalMaxConcurrentWrites(Integer storageWalMaxConcurrentWrites);

        /**
         * <p>
         * Maximum amount of time a write request to the WAL directory will wait when the <a
         * href="https://docs.influxdata.com/influxdb/v2/reference/config-options/#storage-wal-max-concurrent-writes"
         * >maximum number of concurrent active writes to the WAL directory has been met</a>. Set to 0 to disable the
         * timeout.
         * </p>
         * <p>
         * Default: 10 minutes
         * </p>
         * 
         * @param storageWalMaxWriteDelay
         *        Maximum amount of time a write request to the WAL directory will wait when the <a href=
         *        "https://docs.influxdata.com/influxdb/v2/reference/config-options/#storage-wal-max-concurrent-writes"
         *        >maximum number of concurrent active writes to the WAL directory has been met</a>. Set to 0 to disable
         *        the timeout.</p>
         *        <p>
         *        Default: 10 minutes
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageWalMaxWriteDelay(Duration storageWalMaxWriteDelay);

        /**
         * <p>
         * Maximum amount of time a write request to the WAL directory will wait when the <a
         * href="https://docs.influxdata.com/influxdb/v2/reference/config-options/#storage-wal-max-concurrent-writes"
         * >maximum number of concurrent active writes to the WAL directory has been met</a>. Set to 0 to disable the
         * timeout.
         * </p>
         * <p>
         * Default: 10 minutes
         * </p>
         * This is a convenience method that creates an instance of the {@link Duration.Builder} avoiding the need to
         * create one manually via {@link Duration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Duration.Builder#build()} is called immediately and its result is
         * passed to {@link #storageWalMaxWriteDelay(Duration)}.
         * 
         * @param storageWalMaxWriteDelay
         *        a consumer that will call methods on {@link Duration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #storageWalMaxWriteDelay(Duration)
         */
        default Builder storageWalMaxWriteDelay(Consumer<Duration.Builder> storageWalMaxWriteDelay) {
            return storageWalMaxWriteDelay(Duration.builder().applyMutation(storageWalMaxWriteDelay).build());
        }

        /**
         * <p>
         * Disable the InfluxDB user interface (UI). The UI is enabled by default.
         * </p>
         * <p>
         * Default: false
         * </p>
         * 
         * @param uiDisabled
         *        Disable the InfluxDB user interface (UI). The UI is enabled by default.</p>
         *        <p>
         *        Default: false
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uiDisabled(Boolean uiDisabled);
    }

    static final class BuilderImpl implements Builder {
        private Boolean fluxLogEnabled;

        private String logLevel;

        private Boolean noTasks;

        private Integer queryConcurrency;

        private Integer queryQueueSize;

        private String tracingType;

        private Boolean metricsDisabled;

        private Duration httpIdleTimeout;

        private Duration httpReadHeaderTimeout;

        private Duration httpReadTimeout;

        private Duration httpWriteTimeout;

        private Long influxqlMaxSelectBuckets;

        private Long influxqlMaxSelectPoint;

        private Long influxqlMaxSelectSeries;

        private Boolean pprofDisabled;

        private Long queryInitialMemoryBytes;

        private Long queryMaxMemoryBytes;

        private Long queryMemoryBytes;

        private Integer sessionLength;

        private Boolean sessionRenewDisabled;

        private Long storageCacheMaxMemorySize;

        private Long storageCacheSnapshotMemorySize;

        private Duration storageCacheSnapshotWriteColdDuration;

        private Duration storageCompactFullWriteColdDuration;

        private Long storageCompactThroughputBurst;

        private Integer storageMaxConcurrentCompactions;

        private Long storageMaxIndexLogFileSize;

        private Boolean storageNoValidateFieldSize;

        private Duration storageRetentionCheckInterval;

        private Integer storageSeriesFileMaxConcurrentSnapshotCompactions;

        private Long storageSeriesIdSetCacheSize;

        private Integer storageWalMaxConcurrentWrites;

        private Duration storageWalMaxWriteDelay;

        private Boolean uiDisabled;

        private BuilderImpl() {
        }

        private BuilderImpl(InfluxDBv2Parameters model) {
            fluxLogEnabled(model.fluxLogEnabled);
            logLevel(model.logLevel);
            noTasks(model.noTasks);
            queryConcurrency(model.queryConcurrency);
            queryQueueSize(model.queryQueueSize);
            tracingType(model.tracingType);
            metricsDisabled(model.metricsDisabled);
            httpIdleTimeout(model.httpIdleTimeout);
            httpReadHeaderTimeout(model.httpReadHeaderTimeout);
            httpReadTimeout(model.httpReadTimeout);
            httpWriteTimeout(model.httpWriteTimeout);
            influxqlMaxSelectBuckets(model.influxqlMaxSelectBuckets);
            influxqlMaxSelectPoint(model.influxqlMaxSelectPoint);
            influxqlMaxSelectSeries(model.influxqlMaxSelectSeries);
            pprofDisabled(model.pprofDisabled);
            queryInitialMemoryBytes(model.queryInitialMemoryBytes);
            queryMaxMemoryBytes(model.queryMaxMemoryBytes);
            queryMemoryBytes(model.queryMemoryBytes);
            sessionLength(model.sessionLength);
            sessionRenewDisabled(model.sessionRenewDisabled);
            storageCacheMaxMemorySize(model.storageCacheMaxMemorySize);
            storageCacheSnapshotMemorySize(model.storageCacheSnapshotMemorySize);
            storageCacheSnapshotWriteColdDuration(model.storageCacheSnapshotWriteColdDuration);
            storageCompactFullWriteColdDuration(model.storageCompactFullWriteColdDuration);
            storageCompactThroughputBurst(model.storageCompactThroughputBurst);
            storageMaxConcurrentCompactions(model.storageMaxConcurrentCompactions);
            storageMaxIndexLogFileSize(model.storageMaxIndexLogFileSize);
            storageNoValidateFieldSize(model.storageNoValidateFieldSize);
            storageRetentionCheckInterval(model.storageRetentionCheckInterval);
            storageSeriesFileMaxConcurrentSnapshotCompactions(model.storageSeriesFileMaxConcurrentSnapshotCompactions);
            storageSeriesIdSetCacheSize(model.storageSeriesIdSetCacheSize);
            storageWalMaxConcurrentWrites(model.storageWalMaxConcurrentWrites);
            storageWalMaxWriteDelay(model.storageWalMaxWriteDelay);
            uiDisabled(model.uiDisabled);
        }

        public final Boolean getFluxLogEnabled() {
            return fluxLogEnabled;
        }

        public final void setFluxLogEnabled(Boolean fluxLogEnabled) {
            this.fluxLogEnabled = fluxLogEnabled;
        }

        @Override
        public final Builder fluxLogEnabled(Boolean fluxLogEnabled) {
            this.fluxLogEnabled = fluxLogEnabled;
            return this;
        }

        public final String getLogLevel() {
            return logLevel;
        }

        public final void setLogLevel(String logLevel) {
            this.logLevel = logLevel;
        }

        @Override
        public final Builder logLevel(String logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        @Override
        public final Builder logLevel(LogLevel logLevel) {
            this.logLevel(logLevel == null ? null : logLevel.toString());
            return this;
        }

        public final Boolean getNoTasks() {
            return noTasks;
        }

        public final void setNoTasks(Boolean noTasks) {
            this.noTasks = noTasks;
        }

        @Override
        public final Builder noTasks(Boolean noTasks) {
            this.noTasks = noTasks;
            return this;
        }

        public final Integer getQueryConcurrency() {
            return queryConcurrency;
        }

        public final void setQueryConcurrency(Integer queryConcurrency) {
            this.queryConcurrency = queryConcurrency;
        }

        @Override
        public final Builder queryConcurrency(Integer queryConcurrency) {
            this.queryConcurrency = queryConcurrency;
            return this;
        }

        public final Integer getQueryQueueSize() {
            return queryQueueSize;
        }

        public final void setQueryQueueSize(Integer queryQueueSize) {
            this.queryQueueSize = queryQueueSize;
        }

        @Override
        public final Builder queryQueueSize(Integer queryQueueSize) {
            this.queryQueueSize = queryQueueSize;
            return this;
        }

        public final String getTracingType() {
            return tracingType;
        }

        public final void setTracingType(String tracingType) {
            this.tracingType = tracingType;
        }

        @Override
        public final Builder tracingType(String tracingType) {
            this.tracingType = tracingType;
            return this;
        }

        @Override
        public final Builder tracingType(TracingType tracingType) {
            this.tracingType(tracingType == null ? null : tracingType.toString());
            return this;
        }

        public final Boolean getMetricsDisabled() {
            return metricsDisabled;
        }

        public final void setMetricsDisabled(Boolean metricsDisabled) {
            this.metricsDisabled = metricsDisabled;
        }

        @Override
        public final Builder metricsDisabled(Boolean metricsDisabled) {
            this.metricsDisabled = metricsDisabled;
            return this;
        }

        public final Duration.Builder getHttpIdleTimeout() {
            return httpIdleTimeout != null ? httpIdleTimeout.toBuilder() : null;
        }

        public final void setHttpIdleTimeout(Duration.BuilderImpl httpIdleTimeout) {
            this.httpIdleTimeout = httpIdleTimeout != null ? httpIdleTimeout.build() : null;
        }

        @Override
        public final Builder httpIdleTimeout(Duration httpIdleTimeout) {
            this.httpIdleTimeout = httpIdleTimeout;
            return this;
        }

        public final Duration.Builder getHttpReadHeaderTimeout() {
            return httpReadHeaderTimeout != null ? httpReadHeaderTimeout.toBuilder() : null;
        }

        public final void setHttpReadHeaderTimeout(Duration.BuilderImpl httpReadHeaderTimeout) {
            this.httpReadHeaderTimeout = httpReadHeaderTimeout != null ? httpReadHeaderTimeout.build() : null;
        }

        @Override
        public final Builder httpReadHeaderTimeout(Duration httpReadHeaderTimeout) {
            this.httpReadHeaderTimeout = httpReadHeaderTimeout;
            return this;
        }

        public final Duration.Builder getHttpReadTimeout() {
            return httpReadTimeout != null ? httpReadTimeout.toBuilder() : null;
        }

        public final void setHttpReadTimeout(Duration.BuilderImpl httpReadTimeout) {
            this.httpReadTimeout = httpReadTimeout != null ? httpReadTimeout.build() : null;
        }

        @Override
        public final Builder httpReadTimeout(Duration httpReadTimeout) {
            this.httpReadTimeout = httpReadTimeout;
            return this;
        }

        public final Duration.Builder getHttpWriteTimeout() {
            return httpWriteTimeout != null ? httpWriteTimeout.toBuilder() : null;
        }

        public final void setHttpWriteTimeout(Duration.BuilderImpl httpWriteTimeout) {
            this.httpWriteTimeout = httpWriteTimeout != null ? httpWriteTimeout.build() : null;
        }

        @Override
        public final Builder httpWriteTimeout(Duration httpWriteTimeout) {
            this.httpWriteTimeout = httpWriteTimeout;
            return this;
        }

        public final Long getInfluxqlMaxSelectBuckets() {
            return influxqlMaxSelectBuckets;
        }

        public final void setInfluxqlMaxSelectBuckets(Long influxqlMaxSelectBuckets) {
            this.influxqlMaxSelectBuckets = influxqlMaxSelectBuckets;
        }

        @Override
        public final Builder influxqlMaxSelectBuckets(Long influxqlMaxSelectBuckets) {
            this.influxqlMaxSelectBuckets = influxqlMaxSelectBuckets;
            return this;
        }

        public final Long getInfluxqlMaxSelectPoint() {
            return influxqlMaxSelectPoint;
        }

        public final void setInfluxqlMaxSelectPoint(Long influxqlMaxSelectPoint) {
            this.influxqlMaxSelectPoint = influxqlMaxSelectPoint;
        }

        @Override
        public final Builder influxqlMaxSelectPoint(Long influxqlMaxSelectPoint) {
            this.influxqlMaxSelectPoint = influxqlMaxSelectPoint;
            return this;
        }

        public final Long getInfluxqlMaxSelectSeries() {
            return influxqlMaxSelectSeries;
        }

        public final void setInfluxqlMaxSelectSeries(Long influxqlMaxSelectSeries) {
            this.influxqlMaxSelectSeries = influxqlMaxSelectSeries;
        }

        @Override
        public final Builder influxqlMaxSelectSeries(Long influxqlMaxSelectSeries) {
            this.influxqlMaxSelectSeries = influxqlMaxSelectSeries;
            return this;
        }

        public final Boolean getPprofDisabled() {
            return pprofDisabled;
        }

        public final void setPprofDisabled(Boolean pprofDisabled) {
            this.pprofDisabled = pprofDisabled;
        }

        @Override
        public final Builder pprofDisabled(Boolean pprofDisabled) {
            this.pprofDisabled = pprofDisabled;
            return this;
        }

        public final Long getQueryInitialMemoryBytes() {
            return queryInitialMemoryBytes;
        }

        public final void setQueryInitialMemoryBytes(Long queryInitialMemoryBytes) {
            this.queryInitialMemoryBytes = queryInitialMemoryBytes;
        }

        @Override
        public final Builder queryInitialMemoryBytes(Long queryInitialMemoryBytes) {
            this.queryInitialMemoryBytes = queryInitialMemoryBytes;
            return this;
        }

        public final Long getQueryMaxMemoryBytes() {
            return queryMaxMemoryBytes;
        }

        public final void setQueryMaxMemoryBytes(Long queryMaxMemoryBytes) {
            this.queryMaxMemoryBytes = queryMaxMemoryBytes;
        }

        @Override
        public final Builder queryMaxMemoryBytes(Long queryMaxMemoryBytes) {
            this.queryMaxMemoryBytes = queryMaxMemoryBytes;
            return this;
        }

        public final Long getQueryMemoryBytes() {
            return queryMemoryBytes;
        }

        public final void setQueryMemoryBytes(Long queryMemoryBytes) {
            this.queryMemoryBytes = queryMemoryBytes;
        }

        @Override
        public final Builder queryMemoryBytes(Long queryMemoryBytes) {
            this.queryMemoryBytes = queryMemoryBytes;
            return this;
        }

        public final Integer getSessionLength() {
            return sessionLength;
        }

        public final void setSessionLength(Integer sessionLength) {
            this.sessionLength = sessionLength;
        }

        @Override
        public final Builder sessionLength(Integer sessionLength) {
            this.sessionLength = sessionLength;
            return this;
        }

        public final Boolean getSessionRenewDisabled() {
            return sessionRenewDisabled;
        }

        public final void setSessionRenewDisabled(Boolean sessionRenewDisabled) {
            this.sessionRenewDisabled = sessionRenewDisabled;
        }

        @Override
        public final Builder sessionRenewDisabled(Boolean sessionRenewDisabled) {
            this.sessionRenewDisabled = sessionRenewDisabled;
            return this;
        }

        public final Long getStorageCacheMaxMemorySize() {
            return storageCacheMaxMemorySize;
        }

        public final void setStorageCacheMaxMemorySize(Long storageCacheMaxMemorySize) {
            this.storageCacheMaxMemorySize = storageCacheMaxMemorySize;
        }

        @Override
        public final Builder storageCacheMaxMemorySize(Long storageCacheMaxMemorySize) {
            this.storageCacheMaxMemorySize = storageCacheMaxMemorySize;
            return this;
        }

        public final Long getStorageCacheSnapshotMemorySize() {
            return storageCacheSnapshotMemorySize;
        }

        public final void setStorageCacheSnapshotMemorySize(Long storageCacheSnapshotMemorySize) {
            this.storageCacheSnapshotMemorySize = storageCacheSnapshotMemorySize;
        }

        @Override
        public final Builder storageCacheSnapshotMemorySize(Long storageCacheSnapshotMemorySize) {
            this.storageCacheSnapshotMemorySize = storageCacheSnapshotMemorySize;
            return this;
        }

        public final Duration.Builder getStorageCacheSnapshotWriteColdDuration() {
            return storageCacheSnapshotWriteColdDuration != null ? storageCacheSnapshotWriteColdDuration.toBuilder() : null;
        }

        public final void setStorageCacheSnapshotWriteColdDuration(Duration.BuilderImpl storageCacheSnapshotWriteColdDuration) {
            this.storageCacheSnapshotWriteColdDuration = storageCacheSnapshotWriteColdDuration != null ? storageCacheSnapshotWriteColdDuration
                    .build() : null;
        }

        @Override
        public final Builder storageCacheSnapshotWriteColdDuration(Duration storageCacheSnapshotWriteColdDuration) {
            this.storageCacheSnapshotWriteColdDuration = storageCacheSnapshotWriteColdDuration;
            return this;
        }

        public final Duration.Builder getStorageCompactFullWriteColdDuration() {
            return storageCompactFullWriteColdDuration != null ? storageCompactFullWriteColdDuration.toBuilder() : null;
        }

        public final void setStorageCompactFullWriteColdDuration(Duration.BuilderImpl storageCompactFullWriteColdDuration) {
            this.storageCompactFullWriteColdDuration = storageCompactFullWriteColdDuration != null ? storageCompactFullWriteColdDuration
                    .build() : null;
        }

        @Override
        public final Builder storageCompactFullWriteColdDuration(Duration storageCompactFullWriteColdDuration) {
            this.storageCompactFullWriteColdDuration = storageCompactFullWriteColdDuration;
            return this;
        }

        public final Long getStorageCompactThroughputBurst() {
            return storageCompactThroughputBurst;
        }

        public final void setStorageCompactThroughputBurst(Long storageCompactThroughputBurst) {
            this.storageCompactThroughputBurst = storageCompactThroughputBurst;
        }

        @Override
        public final Builder storageCompactThroughputBurst(Long storageCompactThroughputBurst) {
            this.storageCompactThroughputBurst = storageCompactThroughputBurst;
            return this;
        }

        public final Integer getStorageMaxConcurrentCompactions() {
            return storageMaxConcurrentCompactions;
        }

        public final void setStorageMaxConcurrentCompactions(Integer storageMaxConcurrentCompactions) {
            this.storageMaxConcurrentCompactions = storageMaxConcurrentCompactions;
        }

        @Override
        public final Builder storageMaxConcurrentCompactions(Integer storageMaxConcurrentCompactions) {
            this.storageMaxConcurrentCompactions = storageMaxConcurrentCompactions;
            return this;
        }

        public final Long getStorageMaxIndexLogFileSize() {
            return storageMaxIndexLogFileSize;
        }

        public final void setStorageMaxIndexLogFileSize(Long storageMaxIndexLogFileSize) {
            this.storageMaxIndexLogFileSize = storageMaxIndexLogFileSize;
        }

        @Override
        public final Builder storageMaxIndexLogFileSize(Long storageMaxIndexLogFileSize) {
            this.storageMaxIndexLogFileSize = storageMaxIndexLogFileSize;
            return this;
        }

        public final Boolean getStorageNoValidateFieldSize() {
            return storageNoValidateFieldSize;
        }

        public final void setStorageNoValidateFieldSize(Boolean storageNoValidateFieldSize) {
            this.storageNoValidateFieldSize = storageNoValidateFieldSize;
        }

        @Override
        public final Builder storageNoValidateFieldSize(Boolean storageNoValidateFieldSize) {
            this.storageNoValidateFieldSize = storageNoValidateFieldSize;
            return this;
        }

        public final Duration.Builder getStorageRetentionCheckInterval() {
            return storageRetentionCheckInterval != null ? storageRetentionCheckInterval.toBuilder() : null;
        }

        public final void setStorageRetentionCheckInterval(Duration.BuilderImpl storageRetentionCheckInterval) {
            this.storageRetentionCheckInterval = storageRetentionCheckInterval != null ? storageRetentionCheckInterval.build()
                    : null;
        }

        @Override
        public final Builder storageRetentionCheckInterval(Duration storageRetentionCheckInterval) {
            this.storageRetentionCheckInterval = storageRetentionCheckInterval;
            return this;
        }

        public final Integer getStorageSeriesFileMaxConcurrentSnapshotCompactions() {
            return storageSeriesFileMaxConcurrentSnapshotCompactions;
        }

        public final void setStorageSeriesFileMaxConcurrentSnapshotCompactions(
                Integer storageSeriesFileMaxConcurrentSnapshotCompactions) {
            this.storageSeriesFileMaxConcurrentSnapshotCompactions = storageSeriesFileMaxConcurrentSnapshotCompactions;
        }

        @Override
        public final Builder storageSeriesFileMaxConcurrentSnapshotCompactions(
                Integer storageSeriesFileMaxConcurrentSnapshotCompactions) {
            this.storageSeriesFileMaxConcurrentSnapshotCompactions = storageSeriesFileMaxConcurrentSnapshotCompactions;
            return this;
        }

        public final Long getStorageSeriesIdSetCacheSize() {
            return storageSeriesIdSetCacheSize;
        }

        public final void setStorageSeriesIdSetCacheSize(Long storageSeriesIdSetCacheSize) {
            this.storageSeriesIdSetCacheSize = storageSeriesIdSetCacheSize;
        }

        @Override
        public final Builder storageSeriesIdSetCacheSize(Long storageSeriesIdSetCacheSize) {
            this.storageSeriesIdSetCacheSize = storageSeriesIdSetCacheSize;
            return this;
        }

        public final Integer getStorageWalMaxConcurrentWrites() {
            return storageWalMaxConcurrentWrites;
        }

        public final void setStorageWalMaxConcurrentWrites(Integer storageWalMaxConcurrentWrites) {
            this.storageWalMaxConcurrentWrites = storageWalMaxConcurrentWrites;
        }

        @Override
        public final Builder storageWalMaxConcurrentWrites(Integer storageWalMaxConcurrentWrites) {
            this.storageWalMaxConcurrentWrites = storageWalMaxConcurrentWrites;
            return this;
        }

        public final Duration.Builder getStorageWalMaxWriteDelay() {
            return storageWalMaxWriteDelay != null ? storageWalMaxWriteDelay.toBuilder() : null;
        }

        public final void setStorageWalMaxWriteDelay(Duration.BuilderImpl storageWalMaxWriteDelay) {
            this.storageWalMaxWriteDelay = storageWalMaxWriteDelay != null ? storageWalMaxWriteDelay.build() : null;
        }

        @Override
        public final Builder storageWalMaxWriteDelay(Duration storageWalMaxWriteDelay) {
            this.storageWalMaxWriteDelay = storageWalMaxWriteDelay;
            return this;
        }

        public final Boolean getUiDisabled() {
            return uiDisabled;
        }

        public final void setUiDisabled(Boolean uiDisabled) {
            this.uiDisabled = uiDisabled;
        }

        @Override
        public final Builder uiDisabled(Boolean uiDisabled) {
            this.uiDisabled = uiDisabled;
            return this;
        }

        @Override
        public InfluxDBv2Parameters build() {
            return new InfluxDBv2Parameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
