/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.timestreaminfluxdb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * All the customer-modifiable InfluxDB v3 Enterprise parameters in Timestream for InfluxDB.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InfluxDBv3EnterpriseParameters implements SdkPojo, Serializable,
        ToCopyableBuilder<InfluxDBv3EnterpriseParameters.Builder, InfluxDBv3EnterpriseParameters> {
    private static final SdkField<Integer> QUERY_FILE_LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("queryFileLimit").getter(getter(InfluxDBv3EnterpriseParameters::queryFileLimit))
            .setter(setter(Builder::queryFileLimit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryFileLimit").build()).build();

    private static final SdkField<Integer> QUERY_LOG_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("queryLogSize").getter(getter(InfluxDBv3EnterpriseParameters::queryLogSize))
            .setter(setter(Builder::queryLogSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryLogSize").build()).build();

    private static final SdkField<String> LOG_FILTER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("logFilter").getter(getter(InfluxDBv3EnterpriseParameters::logFilter)).setter(setter(Builder::logFilter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logFilter").build()).build();

    private static final SdkField<String> LOG_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("logFormat").getter(getter(InfluxDBv3EnterpriseParameters::logFormatAsString))
            .setter(setter(Builder::logFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logFormat").build()).build();

    private static final SdkField<Integer> DATA_FUSION_NUM_THREADS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("dataFusionNumThreads").getter(getter(InfluxDBv3EnterpriseParameters::dataFusionNumThreads))
            .setter(setter(Builder::dataFusionNumThreads))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataFusionNumThreads").build())
            .build();

    private static final SdkField<String> DATA_FUSION_RUNTIME_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataFusionRuntimeType").getter(getter(InfluxDBv3EnterpriseParameters::dataFusionRuntimeTypeAsString))
            .setter(setter(Builder::dataFusionRuntimeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataFusionRuntimeType").build())
            .build();

    private static final SdkField<Boolean> DATA_FUSION_RUNTIME_DISABLE_LIFO_SLOT_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("dataFusionRuntimeDisableLifoSlot")
            .getter(getter(InfluxDBv3EnterpriseParameters::dataFusionRuntimeDisableLifoSlot))
            .setter(setter(Builder::dataFusionRuntimeDisableLifoSlot))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataFusionRuntimeDisableLifoSlot")
                    .build()).build();

    private static final SdkField<Integer> DATA_FUSION_RUNTIME_EVENT_INTERVAL_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("dataFusionRuntimeEventInterval")
            .getter(getter(InfluxDBv3EnterpriseParameters::dataFusionRuntimeEventInterval))
            .setter(setter(Builder::dataFusionRuntimeEventInterval))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataFusionRuntimeEventInterval")
                    .build()).build();

    private static final SdkField<Integer> DATA_FUSION_RUNTIME_GLOBAL_QUEUE_INTERVAL_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("dataFusionRuntimeGlobalQueueInterval")
            .getter(getter(InfluxDBv3EnterpriseParameters::dataFusionRuntimeGlobalQueueInterval))
            .setter(setter(Builder::dataFusionRuntimeGlobalQueueInterval))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("dataFusionRuntimeGlobalQueueInterval").build()).build();

    private static final SdkField<Integer> DATA_FUSION_RUNTIME_MAX_BLOCKING_THREADS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("dataFusionRuntimeMaxBlockingThreads")
            .getter(getter(InfluxDBv3EnterpriseParameters::dataFusionRuntimeMaxBlockingThreads))
            .setter(setter(Builder::dataFusionRuntimeMaxBlockingThreads))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("dataFusionRuntimeMaxBlockingThreads").build()).build();

    private static final SdkField<Integer> DATA_FUSION_RUNTIME_MAX_IO_EVENTS_PER_TICK_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("dataFusionRuntimeMaxIoEventsPerTick")
            .getter(getter(InfluxDBv3EnterpriseParameters::dataFusionRuntimeMaxIoEventsPerTick))
            .setter(setter(Builder::dataFusionRuntimeMaxIoEventsPerTick))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("dataFusionRuntimeMaxIoEventsPerTick").build()).build();

    private static final SdkField<Duration> DATA_FUSION_RUNTIME_THREAD_KEEP_ALIVE_FIELD = SdkField
            .<Duration> builder(MarshallingType.SDK_POJO)
            .memberName("dataFusionRuntimeThreadKeepAlive")
            .getter(getter(InfluxDBv3EnterpriseParameters::dataFusionRuntimeThreadKeepAlive))
            .setter(setter(Builder::dataFusionRuntimeThreadKeepAlive))
            .constructor(Duration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataFusionRuntimeThreadKeepAlive")
                    .build()).build();

    private static final SdkField<Integer> DATA_FUSION_RUNTIME_THREAD_PRIORITY_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("dataFusionRuntimeThreadPriority")
            .getter(getter(InfluxDBv3EnterpriseParameters::dataFusionRuntimeThreadPriority))
            .setter(setter(Builder::dataFusionRuntimeThreadPriority))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataFusionRuntimeThreadPriority")
                    .build()).build();

    private static final SdkField<Integer> DATA_FUSION_MAX_PARQUET_FANOUT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("dataFusionMaxParquetFanout")
            .getter(getter(InfluxDBv3EnterpriseParameters::dataFusionMaxParquetFanout))
            .setter(setter(Builder::dataFusionMaxParquetFanout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataFusionMaxParquetFanout").build())
            .build();

    private static final SdkField<Boolean> DATA_FUSION_USE_CACHED_PARQUET_LOADER_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("dataFusionUseCachedParquetLoader")
            .getter(getter(InfluxDBv3EnterpriseParameters::dataFusionUseCachedParquetLoader))
            .setter(setter(Builder::dataFusionUseCachedParquetLoader))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataFusionUseCachedParquetLoader")
                    .build()).build();

    private static final SdkField<String> DATA_FUSION_CONFIG_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataFusionConfig").getter(getter(InfluxDBv3EnterpriseParameters::dataFusionConfig))
            .setter(setter(Builder::dataFusionConfig))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataFusionConfig").build()).build();

    private static final SdkField<Long> MAX_HTTP_REQUEST_SIZE_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("maxHttpRequestSize").getter(getter(InfluxDBv3EnterpriseParameters::maxHttpRequestSize))
            .setter(setter(Builder::maxHttpRequestSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxHttpRequestSize").build())
            .build();

    private static final SdkField<PercentOrAbsoluteLong> FORCE_SNAPSHOT_MEM_THRESHOLD_FIELD = SdkField
            .<PercentOrAbsoluteLong> builder(MarshallingType.SDK_POJO).memberName("forceSnapshotMemThreshold")
            .getter(getter(InfluxDBv3EnterpriseParameters::forceSnapshotMemThreshold))
            .setter(setter(Builder::forceSnapshotMemThreshold)).constructor(PercentOrAbsoluteLong::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("forceSnapshotMemThreshold").build())
            .build();

    private static final SdkField<Integer> WAL_SNAPSHOT_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("walSnapshotSize").getter(getter(InfluxDBv3EnterpriseParameters::walSnapshotSize))
            .setter(setter(Builder::walSnapshotSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("walSnapshotSize").build()).build();

    private static final SdkField<Integer> WAL_MAX_WRITE_BUFFER_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("walMaxWriteBufferSize").getter(getter(InfluxDBv3EnterpriseParameters::walMaxWriteBufferSize))
            .setter(setter(Builder::walMaxWriteBufferSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("walMaxWriteBufferSize").build())
            .build();

    private static final SdkField<Integer> SNAPSHOTTED_WAL_FILES_TO_KEEP_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("snapshottedWalFilesToKeep")
            .getter(getter(InfluxDBv3EnterpriseParameters::snapshottedWalFilesToKeep))
            .setter(setter(Builder::snapshottedWalFilesToKeep))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("snapshottedWalFilesToKeep").build())
            .build();

    private static final SdkField<Duration> PREEMPTIVE_CACHE_AGE_FIELD = SdkField.<Duration> builder(MarshallingType.SDK_POJO)
            .memberName("preemptiveCacheAge").getter(getter(InfluxDBv3EnterpriseParameters::preemptiveCacheAge))
            .setter(setter(Builder::preemptiveCacheAge)).constructor(Duration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("preemptiveCacheAge").build())
            .build();

    private static final SdkField<Float> PARQUET_MEM_CACHE_PRUNE_PERCENTAGE_FIELD = SdkField
            .<Float> builder(MarshallingType.FLOAT)
            .memberName("parquetMemCachePrunePercentage")
            .getter(getter(InfluxDBv3EnterpriseParameters::parquetMemCachePrunePercentage))
            .setter(setter(Builder::parquetMemCachePrunePercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parquetMemCachePrunePercentage")
                    .build()).build();

    private static final SdkField<Duration> PARQUET_MEM_CACHE_PRUNE_INTERVAL_FIELD = SdkField
            .<Duration> builder(MarshallingType.SDK_POJO)
            .memberName("parquetMemCachePruneInterval")
            .getter(getter(InfluxDBv3EnterpriseParameters::parquetMemCachePruneInterval))
            .setter(setter(Builder::parquetMemCachePruneInterval))
            .constructor(Duration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parquetMemCachePruneInterval")
                    .build()).build();

    private static final SdkField<Boolean> DISABLE_PARQUET_MEM_CACHE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("disableParquetMemCache").getter(getter(InfluxDBv3EnterpriseParameters::disableParquetMemCache))
            .setter(setter(Builder::disableParquetMemCache))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("disableParquetMemCache").build())
            .build();

    private static final SdkField<Duration> PARQUET_MEM_CACHE_QUERY_PATH_DURATION_FIELD = SdkField
            .<Duration> builder(MarshallingType.SDK_POJO)
            .memberName("parquetMemCacheQueryPathDuration")
            .getter(getter(InfluxDBv3EnterpriseParameters::parquetMemCacheQueryPathDuration))
            .setter(setter(Builder::parquetMemCacheQueryPathDuration))
            .constructor(Duration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parquetMemCacheQueryPathDuration")
                    .build()).build();

    private static final SdkField<Duration> LAST_CACHE_EVICTION_INTERVAL_FIELD = SdkField
            .<Duration> builder(MarshallingType.SDK_POJO).memberName("lastCacheEvictionInterval")
            .getter(getter(InfluxDBv3EnterpriseParameters::lastCacheEvictionInterval))
            .setter(setter(Builder::lastCacheEvictionInterval)).constructor(Duration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastCacheEvictionInterval").build())
            .build();

    private static final SdkField<Duration> DISTINCT_CACHE_EVICTION_INTERVAL_FIELD = SdkField
            .<Duration> builder(MarshallingType.SDK_POJO)
            .memberName("distinctCacheEvictionInterval")
            .getter(getter(InfluxDBv3EnterpriseParameters::distinctCacheEvictionInterval))
            .setter(setter(Builder::distinctCacheEvictionInterval))
            .constructor(Duration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("distinctCacheEvictionInterval")
                    .build()).build();

    private static final SdkField<Duration> GEN1_DURATION_FIELD = SdkField.<Duration> builder(MarshallingType.SDK_POJO)
            .memberName("gen1Duration").getter(getter(InfluxDBv3EnterpriseParameters::gen1Duration))
            .setter(setter(Builder::gen1Duration)).constructor(Duration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gen1Duration").build()).build();

    private static final SdkField<PercentOrAbsoluteLong> EXEC_MEM_POOL_BYTES_FIELD = SdkField
            .<PercentOrAbsoluteLong> builder(MarshallingType.SDK_POJO).memberName("execMemPoolBytes")
            .getter(getter(InfluxDBv3EnterpriseParameters::execMemPoolBytes)).setter(setter(Builder::execMemPoolBytes))
            .constructor(PercentOrAbsoluteLong::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("execMemPoolBytes").build()).build();

    private static final SdkField<PercentOrAbsoluteLong> PARQUET_MEM_CACHE_SIZE_FIELD = SdkField
            .<PercentOrAbsoluteLong> builder(MarshallingType.SDK_POJO).memberName("parquetMemCacheSize")
            .getter(getter(InfluxDBv3EnterpriseParameters::parquetMemCacheSize)).setter(setter(Builder::parquetMemCacheSize))
            .constructor(PercentOrAbsoluteLong::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parquetMemCacheSize").build())
            .build();

    private static final SdkField<Boolean> WAL_REPLAY_FAIL_ON_ERROR_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("walReplayFailOnError").getter(getter(InfluxDBv3EnterpriseParameters::walReplayFailOnError))
            .setter(setter(Builder::walReplayFailOnError))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("walReplayFailOnError").build())
            .build();

    private static final SdkField<Integer> WAL_REPLAY_CONCURRENCY_LIMIT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("walReplayConcurrencyLimit")
            .getter(getter(InfluxDBv3EnterpriseParameters::walReplayConcurrencyLimit))
            .setter(setter(Builder::walReplayConcurrencyLimit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("walReplayConcurrencyLimit").build())
            .build();

    private static final SdkField<Integer> TABLE_INDEX_CACHE_MAX_ENTRIES_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("tableIndexCacheMaxEntries")
            .getter(getter(InfluxDBv3EnterpriseParameters::tableIndexCacheMaxEntries))
            .setter(setter(Builder::tableIndexCacheMaxEntries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tableIndexCacheMaxEntries").build())
            .build();

    private static final SdkField<Integer> TABLE_INDEX_CACHE_CONCURRENCY_LIMIT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("tableIndexCacheConcurrencyLimit")
            .getter(getter(InfluxDBv3EnterpriseParameters::tableIndexCacheConcurrencyLimit))
            .setter(setter(Builder::tableIndexCacheConcurrencyLimit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tableIndexCacheConcurrencyLimit")
                    .build()).build();

    private static final SdkField<Duration> GEN1_LOOKBACK_DURATION_FIELD = SdkField.<Duration> builder(MarshallingType.SDK_POJO)
            .memberName("gen1LookbackDuration").getter(getter(InfluxDBv3EnterpriseParameters::gen1LookbackDuration))
            .setter(setter(Builder::gen1LookbackDuration)).constructor(Duration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gen1LookbackDuration").build())
            .build();

    private static final SdkField<Duration> RETENTION_CHECK_INTERVAL_FIELD = SdkField
            .<Duration> builder(MarshallingType.SDK_POJO).memberName("retentionCheckInterval")
            .getter(getter(InfluxDBv3EnterpriseParameters::retentionCheckInterval))
            .setter(setter(Builder::retentionCheckInterval)).constructor(Duration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retentionCheckInterval").build())
            .build();

    private static final SdkField<Duration> DELETE_GRACE_PERIOD_FIELD = SdkField.<Duration> builder(MarshallingType.SDK_POJO)
            .memberName("deleteGracePeriod").getter(getter(InfluxDBv3EnterpriseParameters::deleteGracePeriod))
            .setter(setter(Builder::deleteGracePeriod)).constructor(Duration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deleteGracePeriod").build()).build();

    private static final SdkField<Duration> HARD_DELETE_DEFAULT_DURATION_FIELD = SdkField
            .<Duration> builder(MarshallingType.SDK_POJO).memberName("hardDeleteDefaultDuration")
            .getter(getter(InfluxDBv3EnterpriseParameters::hardDeleteDefaultDuration))
            .setter(setter(Builder::hardDeleteDefaultDuration)).constructor(Duration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hardDeleteDefaultDuration").build())
            .build();

    private static final SdkField<Integer> INGEST_QUERY_INSTANCES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ingestQueryInstances").getter(getter(InfluxDBv3EnterpriseParameters::ingestQueryInstances))
            .setter(setter(Builder::ingestQueryInstances))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ingestQueryInstances").build())
            .build();

    private static final SdkField<Integer> QUERY_ONLY_INSTANCES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("queryOnlyInstances").getter(getter(InfluxDBv3EnterpriseParameters::queryOnlyInstances))
            .setter(setter(Builder::queryOnlyInstances))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryOnlyInstances").build())
            .build();

    private static final SdkField<Boolean> DEDICATED_COMPACTOR_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("dedicatedCompactor").getter(getter(InfluxDBv3EnterpriseParameters::dedicatedCompactor))
            .setter(setter(Builder::dedicatedCompactor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dedicatedCompactor").build())
            .build();

    private static final SdkField<Integer> COMPACTION_ROW_LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("compactionRowLimit").getter(getter(InfluxDBv3EnterpriseParameters::compactionRowLimit))
            .setter(setter(Builder::compactionRowLimit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("compactionRowLimit").build())
            .build();

    private static final SdkField<Integer> COMPACTION_MAX_NUM_FILES_PER_PLAN_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("compactionMaxNumFilesPerPlan")
            .getter(getter(InfluxDBv3EnterpriseParameters::compactionMaxNumFilesPerPlan))
            .setter(setter(Builder::compactionMaxNumFilesPerPlan))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("compactionMaxNumFilesPerPlan")
                    .build()).build();

    private static final SdkField<Duration> COMPACTION_GEN2_DURATION_FIELD = SdkField
            .<Duration> builder(MarshallingType.SDK_POJO).memberName("compactionGen2Duration")
            .getter(getter(InfluxDBv3EnterpriseParameters::compactionGen2Duration))
            .setter(setter(Builder::compactionGen2Duration)).constructor(Duration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("compactionGen2Duration").build())
            .build();

    private static final SdkField<String> COMPACTION_MULTIPLIERS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("compactionMultipliers").getter(getter(InfluxDBv3EnterpriseParameters::compactionMultipliers))
            .setter(setter(Builder::compactionMultipliers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("compactionMultipliers").build())
            .build();

    private static final SdkField<Duration> COMPACTION_CLEANUP_WAIT_FIELD = SdkField.<Duration> builder(MarshallingType.SDK_POJO)
            .memberName("compactionCleanupWait").getter(getter(InfluxDBv3EnterpriseParameters::compactionCleanupWait))
            .setter(setter(Builder::compactionCleanupWait)).constructor(Duration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("compactionCleanupWait").build())
            .build();

    private static final SdkField<Duration> COMPACTION_CHECK_INTERVAL_FIELD = SdkField
            .<Duration> builder(MarshallingType.SDK_POJO).memberName("compactionCheckInterval")
            .getter(getter(InfluxDBv3EnterpriseParameters::compactionCheckInterval))
            .setter(setter(Builder::compactionCheckInterval)).constructor(Duration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("compactionCheckInterval").build())
            .build();

    private static final SdkField<Boolean> LAST_VALUE_CACHE_DISABLE_FROM_HISTORY_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("lastValueCacheDisableFromHistory")
            .getter(getter(InfluxDBv3EnterpriseParameters::lastValueCacheDisableFromHistory))
            .setter(setter(Builder::lastValueCacheDisableFromHistory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastValueCacheDisableFromHistory")
                    .build()).build();

    private static final SdkField<Boolean> DISTINCT_VALUE_CACHE_DISABLE_FROM_HISTORY_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("distinctValueCacheDisableFromHistory")
            .getter(getter(InfluxDBv3EnterpriseParameters::distinctValueCacheDisableFromHistory))
            .setter(setter(Builder::distinctValueCacheDisableFromHistory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("distinctValueCacheDisableFromHistory").build()).build();

    private static final SdkField<Duration> REPLICATION_INTERVAL_FIELD = SdkField.<Duration> builder(MarshallingType.SDK_POJO)
            .memberName("replicationInterval").getter(getter(InfluxDBv3EnterpriseParameters::replicationInterval))
            .setter(setter(Builder::replicationInterval)).constructor(Duration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicationInterval").build())
            .build();

    private static final SdkField<Duration> CATALOG_SYNC_INTERVAL_FIELD = SdkField.<Duration> builder(MarshallingType.SDK_POJO)
            .memberName("catalogSyncInterval").getter(getter(InfluxDBv3EnterpriseParameters::catalogSyncInterval))
            .setter(setter(Builder::catalogSyncInterval)).constructor(Duration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("catalogSyncInterval").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERY_FILE_LIMIT_FIELD,
            QUERY_LOG_SIZE_FIELD, LOG_FILTER_FIELD, LOG_FORMAT_FIELD, DATA_FUSION_NUM_THREADS_FIELD,
            DATA_FUSION_RUNTIME_TYPE_FIELD, DATA_FUSION_RUNTIME_DISABLE_LIFO_SLOT_FIELD,
            DATA_FUSION_RUNTIME_EVENT_INTERVAL_FIELD, DATA_FUSION_RUNTIME_GLOBAL_QUEUE_INTERVAL_FIELD,
            DATA_FUSION_RUNTIME_MAX_BLOCKING_THREADS_FIELD, DATA_FUSION_RUNTIME_MAX_IO_EVENTS_PER_TICK_FIELD,
            DATA_FUSION_RUNTIME_THREAD_KEEP_ALIVE_FIELD, DATA_FUSION_RUNTIME_THREAD_PRIORITY_FIELD,
            DATA_FUSION_MAX_PARQUET_FANOUT_FIELD, DATA_FUSION_USE_CACHED_PARQUET_LOADER_FIELD, DATA_FUSION_CONFIG_FIELD,
            MAX_HTTP_REQUEST_SIZE_FIELD, FORCE_SNAPSHOT_MEM_THRESHOLD_FIELD, WAL_SNAPSHOT_SIZE_FIELD,
            WAL_MAX_WRITE_BUFFER_SIZE_FIELD, SNAPSHOTTED_WAL_FILES_TO_KEEP_FIELD, PREEMPTIVE_CACHE_AGE_FIELD,
            PARQUET_MEM_CACHE_PRUNE_PERCENTAGE_FIELD, PARQUET_MEM_CACHE_PRUNE_INTERVAL_FIELD, DISABLE_PARQUET_MEM_CACHE_FIELD,
            PARQUET_MEM_CACHE_QUERY_PATH_DURATION_FIELD, LAST_CACHE_EVICTION_INTERVAL_FIELD,
            DISTINCT_CACHE_EVICTION_INTERVAL_FIELD, GEN1_DURATION_FIELD, EXEC_MEM_POOL_BYTES_FIELD, PARQUET_MEM_CACHE_SIZE_FIELD,
            WAL_REPLAY_FAIL_ON_ERROR_FIELD, WAL_REPLAY_CONCURRENCY_LIMIT_FIELD, TABLE_INDEX_CACHE_MAX_ENTRIES_FIELD,
            TABLE_INDEX_CACHE_CONCURRENCY_LIMIT_FIELD, GEN1_LOOKBACK_DURATION_FIELD, RETENTION_CHECK_INTERVAL_FIELD,
            DELETE_GRACE_PERIOD_FIELD, HARD_DELETE_DEFAULT_DURATION_FIELD, INGEST_QUERY_INSTANCES_FIELD,
            QUERY_ONLY_INSTANCES_FIELD, DEDICATED_COMPACTOR_FIELD, COMPACTION_ROW_LIMIT_FIELD,
            COMPACTION_MAX_NUM_FILES_PER_PLAN_FIELD, COMPACTION_GEN2_DURATION_FIELD, COMPACTION_MULTIPLIERS_FIELD,
            COMPACTION_CLEANUP_WAIT_FIELD, COMPACTION_CHECK_INTERVAL_FIELD, LAST_VALUE_CACHE_DISABLE_FROM_HISTORY_FIELD,
            DISTINCT_VALUE_CACHE_DISABLE_FROM_HISTORY_FIELD, REPLICATION_INTERVAL_FIELD, CATALOG_SYNC_INTERVAL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer queryFileLimit;

    private final Integer queryLogSize;

    private final String logFilter;

    private final String logFormat;

    private final Integer dataFusionNumThreads;

    private final String dataFusionRuntimeType;

    private final Boolean dataFusionRuntimeDisableLifoSlot;

    private final Integer dataFusionRuntimeEventInterval;

    private final Integer dataFusionRuntimeGlobalQueueInterval;

    private final Integer dataFusionRuntimeMaxBlockingThreads;

    private final Integer dataFusionRuntimeMaxIoEventsPerTick;

    private final Duration dataFusionRuntimeThreadKeepAlive;

    private final Integer dataFusionRuntimeThreadPriority;

    private final Integer dataFusionMaxParquetFanout;

    private final Boolean dataFusionUseCachedParquetLoader;

    private final String dataFusionConfig;

    private final Long maxHttpRequestSize;

    private final PercentOrAbsoluteLong forceSnapshotMemThreshold;

    private final Integer walSnapshotSize;

    private final Integer walMaxWriteBufferSize;

    private final Integer snapshottedWalFilesToKeep;

    private final Duration preemptiveCacheAge;

    private final Float parquetMemCachePrunePercentage;

    private final Duration parquetMemCachePruneInterval;

    private final Boolean disableParquetMemCache;

    private final Duration parquetMemCacheQueryPathDuration;

    private final Duration lastCacheEvictionInterval;

    private final Duration distinctCacheEvictionInterval;

    private final Duration gen1Duration;

    private final PercentOrAbsoluteLong execMemPoolBytes;

    private final PercentOrAbsoluteLong parquetMemCacheSize;

    private final Boolean walReplayFailOnError;

    private final Integer walReplayConcurrencyLimit;

    private final Integer tableIndexCacheMaxEntries;

    private final Integer tableIndexCacheConcurrencyLimit;

    private final Duration gen1LookbackDuration;

    private final Duration retentionCheckInterval;

    private final Duration deleteGracePeriod;

    private final Duration hardDeleteDefaultDuration;

    private final Integer ingestQueryInstances;

    private final Integer queryOnlyInstances;

    private final Boolean dedicatedCompactor;

    private final Integer compactionRowLimit;

    private final Integer compactionMaxNumFilesPerPlan;

    private final Duration compactionGen2Duration;

    private final String compactionMultipliers;

    private final Duration compactionCleanupWait;

    private final Duration compactionCheckInterval;

    private final Boolean lastValueCacheDisableFromHistory;

    private final Boolean distinctValueCacheDisableFromHistory;

    private final Duration replicationInterval;

    private final Duration catalogSyncInterval;

    private InfluxDBv3EnterpriseParameters(BuilderImpl builder) {
        this.queryFileLimit = builder.queryFileLimit;
        this.queryLogSize = builder.queryLogSize;
        this.logFilter = builder.logFilter;
        this.logFormat = builder.logFormat;
        this.dataFusionNumThreads = builder.dataFusionNumThreads;
        this.dataFusionRuntimeType = builder.dataFusionRuntimeType;
        this.dataFusionRuntimeDisableLifoSlot = builder.dataFusionRuntimeDisableLifoSlot;
        this.dataFusionRuntimeEventInterval = builder.dataFusionRuntimeEventInterval;
        this.dataFusionRuntimeGlobalQueueInterval = builder.dataFusionRuntimeGlobalQueueInterval;
        this.dataFusionRuntimeMaxBlockingThreads = builder.dataFusionRuntimeMaxBlockingThreads;
        this.dataFusionRuntimeMaxIoEventsPerTick = builder.dataFusionRuntimeMaxIoEventsPerTick;
        this.dataFusionRuntimeThreadKeepAlive = builder.dataFusionRuntimeThreadKeepAlive;
        this.dataFusionRuntimeThreadPriority = builder.dataFusionRuntimeThreadPriority;
        this.dataFusionMaxParquetFanout = builder.dataFusionMaxParquetFanout;
        this.dataFusionUseCachedParquetLoader = builder.dataFusionUseCachedParquetLoader;
        this.dataFusionConfig = builder.dataFusionConfig;
        this.maxHttpRequestSize = builder.maxHttpRequestSize;
        this.forceSnapshotMemThreshold = builder.forceSnapshotMemThreshold;
        this.walSnapshotSize = builder.walSnapshotSize;
        this.walMaxWriteBufferSize = builder.walMaxWriteBufferSize;
        this.snapshottedWalFilesToKeep = builder.snapshottedWalFilesToKeep;
        this.preemptiveCacheAge = builder.preemptiveCacheAge;
        this.parquetMemCachePrunePercentage = builder.parquetMemCachePrunePercentage;
        this.parquetMemCachePruneInterval = builder.parquetMemCachePruneInterval;
        this.disableParquetMemCache = builder.disableParquetMemCache;
        this.parquetMemCacheQueryPathDuration = builder.parquetMemCacheQueryPathDuration;
        this.lastCacheEvictionInterval = builder.lastCacheEvictionInterval;
        this.distinctCacheEvictionInterval = builder.distinctCacheEvictionInterval;
        this.gen1Duration = builder.gen1Duration;
        this.execMemPoolBytes = builder.execMemPoolBytes;
        this.parquetMemCacheSize = builder.parquetMemCacheSize;
        this.walReplayFailOnError = builder.walReplayFailOnError;
        this.walReplayConcurrencyLimit = builder.walReplayConcurrencyLimit;
        this.tableIndexCacheMaxEntries = builder.tableIndexCacheMaxEntries;
        this.tableIndexCacheConcurrencyLimit = builder.tableIndexCacheConcurrencyLimit;
        this.gen1LookbackDuration = builder.gen1LookbackDuration;
        this.retentionCheckInterval = builder.retentionCheckInterval;
        this.deleteGracePeriod = builder.deleteGracePeriod;
        this.hardDeleteDefaultDuration = builder.hardDeleteDefaultDuration;
        this.ingestQueryInstances = builder.ingestQueryInstances;
        this.queryOnlyInstances = builder.queryOnlyInstances;
        this.dedicatedCompactor = builder.dedicatedCompactor;
        this.compactionRowLimit = builder.compactionRowLimit;
        this.compactionMaxNumFilesPerPlan = builder.compactionMaxNumFilesPerPlan;
        this.compactionGen2Duration = builder.compactionGen2Duration;
        this.compactionMultipliers = builder.compactionMultipliers;
        this.compactionCleanupWait = builder.compactionCleanupWait;
        this.compactionCheckInterval = builder.compactionCheckInterval;
        this.lastValueCacheDisableFromHistory = builder.lastValueCacheDisableFromHistory;
        this.distinctValueCacheDisableFromHistory = builder.distinctValueCacheDisableFromHistory;
        this.replicationInterval = builder.replicationInterval;
        this.catalogSyncInterval = builder.catalogSyncInterval;
    }

    /**
     * <p>
     * Limits the number of Parquet files a query can access. If a query attempts to read more than this limit, InfluxDB
     * 3 returns an error.
     * </p>
     * <p>
     * Default: 432
     * </p>
     * 
     * @return Limits the number of Parquet files a query can access. If a query attempts to read more than this limit,
     *         InfluxDB 3 returns an error.</p>
     *         <p>
     *         Default: 432
     */
    public final Integer queryFileLimit() {
        return queryFileLimit;
    }

    /**
     * <p>
     * Defines the size of the query log. Up to this many queries remain in the log before older queries are evicted to
     * make room for new ones.
     * </p>
     * <p>
     * Default: 1000
     * </p>
     * 
     * @return Defines the size of the query log. Up to this many queries remain in the log before older queries are
     *         evicted to make room for new ones.</p>
     *         <p>
     *         Default: 1000
     */
    public final Integer queryLogSize() {
        return queryLogSize;
    }

    /**
     * <p>
     * Sets the filter directive for logs.
     * </p>
     * 
     * @return Sets the filter directive for logs.
     */
    public final String logFilter() {
        return logFilter;
    }

    /**
     * <p>
     * Defines the message format for logs.
     * </p>
     * <p>
     * Default: full
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logFormat} will
     * return {@link LogFormats#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #logFormatAsString}.
     * </p>
     * 
     * @return Defines the message format for logs.</p>
     *         <p>
     *         Default: full
     * @see LogFormats
     */
    public final LogFormats logFormat() {
        return LogFormats.fromValue(logFormat);
    }

    /**
     * <p>
     * Defines the message format for logs.
     * </p>
     * <p>
     * Default: full
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logFormat} will
     * return {@link LogFormats#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #logFormatAsString}.
     * </p>
     * 
     * @return Defines the message format for logs.</p>
     *         <p>
     *         Default: full
     * @see LogFormats
     */
    public final String logFormatAsString() {
        return logFormat;
    }

    /**
     * <p>
     * Sets the maximum number of DataFusion runtime threads to use.
     * </p>
     * 
     * @return Sets the maximum number of DataFusion runtime threads to use.
     */
    public final Integer dataFusionNumThreads() {
        return dataFusionNumThreads;
    }

    /**
     * <p>
     * Specifies the DataFusion tokio runtime type.
     * </p>
     * <p>
     * Default: multi-thread
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dataFusionRuntimeType} will return {@link DataFusionRuntimeType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #dataFusionRuntimeTypeAsString}.
     * </p>
     * 
     * @return Specifies the DataFusion tokio runtime type.</p>
     *         <p>
     *         Default: multi-thread
     * @see DataFusionRuntimeType
     */
    public final DataFusionRuntimeType dataFusionRuntimeType() {
        return DataFusionRuntimeType.fromValue(dataFusionRuntimeType);
    }

    /**
     * <p>
     * Specifies the DataFusion tokio runtime type.
     * </p>
     * <p>
     * Default: multi-thread
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dataFusionRuntimeType} will return {@link DataFusionRuntimeType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #dataFusionRuntimeTypeAsString}.
     * </p>
     * 
     * @return Specifies the DataFusion tokio runtime type.</p>
     *         <p>
     *         Default: multi-thread
     * @see DataFusionRuntimeType
     */
    public final String dataFusionRuntimeTypeAsString() {
        return dataFusionRuntimeType;
    }

    /**
     * <p>
     * Disables the LIFO slot of the DataFusion runtime.
     * </p>
     * 
     * @return Disables the LIFO slot of the DataFusion runtime.
     */
    public final Boolean dataFusionRuntimeDisableLifoSlot() {
        return dataFusionRuntimeDisableLifoSlot;
    }

    /**
     * <p>
     * Sets the number of scheduler ticks after which the scheduler of the DataFusion tokio runtime polls for external
     * events–for example: timers, I/O.
     * </p>
     * 
     * @return Sets the number of scheduler ticks after which the scheduler of the DataFusion tokio runtime polls for
     *         external events–for example: timers, I/O.
     */
    public final Integer dataFusionRuntimeEventInterval() {
        return dataFusionRuntimeEventInterval;
    }

    /**
     * <p>
     * Sets the number of scheduler ticks after which the scheduler of the DataFusion runtime polls the global task
     * queue.
     * </p>
     * 
     * @return Sets the number of scheduler ticks after which the scheduler of the DataFusion runtime polls the global
     *         task queue.
     */
    public final Integer dataFusionRuntimeGlobalQueueInterval() {
        return dataFusionRuntimeGlobalQueueInterval;
    }

    /**
     * <p>
     * Specifies the limit for additional threads spawned by the DataFusion runtime.
     * </p>
     * 
     * @return Specifies the limit for additional threads spawned by the DataFusion runtime.
     */
    public final Integer dataFusionRuntimeMaxBlockingThreads() {
        return dataFusionRuntimeMaxBlockingThreads;
    }

    /**
     * <p>
     * Configures the maximum number of events processed per tick by the tokio DataFusion runtime.
     * </p>
     * 
     * @return Configures the maximum number of events processed per tick by the tokio DataFusion runtime.
     */
    public final Integer dataFusionRuntimeMaxIoEventsPerTick() {
        return dataFusionRuntimeMaxIoEventsPerTick;
    }

    /**
     * <p>
     * Sets a custom timeout for a thread in the blocking pool of the tokio DataFusion runtime.
     * </p>
     * 
     * @return Sets a custom timeout for a thread in the blocking pool of the tokio DataFusion runtime.
     */
    public final Duration dataFusionRuntimeThreadKeepAlive() {
        return dataFusionRuntimeThreadKeepAlive;
    }

    /**
     * <p>
     * Sets the thread priority for tokio DataFusion runtime workers.
     * </p>
     * <p>
     * Default: 10
     * </p>
     * 
     * @return Sets the thread priority for tokio DataFusion runtime workers.</p>
     *         <p>
     *         Default: 10
     */
    public final Integer dataFusionRuntimeThreadPriority() {
        return dataFusionRuntimeThreadPriority;
    }

    /**
     * <p>
     * When multiple parquet files are required in a sorted way (deduplication for example), specifies the maximum
     * fanout.
     * </p>
     * <p>
     * Default: 1000
     * </p>
     * 
     * @return When multiple parquet files are required in a sorted way (deduplication for example), specifies the
     *         maximum fanout.</p>
     *         <p>
     *         Default: 1000
     */
    public final Integer dataFusionMaxParquetFanout() {
        return dataFusionMaxParquetFanout;
    }

    /**
     * <p>
     * Uses a cached parquet loader when reading parquet files from the object store.
     * </p>
     * 
     * @return Uses a cached parquet loader when reading parquet files from the object store.
     */
    public final Boolean dataFusionUseCachedParquetLoader() {
        return dataFusionUseCachedParquetLoader;
    }

    /**
     * <p>
     * Provides custom configuration to DataFusion as a comma-separated list of key:value pairs.
     * </p>
     * 
     * @return Provides custom configuration to DataFusion as a comma-separated list of key:value pairs.
     */
    public final String dataFusionConfig() {
        return dataFusionConfig;
    }

    /**
     * <p>
     * Specifies the maximum size of HTTP requests.
     * </p>
     * <p>
     * Default: 10485760
     * </p>
     * 
     * @return Specifies the maximum size of HTTP requests.</p>
     *         <p>
     *         Default: 10485760
     */
    public final Long maxHttpRequestSize() {
        return maxHttpRequestSize;
    }

    /**
     * <p>
     * Specifies the threshold for the internal memory buffer. Supports either a percentage (portion of available
     * memory) or absolute value in MB–for example: 70% or 100
     * </p>
     * <p>
     * Default: 70%
     * </p>
     * 
     * @return Specifies the threshold for the internal memory buffer. Supports either a percentage (portion of
     *         available memory) or absolute value in MB–for example: 70% or 100</p>
     *         <p>
     *         Default: 70%
     */
    public final PercentOrAbsoluteLong forceSnapshotMemThreshold() {
        return forceSnapshotMemThreshold;
    }

    /**
     * <p>
     * Defines the number of WAL files to attempt to remove in a snapshot. This, multiplied by the interval, determines
     * how often snapshots are taken.
     * </p>
     * <p>
     * Default: 600
     * </p>
     * 
     * @return Defines the number of WAL files to attempt to remove in a snapshot. This, multiplied by the interval,
     *         determines how often snapshots are taken.</p>
     *         <p>
     *         Default: 600
     */
    public final Integer walSnapshotSize() {
        return walSnapshotSize;
    }

    /**
     * <p>
     * Specifies the maximum number of write requests that can be buffered before a flush must be executed and succeed.
     * </p>
     * <p>
     * Default: 100000
     * </p>
     * 
     * @return Specifies the maximum number of write requests that can be buffered before a flush must be executed and
     *         succeed.</p>
     *         <p>
     *         Default: 100000
     */
    public final Integer walMaxWriteBufferSize() {
        return walMaxWriteBufferSize;
    }

    /**
     * <p>
     * Specifies the number of snapshotted WAL files to retain in the object store. Flushing the WAL files does not
     * clear the WAL files immediately; they are deleted when the number of snapshotted WAL files exceeds this number.
     * </p>
     * <p>
     * Default: 300
     * </p>
     * 
     * @return Specifies the number of snapshotted WAL files to retain in the object store. Flushing the WAL files does
     *         not clear the WAL files immediately; they are deleted when the number of snapshotted WAL files exceeds
     *         this number.</p>
     *         <p>
     *         Default: 300
     */
    public final Integer snapshottedWalFilesToKeep() {
        return snapshottedWalFilesToKeep;
    }

    /**
     * <p>
     * Specifies the interval to prefetch into the Parquet cache during compaction.
     * </p>
     * <p>
     * Default: 3d
     * </p>
     * 
     * @return Specifies the interval to prefetch into the Parquet cache during compaction.</p>
     *         <p>
     *         Default: 3d
     */
    public final Duration preemptiveCacheAge() {
        return preemptiveCacheAge;
    }

    /**
     * <p>
     * Specifies the percentage of entries to prune during a prune operation on the in-memory Parquet cache.
     * </p>
     * <p>
     * Default: 0.1
     * </p>
     * 
     * @return Specifies the percentage of entries to prune during a prune operation on the in-memory Parquet cache.</p>
     *         <p>
     *         Default: 0.1
     */
    public final Float parquetMemCachePrunePercentage() {
        return parquetMemCachePrunePercentage;
    }

    /**
     * <p>
     * Sets the interval to check if the in-memory Parquet cache needs to be pruned.
     * </p>
     * <p>
     * Default: 1s
     * </p>
     * 
     * @return Sets the interval to check if the in-memory Parquet cache needs to be pruned.</p>
     *         <p>
     *         Default: 1s
     */
    public final Duration parquetMemCachePruneInterval() {
        return parquetMemCachePruneInterval;
    }

    /**
     * <p>
     * Disables the in-memory Parquet cache. By default, the cache is enabled.
     * </p>
     * 
     * @return Disables the in-memory Parquet cache. By default, the cache is enabled.
     */
    public final Boolean disableParquetMemCache() {
        return disableParquetMemCache;
    }

    /**
     * <p>
     * Specifies the time window for caching recent Parquet files in memory.
     * </p>
     * <p>
     * Default: 5h
     * </p>
     * 
     * @return Specifies the time window for caching recent Parquet files in memory.</p>
     *         <p>
     *         Default: 5h
     */
    public final Duration parquetMemCacheQueryPathDuration() {
        return parquetMemCacheQueryPathDuration;
    }

    /**
     * <p>
     * Specifies the interval to evict expired entries from the Last-N-Value cache, expressed as a human-readable
     * duration–for example: 20s, 1m, 1h.
     * </p>
     * <p>
     * Default: 10s
     * </p>
     * 
     * @return Specifies the interval to evict expired entries from the Last-N-Value cache, expressed as a
     *         human-readable duration–for example: 20s, 1m, 1h.</p>
     *         <p>
     *         Default: 10s
     */
    public final Duration lastCacheEvictionInterval() {
        return lastCacheEvictionInterval;
    }

    /**
     * <p>
     * Specifies the interval to evict expired entries from the distinct value cache, expressed as a human-readable
     * duration–for example: 20s, 1m, 1h.
     * </p>
     * <p>
     * Default: 10s
     * </p>
     * 
     * @return Specifies the interval to evict expired entries from the distinct value cache, expressed as a
     *         human-readable duration–for example: 20s, 1m, 1h.</p>
     *         <p>
     *         Default: 10s
     */
    public final Duration distinctCacheEvictionInterval() {
        return distinctCacheEvictionInterval;
    }

    /**
     * <p>
     * Specifies the duration that Parquet files are arranged into. Data timestamps land each row into a file of this
     * duration. Supported durations are 1m, 5m, and 10m. These files are known as “generation 1” files, which the
     * compactor can merge into larger generations.
     * </p>
     * <p>
     * Default: 10m
     * </p>
     * 
     * @return Specifies the duration that Parquet files are arranged into. Data timestamps land each row into a file of
     *         this duration. Supported durations are 1m, 5m, and 10m. These files are known as “generation 1” files,
     *         which the compactor can merge into larger generations.</p>
     *         <p>
     *         Default: 10m
     */
    public final Duration gen1Duration() {
        return gen1Duration;
    }

    /**
     * <p>
     * Specifies the size of memory pool used during query execution. Can be given as absolute value in bytes or as a
     * percentage of the total available memory–for example: 8000000000 or 10%.
     * </p>
     * <p>
     * Default: 20%
     * </p>
     * 
     * @return Specifies the size of memory pool used during query execution. Can be given as absolute value in bytes or
     *         as a percentage of the total available memory–for example: 8000000000 or 10%.</p>
     *         <p>
     *         Default: 20%
     */
    public final PercentOrAbsoluteLong execMemPoolBytes() {
        return execMemPoolBytes;
    }

    /**
     * <p>
     * Specifies the size of the in-memory Parquet cache in megabytes or percentage of total available memory.
     * </p>
     * <p>
     * Default: 20%
     * </p>
     * 
     * @return Specifies the size of the in-memory Parquet cache in megabytes or percentage of total available
     *         memory.</p>
     *         <p>
     *         Default: 20%
     */
    public final PercentOrAbsoluteLong parquetMemCacheSize() {
        return parquetMemCacheSize;
    }

    /**
     * <p>
     * Determines whether WAL replay should fail when encountering errors.
     * </p>
     * <p>
     * Default: false
     * </p>
     * 
     * @return Determines whether WAL replay should fail when encountering errors.</p>
     *         <p>
     *         Default: false
     */
    public final Boolean walReplayFailOnError() {
        return walReplayFailOnError;
    }

    /**
     * <p>
     * Concurrency limit during WAL replay. Setting this number too high can lead to OOM. The default is dynamically
     * determined.
     * </p>
     * <p>
     * Default: max(num_cpus, 10)
     * </p>
     * 
     * @return Concurrency limit during WAL replay. Setting this number too high can lead to OOM. The default is
     *         dynamically determined.</p>
     *         <p>
     *         Default: max(num_cpus, 10)
     */
    public final Integer walReplayConcurrencyLimit() {
        return walReplayConcurrencyLimit;
    }

    /**
     * <p>
     * Specifies the maximum number of entries in the table index cache.
     * </p>
     * <p>
     * Default: 1000
     * </p>
     * 
     * @return Specifies the maximum number of entries in the table index cache.</p>
     *         <p>
     *         Default: 1000
     */
    public final Integer tableIndexCacheMaxEntries() {
        return tableIndexCacheMaxEntries;
    }

    /**
     * <p>
     * Limits the concurrency level for table index cache operations.
     * </p>
     * <p>
     * Default: 8
     * </p>
     * 
     * @return Limits the concurrency level for table index cache operations.</p>
     *         <p>
     *         Default: 8
     */
    public final Integer tableIndexCacheConcurrencyLimit() {
        return tableIndexCacheConcurrencyLimit;
    }

    /**
     * <p>
     * Specifies how far back to look when creating generation 1 Parquet files.
     * </p>
     * <p>
     * Default: 24h
     * </p>
     * 
     * @return Specifies how far back to look when creating generation 1 Parquet files.</p>
     *         <p>
     *         Default: 24h
     */
    public final Duration gen1LookbackDuration() {
        return gen1LookbackDuration;
    }

    /**
     * <p>
     * The interval at which retention policies are checked and enforced. Enter as a human-readable time–for example:
     * 30m or 1h.
     * </p>
     * <p>
     * Default: 30m
     * </p>
     * 
     * @return The interval at which retention policies are checked and enforced. Enter as a human-readable time–for
     *         example: 30m or 1h.</p>
     *         <p>
     *         Default: 30m
     */
    public final Duration retentionCheckInterval() {
        return retentionCheckInterval;
    }

    /**
     * <p>
     * Specifies the grace period before permanently deleting data.
     * </p>
     * <p>
     * Default: 24h
     * </p>
     * 
     * @return Specifies the grace period before permanently deleting data.</p>
     *         <p>
     *         Default: 24h
     */
    public final Duration deleteGracePeriod() {
        return deleteGracePeriod;
    }

    /**
     * <p>
     * Sets the default duration for hard deletion of data.
     * </p>
     * <p>
     * Default: 90d
     * </p>
     * 
     * @return Sets the default duration for hard deletion of data.</p>
     *         <p>
     *         Default: 90d
     */
    public final Duration hardDeleteDefaultDuration() {
        return hardDeleteDefaultDuration;
    }

    /**
     * <p>
     * Specifies number of instances in the DbCluster which can both ingest and query.
     * </p>
     * 
     * @return Specifies number of instances in the DbCluster which can both ingest and query.
     */
    public final Integer ingestQueryInstances() {
        return ingestQueryInstances;
    }

    /**
     * <p>
     * Specifies number of instances in the DbCluster which can only query.
     * </p>
     * 
     * @return Specifies number of instances in the DbCluster which can only query.
     */
    public final Integer queryOnlyInstances() {
        return queryOnlyInstances;
    }

    /**
     * <p>
     * Specifies if the compactor instance should be a standalone instance or not.
     * </p>
     * 
     * @return Specifies if the compactor instance should be a standalone instance or not.
     */
    public final Boolean dedicatedCompactor() {
        return dedicatedCompactor;
    }

    /**
     * <p>
     * Specifies the soft limit for the number of rows per file that the compactor writes. The compactor may write more
     * rows than this limit.
     * </p>
     * <p>
     * Default: 1000000
     * </p>
     * 
     * @return Specifies the soft limit for the number of rows per file that the compactor writes. The compactor may
     *         write more rows than this limit.</p>
     *         <p>
     *         Default: 1000000
     */
    public final Integer compactionRowLimit() {
        return compactionRowLimit;
    }

    /**
     * <p>
     * Sets the maximum number of files included in any compaction plan.
     * </p>
     * <p>
     * Default: 500
     * </p>
     * 
     * @return Sets the maximum number of files included in any compaction plan.</p>
     *         <p>
     *         Default: 500
     */
    public final Integer compactionMaxNumFilesPerPlan() {
        return compactionMaxNumFilesPerPlan;
    }

    /**
     * <p>
     * Specifies the duration of the first level of compaction (gen2). Later levels of compaction are multiples of this
     * duration. This value should be equal to or greater than the gen1 duration.
     * </p>
     * <p>
     * Default: 20m
     * </p>
     * 
     * @return Specifies the duration of the first level of compaction (gen2). Later levels of compaction are multiples
     *         of this duration. This value should be equal to or greater than the gen1 duration.</p>
     *         <p>
     *         Default: 20m
     */
    public final Duration compactionGen2Duration() {
        return compactionGen2Duration;
    }

    /**
     * <p>
     * Specifies a comma-separated list of multiples defining the duration of each level of compaction. The number of
     * elements in the list determines the number of compaction levels. The first element specifies the duration of the
     * first level (gen3); subsequent levels are multiples of the previous level.
     * </p>
     * <p>
     * Default: 3,4,6,5
     * </p>
     * 
     * @return Specifies a comma-separated list of multiples defining the duration of each level of compaction. The
     *         number of elements in the list determines the number of compaction levels. The first element specifies
     *         the duration of the first level (gen3); subsequent levels are multiples of the previous level.</p>
     *         <p>
     *         Default: 3,4,6,5
     */
    public final String compactionMultipliers() {
        return compactionMultipliers;
    }

    /**
     * <p>
     * Specifies the amount of time that the compactor waits after finishing a compaction run to delete files marked as
     * needing deletion during that compaction run.
     * </p>
     * <p>
     * Default: 10m
     * </p>
     * 
     * @return Specifies the amount of time that the compactor waits after finishing a compaction run to delete files
     *         marked as needing deletion during that compaction run.</p>
     *         <p>
     *         Default: 10m
     */
    public final Duration compactionCleanupWait() {
        return compactionCleanupWait;
    }

    /**
     * <p>
     * Specifies how often the compactor checks for new compaction work to perform.
     * </p>
     * <p>
     * Default: 10s
     * </p>
     * 
     * @return Specifies how often the compactor checks for new compaction work to perform.</p>
     *         <p>
     *         Default: 10s
     */
    public final Duration compactionCheckInterval() {
        return compactionCheckInterval;
    }

    /**
     * <p>
     * Disables populating the last-N-value cache from historical data. If disabled, the cache is still populated with
     * data from the write-ahead log (WAL).
     * </p>
     * 
     * @return Disables populating the last-N-value cache from historical data. If disabled, the cache is still
     *         populated with data from the write-ahead log (WAL).
     */
    public final Boolean lastValueCacheDisableFromHistory() {
        return lastValueCacheDisableFromHistory;
    }

    /**
     * <p>
     * Disables populating the distinct value cache from historical data. If disabled, the cache is still populated with
     * data from the write-ahead log (WAL).
     * </p>
     * 
     * @return Disables populating the distinct value cache from historical data. If disabled, the cache is still
     *         populated with data from the write-ahead log (WAL).
     */
    public final Boolean distinctValueCacheDisableFromHistory() {
        return distinctValueCacheDisableFromHistory;
    }

    /**
     * <p>
     * Specifies the interval at which data replication occurs between cluster nodes.
     * </p>
     * <p>
     * Default: 250ms
     * </p>
     * 
     * @return Specifies the interval at which data replication occurs between cluster nodes.</p>
     *         <p>
     *         Default: 250ms
     */
    public final Duration replicationInterval() {
        return replicationInterval;
    }

    /**
     * <p>
     * Defines how often the catalog synchronizes across cluster nodes.
     * </p>
     * <p>
     * Default: 10s
     * </p>
     * 
     * @return Defines how often the catalog synchronizes across cluster nodes.</p>
     *         <p>
     *         Default: 10s
     */
    public final Duration catalogSyncInterval() {
        return catalogSyncInterval;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(queryFileLimit());
        hashCode = 31 * hashCode + Objects.hashCode(queryLogSize());
        hashCode = 31 * hashCode + Objects.hashCode(logFilter());
        hashCode = 31 * hashCode + Objects.hashCode(logFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dataFusionNumThreads());
        hashCode = 31 * hashCode + Objects.hashCode(dataFusionRuntimeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dataFusionRuntimeDisableLifoSlot());
        hashCode = 31 * hashCode + Objects.hashCode(dataFusionRuntimeEventInterval());
        hashCode = 31 * hashCode + Objects.hashCode(dataFusionRuntimeGlobalQueueInterval());
        hashCode = 31 * hashCode + Objects.hashCode(dataFusionRuntimeMaxBlockingThreads());
        hashCode = 31 * hashCode + Objects.hashCode(dataFusionRuntimeMaxIoEventsPerTick());
        hashCode = 31 * hashCode + Objects.hashCode(dataFusionRuntimeThreadKeepAlive());
        hashCode = 31 * hashCode + Objects.hashCode(dataFusionRuntimeThreadPriority());
        hashCode = 31 * hashCode + Objects.hashCode(dataFusionMaxParquetFanout());
        hashCode = 31 * hashCode + Objects.hashCode(dataFusionUseCachedParquetLoader());
        hashCode = 31 * hashCode + Objects.hashCode(dataFusionConfig());
        hashCode = 31 * hashCode + Objects.hashCode(maxHttpRequestSize());
        hashCode = 31 * hashCode + Objects.hashCode(forceSnapshotMemThreshold());
        hashCode = 31 * hashCode + Objects.hashCode(walSnapshotSize());
        hashCode = 31 * hashCode + Objects.hashCode(walMaxWriteBufferSize());
        hashCode = 31 * hashCode + Objects.hashCode(snapshottedWalFilesToKeep());
        hashCode = 31 * hashCode + Objects.hashCode(preemptiveCacheAge());
        hashCode = 31 * hashCode + Objects.hashCode(parquetMemCachePrunePercentage());
        hashCode = 31 * hashCode + Objects.hashCode(parquetMemCachePruneInterval());
        hashCode = 31 * hashCode + Objects.hashCode(disableParquetMemCache());
        hashCode = 31 * hashCode + Objects.hashCode(parquetMemCacheQueryPathDuration());
        hashCode = 31 * hashCode + Objects.hashCode(lastCacheEvictionInterval());
        hashCode = 31 * hashCode + Objects.hashCode(distinctCacheEvictionInterval());
        hashCode = 31 * hashCode + Objects.hashCode(gen1Duration());
        hashCode = 31 * hashCode + Objects.hashCode(execMemPoolBytes());
        hashCode = 31 * hashCode + Objects.hashCode(parquetMemCacheSize());
        hashCode = 31 * hashCode + Objects.hashCode(walReplayFailOnError());
        hashCode = 31 * hashCode + Objects.hashCode(walReplayConcurrencyLimit());
        hashCode = 31 * hashCode + Objects.hashCode(tableIndexCacheMaxEntries());
        hashCode = 31 * hashCode + Objects.hashCode(tableIndexCacheConcurrencyLimit());
        hashCode = 31 * hashCode + Objects.hashCode(gen1LookbackDuration());
        hashCode = 31 * hashCode + Objects.hashCode(retentionCheckInterval());
        hashCode = 31 * hashCode + Objects.hashCode(deleteGracePeriod());
        hashCode = 31 * hashCode + Objects.hashCode(hardDeleteDefaultDuration());
        hashCode = 31 * hashCode + Objects.hashCode(ingestQueryInstances());
        hashCode = 31 * hashCode + Objects.hashCode(queryOnlyInstances());
        hashCode = 31 * hashCode + Objects.hashCode(dedicatedCompactor());
        hashCode = 31 * hashCode + Objects.hashCode(compactionRowLimit());
        hashCode = 31 * hashCode + Objects.hashCode(compactionMaxNumFilesPerPlan());
        hashCode = 31 * hashCode + Objects.hashCode(compactionGen2Duration());
        hashCode = 31 * hashCode + Objects.hashCode(compactionMultipliers());
        hashCode = 31 * hashCode + Objects.hashCode(compactionCleanupWait());
        hashCode = 31 * hashCode + Objects.hashCode(compactionCheckInterval());
        hashCode = 31 * hashCode + Objects.hashCode(lastValueCacheDisableFromHistory());
        hashCode = 31 * hashCode + Objects.hashCode(distinctValueCacheDisableFromHistory());
        hashCode = 31 * hashCode + Objects.hashCode(replicationInterval());
        hashCode = 31 * hashCode + Objects.hashCode(catalogSyncInterval());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InfluxDBv3EnterpriseParameters)) {
            return false;
        }
        InfluxDBv3EnterpriseParameters other = (InfluxDBv3EnterpriseParameters) obj;
        return Objects.equals(queryFileLimit(), other.queryFileLimit()) && Objects.equals(queryLogSize(), other.queryLogSize())
                && Objects.equals(logFilter(), other.logFilter())
                && Objects.equals(logFormatAsString(), other.logFormatAsString())
                && Objects.equals(dataFusionNumThreads(), other.dataFusionNumThreads())
                && Objects.equals(dataFusionRuntimeTypeAsString(), other.dataFusionRuntimeTypeAsString())
                && Objects.equals(dataFusionRuntimeDisableLifoSlot(), other.dataFusionRuntimeDisableLifoSlot())
                && Objects.equals(dataFusionRuntimeEventInterval(), other.dataFusionRuntimeEventInterval())
                && Objects.equals(dataFusionRuntimeGlobalQueueInterval(), other.dataFusionRuntimeGlobalQueueInterval())
                && Objects.equals(dataFusionRuntimeMaxBlockingThreads(), other.dataFusionRuntimeMaxBlockingThreads())
                && Objects.equals(dataFusionRuntimeMaxIoEventsPerTick(), other.dataFusionRuntimeMaxIoEventsPerTick())
                && Objects.equals(dataFusionRuntimeThreadKeepAlive(), other.dataFusionRuntimeThreadKeepAlive())
                && Objects.equals(dataFusionRuntimeThreadPriority(), other.dataFusionRuntimeThreadPriority())
                && Objects.equals(dataFusionMaxParquetFanout(), other.dataFusionMaxParquetFanout())
                && Objects.equals(dataFusionUseCachedParquetLoader(), other.dataFusionUseCachedParquetLoader())
                && Objects.equals(dataFusionConfig(), other.dataFusionConfig())
                && Objects.equals(maxHttpRequestSize(), other.maxHttpRequestSize())
                && Objects.equals(forceSnapshotMemThreshold(), other.forceSnapshotMemThreshold())
                && Objects.equals(walSnapshotSize(), other.walSnapshotSize())
                && Objects.equals(walMaxWriteBufferSize(), other.walMaxWriteBufferSize())
                && Objects.equals(snapshottedWalFilesToKeep(), other.snapshottedWalFilesToKeep())
                && Objects.equals(preemptiveCacheAge(), other.preemptiveCacheAge())
                && Objects.equals(parquetMemCachePrunePercentage(), other.parquetMemCachePrunePercentage())
                && Objects.equals(parquetMemCachePruneInterval(), other.parquetMemCachePruneInterval())
                && Objects.equals(disableParquetMemCache(), other.disableParquetMemCache())
                && Objects.equals(parquetMemCacheQueryPathDuration(), other.parquetMemCacheQueryPathDuration())
                && Objects.equals(lastCacheEvictionInterval(), other.lastCacheEvictionInterval())
                && Objects.equals(distinctCacheEvictionInterval(), other.distinctCacheEvictionInterval())
                && Objects.equals(gen1Duration(), other.gen1Duration())
                && Objects.equals(execMemPoolBytes(), other.execMemPoolBytes())
                && Objects.equals(parquetMemCacheSize(), other.parquetMemCacheSize())
                && Objects.equals(walReplayFailOnError(), other.walReplayFailOnError())
                && Objects.equals(walReplayConcurrencyLimit(), other.walReplayConcurrencyLimit())
                && Objects.equals(tableIndexCacheMaxEntries(), other.tableIndexCacheMaxEntries())
                && Objects.equals(tableIndexCacheConcurrencyLimit(), other.tableIndexCacheConcurrencyLimit())
                && Objects.equals(gen1LookbackDuration(), other.gen1LookbackDuration())
                && Objects.equals(retentionCheckInterval(), other.retentionCheckInterval())
                && Objects.equals(deleteGracePeriod(), other.deleteGracePeriod())
                && Objects.equals(hardDeleteDefaultDuration(), other.hardDeleteDefaultDuration())
                && Objects.equals(ingestQueryInstances(), other.ingestQueryInstances())
                && Objects.equals(queryOnlyInstances(), other.queryOnlyInstances())
                && Objects.equals(dedicatedCompactor(), other.dedicatedCompactor())
                && Objects.equals(compactionRowLimit(), other.compactionRowLimit())
                && Objects.equals(compactionMaxNumFilesPerPlan(), other.compactionMaxNumFilesPerPlan())
                && Objects.equals(compactionGen2Duration(), other.compactionGen2Duration())
                && Objects.equals(compactionMultipliers(), other.compactionMultipliers())
                && Objects.equals(compactionCleanupWait(), other.compactionCleanupWait())
                && Objects.equals(compactionCheckInterval(), other.compactionCheckInterval())
                && Objects.equals(lastValueCacheDisableFromHistory(), other.lastValueCacheDisableFromHistory())
                && Objects.equals(distinctValueCacheDisableFromHistory(), other.distinctValueCacheDisableFromHistory())
                && Objects.equals(replicationInterval(), other.replicationInterval())
                && Objects.equals(catalogSyncInterval(), other.catalogSyncInterval());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InfluxDBv3EnterpriseParameters").add("QueryFileLimit", queryFileLimit())
                .add("QueryLogSize", queryLogSize()).add("LogFilter", logFilter()).add("LogFormat", logFormatAsString())
                .add("DataFusionNumThreads", dataFusionNumThreads())
                .add("DataFusionRuntimeType", dataFusionRuntimeTypeAsString())
                .add("DataFusionRuntimeDisableLifoSlot", dataFusionRuntimeDisableLifoSlot())
                .add("DataFusionRuntimeEventInterval", dataFusionRuntimeEventInterval())
                .add("DataFusionRuntimeGlobalQueueInterval", dataFusionRuntimeGlobalQueueInterval())
                .add("DataFusionRuntimeMaxBlockingThreads", dataFusionRuntimeMaxBlockingThreads())
                .add("DataFusionRuntimeMaxIoEventsPerTick", dataFusionRuntimeMaxIoEventsPerTick())
                .add("DataFusionRuntimeThreadKeepAlive", dataFusionRuntimeThreadKeepAlive())
                .add("DataFusionRuntimeThreadPriority", dataFusionRuntimeThreadPriority())
                .add("DataFusionMaxParquetFanout", dataFusionMaxParquetFanout())
                .add("DataFusionUseCachedParquetLoader", dataFusionUseCachedParquetLoader())
                .add("DataFusionConfig", dataFusionConfig()).add("MaxHttpRequestSize", maxHttpRequestSize())
                .add("ForceSnapshotMemThreshold", forceSnapshotMemThreshold()).add("WalSnapshotSize", walSnapshotSize())
                .add("WalMaxWriteBufferSize", walMaxWriteBufferSize())
                .add("SnapshottedWalFilesToKeep", snapshottedWalFilesToKeep()).add("PreemptiveCacheAge", preemptiveCacheAge())
                .add("ParquetMemCachePrunePercentage", parquetMemCachePrunePercentage())
                .add("ParquetMemCachePruneInterval", parquetMemCachePruneInterval())
                .add("DisableParquetMemCache", disableParquetMemCache())
                .add("ParquetMemCacheQueryPathDuration", parquetMemCacheQueryPathDuration())
                .add("LastCacheEvictionInterval", lastCacheEvictionInterval())
                .add("DistinctCacheEvictionInterval", distinctCacheEvictionInterval()).add("Gen1Duration", gen1Duration())
                .add("ExecMemPoolBytes", execMemPoolBytes()).add("ParquetMemCacheSize", parquetMemCacheSize())
                .add("WalReplayFailOnError", walReplayFailOnError())
                .add("WalReplayConcurrencyLimit", walReplayConcurrencyLimit())
                .add("TableIndexCacheMaxEntries", tableIndexCacheMaxEntries())
                .add("TableIndexCacheConcurrencyLimit", tableIndexCacheConcurrencyLimit())
                .add("Gen1LookbackDuration", gen1LookbackDuration()).add("RetentionCheckInterval", retentionCheckInterval())
                .add("DeleteGracePeriod", deleteGracePeriod()).add("HardDeleteDefaultDuration", hardDeleteDefaultDuration())
                .add("IngestQueryInstances", ingestQueryInstances()).add("QueryOnlyInstances", queryOnlyInstances())
                .add("DedicatedCompactor", dedicatedCompactor()).add("CompactionRowLimit", compactionRowLimit())
                .add("CompactionMaxNumFilesPerPlan", compactionMaxNumFilesPerPlan())
                .add("CompactionGen2Duration", compactionGen2Duration()).add("CompactionMultipliers", compactionMultipliers())
                .add("CompactionCleanupWait", compactionCleanupWait()).add("CompactionCheckInterval", compactionCheckInterval())
                .add("LastValueCacheDisableFromHistory", lastValueCacheDisableFromHistory())
                .add("DistinctValueCacheDisableFromHistory", distinctValueCacheDisableFromHistory())
                .add("ReplicationInterval", replicationInterval()).add("CatalogSyncInterval", catalogSyncInterval()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "queryFileLimit":
            return Optional.ofNullable(clazz.cast(queryFileLimit()));
        case "queryLogSize":
            return Optional.ofNullable(clazz.cast(queryLogSize()));
        case "logFilter":
            return Optional.ofNullable(clazz.cast(logFilter()));
        case "logFormat":
            return Optional.ofNullable(clazz.cast(logFormatAsString()));
        case "dataFusionNumThreads":
            return Optional.ofNullable(clazz.cast(dataFusionNumThreads()));
        case "dataFusionRuntimeType":
            return Optional.ofNullable(clazz.cast(dataFusionRuntimeTypeAsString()));
        case "dataFusionRuntimeDisableLifoSlot":
            return Optional.ofNullable(clazz.cast(dataFusionRuntimeDisableLifoSlot()));
        case "dataFusionRuntimeEventInterval":
            return Optional.ofNullable(clazz.cast(dataFusionRuntimeEventInterval()));
        case "dataFusionRuntimeGlobalQueueInterval":
            return Optional.ofNullable(clazz.cast(dataFusionRuntimeGlobalQueueInterval()));
        case "dataFusionRuntimeMaxBlockingThreads":
            return Optional.ofNullable(clazz.cast(dataFusionRuntimeMaxBlockingThreads()));
        case "dataFusionRuntimeMaxIoEventsPerTick":
            return Optional.ofNullable(clazz.cast(dataFusionRuntimeMaxIoEventsPerTick()));
        case "dataFusionRuntimeThreadKeepAlive":
            return Optional.ofNullable(clazz.cast(dataFusionRuntimeThreadKeepAlive()));
        case "dataFusionRuntimeThreadPriority":
            return Optional.ofNullable(clazz.cast(dataFusionRuntimeThreadPriority()));
        case "dataFusionMaxParquetFanout":
            return Optional.ofNullable(clazz.cast(dataFusionMaxParquetFanout()));
        case "dataFusionUseCachedParquetLoader":
            return Optional.ofNullable(clazz.cast(dataFusionUseCachedParquetLoader()));
        case "dataFusionConfig":
            return Optional.ofNullable(clazz.cast(dataFusionConfig()));
        case "maxHttpRequestSize":
            return Optional.ofNullable(clazz.cast(maxHttpRequestSize()));
        case "forceSnapshotMemThreshold":
            return Optional.ofNullable(clazz.cast(forceSnapshotMemThreshold()));
        case "walSnapshotSize":
            return Optional.ofNullable(clazz.cast(walSnapshotSize()));
        case "walMaxWriteBufferSize":
            return Optional.ofNullable(clazz.cast(walMaxWriteBufferSize()));
        case "snapshottedWalFilesToKeep":
            return Optional.ofNullable(clazz.cast(snapshottedWalFilesToKeep()));
        case "preemptiveCacheAge":
            return Optional.ofNullable(clazz.cast(preemptiveCacheAge()));
        case "parquetMemCachePrunePercentage":
            return Optional.ofNullable(clazz.cast(parquetMemCachePrunePercentage()));
        case "parquetMemCachePruneInterval":
            return Optional.ofNullable(clazz.cast(parquetMemCachePruneInterval()));
        case "disableParquetMemCache":
            return Optional.ofNullable(clazz.cast(disableParquetMemCache()));
        case "parquetMemCacheQueryPathDuration":
            return Optional.ofNullable(clazz.cast(parquetMemCacheQueryPathDuration()));
        case "lastCacheEvictionInterval":
            return Optional.ofNullable(clazz.cast(lastCacheEvictionInterval()));
        case "distinctCacheEvictionInterval":
            return Optional.ofNullable(clazz.cast(distinctCacheEvictionInterval()));
        case "gen1Duration":
            return Optional.ofNullable(clazz.cast(gen1Duration()));
        case "execMemPoolBytes":
            return Optional.ofNullable(clazz.cast(execMemPoolBytes()));
        case "parquetMemCacheSize":
            return Optional.ofNullable(clazz.cast(parquetMemCacheSize()));
        case "walReplayFailOnError":
            return Optional.ofNullable(clazz.cast(walReplayFailOnError()));
        case "walReplayConcurrencyLimit":
            return Optional.ofNullable(clazz.cast(walReplayConcurrencyLimit()));
        case "tableIndexCacheMaxEntries":
            return Optional.ofNullable(clazz.cast(tableIndexCacheMaxEntries()));
        case "tableIndexCacheConcurrencyLimit":
            return Optional.ofNullable(clazz.cast(tableIndexCacheConcurrencyLimit()));
        case "gen1LookbackDuration":
            return Optional.ofNullable(clazz.cast(gen1LookbackDuration()));
        case "retentionCheckInterval":
            return Optional.ofNullable(clazz.cast(retentionCheckInterval()));
        case "deleteGracePeriod":
            return Optional.ofNullable(clazz.cast(deleteGracePeriod()));
        case "hardDeleteDefaultDuration":
            return Optional.ofNullable(clazz.cast(hardDeleteDefaultDuration()));
        case "ingestQueryInstances":
            return Optional.ofNullable(clazz.cast(ingestQueryInstances()));
        case "queryOnlyInstances":
            return Optional.ofNullable(clazz.cast(queryOnlyInstances()));
        case "dedicatedCompactor":
            return Optional.ofNullable(clazz.cast(dedicatedCompactor()));
        case "compactionRowLimit":
            return Optional.ofNullable(clazz.cast(compactionRowLimit()));
        case "compactionMaxNumFilesPerPlan":
            return Optional.ofNullable(clazz.cast(compactionMaxNumFilesPerPlan()));
        case "compactionGen2Duration":
            return Optional.ofNullable(clazz.cast(compactionGen2Duration()));
        case "compactionMultipliers":
            return Optional.ofNullable(clazz.cast(compactionMultipliers()));
        case "compactionCleanupWait":
            return Optional.ofNullable(clazz.cast(compactionCleanupWait()));
        case "compactionCheckInterval":
            return Optional.ofNullable(clazz.cast(compactionCheckInterval()));
        case "lastValueCacheDisableFromHistory":
            return Optional.ofNullable(clazz.cast(lastValueCacheDisableFromHistory()));
        case "distinctValueCacheDisableFromHistory":
            return Optional.ofNullable(clazz.cast(distinctValueCacheDisableFromHistory()));
        case "replicationInterval":
            return Optional.ofNullable(clazz.cast(replicationInterval()));
        case "catalogSyncInterval":
            return Optional.ofNullable(clazz.cast(catalogSyncInterval()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("queryFileLimit", QUERY_FILE_LIMIT_FIELD);
        map.put("queryLogSize", QUERY_LOG_SIZE_FIELD);
        map.put("logFilter", LOG_FILTER_FIELD);
        map.put("logFormat", LOG_FORMAT_FIELD);
        map.put("dataFusionNumThreads", DATA_FUSION_NUM_THREADS_FIELD);
        map.put("dataFusionRuntimeType", DATA_FUSION_RUNTIME_TYPE_FIELD);
        map.put("dataFusionRuntimeDisableLifoSlot", DATA_FUSION_RUNTIME_DISABLE_LIFO_SLOT_FIELD);
        map.put("dataFusionRuntimeEventInterval", DATA_FUSION_RUNTIME_EVENT_INTERVAL_FIELD);
        map.put("dataFusionRuntimeGlobalQueueInterval", DATA_FUSION_RUNTIME_GLOBAL_QUEUE_INTERVAL_FIELD);
        map.put("dataFusionRuntimeMaxBlockingThreads", DATA_FUSION_RUNTIME_MAX_BLOCKING_THREADS_FIELD);
        map.put("dataFusionRuntimeMaxIoEventsPerTick", DATA_FUSION_RUNTIME_MAX_IO_EVENTS_PER_TICK_FIELD);
        map.put("dataFusionRuntimeThreadKeepAlive", DATA_FUSION_RUNTIME_THREAD_KEEP_ALIVE_FIELD);
        map.put("dataFusionRuntimeThreadPriority", DATA_FUSION_RUNTIME_THREAD_PRIORITY_FIELD);
        map.put("dataFusionMaxParquetFanout", DATA_FUSION_MAX_PARQUET_FANOUT_FIELD);
        map.put("dataFusionUseCachedParquetLoader", DATA_FUSION_USE_CACHED_PARQUET_LOADER_FIELD);
        map.put("dataFusionConfig", DATA_FUSION_CONFIG_FIELD);
        map.put("maxHttpRequestSize", MAX_HTTP_REQUEST_SIZE_FIELD);
        map.put("forceSnapshotMemThreshold", FORCE_SNAPSHOT_MEM_THRESHOLD_FIELD);
        map.put("walSnapshotSize", WAL_SNAPSHOT_SIZE_FIELD);
        map.put("walMaxWriteBufferSize", WAL_MAX_WRITE_BUFFER_SIZE_FIELD);
        map.put("snapshottedWalFilesToKeep", SNAPSHOTTED_WAL_FILES_TO_KEEP_FIELD);
        map.put("preemptiveCacheAge", PREEMPTIVE_CACHE_AGE_FIELD);
        map.put("parquetMemCachePrunePercentage", PARQUET_MEM_CACHE_PRUNE_PERCENTAGE_FIELD);
        map.put("parquetMemCachePruneInterval", PARQUET_MEM_CACHE_PRUNE_INTERVAL_FIELD);
        map.put("disableParquetMemCache", DISABLE_PARQUET_MEM_CACHE_FIELD);
        map.put("parquetMemCacheQueryPathDuration", PARQUET_MEM_CACHE_QUERY_PATH_DURATION_FIELD);
        map.put("lastCacheEvictionInterval", LAST_CACHE_EVICTION_INTERVAL_FIELD);
        map.put("distinctCacheEvictionInterval", DISTINCT_CACHE_EVICTION_INTERVAL_FIELD);
        map.put("gen1Duration", GEN1_DURATION_FIELD);
        map.put("execMemPoolBytes", EXEC_MEM_POOL_BYTES_FIELD);
        map.put("parquetMemCacheSize", PARQUET_MEM_CACHE_SIZE_FIELD);
        map.put("walReplayFailOnError", WAL_REPLAY_FAIL_ON_ERROR_FIELD);
        map.put("walReplayConcurrencyLimit", WAL_REPLAY_CONCURRENCY_LIMIT_FIELD);
        map.put("tableIndexCacheMaxEntries", TABLE_INDEX_CACHE_MAX_ENTRIES_FIELD);
        map.put("tableIndexCacheConcurrencyLimit", TABLE_INDEX_CACHE_CONCURRENCY_LIMIT_FIELD);
        map.put("gen1LookbackDuration", GEN1_LOOKBACK_DURATION_FIELD);
        map.put("retentionCheckInterval", RETENTION_CHECK_INTERVAL_FIELD);
        map.put("deleteGracePeriod", DELETE_GRACE_PERIOD_FIELD);
        map.put("hardDeleteDefaultDuration", HARD_DELETE_DEFAULT_DURATION_FIELD);
        map.put("ingestQueryInstances", INGEST_QUERY_INSTANCES_FIELD);
        map.put("queryOnlyInstances", QUERY_ONLY_INSTANCES_FIELD);
        map.put("dedicatedCompactor", DEDICATED_COMPACTOR_FIELD);
        map.put("compactionRowLimit", COMPACTION_ROW_LIMIT_FIELD);
        map.put("compactionMaxNumFilesPerPlan", COMPACTION_MAX_NUM_FILES_PER_PLAN_FIELD);
        map.put("compactionGen2Duration", COMPACTION_GEN2_DURATION_FIELD);
        map.put("compactionMultipliers", COMPACTION_MULTIPLIERS_FIELD);
        map.put("compactionCleanupWait", COMPACTION_CLEANUP_WAIT_FIELD);
        map.put("compactionCheckInterval", COMPACTION_CHECK_INTERVAL_FIELD);
        map.put("lastValueCacheDisableFromHistory", LAST_VALUE_CACHE_DISABLE_FROM_HISTORY_FIELD);
        map.put("distinctValueCacheDisableFromHistory", DISTINCT_VALUE_CACHE_DISABLE_FROM_HISTORY_FIELD);
        map.put("replicationInterval", REPLICATION_INTERVAL_FIELD);
        map.put("catalogSyncInterval", CATALOG_SYNC_INTERVAL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InfluxDBv3EnterpriseParameters, T> g) {
        return obj -> g.apply((InfluxDBv3EnterpriseParameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InfluxDBv3EnterpriseParameters> {
        /**
         * <p>
         * Limits the number of Parquet files a query can access. If a query attempts to read more than this limit,
         * InfluxDB 3 returns an error.
         * </p>
         * <p>
         * Default: 432
         * </p>
         * 
         * @param queryFileLimit
         *        Limits the number of Parquet files a query can access. If a query attempts to read more than this
         *        limit, InfluxDB 3 returns an error.</p>
         *        <p>
         *        Default: 432
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryFileLimit(Integer queryFileLimit);

        /**
         * <p>
         * Defines the size of the query log. Up to this many queries remain in the log before older queries are evicted
         * to make room for new ones.
         * </p>
         * <p>
         * Default: 1000
         * </p>
         * 
         * @param queryLogSize
         *        Defines the size of the query log. Up to this many queries remain in the log before older queries are
         *        evicted to make room for new ones.</p>
         *        <p>
         *        Default: 1000
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryLogSize(Integer queryLogSize);

        /**
         * <p>
         * Sets the filter directive for logs.
         * </p>
         * 
         * @param logFilter
         *        Sets the filter directive for logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logFilter(String logFilter);

        /**
         * <p>
         * Defines the message format for logs.
         * </p>
         * <p>
         * Default: full
         * </p>
         * 
         * @param logFormat
         *        Defines the message format for logs.</p>
         *        <p>
         *        Default: full
         * @see LogFormats
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogFormats
         */
        Builder logFormat(String logFormat);

        /**
         * <p>
         * Defines the message format for logs.
         * </p>
         * <p>
         * Default: full
         * </p>
         * 
         * @param logFormat
         *        Defines the message format for logs.</p>
         *        <p>
         *        Default: full
         * @see LogFormats
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogFormats
         */
        Builder logFormat(LogFormats logFormat);

        /**
         * <p>
         * Sets the maximum number of DataFusion runtime threads to use.
         * </p>
         * 
         * @param dataFusionNumThreads
         *        Sets the maximum number of DataFusion runtime threads to use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataFusionNumThreads(Integer dataFusionNumThreads);

        /**
         * <p>
         * Specifies the DataFusion tokio runtime type.
         * </p>
         * <p>
         * Default: multi-thread
         * </p>
         * 
         * @param dataFusionRuntimeType
         *        Specifies the DataFusion tokio runtime type.</p>
         *        <p>
         *        Default: multi-thread
         * @see DataFusionRuntimeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataFusionRuntimeType
         */
        Builder dataFusionRuntimeType(String dataFusionRuntimeType);

        /**
         * <p>
         * Specifies the DataFusion tokio runtime type.
         * </p>
         * <p>
         * Default: multi-thread
         * </p>
         * 
         * @param dataFusionRuntimeType
         *        Specifies the DataFusion tokio runtime type.</p>
         *        <p>
         *        Default: multi-thread
         * @see DataFusionRuntimeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataFusionRuntimeType
         */
        Builder dataFusionRuntimeType(DataFusionRuntimeType dataFusionRuntimeType);

        /**
         * <p>
         * Disables the LIFO slot of the DataFusion runtime.
         * </p>
         * 
         * @param dataFusionRuntimeDisableLifoSlot
         *        Disables the LIFO slot of the DataFusion runtime.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataFusionRuntimeDisableLifoSlot(Boolean dataFusionRuntimeDisableLifoSlot);

        /**
         * <p>
         * Sets the number of scheduler ticks after which the scheduler of the DataFusion tokio runtime polls for
         * external events–for example: timers, I/O.
         * </p>
         * 
         * @param dataFusionRuntimeEventInterval
         *        Sets the number of scheduler ticks after which the scheduler of the DataFusion tokio runtime polls for
         *        external events–for example: timers, I/O.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataFusionRuntimeEventInterval(Integer dataFusionRuntimeEventInterval);

        /**
         * <p>
         * Sets the number of scheduler ticks after which the scheduler of the DataFusion runtime polls the global task
         * queue.
         * </p>
         * 
         * @param dataFusionRuntimeGlobalQueueInterval
         *        Sets the number of scheduler ticks after which the scheduler of the DataFusion runtime polls the
         *        global task queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataFusionRuntimeGlobalQueueInterval(Integer dataFusionRuntimeGlobalQueueInterval);

        /**
         * <p>
         * Specifies the limit for additional threads spawned by the DataFusion runtime.
         * </p>
         * 
         * @param dataFusionRuntimeMaxBlockingThreads
         *        Specifies the limit for additional threads spawned by the DataFusion runtime.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataFusionRuntimeMaxBlockingThreads(Integer dataFusionRuntimeMaxBlockingThreads);

        /**
         * <p>
         * Configures the maximum number of events processed per tick by the tokio DataFusion runtime.
         * </p>
         * 
         * @param dataFusionRuntimeMaxIoEventsPerTick
         *        Configures the maximum number of events processed per tick by the tokio DataFusion runtime.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataFusionRuntimeMaxIoEventsPerTick(Integer dataFusionRuntimeMaxIoEventsPerTick);

        /**
         * <p>
         * Sets a custom timeout for a thread in the blocking pool of the tokio DataFusion runtime.
         * </p>
         * 
         * @param dataFusionRuntimeThreadKeepAlive
         *        Sets a custom timeout for a thread in the blocking pool of the tokio DataFusion runtime.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataFusionRuntimeThreadKeepAlive(Duration dataFusionRuntimeThreadKeepAlive);

        /**
         * <p>
         * Sets a custom timeout for a thread in the blocking pool of the tokio DataFusion runtime.
         * </p>
         * This is a convenience method that creates an instance of the {@link Duration.Builder} avoiding the need to
         * create one manually via {@link Duration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Duration.Builder#build()} is called immediately and its result is
         * passed to {@link #dataFusionRuntimeThreadKeepAlive(Duration)}.
         * 
         * @param dataFusionRuntimeThreadKeepAlive
         *        a consumer that will call methods on {@link Duration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataFusionRuntimeThreadKeepAlive(Duration)
         */
        default Builder dataFusionRuntimeThreadKeepAlive(Consumer<Duration.Builder> dataFusionRuntimeThreadKeepAlive) {
            return dataFusionRuntimeThreadKeepAlive(Duration.builder().applyMutation(dataFusionRuntimeThreadKeepAlive).build());
        }

        /**
         * <p>
         * Sets the thread priority for tokio DataFusion runtime workers.
         * </p>
         * <p>
         * Default: 10
         * </p>
         * 
         * @param dataFusionRuntimeThreadPriority
         *        Sets the thread priority for tokio DataFusion runtime workers.</p>
         *        <p>
         *        Default: 10
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataFusionRuntimeThreadPriority(Integer dataFusionRuntimeThreadPriority);

        /**
         * <p>
         * When multiple parquet files are required in a sorted way (deduplication for example), specifies the maximum
         * fanout.
         * </p>
         * <p>
         * Default: 1000
         * </p>
         * 
         * @param dataFusionMaxParquetFanout
         *        When multiple parquet files are required in a sorted way (deduplication for example), specifies the
         *        maximum fanout.</p>
         *        <p>
         *        Default: 1000
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataFusionMaxParquetFanout(Integer dataFusionMaxParquetFanout);

        /**
         * <p>
         * Uses a cached parquet loader when reading parquet files from the object store.
         * </p>
         * 
         * @param dataFusionUseCachedParquetLoader
         *        Uses a cached parquet loader when reading parquet files from the object store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataFusionUseCachedParquetLoader(Boolean dataFusionUseCachedParquetLoader);

        /**
         * <p>
         * Provides custom configuration to DataFusion as a comma-separated list of key:value pairs.
         * </p>
         * 
         * @param dataFusionConfig
         *        Provides custom configuration to DataFusion as a comma-separated list of key:value pairs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataFusionConfig(String dataFusionConfig);

        /**
         * <p>
         * Specifies the maximum size of HTTP requests.
         * </p>
         * <p>
         * Default: 10485760
         * </p>
         * 
         * @param maxHttpRequestSize
         *        Specifies the maximum size of HTTP requests.</p>
         *        <p>
         *        Default: 10485760
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxHttpRequestSize(Long maxHttpRequestSize);

        /**
         * <p>
         * Specifies the threshold for the internal memory buffer. Supports either a percentage (portion of available
         * memory) or absolute value in MB–for example: 70% or 100
         * </p>
         * <p>
         * Default: 70%
         * </p>
         * 
         * @param forceSnapshotMemThreshold
         *        Specifies the threshold for the internal memory buffer. Supports either a percentage (portion of
         *        available memory) or absolute value in MB–for example: 70% or 100</p>
         *        <p>
         *        Default: 70%
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forceSnapshotMemThreshold(PercentOrAbsoluteLong forceSnapshotMemThreshold);

        /**
         * <p>
         * Specifies the threshold for the internal memory buffer. Supports either a percentage (portion of available
         * memory) or absolute value in MB–for example: 70% or 100
         * </p>
         * <p>
         * Default: 70%
         * </p>
         * This is a convenience method that creates an instance of the {@link PercentOrAbsoluteLong.Builder} avoiding
         * the need to create one manually via {@link PercentOrAbsoluteLong#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PercentOrAbsoluteLong.Builder#build()} is called immediately and
         * its result is passed to {@link #forceSnapshotMemThreshold(PercentOrAbsoluteLong)}.
         * 
         * @param forceSnapshotMemThreshold
         *        a consumer that will call methods on {@link PercentOrAbsoluteLong.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #forceSnapshotMemThreshold(PercentOrAbsoluteLong)
         */
        default Builder forceSnapshotMemThreshold(Consumer<PercentOrAbsoluteLong.Builder> forceSnapshotMemThreshold) {
            return forceSnapshotMemThreshold(PercentOrAbsoluteLong.builder().applyMutation(forceSnapshotMemThreshold).build());
        }

        /**
         * <p>
         * Defines the number of WAL files to attempt to remove in a snapshot. This, multiplied by the interval,
         * determines how often snapshots are taken.
         * </p>
         * <p>
         * Default: 600
         * </p>
         * 
         * @param walSnapshotSize
         *        Defines the number of WAL files to attempt to remove in a snapshot. This, multiplied by the interval,
         *        determines how often snapshots are taken.</p>
         *        <p>
         *        Default: 600
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder walSnapshotSize(Integer walSnapshotSize);

        /**
         * <p>
         * Specifies the maximum number of write requests that can be buffered before a flush must be executed and
         * succeed.
         * </p>
         * <p>
         * Default: 100000
         * </p>
         * 
         * @param walMaxWriteBufferSize
         *        Specifies the maximum number of write requests that can be buffered before a flush must be executed
         *        and succeed.</p>
         *        <p>
         *        Default: 100000
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder walMaxWriteBufferSize(Integer walMaxWriteBufferSize);

        /**
         * <p>
         * Specifies the number of snapshotted WAL files to retain in the object store. Flushing the WAL files does not
         * clear the WAL files immediately; they are deleted when the number of snapshotted WAL files exceeds this
         * number.
         * </p>
         * <p>
         * Default: 300
         * </p>
         * 
         * @param snapshottedWalFilesToKeep
         *        Specifies the number of snapshotted WAL files to retain in the object store. Flushing the WAL files
         *        does not clear the WAL files immediately; they are deleted when the number of snapshotted WAL files
         *        exceeds this number.</p>
         *        <p>
         *        Default: 300
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshottedWalFilesToKeep(Integer snapshottedWalFilesToKeep);

        /**
         * <p>
         * Specifies the interval to prefetch into the Parquet cache during compaction.
         * </p>
         * <p>
         * Default: 3d
         * </p>
         * 
         * @param preemptiveCacheAge
         *        Specifies the interval to prefetch into the Parquet cache during compaction.</p>
         *        <p>
         *        Default: 3d
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preemptiveCacheAge(Duration preemptiveCacheAge);

        /**
         * <p>
         * Specifies the interval to prefetch into the Parquet cache during compaction.
         * </p>
         * <p>
         * Default: 3d
         * </p>
         * This is a convenience method that creates an instance of the {@link Duration.Builder} avoiding the need to
         * create one manually via {@link Duration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Duration.Builder#build()} is called immediately and its result is
         * passed to {@link #preemptiveCacheAge(Duration)}.
         * 
         * @param preemptiveCacheAge
         *        a consumer that will call methods on {@link Duration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #preemptiveCacheAge(Duration)
         */
        default Builder preemptiveCacheAge(Consumer<Duration.Builder> preemptiveCacheAge) {
            return preemptiveCacheAge(Duration.builder().applyMutation(preemptiveCacheAge).build());
        }

        /**
         * <p>
         * Specifies the percentage of entries to prune during a prune operation on the in-memory Parquet cache.
         * </p>
         * <p>
         * Default: 0.1
         * </p>
         * 
         * @param parquetMemCachePrunePercentage
         *        Specifies the percentage of entries to prune during a prune operation on the in-memory Parquet
         *        cache.</p>
         *        <p>
         *        Default: 0.1
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parquetMemCachePrunePercentage(Float parquetMemCachePrunePercentage);

        /**
         * <p>
         * Sets the interval to check if the in-memory Parquet cache needs to be pruned.
         * </p>
         * <p>
         * Default: 1s
         * </p>
         * 
         * @param parquetMemCachePruneInterval
         *        Sets the interval to check if the in-memory Parquet cache needs to be pruned.</p>
         *        <p>
         *        Default: 1s
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parquetMemCachePruneInterval(Duration parquetMemCachePruneInterval);

        /**
         * <p>
         * Sets the interval to check if the in-memory Parquet cache needs to be pruned.
         * </p>
         * <p>
         * Default: 1s
         * </p>
         * This is a convenience method that creates an instance of the {@link Duration.Builder} avoiding the need to
         * create one manually via {@link Duration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Duration.Builder#build()} is called immediately and its result is
         * passed to {@link #parquetMemCachePruneInterval(Duration)}.
         * 
         * @param parquetMemCachePruneInterval
         *        a consumer that will call methods on {@link Duration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parquetMemCachePruneInterval(Duration)
         */
        default Builder parquetMemCachePruneInterval(Consumer<Duration.Builder> parquetMemCachePruneInterval) {
            return parquetMemCachePruneInterval(Duration.builder().applyMutation(parquetMemCachePruneInterval).build());
        }

        /**
         * <p>
         * Disables the in-memory Parquet cache. By default, the cache is enabled.
         * </p>
         * 
         * @param disableParquetMemCache
         *        Disables the in-memory Parquet cache. By default, the cache is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disableParquetMemCache(Boolean disableParquetMemCache);

        /**
         * <p>
         * Specifies the time window for caching recent Parquet files in memory.
         * </p>
         * <p>
         * Default: 5h
         * </p>
         * 
         * @param parquetMemCacheQueryPathDuration
         *        Specifies the time window for caching recent Parquet files in memory.</p>
         *        <p>
         *        Default: 5h
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parquetMemCacheQueryPathDuration(Duration parquetMemCacheQueryPathDuration);

        /**
         * <p>
         * Specifies the time window for caching recent Parquet files in memory.
         * </p>
         * <p>
         * Default: 5h
         * </p>
         * This is a convenience method that creates an instance of the {@link Duration.Builder} avoiding the need to
         * create one manually via {@link Duration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Duration.Builder#build()} is called immediately and its result is
         * passed to {@link #parquetMemCacheQueryPathDuration(Duration)}.
         * 
         * @param parquetMemCacheQueryPathDuration
         *        a consumer that will call methods on {@link Duration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parquetMemCacheQueryPathDuration(Duration)
         */
        default Builder parquetMemCacheQueryPathDuration(Consumer<Duration.Builder> parquetMemCacheQueryPathDuration) {
            return parquetMemCacheQueryPathDuration(Duration.builder().applyMutation(parquetMemCacheQueryPathDuration).build());
        }

        /**
         * <p>
         * Specifies the interval to evict expired entries from the Last-N-Value cache, expressed as a human-readable
         * duration–for example: 20s, 1m, 1h.
         * </p>
         * <p>
         * Default: 10s
         * </p>
         * 
         * @param lastCacheEvictionInterval
         *        Specifies the interval to evict expired entries from the Last-N-Value cache, expressed as a
         *        human-readable duration–for example: 20s, 1m, 1h.</p>
         *        <p>
         *        Default: 10s
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastCacheEvictionInterval(Duration lastCacheEvictionInterval);

        /**
         * <p>
         * Specifies the interval to evict expired entries from the Last-N-Value cache, expressed as a human-readable
         * duration–for example: 20s, 1m, 1h.
         * </p>
         * <p>
         * Default: 10s
         * </p>
         * This is a convenience method that creates an instance of the {@link Duration.Builder} avoiding the need to
         * create one manually via {@link Duration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Duration.Builder#build()} is called immediately and its result is
         * passed to {@link #lastCacheEvictionInterval(Duration)}.
         * 
         * @param lastCacheEvictionInterval
         *        a consumer that will call methods on {@link Duration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lastCacheEvictionInterval(Duration)
         */
        default Builder lastCacheEvictionInterval(Consumer<Duration.Builder> lastCacheEvictionInterval) {
            return lastCacheEvictionInterval(Duration.builder().applyMutation(lastCacheEvictionInterval).build());
        }

        /**
         * <p>
         * Specifies the interval to evict expired entries from the distinct value cache, expressed as a human-readable
         * duration–for example: 20s, 1m, 1h.
         * </p>
         * <p>
         * Default: 10s
         * </p>
         * 
         * @param distinctCacheEvictionInterval
         *        Specifies the interval to evict expired entries from the distinct value cache, expressed as a
         *        human-readable duration–for example: 20s, 1m, 1h.</p>
         *        <p>
         *        Default: 10s
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder distinctCacheEvictionInterval(Duration distinctCacheEvictionInterval);

        /**
         * <p>
         * Specifies the interval to evict expired entries from the distinct value cache, expressed as a human-readable
         * duration–for example: 20s, 1m, 1h.
         * </p>
         * <p>
         * Default: 10s
         * </p>
         * This is a convenience method that creates an instance of the {@link Duration.Builder} avoiding the need to
         * create one manually via {@link Duration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Duration.Builder#build()} is called immediately and its result is
         * passed to {@link #distinctCacheEvictionInterval(Duration)}.
         * 
         * @param distinctCacheEvictionInterval
         *        a consumer that will call methods on {@link Duration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #distinctCacheEvictionInterval(Duration)
         */
        default Builder distinctCacheEvictionInterval(Consumer<Duration.Builder> distinctCacheEvictionInterval) {
            return distinctCacheEvictionInterval(Duration.builder().applyMutation(distinctCacheEvictionInterval).build());
        }

        /**
         * <p>
         * Specifies the duration that Parquet files are arranged into. Data timestamps land each row into a file of
         * this duration. Supported durations are 1m, 5m, and 10m. These files are known as “generation 1” files, which
         * the compactor can merge into larger generations.
         * </p>
         * <p>
         * Default: 10m
         * </p>
         * 
         * @param gen1Duration
         *        Specifies the duration that Parquet files are arranged into. Data timestamps land each row into a file
         *        of this duration. Supported durations are 1m, 5m, and 10m. These files are known as “generation 1”
         *        files, which the compactor can merge into larger generations.</p>
         *        <p>
         *        Default: 10m
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gen1Duration(Duration gen1Duration);

        /**
         * <p>
         * Specifies the duration that Parquet files are arranged into. Data timestamps land each row into a file of
         * this duration. Supported durations are 1m, 5m, and 10m. These files are known as “generation 1” files, which
         * the compactor can merge into larger generations.
         * </p>
         * <p>
         * Default: 10m
         * </p>
         * This is a convenience method that creates an instance of the {@link Duration.Builder} avoiding the need to
         * create one manually via {@link Duration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Duration.Builder#build()} is called immediately and its result is
         * passed to {@link #gen1Duration(Duration)}.
         * 
         * @param gen1Duration
         *        a consumer that will call methods on {@link Duration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #gen1Duration(Duration)
         */
        default Builder gen1Duration(Consumer<Duration.Builder> gen1Duration) {
            return gen1Duration(Duration.builder().applyMutation(gen1Duration).build());
        }

        /**
         * <p>
         * Specifies the size of memory pool used during query execution. Can be given as absolute value in bytes or as
         * a percentage of the total available memory–for example: 8000000000 or 10%.
         * </p>
         * <p>
         * Default: 20%
         * </p>
         * 
         * @param execMemPoolBytes
         *        Specifies the size of memory pool used during query execution. Can be given as absolute value in bytes
         *        or as a percentage of the total available memory–for example: 8000000000 or 10%.</p>
         *        <p>
         *        Default: 20%
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder execMemPoolBytes(PercentOrAbsoluteLong execMemPoolBytes);

        /**
         * <p>
         * Specifies the size of memory pool used during query execution. Can be given as absolute value in bytes or as
         * a percentage of the total available memory–for example: 8000000000 or 10%.
         * </p>
         * <p>
         * Default: 20%
         * </p>
         * This is a convenience method that creates an instance of the {@link PercentOrAbsoluteLong.Builder} avoiding
         * the need to create one manually via {@link PercentOrAbsoluteLong#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PercentOrAbsoluteLong.Builder#build()} is called immediately and
         * its result is passed to {@link #execMemPoolBytes(PercentOrAbsoluteLong)}.
         * 
         * @param execMemPoolBytes
         *        a consumer that will call methods on {@link PercentOrAbsoluteLong.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #execMemPoolBytes(PercentOrAbsoluteLong)
         */
        default Builder execMemPoolBytes(Consumer<PercentOrAbsoluteLong.Builder> execMemPoolBytes) {
            return execMemPoolBytes(PercentOrAbsoluteLong.builder().applyMutation(execMemPoolBytes).build());
        }

        /**
         * <p>
         * Specifies the size of the in-memory Parquet cache in megabytes or percentage of total available memory.
         * </p>
         * <p>
         * Default: 20%
         * </p>
         * 
         * @param parquetMemCacheSize
         *        Specifies the size of the in-memory Parquet cache in megabytes or percentage of total available
         *        memory.</p>
         *        <p>
         *        Default: 20%
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parquetMemCacheSize(PercentOrAbsoluteLong parquetMemCacheSize);

        /**
         * <p>
         * Specifies the size of the in-memory Parquet cache in megabytes or percentage of total available memory.
         * </p>
         * <p>
         * Default: 20%
         * </p>
         * This is a convenience method that creates an instance of the {@link PercentOrAbsoluteLong.Builder} avoiding
         * the need to create one manually via {@link PercentOrAbsoluteLong#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PercentOrAbsoluteLong.Builder#build()} is called immediately and
         * its result is passed to {@link #parquetMemCacheSize(PercentOrAbsoluteLong)}.
         * 
         * @param parquetMemCacheSize
         *        a consumer that will call methods on {@link PercentOrAbsoluteLong.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parquetMemCacheSize(PercentOrAbsoluteLong)
         */
        default Builder parquetMemCacheSize(Consumer<PercentOrAbsoluteLong.Builder> parquetMemCacheSize) {
            return parquetMemCacheSize(PercentOrAbsoluteLong.builder().applyMutation(parquetMemCacheSize).build());
        }

        /**
         * <p>
         * Determines whether WAL replay should fail when encountering errors.
         * </p>
         * <p>
         * Default: false
         * </p>
         * 
         * @param walReplayFailOnError
         *        Determines whether WAL replay should fail when encountering errors.</p>
         *        <p>
         *        Default: false
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder walReplayFailOnError(Boolean walReplayFailOnError);

        /**
         * <p>
         * Concurrency limit during WAL replay. Setting this number too high can lead to OOM. The default is dynamically
         * determined.
         * </p>
         * <p>
         * Default: max(num_cpus, 10)
         * </p>
         * 
         * @param walReplayConcurrencyLimit
         *        Concurrency limit during WAL replay. Setting this number too high can lead to OOM. The default is
         *        dynamically determined.</p>
         *        <p>
         *        Default: max(num_cpus, 10)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder walReplayConcurrencyLimit(Integer walReplayConcurrencyLimit);

        /**
         * <p>
         * Specifies the maximum number of entries in the table index cache.
         * </p>
         * <p>
         * Default: 1000
         * </p>
         * 
         * @param tableIndexCacheMaxEntries
         *        Specifies the maximum number of entries in the table index cache.</p>
         *        <p>
         *        Default: 1000
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableIndexCacheMaxEntries(Integer tableIndexCacheMaxEntries);

        /**
         * <p>
         * Limits the concurrency level for table index cache operations.
         * </p>
         * <p>
         * Default: 8
         * </p>
         * 
         * @param tableIndexCacheConcurrencyLimit
         *        Limits the concurrency level for table index cache operations.</p>
         *        <p>
         *        Default: 8
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableIndexCacheConcurrencyLimit(Integer tableIndexCacheConcurrencyLimit);

        /**
         * <p>
         * Specifies how far back to look when creating generation 1 Parquet files.
         * </p>
         * <p>
         * Default: 24h
         * </p>
         * 
         * @param gen1LookbackDuration
         *        Specifies how far back to look when creating generation 1 Parquet files.</p>
         *        <p>
         *        Default: 24h
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gen1LookbackDuration(Duration gen1LookbackDuration);

        /**
         * <p>
         * Specifies how far back to look when creating generation 1 Parquet files.
         * </p>
         * <p>
         * Default: 24h
         * </p>
         * This is a convenience method that creates an instance of the {@link Duration.Builder} avoiding the need to
         * create one manually via {@link Duration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Duration.Builder#build()} is called immediately and its result is
         * passed to {@link #gen1LookbackDuration(Duration)}.
         * 
         * @param gen1LookbackDuration
         *        a consumer that will call methods on {@link Duration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #gen1LookbackDuration(Duration)
         */
        default Builder gen1LookbackDuration(Consumer<Duration.Builder> gen1LookbackDuration) {
            return gen1LookbackDuration(Duration.builder().applyMutation(gen1LookbackDuration).build());
        }

        /**
         * <p>
         * The interval at which retention policies are checked and enforced. Enter as a human-readable time–for
         * example: 30m or 1h.
         * </p>
         * <p>
         * Default: 30m
         * </p>
         * 
         * @param retentionCheckInterval
         *        The interval at which retention policies are checked and enforced. Enter as a human-readable time–for
         *        example: 30m or 1h.</p>
         *        <p>
         *        Default: 30m
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retentionCheckInterval(Duration retentionCheckInterval);

        /**
         * <p>
         * The interval at which retention policies are checked and enforced. Enter as a human-readable time–for
         * example: 30m or 1h.
         * </p>
         * <p>
         * Default: 30m
         * </p>
         * This is a convenience method that creates an instance of the {@link Duration.Builder} avoiding the need to
         * create one manually via {@link Duration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Duration.Builder#build()} is called immediately and its result is
         * passed to {@link #retentionCheckInterval(Duration)}.
         * 
         * @param retentionCheckInterval
         *        a consumer that will call methods on {@link Duration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #retentionCheckInterval(Duration)
         */
        default Builder retentionCheckInterval(Consumer<Duration.Builder> retentionCheckInterval) {
            return retentionCheckInterval(Duration.builder().applyMutation(retentionCheckInterval).build());
        }

        /**
         * <p>
         * Specifies the grace period before permanently deleting data.
         * </p>
         * <p>
         * Default: 24h
         * </p>
         * 
         * @param deleteGracePeriod
         *        Specifies the grace period before permanently deleting data.</p>
         *        <p>
         *        Default: 24h
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteGracePeriod(Duration deleteGracePeriod);

        /**
         * <p>
         * Specifies the grace period before permanently deleting data.
         * </p>
         * <p>
         * Default: 24h
         * </p>
         * This is a convenience method that creates an instance of the {@link Duration.Builder} avoiding the need to
         * create one manually via {@link Duration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Duration.Builder#build()} is called immediately and its result is
         * passed to {@link #deleteGracePeriod(Duration)}.
         * 
         * @param deleteGracePeriod
         *        a consumer that will call methods on {@link Duration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deleteGracePeriod(Duration)
         */
        default Builder deleteGracePeriod(Consumer<Duration.Builder> deleteGracePeriod) {
            return deleteGracePeriod(Duration.builder().applyMutation(deleteGracePeriod).build());
        }

        /**
         * <p>
         * Sets the default duration for hard deletion of data.
         * </p>
         * <p>
         * Default: 90d
         * </p>
         * 
         * @param hardDeleteDefaultDuration
         *        Sets the default duration for hard deletion of data.</p>
         *        <p>
         *        Default: 90d
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hardDeleteDefaultDuration(Duration hardDeleteDefaultDuration);

        /**
         * <p>
         * Sets the default duration for hard deletion of data.
         * </p>
         * <p>
         * Default: 90d
         * </p>
         * This is a convenience method that creates an instance of the {@link Duration.Builder} avoiding the need to
         * create one manually via {@link Duration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Duration.Builder#build()} is called immediately and its result is
         * passed to {@link #hardDeleteDefaultDuration(Duration)}.
         * 
         * @param hardDeleteDefaultDuration
         *        a consumer that will call methods on {@link Duration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hardDeleteDefaultDuration(Duration)
         */
        default Builder hardDeleteDefaultDuration(Consumer<Duration.Builder> hardDeleteDefaultDuration) {
            return hardDeleteDefaultDuration(Duration.builder().applyMutation(hardDeleteDefaultDuration).build());
        }

        /**
         * <p>
         * Specifies number of instances in the DbCluster which can both ingest and query.
         * </p>
         * 
         * @param ingestQueryInstances
         *        Specifies number of instances in the DbCluster which can both ingest and query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ingestQueryInstances(Integer ingestQueryInstances);

        /**
         * <p>
         * Specifies number of instances in the DbCluster which can only query.
         * </p>
         * 
         * @param queryOnlyInstances
         *        Specifies number of instances in the DbCluster which can only query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryOnlyInstances(Integer queryOnlyInstances);

        /**
         * <p>
         * Specifies if the compactor instance should be a standalone instance or not.
         * </p>
         * 
         * @param dedicatedCompactor
         *        Specifies if the compactor instance should be a standalone instance or not.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dedicatedCompactor(Boolean dedicatedCompactor);

        /**
         * <p>
         * Specifies the soft limit for the number of rows per file that the compactor writes. The compactor may write
         * more rows than this limit.
         * </p>
         * <p>
         * Default: 1000000
         * </p>
         * 
         * @param compactionRowLimit
         *        Specifies the soft limit for the number of rows per file that the compactor writes. The compactor may
         *        write more rows than this limit.</p>
         *        <p>
         *        Default: 1000000
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compactionRowLimit(Integer compactionRowLimit);

        /**
         * <p>
         * Sets the maximum number of files included in any compaction plan.
         * </p>
         * <p>
         * Default: 500
         * </p>
         * 
         * @param compactionMaxNumFilesPerPlan
         *        Sets the maximum number of files included in any compaction plan.</p>
         *        <p>
         *        Default: 500
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compactionMaxNumFilesPerPlan(Integer compactionMaxNumFilesPerPlan);

        /**
         * <p>
         * Specifies the duration of the first level of compaction (gen2). Later levels of compaction are multiples of
         * this duration. This value should be equal to or greater than the gen1 duration.
         * </p>
         * <p>
         * Default: 20m
         * </p>
         * 
         * @param compactionGen2Duration
         *        Specifies the duration of the first level of compaction (gen2). Later levels of compaction are
         *        multiples of this duration. This value should be equal to or greater than the gen1 duration.</p>
         *        <p>
         *        Default: 20m
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compactionGen2Duration(Duration compactionGen2Duration);

        /**
         * <p>
         * Specifies the duration of the first level of compaction (gen2). Later levels of compaction are multiples of
         * this duration. This value should be equal to or greater than the gen1 duration.
         * </p>
         * <p>
         * Default: 20m
         * </p>
         * This is a convenience method that creates an instance of the {@link Duration.Builder} avoiding the need to
         * create one manually via {@link Duration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Duration.Builder#build()} is called immediately and its result is
         * passed to {@link #compactionGen2Duration(Duration)}.
         * 
         * @param compactionGen2Duration
         *        a consumer that will call methods on {@link Duration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #compactionGen2Duration(Duration)
         */
        default Builder compactionGen2Duration(Consumer<Duration.Builder> compactionGen2Duration) {
            return compactionGen2Duration(Duration.builder().applyMutation(compactionGen2Duration).build());
        }

        /**
         * <p>
         * Specifies a comma-separated list of multiples defining the duration of each level of compaction. The number
         * of elements in the list determines the number of compaction levels. The first element specifies the duration
         * of the first level (gen3); subsequent levels are multiples of the previous level.
         * </p>
         * <p>
         * Default: 3,4,6,5
         * </p>
         * 
         * @param compactionMultipliers
         *        Specifies a comma-separated list of multiples defining the duration of each level of compaction. The
         *        number of elements in the list determines the number of compaction levels. The first element specifies
         *        the duration of the first level (gen3); subsequent levels are multiples of the previous level.</p>
         *        <p>
         *        Default: 3,4,6,5
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compactionMultipliers(String compactionMultipliers);

        /**
         * <p>
         * Specifies the amount of time that the compactor waits after finishing a compaction run to delete files marked
         * as needing deletion during that compaction run.
         * </p>
         * <p>
         * Default: 10m
         * </p>
         * 
         * @param compactionCleanupWait
         *        Specifies the amount of time that the compactor waits after finishing a compaction run to delete files
         *        marked as needing deletion during that compaction run.</p>
         *        <p>
         *        Default: 10m
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compactionCleanupWait(Duration compactionCleanupWait);

        /**
         * <p>
         * Specifies the amount of time that the compactor waits after finishing a compaction run to delete files marked
         * as needing deletion during that compaction run.
         * </p>
         * <p>
         * Default: 10m
         * </p>
         * This is a convenience method that creates an instance of the {@link Duration.Builder} avoiding the need to
         * create one manually via {@link Duration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Duration.Builder#build()} is called immediately and its result is
         * passed to {@link #compactionCleanupWait(Duration)}.
         * 
         * @param compactionCleanupWait
         *        a consumer that will call methods on {@link Duration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #compactionCleanupWait(Duration)
         */
        default Builder compactionCleanupWait(Consumer<Duration.Builder> compactionCleanupWait) {
            return compactionCleanupWait(Duration.builder().applyMutation(compactionCleanupWait).build());
        }

        /**
         * <p>
         * Specifies how often the compactor checks for new compaction work to perform.
         * </p>
         * <p>
         * Default: 10s
         * </p>
         * 
         * @param compactionCheckInterval
         *        Specifies how often the compactor checks for new compaction work to perform.</p>
         *        <p>
         *        Default: 10s
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compactionCheckInterval(Duration compactionCheckInterval);

        /**
         * <p>
         * Specifies how often the compactor checks for new compaction work to perform.
         * </p>
         * <p>
         * Default: 10s
         * </p>
         * This is a convenience method that creates an instance of the {@link Duration.Builder} avoiding the need to
         * create one manually via {@link Duration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Duration.Builder#build()} is called immediately and its result is
         * passed to {@link #compactionCheckInterval(Duration)}.
         * 
         * @param compactionCheckInterval
         *        a consumer that will call methods on {@link Duration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #compactionCheckInterval(Duration)
         */
        default Builder compactionCheckInterval(Consumer<Duration.Builder> compactionCheckInterval) {
            return compactionCheckInterval(Duration.builder().applyMutation(compactionCheckInterval).build());
        }

        /**
         * <p>
         * Disables populating the last-N-value cache from historical data. If disabled, the cache is still populated
         * with data from the write-ahead log (WAL).
         * </p>
         * 
         * @param lastValueCacheDisableFromHistory
         *        Disables populating the last-N-value cache from historical data. If disabled, the cache is still
         *        populated with data from the write-ahead log (WAL).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastValueCacheDisableFromHistory(Boolean lastValueCacheDisableFromHistory);

        /**
         * <p>
         * Disables populating the distinct value cache from historical data. If disabled, the cache is still populated
         * with data from the write-ahead log (WAL).
         * </p>
         * 
         * @param distinctValueCacheDisableFromHistory
         *        Disables populating the distinct value cache from historical data. If disabled, the cache is still
         *        populated with data from the write-ahead log (WAL).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder distinctValueCacheDisableFromHistory(Boolean distinctValueCacheDisableFromHistory);

        /**
         * <p>
         * Specifies the interval at which data replication occurs between cluster nodes.
         * </p>
         * <p>
         * Default: 250ms
         * </p>
         * 
         * @param replicationInterval
         *        Specifies the interval at which data replication occurs between cluster nodes.</p>
         *        <p>
         *        Default: 250ms
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationInterval(Duration replicationInterval);

        /**
         * <p>
         * Specifies the interval at which data replication occurs between cluster nodes.
         * </p>
         * <p>
         * Default: 250ms
         * </p>
         * This is a convenience method that creates an instance of the {@link Duration.Builder} avoiding the need to
         * create one manually via {@link Duration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Duration.Builder#build()} is called immediately and its result is
         * passed to {@link #replicationInterval(Duration)}.
         * 
         * @param replicationInterval
         *        a consumer that will call methods on {@link Duration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #replicationInterval(Duration)
         */
        default Builder replicationInterval(Consumer<Duration.Builder> replicationInterval) {
            return replicationInterval(Duration.builder().applyMutation(replicationInterval).build());
        }

        /**
         * <p>
         * Defines how often the catalog synchronizes across cluster nodes.
         * </p>
         * <p>
         * Default: 10s
         * </p>
         * 
         * @param catalogSyncInterval
         *        Defines how often the catalog synchronizes across cluster nodes.</p>
         *        <p>
         *        Default: 10s
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalogSyncInterval(Duration catalogSyncInterval);

        /**
         * <p>
         * Defines how often the catalog synchronizes across cluster nodes.
         * </p>
         * <p>
         * Default: 10s
         * </p>
         * This is a convenience method that creates an instance of the {@link Duration.Builder} avoiding the need to
         * create one manually via {@link Duration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Duration.Builder#build()} is called immediately and its result is
         * passed to {@link #catalogSyncInterval(Duration)}.
         * 
         * @param catalogSyncInterval
         *        a consumer that will call methods on {@link Duration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #catalogSyncInterval(Duration)
         */
        default Builder catalogSyncInterval(Consumer<Duration.Builder> catalogSyncInterval) {
            return catalogSyncInterval(Duration.builder().applyMutation(catalogSyncInterval).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Integer queryFileLimit;

        private Integer queryLogSize;

        private String logFilter;

        private String logFormat;

        private Integer dataFusionNumThreads;

        private String dataFusionRuntimeType;

        private Boolean dataFusionRuntimeDisableLifoSlot;

        private Integer dataFusionRuntimeEventInterval;

        private Integer dataFusionRuntimeGlobalQueueInterval;

        private Integer dataFusionRuntimeMaxBlockingThreads;

        private Integer dataFusionRuntimeMaxIoEventsPerTick;

        private Duration dataFusionRuntimeThreadKeepAlive;

        private Integer dataFusionRuntimeThreadPriority;

        private Integer dataFusionMaxParquetFanout;

        private Boolean dataFusionUseCachedParquetLoader;

        private String dataFusionConfig;

        private Long maxHttpRequestSize;

        private PercentOrAbsoluteLong forceSnapshotMemThreshold;

        private Integer walSnapshotSize;

        private Integer walMaxWriteBufferSize;

        private Integer snapshottedWalFilesToKeep;

        private Duration preemptiveCacheAge;

        private Float parquetMemCachePrunePercentage;

        private Duration parquetMemCachePruneInterval;

        private Boolean disableParquetMemCache;

        private Duration parquetMemCacheQueryPathDuration;

        private Duration lastCacheEvictionInterval;

        private Duration distinctCacheEvictionInterval;

        private Duration gen1Duration;

        private PercentOrAbsoluteLong execMemPoolBytes;

        private PercentOrAbsoluteLong parquetMemCacheSize;

        private Boolean walReplayFailOnError;

        private Integer walReplayConcurrencyLimit;

        private Integer tableIndexCacheMaxEntries;

        private Integer tableIndexCacheConcurrencyLimit;

        private Duration gen1LookbackDuration;

        private Duration retentionCheckInterval;

        private Duration deleteGracePeriod;

        private Duration hardDeleteDefaultDuration;

        private Integer ingestQueryInstances;

        private Integer queryOnlyInstances;

        private Boolean dedicatedCompactor;

        private Integer compactionRowLimit;

        private Integer compactionMaxNumFilesPerPlan;

        private Duration compactionGen2Duration;

        private String compactionMultipliers;

        private Duration compactionCleanupWait;

        private Duration compactionCheckInterval;

        private Boolean lastValueCacheDisableFromHistory;

        private Boolean distinctValueCacheDisableFromHistory;

        private Duration replicationInterval;

        private Duration catalogSyncInterval;

        private BuilderImpl() {
        }

        private BuilderImpl(InfluxDBv3EnterpriseParameters model) {
            queryFileLimit(model.queryFileLimit);
            queryLogSize(model.queryLogSize);
            logFilter(model.logFilter);
            logFormat(model.logFormat);
            dataFusionNumThreads(model.dataFusionNumThreads);
            dataFusionRuntimeType(model.dataFusionRuntimeType);
            dataFusionRuntimeDisableLifoSlot(model.dataFusionRuntimeDisableLifoSlot);
            dataFusionRuntimeEventInterval(model.dataFusionRuntimeEventInterval);
            dataFusionRuntimeGlobalQueueInterval(model.dataFusionRuntimeGlobalQueueInterval);
            dataFusionRuntimeMaxBlockingThreads(model.dataFusionRuntimeMaxBlockingThreads);
            dataFusionRuntimeMaxIoEventsPerTick(model.dataFusionRuntimeMaxIoEventsPerTick);
            dataFusionRuntimeThreadKeepAlive(model.dataFusionRuntimeThreadKeepAlive);
            dataFusionRuntimeThreadPriority(model.dataFusionRuntimeThreadPriority);
            dataFusionMaxParquetFanout(model.dataFusionMaxParquetFanout);
            dataFusionUseCachedParquetLoader(model.dataFusionUseCachedParquetLoader);
            dataFusionConfig(model.dataFusionConfig);
            maxHttpRequestSize(model.maxHttpRequestSize);
            forceSnapshotMemThreshold(model.forceSnapshotMemThreshold);
            walSnapshotSize(model.walSnapshotSize);
            walMaxWriteBufferSize(model.walMaxWriteBufferSize);
            snapshottedWalFilesToKeep(model.snapshottedWalFilesToKeep);
            preemptiveCacheAge(model.preemptiveCacheAge);
            parquetMemCachePrunePercentage(model.parquetMemCachePrunePercentage);
            parquetMemCachePruneInterval(model.parquetMemCachePruneInterval);
            disableParquetMemCache(model.disableParquetMemCache);
            parquetMemCacheQueryPathDuration(model.parquetMemCacheQueryPathDuration);
            lastCacheEvictionInterval(model.lastCacheEvictionInterval);
            distinctCacheEvictionInterval(model.distinctCacheEvictionInterval);
            gen1Duration(model.gen1Duration);
            execMemPoolBytes(model.execMemPoolBytes);
            parquetMemCacheSize(model.parquetMemCacheSize);
            walReplayFailOnError(model.walReplayFailOnError);
            walReplayConcurrencyLimit(model.walReplayConcurrencyLimit);
            tableIndexCacheMaxEntries(model.tableIndexCacheMaxEntries);
            tableIndexCacheConcurrencyLimit(model.tableIndexCacheConcurrencyLimit);
            gen1LookbackDuration(model.gen1LookbackDuration);
            retentionCheckInterval(model.retentionCheckInterval);
            deleteGracePeriod(model.deleteGracePeriod);
            hardDeleteDefaultDuration(model.hardDeleteDefaultDuration);
            ingestQueryInstances(model.ingestQueryInstances);
            queryOnlyInstances(model.queryOnlyInstances);
            dedicatedCompactor(model.dedicatedCompactor);
            compactionRowLimit(model.compactionRowLimit);
            compactionMaxNumFilesPerPlan(model.compactionMaxNumFilesPerPlan);
            compactionGen2Duration(model.compactionGen2Duration);
            compactionMultipliers(model.compactionMultipliers);
            compactionCleanupWait(model.compactionCleanupWait);
            compactionCheckInterval(model.compactionCheckInterval);
            lastValueCacheDisableFromHistory(model.lastValueCacheDisableFromHistory);
            distinctValueCacheDisableFromHistory(model.distinctValueCacheDisableFromHistory);
            replicationInterval(model.replicationInterval);
            catalogSyncInterval(model.catalogSyncInterval);
        }

        public final Integer getQueryFileLimit() {
            return queryFileLimit;
        }

        public final void setQueryFileLimit(Integer queryFileLimit) {
            this.queryFileLimit = queryFileLimit;
        }

        @Override
        public final Builder queryFileLimit(Integer queryFileLimit) {
            this.queryFileLimit = queryFileLimit;
            return this;
        }

        public final Integer getQueryLogSize() {
            return queryLogSize;
        }

        public final void setQueryLogSize(Integer queryLogSize) {
            this.queryLogSize = queryLogSize;
        }

        @Override
        public final Builder queryLogSize(Integer queryLogSize) {
            this.queryLogSize = queryLogSize;
            return this;
        }

        public final String getLogFilter() {
            return logFilter;
        }

        public final void setLogFilter(String logFilter) {
            this.logFilter = logFilter;
        }

        @Override
        public final Builder logFilter(String logFilter) {
            this.logFilter = logFilter;
            return this;
        }

        public final String getLogFormat() {
            return logFormat;
        }

        public final void setLogFormat(String logFormat) {
            this.logFormat = logFormat;
        }

        @Override
        public final Builder logFormat(String logFormat) {
            this.logFormat = logFormat;
            return this;
        }

        @Override
        public final Builder logFormat(LogFormats logFormat) {
            this.logFormat(logFormat == null ? null : logFormat.toString());
            return this;
        }

        public final Integer getDataFusionNumThreads() {
            return dataFusionNumThreads;
        }

        public final void setDataFusionNumThreads(Integer dataFusionNumThreads) {
            this.dataFusionNumThreads = dataFusionNumThreads;
        }

        @Override
        public final Builder dataFusionNumThreads(Integer dataFusionNumThreads) {
            this.dataFusionNumThreads = dataFusionNumThreads;
            return this;
        }

        public final String getDataFusionRuntimeType() {
            return dataFusionRuntimeType;
        }

        public final void setDataFusionRuntimeType(String dataFusionRuntimeType) {
            this.dataFusionRuntimeType = dataFusionRuntimeType;
        }

        @Override
        public final Builder dataFusionRuntimeType(String dataFusionRuntimeType) {
            this.dataFusionRuntimeType = dataFusionRuntimeType;
            return this;
        }

        @Override
        public final Builder dataFusionRuntimeType(DataFusionRuntimeType dataFusionRuntimeType) {
            this.dataFusionRuntimeType(dataFusionRuntimeType == null ? null : dataFusionRuntimeType.toString());
            return this;
        }

        public final Boolean getDataFusionRuntimeDisableLifoSlot() {
            return dataFusionRuntimeDisableLifoSlot;
        }

        public final void setDataFusionRuntimeDisableLifoSlot(Boolean dataFusionRuntimeDisableLifoSlot) {
            this.dataFusionRuntimeDisableLifoSlot = dataFusionRuntimeDisableLifoSlot;
        }

        @Override
        public final Builder dataFusionRuntimeDisableLifoSlot(Boolean dataFusionRuntimeDisableLifoSlot) {
            this.dataFusionRuntimeDisableLifoSlot = dataFusionRuntimeDisableLifoSlot;
            return this;
        }

        public final Integer getDataFusionRuntimeEventInterval() {
            return dataFusionRuntimeEventInterval;
        }

        public final void setDataFusionRuntimeEventInterval(Integer dataFusionRuntimeEventInterval) {
            this.dataFusionRuntimeEventInterval = dataFusionRuntimeEventInterval;
        }

        @Override
        public final Builder dataFusionRuntimeEventInterval(Integer dataFusionRuntimeEventInterval) {
            this.dataFusionRuntimeEventInterval = dataFusionRuntimeEventInterval;
            return this;
        }

        public final Integer getDataFusionRuntimeGlobalQueueInterval() {
            return dataFusionRuntimeGlobalQueueInterval;
        }

        public final void setDataFusionRuntimeGlobalQueueInterval(Integer dataFusionRuntimeGlobalQueueInterval) {
            this.dataFusionRuntimeGlobalQueueInterval = dataFusionRuntimeGlobalQueueInterval;
        }

        @Override
        public final Builder dataFusionRuntimeGlobalQueueInterval(Integer dataFusionRuntimeGlobalQueueInterval) {
            this.dataFusionRuntimeGlobalQueueInterval = dataFusionRuntimeGlobalQueueInterval;
            return this;
        }

        public final Integer getDataFusionRuntimeMaxBlockingThreads() {
            return dataFusionRuntimeMaxBlockingThreads;
        }

        public final void setDataFusionRuntimeMaxBlockingThreads(Integer dataFusionRuntimeMaxBlockingThreads) {
            this.dataFusionRuntimeMaxBlockingThreads = dataFusionRuntimeMaxBlockingThreads;
        }

        @Override
        public final Builder dataFusionRuntimeMaxBlockingThreads(Integer dataFusionRuntimeMaxBlockingThreads) {
            this.dataFusionRuntimeMaxBlockingThreads = dataFusionRuntimeMaxBlockingThreads;
            return this;
        }

        public final Integer getDataFusionRuntimeMaxIoEventsPerTick() {
            return dataFusionRuntimeMaxIoEventsPerTick;
        }

        public final void setDataFusionRuntimeMaxIoEventsPerTick(Integer dataFusionRuntimeMaxIoEventsPerTick) {
            this.dataFusionRuntimeMaxIoEventsPerTick = dataFusionRuntimeMaxIoEventsPerTick;
        }

        @Override
        public final Builder dataFusionRuntimeMaxIoEventsPerTick(Integer dataFusionRuntimeMaxIoEventsPerTick) {
            this.dataFusionRuntimeMaxIoEventsPerTick = dataFusionRuntimeMaxIoEventsPerTick;
            return this;
        }

        public final Duration.Builder getDataFusionRuntimeThreadKeepAlive() {
            return dataFusionRuntimeThreadKeepAlive != null ? dataFusionRuntimeThreadKeepAlive.toBuilder() : null;
        }

        public final void setDataFusionRuntimeThreadKeepAlive(Duration.BuilderImpl dataFusionRuntimeThreadKeepAlive) {
            this.dataFusionRuntimeThreadKeepAlive = dataFusionRuntimeThreadKeepAlive != null ? dataFusionRuntimeThreadKeepAlive
                    .build() : null;
        }

        @Override
        public final Builder dataFusionRuntimeThreadKeepAlive(Duration dataFusionRuntimeThreadKeepAlive) {
            this.dataFusionRuntimeThreadKeepAlive = dataFusionRuntimeThreadKeepAlive;
            return this;
        }

        public final Integer getDataFusionRuntimeThreadPriority() {
            return dataFusionRuntimeThreadPriority;
        }

        public final void setDataFusionRuntimeThreadPriority(Integer dataFusionRuntimeThreadPriority) {
            this.dataFusionRuntimeThreadPriority = dataFusionRuntimeThreadPriority;
        }

        @Override
        public final Builder dataFusionRuntimeThreadPriority(Integer dataFusionRuntimeThreadPriority) {
            this.dataFusionRuntimeThreadPriority = dataFusionRuntimeThreadPriority;
            return this;
        }

        public final Integer getDataFusionMaxParquetFanout() {
            return dataFusionMaxParquetFanout;
        }

        public final void setDataFusionMaxParquetFanout(Integer dataFusionMaxParquetFanout) {
            this.dataFusionMaxParquetFanout = dataFusionMaxParquetFanout;
        }

        @Override
        public final Builder dataFusionMaxParquetFanout(Integer dataFusionMaxParquetFanout) {
            this.dataFusionMaxParquetFanout = dataFusionMaxParquetFanout;
            return this;
        }

        public final Boolean getDataFusionUseCachedParquetLoader() {
            return dataFusionUseCachedParquetLoader;
        }

        public final void setDataFusionUseCachedParquetLoader(Boolean dataFusionUseCachedParquetLoader) {
            this.dataFusionUseCachedParquetLoader = dataFusionUseCachedParquetLoader;
        }

        @Override
        public final Builder dataFusionUseCachedParquetLoader(Boolean dataFusionUseCachedParquetLoader) {
            this.dataFusionUseCachedParquetLoader = dataFusionUseCachedParquetLoader;
            return this;
        }

        public final String getDataFusionConfig() {
            return dataFusionConfig;
        }

        public final void setDataFusionConfig(String dataFusionConfig) {
            this.dataFusionConfig = dataFusionConfig;
        }

        @Override
        public final Builder dataFusionConfig(String dataFusionConfig) {
            this.dataFusionConfig = dataFusionConfig;
            return this;
        }

        public final Long getMaxHttpRequestSize() {
            return maxHttpRequestSize;
        }

        public final void setMaxHttpRequestSize(Long maxHttpRequestSize) {
            this.maxHttpRequestSize = maxHttpRequestSize;
        }

        @Override
        public final Builder maxHttpRequestSize(Long maxHttpRequestSize) {
            this.maxHttpRequestSize = maxHttpRequestSize;
            return this;
        }

        public final PercentOrAbsoluteLong.Builder getForceSnapshotMemThreshold() {
            return forceSnapshotMemThreshold != null ? forceSnapshotMemThreshold.toBuilder() : null;
        }

        public final void setForceSnapshotMemThreshold(PercentOrAbsoluteLong.BuilderImpl forceSnapshotMemThreshold) {
            this.forceSnapshotMemThreshold = forceSnapshotMemThreshold != null ? forceSnapshotMemThreshold.build() : null;
        }

        @Override
        public final Builder forceSnapshotMemThreshold(PercentOrAbsoluteLong forceSnapshotMemThreshold) {
            this.forceSnapshotMemThreshold = forceSnapshotMemThreshold;
            return this;
        }

        public final Integer getWalSnapshotSize() {
            return walSnapshotSize;
        }

        public final void setWalSnapshotSize(Integer walSnapshotSize) {
            this.walSnapshotSize = walSnapshotSize;
        }

        @Override
        public final Builder walSnapshotSize(Integer walSnapshotSize) {
            this.walSnapshotSize = walSnapshotSize;
            return this;
        }

        public final Integer getWalMaxWriteBufferSize() {
            return walMaxWriteBufferSize;
        }

        public final void setWalMaxWriteBufferSize(Integer walMaxWriteBufferSize) {
            this.walMaxWriteBufferSize = walMaxWriteBufferSize;
        }

        @Override
        public final Builder walMaxWriteBufferSize(Integer walMaxWriteBufferSize) {
            this.walMaxWriteBufferSize = walMaxWriteBufferSize;
            return this;
        }

        public final Integer getSnapshottedWalFilesToKeep() {
            return snapshottedWalFilesToKeep;
        }

        public final void setSnapshottedWalFilesToKeep(Integer snapshottedWalFilesToKeep) {
            this.snapshottedWalFilesToKeep = snapshottedWalFilesToKeep;
        }

        @Override
        public final Builder snapshottedWalFilesToKeep(Integer snapshottedWalFilesToKeep) {
            this.snapshottedWalFilesToKeep = snapshottedWalFilesToKeep;
            return this;
        }

        public final Duration.Builder getPreemptiveCacheAge() {
            return preemptiveCacheAge != null ? preemptiveCacheAge.toBuilder() : null;
        }

        public final void setPreemptiveCacheAge(Duration.BuilderImpl preemptiveCacheAge) {
            this.preemptiveCacheAge = preemptiveCacheAge != null ? preemptiveCacheAge.build() : null;
        }

        @Override
        public final Builder preemptiveCacheAge(Duration preemptiveCacheAge) {
            this.preemptiveCacheAge = preemptiveCacheAge;
            return this;
        }

        public final Float getParquetMemCachePrunePercentage() {
            return parquetMemCachePrunePercentage;
        }

        public final void setParquetMemCachePrunePercentage(Float parquetMemCachePrunePercentage) {
            this.parquetMemCachePrunePercentage = parquetMemCachePrunePercentage;
        }

        @Override
        public final Builder parquetMemCachePrunePercentage(Float parquetMemCachePrunePercentage) {
            this.parquetMemCachePrunePercentage = parquetMemCachePrunePercentage;
            return this;
        }

        public final Duration.Builder getParquetMemCachePruneInterval() {
            return parquetMemCachePruneInterval != null ? parquetMemCachePruneInterval.toBuilder() : null;
        }

        public final void setParquetMemCachePruneInterval(Duration.BuilderImpl parquetMemCachePruneInterval) {
            this.parquetMemCachePruneInterval = parquetMemCachePruneInterval != null ? parquetMemCachePruneInterval.build()
                    : null;
        }

        @Override
        public final Builder parquetMemCachePruneInterval(Duration parquetMemCachePruneInterval) {
            this.parquetMemCachePruneInterval = parquetMemCachePruneInterval;
            return this;
        }

        public final Boolean getDisableParquetMemCache() {
            return disableParquetMemCache;
        }

        public final void setDisableParquetMemCache(Boolean disableParquetMemCache) {
            this.disableParquetMemCache = disableParquetMemCache;
        }

        @Override
        public final Builder disableParquetMemCache(Boolean disableParquetMemCache) {
            this.disableParquetMemCache = disableParquetMemCache;
            return this;
        }

        public final Duration.Builder getParquetMemCacheQueryPathDuration() {
            return parquetMemCacheQueryPathDuration != null ? parquetMemCacheQueryPathDuration.toBuilder() : null;
        }

        public final void setParquetMemCacheQueryPathDuration(Duration.BuilderImpl parquetMemCacheQueryPathDuration) {
            this.parquetMemCacheQueryPathDuration = parquetMemCacheQueryPathDuration != null ? parquetMemCacheQueryPathDuration
                    .build() : null;
        }

        @Override
        public final Builder parquetMemCacheQueryPathDuration(Duration parquetMemCacheQueryPathDuration) {
            this.parquetMemCacheQueryPathDuration = parquetMemCacheQueryPathDuration;
            return this;
        }

        public final Duration.Builder getLastCacheEvictionInterval() {
            return lastCacheEvictionInterval != null ? lastCacheEvictionInterval.toBuilder() : null;
        }

        public final void setLastCacheEvictionInterval(Duration.BuilderImpl lastCacheEvictionInterval) {
            this.lastCacheEvictionInterval = lastCacheEvictionInterval != null ? lastCacheEvictionInterval.build() : null;
        }

        @Override
        public final Builder lastCacheEvictionInterval(Duration lastCacheEvictionInterval) {
            this.lastCacheEvictionInterval = lastCacheEvictionInterval;
            return this;
        }

        public final Duration.Builder getDistinctCacheEvictionInterval() {
            return distinctCacheEvictionInterval != null ? distinctCacheEvictionInterval.toBuilder() : null;
        }

        public final void setDistinctCacheEvictionInterval(Duration.BuilderImpl distinctCacheEvictionInterval) {
            this.distinctCacheEvictionInterval = distinctCacheEvictionInterval != null ? distinctCacheEvictionInterval.build()
                    : null;
        }

        @Override
        public final Builder distinctCacheEvictionInterval(Duration distinctCacheEvictionInterval) {
            this.distinctCacheEvictionInterval = distinctCacheEvictionInterval;
            return this;
        }

        public final Duration.Builder getGen1Duration() {
            return gen1Duration != null ? gen1Duration.toBuilder() : null;
        }

        public final void setGen1Duration(Duration.BuilderImpl gen1Duration) {
            this.gen1Duration = gen1Duration != null ? gen1Duration.build() : null;
        }

        @Override
        public final Builder gen1Duration(Duration gen1Duration) {
            this.gen1Duration = gen1Duration;
            return this;
        }

        public final PercentOrAbsoluteLong.Builder getExecMemPoolBytes() {
            return execMemPoolBytes != null ? execMemPoolBytes.toBuilder() : null;
        }

        public final void setExecMemPoolBytes(PercentOrAbsoluteLong.BuilderImpl execMemPoolBytes) {
            this.execMemPoolBytes = execMemPoolBytes != null ? execMemPoolBytes.build() : null;
        }

        @Override
        public final Builder execMemPoolBytes(PercentOrAbsoluteLong execMemPoolBytes) {
            this.execMemPoolBytes = execMemPoolBytes;
            return this;
        }

        public final PercentOrAbsoluteLong.Builder getParquetMemCacheSize() {
            return parquetMemCacheSize != null ? parquetMemCacheSize.toBuilder() : null;
        }

        public final void setParquetMemCacheSize(PercentOrAbsoluteLong.BuilderImpl parquetMemCacheSize) {
            this.parquetMemCacheSize = parquetMemCacheSize != null ? parquetMemCacheSize.build() : null;
        }

        @Override
        public final Builder parquetMemCacheSize(PercentOrAbsoluteLong parquetMemCacheSize) {
            this.parquetMemCacheSize = parquetMemCacheSize;
            return this;
        }

        public final Boolean getWalReplayFailOnError() {
            return walReplayFailOnError;
        }

        public final void setWalReplayFailOnError(Boolean walReplayFailOnError) {
            this.walReplayFailOnError = walReplayFailOnError;
        }

        @Override
        public final Builder walReplayFailOnError(Boolean walReplayFailOnError) {
            this.walReplayFailOnError = walReplayFailOnError;
            return this;
        }

        public final Integer getWalReplayConcurrencyLimit() {
            return walReplayConcurrencyLimit;
        }

        public final void setWalReplayConcurrencyLimit(Integer walReplayConcurrencyLimit) {
            this.walReplayConcurrencyLimit = walReplayConcurrencyLimit;
        }

        @Override
        public final Builder walReplayConcurrencyLimit(Integer walReplayConcurrencyLimit) {
            this.walReplayConcurrencyLimit = walReplayConcurrencyLimit;
            return this;
        }

        public final Integer getTableIndexCacheMaxEntries() {
            return tableIndexCacheMaxEntries;
        }

        public final void setTableIndexCacheMaxEntries(Integer tableIndexCacheMaxEntries) {
            this.tableIndexCacheMaxEntries = tableIndexCacheMaxEntries;
        }

        @Override
        public final Builder tableIndexCacheMaxEntries(Integer tableIndexCacheMaxEntries) {
            this.tableIndexCacheMaxEntries = tableIndexCacheMaxEntries;
            return this;
        }

        public final Integer getTableIndexCacheConcurrencyLimit() {
            return tableIndexCacheConcurrencyLimit;
        }

        public final void setTableIndexCacheConcurrencyLimit(Integer tableIndexCacheConcurrencyLimit) {
            this.tableIndexCacheConcurrencyLimit = tableIndexCacheConcurrencyLimit;
        }

        @Override
        public final Builder tableIndexCacheConcurrencyLimit(Integer tableIndexCacheConcurrencyLimit) {
            this.tableIndexCacheConcurrencyLimit = tableIndexCacheConcurrencyLimit;
            return this;
        }

        public final Duration.Builder getGen1LookbackDuration() {
            return gen1LookbackDuration != null ? gen1LookbackDuration.toBuilder() : null;
        }

        public final void setGen1LookbackDuration(Duration.BuilderImpl gen1LookbackDuration) {
            this.gen1LookbackDuration = gen1LookbackDuration != null ? gen1LookbackDuration.build() : null;
        }

        @Override
        public final Builder gen1LookbackDuration(Duration gen1LookbackDuration) {
            this.gen1LookbackDuration = gen1LookbackDuration;
            return this;
        }

        public final Duration.Builder getRetentionCheckInterval() {
            return retentionCheckInterval != null ? retentionCheckInterval.toBuilder() : null;
        }

        public final void setRetentionCheckInterval(Duration.BuilderImpl retentionCheckInterval) {
            this.retentionCheckInterval = retentionCheckInterval != null ? retentionCheckInterval.build() : null;
        }

        @Override
        public final Builder retentionCheckInterval(Duration retentionCheckInterval) {
            this.retentionCheckInterval = retentionCheckInterval;
            return this;
        }

        public final Duration.Builder getDeleteGracePeriod() {
            return deleteGracePeriod != null ? deleteGracePeriod.toBuilder() : null;
        }

        public final void setDeleteGracePeriod(Duration.BuilderImpl deleteGracePeriod) {
            this.deleteGracePeriod = deleteGracePeriod != null ? deleteGracePeriod.build() : null;
        }

        @Override
        public final Builder deleteGracePeriod(Duration deleteGracePeriod) {
            this.deleteGracePeriod = deleteGracePeriod;
            return this;
        }

        public final Duration.Builder getHardDeleteDefaultDuration() {
            return hardDeleteDefaultDuration != null ? hardDeleteDefaultDuration.toBuilder() : null;
        }

        public final void setHardDeleteDefaultDuration(Duration.BuilderImpl hardDeleteDefaultDuration) {
            this.hardDeleteDefaultDuration = hardDeleteDefaultDuration != null ? hardDeleteDefaultDuration.build() : null;
        }

        @Override
        public final Builder hardDeleteDefaultDuration(Duration hardDeleteDefaultDuration) {
            this.hardDeleteDefaultDuration = hardDeleteDefaultDuration;
            return this;
        }

        public final Integer getIngestQueryInstances() {
            return ingestQueryInstances;
        }

        public final void setIngestQueryInstances(Integer ingestQueryInstances) {
            this.ingestQueryInstances = ingestQueryInstances;
        }

        @Override
        public final Builder ingestQueryInstances(Integer ingestQueryInstances) {
            this.ingestQueryInstances = ingestQueryInstances;
            return this;
        }

        public final Integer getQueryOnlyInstances() {
            return queryOnlyInstances;
        }

        public final void setQueryOnlyInstances(Integer queryOnlyInstances) {
            this.queryOnlyInstances = queryOnlyInstances;
        }

        @Override
        public final Builder queryOnlyInstances(Integer queryOnlyInstances) {
            this.queryOnlyInstances = queryOnlyInstances;
            return this;
        }

        public final Boolean getDedicatedCompactor() {
            return dedicatedCompactor;
        }

        public final void setDedicatedCompactor(Boolean dedicatedCompactor) {
            this.dedicatedCompactor = dedicatedCompactor;
        }

        @Override
        public final Builder dedicatedCompactor(Boolean dedicatedCompactor) {
            this.dedicatedCompactor = dedicatedCompactor;
            return this;
        }

        public final Integer getCompactionRowLimit() {
            return compactionRowLimit;
        }

        public final void setCompactionRowLimit(Integer compactionRowLimit) {
            this.compactionRowLimit = compactionRowLimit;
        }

        @Override
        public final Builder compactionRowLimit(Integer compactionRowLimit) {
            this.compactionRowLimit = compactionRowLimit;
            return this;
        }

        public final Integer getCompactionMaxNumFilesPerPlan() {
            return compactionMaxNumFilesPerPlan;
        }

        public final void setCompactionMaxNumFilesPerPlan(Integer compactionMaxNumFilesPerPlan) {
            this.compactionMaxNumFilesPerPlan = compactionMaxNumFilesPerPlan;
        }

        @Override
        public final Builder compactionMaxNumFilesPerPlan(Integer compactionMaxNumFilesPerPlan) {
            this.compactionMaxNumFilesPerPlan = compactionMaxNumFilesPerPlan;
            return this;
        }

        public final Duration.Builder getCompactionGen2Duration() {
            return compactionGen2Duration != null ? compactionGen2Duration.toBuilder() : null;
        }

        public final void setCompactionGen2Duration(Duration.BuilderImpl compactionGen2Duration) {
            this.compactionGen2Duration = compactionGen2Duration != null ? compactionGen2Duration.build() : null;
        }

        @Override
        public final Builder compactionGen2Duration(Duration compactionGen2Duration) {
            this.compactionGen2Duration = compactionGen2Duration;
            return this;
        }

        public final String getCompactionMultipliers() {
            return compactionMultipliers;
        }

        public final void setCompactionMultipliers(String compactionMultipliers) {
            this.compactionMultipliers = compactionMultipliers;
        }

        @Override
        public final Builder compactionMultipliers(String compactionMultipliers) {
            this.compactionMultipliers = compactionMultipliers;
            return this;
        }

        public final Duration.Builder getCompactionCleanupWait() {
            return compactionCleanupWait != null ? compactionCleanupWait.toBuilder() : null;
        }

        public final void setCompactionCleanupWait(Duration.BuilderImpl compactionCleanupWait) {
            this.compactionCleanupWait = compactionCleanupWait != null ? compactionCleanupWait.build() : null;
        }

        @Override
        public final Builder compactionCleanupWait(Duration compactionCleanupWait) {
            this.compactionCleanupWait = compactionCleanupWait;
            return this;
        }

        public final Duration.Builder getCompactionCheckInterval() {
            return compactionCheckInterval != null ? compactionCheckInterval.toBuilder() : null;
        }

        public final void setCompactionCheckInterval(Duration.BuilderImpl compactionCheckInterval) {
            this.compactionCheckInterval = compactionCheckInterval != null ? compactionCheckInterval.build() : null;
        }

        @Override
        public final Builder compactionCheckInterval(Duration compactionCheckInterval) {
            this.compactionCheckInterval = compactionCheckInterval;
            return this;
        }

        public final Boolean getLastValueCacheDisableFromHistory() {
            return lastValueCacheDisableFromHistory;
        }

        public final void setLastValueCacheDisableFromHistory(Boolean lastValueCacheDisableFromHistory) {
            this.lastValueCacheDisableFromHistory = lastValueCacheDisableFromHistory;
        }

        @Override
        public final Builder lastValueCacheDisableFromHistory(Boolean lastValueCacheDisableFromHistory) {
            this.lastValueCacheDisableFromHistory = lastValueCacheDisableFromHistory;
            return this;
        }

        public final Boolean getDistinctValueCacheDisableFromHistory() {
            return distinctValueCacheDisableFromHistory;
        }

        public final void setDistinctValueCacheDisableFromHistory(Boolean distinctValueCacheDisableFromHistory) {
            this.distinctValueCacheDisableFromHistory = distinctValueCacheDisableFromHistory;
        }

        @Override
        public final Builder distinctValueCacheDisableFromHistory(Boolean distinctValueCacheDisableFromHistory) {
            this.distinctValueCacheDisableFromHistory = distinctValueCacheDisableFromHistory;
            return this;
        }

        public final Duration.Builder getReplicationInterval() {
            return replicationInterval != null ? replicationInterval.toBuilder() : null;
        }

        public final void setReplicationInterval(Duration.BuilderImpl replicationInterval) {
            this.replicationInterval = replicationInterval != null ? replicationInterval.build() : null;
        }

        @Override
        public final Builder replicationInterval(Duration replicationInterval) {
            this.replicationInterval = replicationInterval;
            return this;
        }

        public final Duration.Builder getCatalogSyncInterval() {
            return catalogSyncInterval != null ? catalogSyncInterval.toBuilder() : null;
        }

        public final void setCatalogSyncInterval(Duration.BuilderImpl catalogSyncInterval) {
            this.catalogSyncInterval = catalogSyncInterval != null ? catalogSyncInterval.build() : null;
        }

        @Override
        public final Builder catalogSyncInterval(Duration catalogSyncInterval) {
            this.catalogSyncInterval = catalogSyncInterval;
            return this;
        }

        @Override
        public InfluxDBv3EnterpriseParameters build() {
            return new InfluxDBv3EnterpriseParameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
