/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.timestreaminfluxdb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateDbClusterRequest extends TimestreamInfluxDbRequest implements
        ToCopyableBuilder<UpdateDbClusterRequest.Builder, UpdateDbClusterRequest> {
    private static final SdkField<String> DB_CLUSTER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dbClusterId").getter(getter(UpdateDbClusterRequest::dbClusterId)).setter(setter(Builder::dbClusterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbClusterId").build()).build();

    private static final SdkField<LogDeliveryConfiguration> LOG_DELIVERY_CONFIGURATION_FIELD = SdkField
            .<LogDeliveryConfiguration> builder(MarshallingType.SDK_POJO).memberName("logDeliveryConfiguration")
            .getter(getter(UpdateDbClusterRequest::logDeliveryConfiguration)).setter(setter(Builder::logDeliveryConfiguration))
            .constructor(LogDeliveryConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logDeliveryConfiguration").build())
            .build();

    private static final SdkField<String> DB_PARAMETER_GROUP_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("dbParameterGroupIdentifier")
            .getter(getter(UpdateDbClusterRequest::dbParameterGroupIdentifier))
            .setter(setter(Builder::dbParameterGroupIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbParameterGroupIdentifier").build())
            .build();

    private static final SdkField<Integer> PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("port")
            .getter(getter(UpdateDbClusterRequest::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("port").build()).build();

    private static final SdkField<String> DB_INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dbInstanceType").getter(getter(UpdateDbClusterRequest::dbInstanceTypeAsString))
            .setter(setter(Builder::dbInstanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbInstanceType").build()).build();

    private static final SdkField<String> FAILOVER_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("failoverMode").getter(getter(UpdateDbClusterRequest::failoverModeAsString))
            .setter(setter(Builder::failoverMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failoverMode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_CLUSTER_ID_FIELD,
            LOG_DELIVERY_CONFIGURATION_FIELD, DB_PARAMETER_GROUP_IDENTIFIER_FIELD, PORT_FIELD, DB_INSTANCE_TYPE_FIELD,
            FAILOVER_MODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String dbClusterId;

    private final LogDeliveryConfiguration logDeliveryConfiguration;

    private final String dbParameterGroupIdentifier;

    private final Integer port;

    private final String dbInstanceType;

    private final String failoverMode;

    private UpdateDbClusterRequest(BuilderImpl builder) {
        super(builder);
        this.dbClusterId = builder.dbClusterId;
        this.logDeliveryConfiguration = builder.logDeliveryConfiguration;
        this.dbParameterGroupIdentifier = builder.dbParameterGroupIdentifier;
        this.port = builder.port;
        this.dbInstanceType = builder.dbInstanceType;
        this.failoverMode = builder.failoverMode;
    }

    /**
     * <p>
     * Service-generated unique identifier of the DB cluster to update.
     * </p>
     * 
     * @return Service-generated unique identifier of the DB cluster to update.
     */
    public final String dbClusterId() {
        return dbClusterId;
    }

    /**
     * <p>
     * The log delivery configuration to apply to the DB cluster.
     * </p>
     * 
     * @return The log delivery configuration to apply to the DB cluster.
     */
    public final LogDeliveryConfiguration logDeliveryConfiguration() {
        return logDeliveryConfiguration;
    }

    /**
     * <p>
     * Update the DB cluster to use the specified DB parameter group.
     * </p>
     * 
     * @return Update the DB cluster to use the specified DB parameter group.
     */
    public final String dbParameterGroupIdentifier() {
        return dbParameterGroupIdentifier;
    }

    /**
     * <p>
     * Update the DB cluster to use the specified port.
     * </p>
     * 
     * @return Update the DB cluster to use the specified port.
     */
    public final Integer port() {
        return port;
    }

    /**
     * <p>
     * Update the DB cluster to use the specified DB instance Type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dbInstanceType}
     * will return {@link DbInstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #dbInstanceTypeAsString}.
     * </p>
     * 
     * @return Update the DB cluster to use the specified DB instance Type.
     * @see DbInstanceType
     */
    public final DbInstanceType dbInstanceType() {
        return DbInstanceType.fromValue(dbInstanceType);
    }

    /**
     * <p>
     * Update the DB cluster to use the specified DB instance Type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dbInstanceType}
     * will return {@link DbInstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #dbInstanceTypeAsString}.
     * </p>
     * 
     * @return Update the DB cluster to use the specified DB instance Type.
     * @see DbInstanceType
     */
    public final String dbInstanceTypeAsString() {
        return dbInstanceType;
    }

    /**
     * <p>
     * Update the DB cluster's failover behavior.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #failoverMode} will
     * return {@link FailoverMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #failoverModeAsString}.
     * </p>
     * 
     * @return Update the DB cluster's failover behavior.
     * @see FailoverMode
     */
    public final FailoverMode failoverMode() {
        return FailoverMode.fromValue(failoverMode);
    }

    /**
     * <p>
     * Update the DB cluster's failover behavior.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #failoverMode} will
     * return {@link FailoverMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #failoverModeAsString}.
     * </p>
     * 
     * @return Update the DB cluster's failover behavior.
     * @see FailoverMode
     */
    public final String failoverModeAsString() {
        return failoverMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dbClusterId());
        hashCode = 31 * hashCode + Objects.hashCode(logDeliveryConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(dbParameterGroupIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(dbInstanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(failoverModeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDbClusterRequest)) {
            return false;
        }
        UpdateDbClusterRequest other = (UpdateDbClusterRequest) obj;
        return Objects.equals(dbClusterId(), other.dbClusterId())
                && Objects.equals(logDeliveryConfiguration(), other.logDeliveryConfiguration())
                && Objects.equals(dbParameterGroupIdentifier(), other.dbParameterGroupIdentifier())
                && Objects.equals(port(), other.port())
                && Objects.equals(dbInstanceTypeAsString(), other.dbInstanceTypeAsString())
                && Objects.equals(failoverModeAsString(), other.failoverModeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateDbClusterRequest").add("DbClusterId", dbClusterId())
                .add("LogDeliveryConfiguration", logDeliveryConfiguration())
                .add("DbParameterGroupIdentifier", dbParameterGroupIdentifier()).add("Port", port())
                .add("DbInstanceType", dbInstanceTypeAsString()).add("FailoverMode", failoverModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dbClusterId":
            return Optional.ofNullable(clazz.cast(dbClusterId()));
        case "logDeliveryConfiguration":
            return Optional.ofNullable(clazz.cast(logDeliveryConfiguration()));
        case "dbParameterGroupIdentifier":
            return Optional.ofNullable(clazz.cast(dbParameterGroupIdentifier()));
        case "port":
            return Optional.ofNullable(clazz.cast(port()));
        case "dbInstanceType":
            return Optional.ofNullable(clazz.cast(dbInstanceTypeAsString()));
        case "failoverMode":
            return Optional.ofNullable(clazz.cast(failoverModeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("dbClusterId", DB_CLUSTER_ID_FIELD);
        map.put("logDeliveryConfiguration", LOG_DELIVERY_CONFIGURATION_FIELD);
        map.put("dbParameterGroupIdentifier", DB_PARAMETER_GROUP_IDENTIFIER_FIELD);
        map.put("port", PORT_FIELD);
        map.put("dbInstanceType", DB_INSTANCE_TYPE_FIELD);
        map.put("failoverMode", FAILOVER_MODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateDbClusterRequest, T> g) {
        return obj -> g.apply((UpdateDbClusterRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends TimestreamInfluxDbRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateDbClusterRequest> {
        /**
         * <p>
         * Service-generated unique identifier of the DB cluster to update.
         * </p>
         * 
         * @param dbClusterId
         *        Service-generated unique identifier of the DB cluster to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterId(String dbClusterId);

        /**
         * <p>
         * The log delivery configuration to apply to the DB cluster.
         * </p>
         * 
         * @param logDeliveryConfiguration
         *        The log delivery configuration to apply to the DB cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logDeliveryConfiguration(LogDeliveryConfiguration logDeliveryConfiguration);

        /**
         * <p>
         * The log delivery configuration to apply to the DB cluster.
         * </p>
         * This is a convenience method that creates an instance of the {@link LogDeliveryConfiguration.Builder}
         * avoiding the need to create one manually via {@link LogDeliveryConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LogDeliveryConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #logDeliveryConfiguration(LogDeliveryConfiguration)}.
         * 
         * @param logDeliveryConfiguration
         *        a consumer that will call methods on {@link LogDeliveryConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logDeliveryConfiguration(LogDeliveryConfiguration)
         */
        default Builder logDeliveryConfiguration(Consumer<LogDeliveryConfiguration.Builder> logDeliveryConfiguration) {
            return logDeliveryConfiguration(LogDeliveryConfiguration.builder().applyMutation(logDeliveryConfiguration).build());
        }

        /**
         * <p>
         * Update the DB cluster to use the specified DB parameter group.
         * </p>
         * 
         * @param dbParameterGroupIdentifier
         *        Update the DB cluster to use the specified DB parameter group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbParameterGroupIdentifier(String dbParameterGroupIdentifier);

        /**
         * <p>
         * Update the DB cluster to use the specified port.
         * </p>
         * 
         * @param port
         *        Update the DB cluster to use the specified port.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);

        /**
         * <p>
         * Update the DB cluster to use the specified DB instance Type.
         * </p>
         * 
         * @param dbInstanceType
         *        Update the DB cluster to use the specified DB instance Type.
         * @see DbInstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DbInstanceType
         */
        Builder dbInstanceType(String dbInstanceType);

        /**
         * <p>
         * Update the DB cluster to use the specified DB instance Type.
         * </p>
         * 
         * @param dbInstanceType
         *        Update the DB cluster to use the specified DB instance Type.
         * @see DbInstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DbInstanceType
         */
        Builder dbInstanceType(DbInstanceType dbInstanceType);

        /**
         * <p>
         * Update the DB cluster's failover behavior.
         * </p>
         * 
         * @param failoverMode
         *        Update the DB cluster's failover behavior.
         * @see FailoverMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FailoverMode
         */
        Builder failoverMode(String failoverMode);

        /**
         * <p>
         * Update the DB cluster's failover behavior.
         * </p>
         * 
         * @param failoverMode
         *        Update the DB cluster's failover behavior.
         * @see FailoverMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FailoverMode
         */
        Builder failoverMode(FailoverMode failoverMode);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends TimestreamInfluxDbRequest.BuilderImpl implements Builder {
        private String dbClusterId;

        private LogDeliveryConfiguration logDeliveryConfiguration;

        private String dbParameterGroupIdentifier;

        private Integer port;

        private String dbInstanceType;

        private String failoverMode;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDbClusterRequest model) {
            super(model);
            dbClusterId(model.dbClusterId);
            logDeliveryConfiguration(model.logDeliveryConfiguration);
            dbParameterGroupIdentifier(model.dbParameterGroupIdentifier);
            port(model.port);
            dbInstanceType(model.dbInstanceType);
            failoverMode(model.failoverMode);
        }

        public final String getDbClusterId() {
            return dbClusterId;
        }

        public final void setDbClusterId(String dbClusterId) {
            this.dbClusterId = dbClusterId;
        }

        @Override
        public final Builder dbClusterId(String dbClusterId) {
            this.dbClusterId = dbClusterId;
            return this;
        }

        public final LogDeliveryConfiguration.Builder getLogDeliveryConfiguration() {
            return logDeliveryConfiguration != null ? logDeliveryConfiguration.toBuilder() : null;
        }

        public final void setLogDeliveryConfiguration(LogDeliveryConfiguration.BuilderImpl logDeliveryConfiguration) {
            this.logDeliveryConfiguration = logDeliveryConfiguration != null ? logDeliveryConfiguration.build() : null;
        }

        @Override
        public final Builder logDeliveryConfiguration(LogDeliveryConfiguration logDeliveryConfiguration) {
            this.logDeliveryConfiguration = logDeliveryConfiguration;
            return this;
        }

        public final String getDbParameterGroupIdentifier() {
            return dbParameterGroupIdentifier;
        }

        public final void setDbParameterGroupIdentifier(String dbParameterGroupIdentifier) {
            this.dbParameterGroupIdentifier = dbParameterGroupIdentifier;
        }

        @Override
        public final Builder dbParameterGroupIdentifier(String dbParameterGroupIdentifier) {
            this.dbParameterGroupIdentifier = dbParameterGroupIdentifier;
            return this;
        }

        public final Integer getPort() {
            return port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getDbInstanceType() {
            return dbInstanceType;
        }

        public final void setDbInstanceType(String dbInstanceType) {
            this.dbInstanceType = dbInstanceType;
        }

        @Override
        public final Builder dbInstanceType(String dbInstanceType) {
            this.dbInstanceType = dbInstanceType;
            return this;
        }

        @Override
        public final Builder dbInstanceType(DbInstanceType dbInstanceType) {
            this.dbInstanceType(dbInstanceType == null ? null : dbInstanceType.toString());
            return this;
        }

        public final String getFailoverMode() {
            return failoverMode;
        }

        public final void setFailoverMode(String failoverMode) {
            this.failoverMode = failoverMode;
        }

        @Override
        public final Builder failoverMode(String failoverMode) {
            this.failoverMode = failoverMode;
            return this;
        }

        @Override
        public final Builder failoverMode(FailoverMode failoverMode) {
            this.failoverMode(failoverMode == null ? null : failoverMode.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDbClusterRequest build() {
            return new UpdateDbClusterRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
