/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.timestreamquery.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class QueryRequest extends TimestreamQueryRequest implements ToCopyableBuilder<QueryRequest.Builder, QueryRequest> {
    private static final SdkField<String> QUERY_STRING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QueryString").getter(getter(QueryRequest::queryString)).setter(setter(Builder::queryString))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryString").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(QueryRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(QueryRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_ROWS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxRows").getter(getter(QueryRequest::maxRows)).setter(setter(Builder::maxRows))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRows").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERY_STRING_FIELD,
            CLIENT_TOKEN_FIELD, NEXT_TOKEN_FIELD, MAX_ROWS_FIELD));

    private final String queryString;

    private final String clientToken;

    private final String nextToken;

    private final Integer maxRows;

    private QueryRequest(BuilderImpl builder) {
        super(builder);
        this.queryString = builder.queryString;
        this.clientToken = builder.clientToken;
        this.nextToken = builder.nextToken;
        this.maxRows = builder.maxRows;
    }

    /**
     * <p>
     * The query to be executed by Timestream.
     * </p>
     * 
     * @return The query to be executed by Timestream.
     */
    public final String queryString() {
        return queryString;
    }

    /**
     * <p>
     * Unique, case-sensitive string of up to 64 ASCII characters that you specify when you make a Query request.
     * Providing a <code>ClientToken</code> makes the call to <code>Query</code> idempotent, meaning that multiple
     * identical calls have the same effect as one single call.
     * </p>
     * <p>
     * Your query request will fail in the following cases:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you submit a request with the same client token outside the 5-minute idepotency window.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you submit a request with the same client token but a change in other parameters within the 5-minute
     * idempotency window.
     * </p>
     * </li>
     * </ul>
     * <p>
     * After 4 hours, any request with the same client token is treated as a new request.
     * </p>
     * 
     * @return Unique, case-sensitive string of up to 64 ASCII characters that you specify when you make a Query
     *         request. Providing a <code>ClientToken</code> makes the call to <code>Query</code> idempotent, meaning
     *         that multiple identical calls have the same effect as one single call. </p>
     *         <p>
     *         Your query request will fail in the following cases:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If you submit a request with the same client token outside the 5-minute idepotency window.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If you submit a request with the same client token but a change in other parameters within the 5-minute
     *         idempotency window.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         After 4 hours, any request with the same client token is treated as a new request.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * A pagination token passed to get a set of results.
     * </p>
     * 
     * @return A pagination token passed to get a set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The total number of rows to return in the output. If the total number of rows available is more than the value
     * specified, a NextToken is provided in the command's output. To resume pagination, provide the NextToken value in
     * the starting-token argument of a subsequent command.
     * </p>
     * 
     * @return The total number of rows to return in the output. If the total number of rows available is more than the
     *         value specified, a NextToken is provided in the command's output. To resume pagination, provide the
     *         NextToken value in the starting-token argument of a subsequent command.
     */
    public final Integer maxRows() {
        return maxRows;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(queryString());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxRows());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryRequest)) {
            return false;
        }
        QueryRequest other = (QueryRequest) obj;
        return Objects.equals(queryString(), other.queryString()) && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxRows(), other.maxRows());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("QueryRequest")
                .add("QueryString", queryString() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ClientToken", clientToken() == null ? null : "*** Sensitive Data Redacted ***")
                .add("NextToken", nextToken()).add("MaxRows", maxRows()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "QueryString":
            return Optional.ofNullable(clazz.cast(queryString()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxRows":
            return Optional.ofNullable(clazz.cast(maxRows()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<QueryRequest, T> g) {
        return obj -> g.apply((QueryRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TimestreamQueryRequest.Builder, SdkPojo, CopyableBuilder<Builder, QueryRequest> {
        /**
         * <p>
         * The query to be executed by Timestream.
         * </p>
         * 
         * @param queryString
         *        The query to be executed by Timestream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryString(String queryString);

        /**
         * <p>
         * Unique, case-sensitive string of up to 64 ASCII characters that you specify when you make a Query request.
         * Providing a <code>ClientToken</code> makes the call to <code>Query</code> idempotent, meaning that multiple
         * identical calls have the same effect as one single call.
         * </p>
         * <p>
         * Your query request will fail in the following cases:
         * </p>
         * <ul>
         * <li>
         * <p>
         * If you submit a request with the same client token outside the 5-minute idepotency window.
         * </p>
         * </li>
         * <li>
         * <p>
         * If you submit a request with the same client token but a change in other parameters within the 5-minute
         * idempotency window.
         * </p>
         * </li>
         * </ul>
         * <p>
         * After 4 hours, any request with the same client token is treated as a new request.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive string of up to 64 ASCII characters that you specify when you make a Query
         *        request. Providing a <code>ClientToken</code> makes the call to <code>Query</code> idempotent, meaning
         *        that multiple identical calls have the same effect as one single call. </p>
         *        <p>
         *        Your query request will fail in the following cases:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If you submit a request with the same client token outside the 5-minute idepotency window.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If you submit a request with the same client token but a change in other parameters within the
         *        5-minute idempotency window.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        After 4 hours, any request with the same client token is treated as a new request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * A pagination token passed to get a set of results.
         * </p>
         * 
         * @param nextToken
         *        A pagination token passed to get a set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The total number of rows to return in the output. If the total number of rows available is more than the
         * value specified, a NextToken is provided in the command's output. To resume pagination, provide the NextToken
         * value in the starting-token argument of a subsequent command.
         * </p>
         * 
         * @param maxRows
         *        The total number of rows to return in the output. If the total number of rows available is more than
         *        the value specified, a NextToken is provided in the command's output. To resume pagination, provide
         *        the NextToken value in the starting-token argument of a subsequent command.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxRows(Integer maxRows);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends TimestreamQueryRequest.BuilderImpl implements Builder {
        private String queryString;

        private String clientToken;

        private String nextToken;

        private Integer maxRows;

        private BuilderImpl() {
        }

        private BuilderImpl(QueryRequest model) {
            super(model);
            queryString(model.queryString);
            clientToken(model.clientToken);
            nextToken(model.nextToken);
            maxRows(model.maxRows);
        }

        public final String getQueryString() {
            return queryString;
        }

        @Override
        public final Builder queryString(String queryString) {
            this.queryString = queryString;
            return this;
        }

        public final void setQueryString(String queryString) {
            this.queryString = queryString;
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxRows() {
            return maxRows;
        }

        @Override
        public final Builder maxRows(Integer maxRows) {
            this.maxRows = maxRows;
            return this;
        }

        public final void setMaxRows(Integer maxRows) {
            this.maxRows = maxRows;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public QueryRequest build() {
            return new QueryRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
