/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.timestreamquery.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Notification configuration for a scheduled query. A notification is sent by Timestream when a scheduled query is
 * created, its state is updated or when it is deleted.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NotificationConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<NotificationConfiguration.Builder, NotificationConfiguration> {
    private static final SdkField<SnsConfiguration> SNS_CONFIGURATION_FIELD = SdkField
            .<SnsConfiguration> builder(MarshallingType.SDK_POJO).memberName("SnsConfiguration")
            .getter(getter(NotificationConfiguration::snsConfiguration)).setter(setter(Builder::snsConfiguration))
            .constructor(SnsConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnsConfiguration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SNS_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final SnsConfiguration snsConfiguration;

    private NotificationConfiguration(BuilderImpl builder) {
        this.snsConfiguration = builder.snsConfiguration;
    }

    /**
     * <p>
     * Details on SNS configuration.
     * </p>
     * 
     * @return Details on SNS configuration.
     */
    public final SnsConfiguration snsConfiguration() {
        return snsConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(snsConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NotificationConfiguration)) {
            return false;
        }
        NotificationConfiguration other = (NotificationConfiguration) obj;
        return Objects.equals(snsConfiguration(), other.snsConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NotificationConfiguration").add("SnsConfiguration", snsConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SnsConfiguration":
            return Optional.ofNullable(clazz.cast(snsConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NotificationConfiguration, T> g) {
        return obj -> g.apply((NotificationConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NotificationConfiguration> {
        /**
         * <p>
         * Details on SNS configuration.
         * </p>
         * 
         * @param snsConfiguration
         *        Details on SNS configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snsConfiguration(SnsConfiguration snsConfiguration);

        /**
         * <p>
         * Details on SNS configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link SnsConfiguration.Builder} avoiding the
         * need to create one manually via {@link SnsConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link SnsConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #snsConfiguration(SnsConfiguration)}.
         * 
         * @param snsConfiguration
         *        a consumer that will call methods on {@link SnsConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #snsConfiguration(SnsConfiguration)
         */
        default Builder snsConfiguration(Consumer<SnsConfiguration.Builder> snsConfiguration) {
            return snsConfiguration(SnsConfiguration.builder().applyMutation(snsConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SnsConfiguration snsConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(NotificationConfiguration model) {
            snsConfiguration(model.snsConfiguration);
        }

        public final SnsConfiguration.Builder getSnsConfiguration() {
            return snsConfiguration != null ? snsConfiguration.toBuilder() : null;
        }

        public final void setSnsConfiguration(SnsConfiguration.BuilderImpl snsConfiguration) {
            this.snsConfiguration = snsConfiguration != null ? snsConfiguration.build() : null;
        }

        @Override
        public final Builder snsConfiguration(SnsConfiguration snsConfiguration) {
            this.snsConfiguration = snsConfiguration;
            return this;
        }

        @Override
        public NotificationConfiguration build() {
            return new NotificationConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
