/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.timestreamquery.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the data type of a column in a query result set. The data type can be scalar or complex. The supported
 * scalar data types are integers, Boolean, string, double, timestamp, date, time, and intervals. The supported complex
 * data types are arrays, rows, and timeseries.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Type implements SdkPojo, Serializable, ToCopyableBuilder<Type.Builder, Type> {
    private static final SdkField<String> SCALAR_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ScalarType").getter(getter(Type::scalarTypeAsString)).setter(setter(Builder::scalarType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalarType").build()).build();

    private static final SdkField<ColumnInfo> ARRAY_COLUMN_INFO_FIELD = SdkField.<ColumnInfo> builder(MarshallingType.SDK_POJO)
            .memberName("ArrayColumnInfo").getter(getter(Type::arrayColumnInfo)).setter(setter(Builder::arrayColumnInfo))
            .constructor(ColumnInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArrayColumnInfo").build()).build();

    private static final SdkField<ColumnInfo> TIME_SERIES_MEASURE_VALUE_COLUMN_INFO_FIELD = SdkField
            .<ColumnInfo> builder(MarshallingType.SDK_POJO)
            .memberName("TimeSeriesMeasureValueColumnInfo")
            .getter(getter(Type::timeSeriesMeasureValueColumnInfo))
            .setter(setter(Builder::timeSeriesMeasureValueColumnInfo))
            .constructor(ColumnInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeSeriesMeasureValueColumnInfo")
                    .build()).build();

    private static final SdkField<List<ColumnInfo>> ROW_COLUMN_INFO_FIELD = SdkField
            .<List<ColumnInfo>> builder(MarshallingType.LIST)
            .memberName("RowColumnInfo")
            .getter(getter(Type::rowColumnInfo))
            .setter(setter(Builder::rowColumnInfo))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RowColumnInfo").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ColumnInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(ColumnInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCALAR_TYPE_FIELD,
            ARRAY_COLUMN_INFO_FIELD, TIME_SERIES_MEASURE_VALUE_COLUMN_INFO_FIELD, ROW_COLUMN_INFO_FIELD));

    private static final long serialVersionUID = 1L;

    private final String scalarType;

    private final ColumnInfo arrayColumnInfo;

    private final ColumnInfo timeSeriesMeasureValueColumnInfo;

    private final List<ColumnInfo> rowColumnInfo;

    private Type(BuilderImpl builder) {
        this.scalarType = builder.scalarType;
        this.arrayColumnInfo = builder.arrayColumnInfo;
        this.timeSeriesMeasureValueColumnInfo = builder.timeSeriesMeasureValueColumnInfo;
        this.rowColumnInfo = builder.rowColumnInfo;
    }

    /**
     * <p>
     * Indicates if the column is of type string, integer, Boolean, double, timestamp, date, time.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scalarType} will
     * return {@link ScalarType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scalarTypeAsString}.
     * </p>
     * 
     * @return Indicates if the column is of type string, integer, Boolean, double, timestamp, date, time.
     * @see ScalarType
     */
    public final ScalarType scalarType() {
        return ScalarType.fromValue(scalarType);
    }

    /**
     * <p>
     * Indicates if the column is of type string, integer, Boolean, double, timestamp, date, time.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scalarType} will
     * return {@link ScalarType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scalarTypeAsString}.
     * </p>
     * 
     * @return Indicates if the column is of type string, integer, Boolean, double, timestamp, date, time.
     * @see ScalarType
     */
    public final String scalarTypeAsString() {
        return scalarType;
    }

    /**
     * <p>
     * Indicates if the column is an array.
     * </p>
     * 
     * @return Indicates if the column is an array.
     */
    public final ColumnInfo arrayColumnInfo() {
        return arrayColumnInfo;
    }

    /**
     * <p>
     * Indicates if the column is a timeseries data type.
     * </p>
     * 
     * @return Indicates if the column is a timeseries data type.
     */
    public final ColumnInfo timeSeriesMeasureValueColumnInfo() {
        return timeSeriesMeasureValueColumnInfo;
    }

    /**
     * For responses, this returns true if the service returned a value for the RowColumnInfo property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRowColumnInfo() {
        return rowColumnInfo != null && !(rowColumnInfo instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Indicates if the column is a row.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRowColumnInfo} method.
     * </p>
     * 
     * @return Indicates if the column is a row.
     */
    public final List<ColumnInfo> rowColumnInfo() {
        return rowColumnInfo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(scalarTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(arrayColumnInfo());
        hashCode = 31 * hashCode + Objects.hashCode(timeSeriesMeasureValueColumnInfo());
        hashCode = 31 * hashCode + Objects.hashCode(hasRowColumnInfo() ? rowColumnInfo() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Type)) {
            return false;
        }
        Type other = (Type) obj;
        return Objects.equals(scalarTypeAsString(), other.scalarTypeAsString())
                && Objects.equals(arrayColumnInfo(), other.arrayColumnInfo())
                && Objects.equals(timeSeriesMeasureValueColumnInfo(), other.timeSeriesMeasureValueColumnInfo())
                && hasRowColumnInfo() == other.hasRowColumnInfo() && Objects.equals(rowColumnInfo(), other.rowColumnInfo());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Type").add("ScalarType", scalarTypeAsString()).add("ArrayColumnInfo", arrayColumnInfo())
                .add("TimeSeriesMeasureValueColumnInfo", timeSeriesMeasureValueColumnInfo())
                .add("RowColumnInfo", hasRowColumnInfo() ? rowColumnInfo() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ScalarType":
            return Optional.ofNullable(clazz.cast(scalarTypeAsString()));
        case "ArrayColumnInfo":
            return Optional.ofNullable(clazz.cast(arrayColumnInfo()));
        case "TimeSeriesMeasureValueColumnInfo":
            return Optional.ofNullable(clazz.cast(timeSeriesMeasureValueColumnInfo()));
        case "RowColumnInfo":
            return Optional.ofNullable(clazz.cast(rowColumnInfo()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Type, T> g) {
        return obj -> g.apply((Type) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Type> {
        /**
         * <p>
         * Indicates if the column is of type string, integer, Boolean, double, timestamp, date, time.
         * </p>
         * 
         * @param scalarType
         *        Indicates if the column is of type string, integer, Boolean, double, timestamp, date, time.
         * @see ScalarType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScalarType
         */
        Builder scalarType(String scalarType);

        /**
         * <p>
         * Indicates if the column is of type string, integer, Boolean, double, timestamp, date, time.
         * </p>
         * 
         * @param scalarType
         *        Indicates if the column is of type string, integer, Boolean, double, timestamp, date, time.
         * @see ScalarType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScalarType
         */
        Builder scalarType(ScalarType scalarType);

        /**
         * <p>
         * Indicates if the column is an array.
         * </p>
         * 
         * @param arrayColumnInfo
         *        Indicates if the column is an array.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arrayColumnInfo(ColumnInfo arrayColumnInfo);

        /**
         * <p>
         * Indicates if the column is an array.
         * </p>
         * This is a convenience method that creates an instance of the {@link ColumnInfo.Builder} avoiding the need to
         * create one manually via {@link ColumnInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link ColumnInfo.Builder#build()} is called immediately and its result
         * is passed to {@link #arrayColumnInfo(ColumnInfo)}.
         * 
         * @param arrayColumnInfo
         *        a consumer that will call methods on {@link ColumnInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #arrayColumnInfo(ColumnInfo)
         */
        default Builder arrayColumnInfo(Consumer<ColumnInfo.Builder> arrayColumnInfo) {
            return arrayColumnInfo(ColumnInfo.builder().applyMutation(arrayColumnInfo).build());
        }

        /**
         * <p>
         * Indicates if the column is a timeseries data type.
         * </p>
         * 
         * @param timeSeriesMeasureValueColumnInfo
         *        Indicates if the column is a timeseries data type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeSeriesMeasureValueColumnInfo(ColumnInfo timeSeriesMeasureValueColumnInfo);

        /**
         * <p>
         * Indicates if the column is a timeseries data type.
         * </p>
         * This is a convenience method that creates an instance of the {@link ColumnInfo.Builder} avoiding the need to
         * create one manually via {@link ColumnInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link ColumnInfo.Builder#build()} is called immediately and its result
         * is passed to {@link #timeSeriesMeasureValueColumnInfo(ColumnInfo)}.
         * 
         * @param timeSeriesMeasureValueColumnInfo
         *        a consumer that will call methods on {@link ColumnInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timeSeriesMeasureValueColumnInfo(ColumnInfo)
         */
        default Builder timeSeriesMeasureValueColumnInfo(Consumer<ColumnInfo.Builder> timeSeriesMeasureValueColumnInfo) {
            return timeSeriesMeasureValueColumnInfo(ColumnInfo.builder().applyMutation(timeSeriesMeasureValueColumnInfo).build());
        }

        /**
         * <p>
         * Indicates if the column is a row.
         * </p>
         * 
         * @param rowColumnInfo
         *        Indicates if the column is a row.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rowColumnInfo(Collection<ColumnInfo> rowColumnInfo);

        /**
         * <p>
         * Indicates if the column is a row.
         * </p>
         * 
         * @param rowColumnInfo
         *        Indicates if the column is a row.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rowColumnInfo(ColumnInfo... rowColumnInfo);

        /**
         * <p>
         * Indicates if the column is a row.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<ColumnInfo>.Builder} avoiding the
         * need to create one manually via {@link List<ColumnInfo>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ColumnInfo>.Builder#build()} is called immediately and its
         * result is passed to {@link #rowColumnInfo(List<ColumnInfo>)}.
         * 
         * @param rowColumnInfo
         *        a consumer that will call methods on {@link List<ColumnInfo>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rowColumnInfo(List<ColumnInfo>)
         */
        Builder rowColumnInfo(Consumer<ColumnInfo.Builder>... rowColumnInfo);
    }

    static final class BuilderImpl implements Builder {
        private String scalarType;

        private ColumnInfo arrayColumnInfo;

        private ColumnInfo timeSeriesMeasureValueColumnInfo;

        private List<ColumnInfo> rowColumnInfo = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Type model) {
            scalarType(model.scalarType);
            arrayColumnInfo(model.arrayColumnInfo);
            timeSeriesMeasureValueColumnInfo(model.timeSeriesMeasureValueColumnInfo);
            rowColumnInfo(model.rowColumnInfo);
        }

        public final String getScalarType() {
            return scalarType;
        }

        public final void setScalarType(String scalarType) {
            this.scalarType = scalarType;
        }

        @Override
        public final Builder scalarType(String scalarType) {
            this.scalarType = scalarType;
            return this;
        }

        @Override
        public final Builder scalarType(ScalarType scalarType) {
            this.scalarType(scalarType == null ? null : scalarType.toString());
            return this;
        }

        public final ColumnInfo.Builder getArrayColumnInfo() {
            return arrayColumnInfo != null ? arrayColumnInfo.toBuilder() : null;
        }

        public final void setArrayColumnInfo(ColumnInfo.BuilderImpl arrayColumnInfo) {
            this.arrayColumnInfo = arrayColumnInfo != null ? arrayColumnInfo.build() : null;
        }

        @Override
        public final Builder arrayColumnInfo(ColumnInfo arrayColumnInfo) {
            this.arrayColumnInfo = arrayColumnInfo;
            return this;
        }

        public final ColumnInfo.Builder getTimeSeriesMeasureValueColumnInfo() {
            return timeSeriesMeasureValueColumnInfo != null ? timeSeriesMeasureValueColumnInfo.toBuilder() : null;
        }

        public final void setTimeSeriesMeasureValueColumnInfo(ColumnInfo.BuilderImpl timeSeriesMeasureValueColumnInfo) {
            this.timeSeriesMeasureValueColumnInfo = timeSeriesMeasureValueColumnInfo != null ? timeSeriesMeasureValueColumnInfo
                    .build() : null;
        }

        @Override
        public final Builder timeSeriesMeasureValueColumnInfo(ColumnInfo timeSeriesMeasureValueColumnInfo) {
            this.timeSeriesMeasureValueColumnInfo = timeSeriesMeasureValueColumnInfo;
            return this;
        }

        public final List<ColumnInfo.Builder> getRowColumnInfo() {
            List<ColumnInfo.Builder> result = ColumnInfoListCopier.copyToBuilder(this.rowColumnInfo);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRowColumnInfo(Collection<ColumnInfo.BuilderImpl> rowColumnInfo) {
            this.rowColumnInfo = ColumnInfoListCopier.copyFromBuilder(rowColumnInfo);
        }

        @Override
        public final Builder rowColumnInfo(Collection<ColumnInfo> rowColumnInfo) {
            this.rowColumnInfo = ColumnInfoListCopier.copy(rowColumnInfo);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rowColumnInfo(ColumnInfo... rowColumnInfo) {
            rowColumnInfo(Arrays.asList(rowColumnInfo));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rowColumnInfo(Consumer<ColumnInfo.Builder>... rowColumnInfo) {
            rowColumnInfo(Stream.of(rowColumnInfo).map(c -> ColumnInfo.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Type build() {
            return new Type(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
