/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.timestreamquery.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the metadata for query results such as the column names, data types, and other attributes.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ColumnInfo implements SdkPojo, Serializable, ToCopyableBuilder<ColumnInfo.Builder, ColumnInfo> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(ColumnInfo::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<Type> TYPE_FIELD = SdkField.<Type> builder(MarshallingType.SDK_POJO).memberName("Type")
            .getter(getter(ColumnInfo::type)).setter(setter(Builder::type)).constructor(Type::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final Type type;

    private ColumnInfo(BuilderImpl builder) {
        this.name = builder.name;
        this.type = builder.type;
    }

    /**
     * <p>
     * The name of the result set column. The name of the result set is available for columns of all data types except
     * for arrays.
     * </p>
     * 
     * @return The name of the result set column. The name of the result set is available for columns of all data types
     *         except for arrays.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The data type of the result set column. The data type can be a scalar or complex. Scalar data types are integers,
     * strings, doubles, Booleans, and others. Complex data types are types such as arrays, rows, and others.
     * </p>
     * 
     * @return The data type of the result set column. The data type can be a scalar or complex. Scalar data types are
     *         integers, strings, doubles, Booleans, and others. Complex data types are types such as arrays, rows, and
     *         others.
     */
    public final Type type() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ColumnInfo)) {
            return false;
        }
        ColumnInfo other = (ColumnInfo) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(type(), other.type());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ColumnInfo").add("Name", name()).add("Type", type()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ColumnInfo, T> g) {
        return obj -> g.apply((ColumnInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ColumnInfo> {
        /**
         * <p>
         * The name of the result set column. The name of the result set is available for columns of all data types
         * except for arrays.
         * </p>
         * 
         * @param name
         *        The name of the result set column. The name of the result set is available for columns of all data
         *        types except for arrays.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The data type of the result set column. The data type can be a scalar or complex. Scalar data types are
         * integers, strings, doubles, Booleans, and others. Complex data types are types such as arrays, rows, and
         * others.
         * </p>
         * 
         * @param type
         *        The data type of the result set column. The data type can be a scalar or complex. Scalar data types
         *        are integers, strings, doubles, Booleans, and others. Complex data types are types such as arrays,
         *        rows, and others.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(Type type);

        /**
         * <p>
         * The data type of the result set column. The data type can be a scalar or complex. Scalar data types are
         * integers, strings, doubles, Booleans, and others. Complex data types are types such as arrays, rows, and
         * others.
         * </p>
         * This is a convenience that creates an instance of the {@link Type.Builder} avoiding the need to create one
         * manually via {@link Type#builder()}.
         *
         * When the {@link Consumer} completes, {@link Type.Builder#build()} is called immediately and its result is
         * passed to {@link #type(Type)}.
         * 
         * @param type
         *        a consumer that will call methods on {@link Type.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #type(Type)
         */
        default Builder type(Consumer<Type.Builder> type) {
            return type(Type.builder().applyMutation(type).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private Type type;

        private BuilderImpl() {
        }

        private BuilderImpl(ColumnInfo model) {
            name(model.name);
            type(model.type);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Type.Builder getType() {
            return type != null ? type.toBuilder() : null;
        }

        public final void setType(Type.BuilderImpl type) {
            this.type = type != null ? type.build() : null;
        }

        @Override
        @Transient
        public final Builder type(Type type) {
            this.type = type;
            return this;
        }

        @Override
        public ColumnInfo build() {
            return new ColumnInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
