/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.timestreamquery.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents an available endpoint against which to make API calls against, as well as the TTL for that endpoint.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Endpoint implements SdkPojo, Serializable, ToCopyableBuilder<Endpoint.Builder, Endpoint> {
    private static final SdkField<String> ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Address")
            .getter(getter(Endpoint::address)).setter(setter(Builder::address))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Address").build()).build();

    private static final SdkField<Long> CACHE_PERIOD_IN_MINUTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("CachePeriodInMinutes").getter(getter(Endpoint::cachePeriodInMinutes))
            .setter(setter(Builder::cachePeriodInMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CachePeriodInMinutes").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDRESS_FIELD,
            CACHE_PERIOD_IN_MINUTES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String address;

    private final Long cachePeriodInMinutes;

    private Endpoint(BuilderImpl builder) {
        this.address = builder.address;
        this.cachePeriodInMinutes = builder.cachePeriodInMinutes;
    }

    /**
     * <p>
     * An endpoint address.
     * </p>
     * 
     * @return An endpoint address.
     */
    public final String address() {
        return address;
    }

    /**
     * <p>
     * The TTL for the endpoint, in minutes.
     * </p>
     * 
     * @return The TTL for the endpoint, in minutes.
     */
    public final Long cachePeriodInMinutes() {
        return cachePeriodInMinutes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(address());
        hashCode = 31 * hashCode + Objects.hashCode(cachePeriodInMinutes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Endpoint)) {
            return false;
        }
        Endpoint other = (Endpoint) obj;
        return Objects.equals(address(), other.address()) && Objects.equals(cachePeriodInMinutes(), other.cachePeriodInMinutes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Endpoint").add("Address", address()).add("CachePeriodInMinutes", cachePeriodInMinutes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Address":
            return Optional.ofNullable(clazz.cast(address()));
        case "CachePeriodInMinutes":
            return Optional.ofNullable(clazz.cast(cachePeriodInMinutes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Endpoint, T> g) {
        return obj -> g.apply((Endpoint) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Endpoint> {
        /**
         * <p>
         * An endpoint address.
         * </p>
         * 
         * @param address
         *        An endpoint address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder address(String address);

        /**
         * <p>
         * The TTL for the endpoint, in minutes.
         * </p>
         * 
         * @param cachePeriodInMinutes
         *        The TTL for the endpoint, in minutes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cachePeriodInMinutes(Long cachePeriodInMinutes);
    }

    static final class BuilderImpl implements Builder {
        private String address;

        private Long cachePeriodInMinutes;

        private BuilderImpl() {
        }

        private BuilderImpl(Endpoint model) {
            address(model.address);
            cachePeriodInMinutes(model.cachePeriodInMinutes);
        }

        public final String getAddress() {
            return address;
        }

        public final void setAddress(String address) {
            this.address = address;
        }

        @Override
        @Transient
        public final Builder address(String address) {
            this.address = address;
            return this;
        }

        public final Long getCachePeriodInMinutes() {
            return cachePeriodInMinutes;
        }

        public final void setCachePeriodInMinutes(Long cachePeriodInMinutes) {
            this.cachePeriodInMinutes = cachePeriodInMinutes;
        }

        @Override
        @Transient
        public final Builder cachePeriodInMinutes(Long cachePeriodInMinutes) {
            this.cachePeriodInMinutes = cachePeriodInMinutes;
            return this;
        }

        @Override
        public Endpoint build() {
            return new Endpoint(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
