/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.timestreamquery.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details of the column that is returned by the query.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SelectColumn implements SdkPojo, Serializable, ToCopyableBuilder<SelectColumn.Builder, SelectColumn> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(SelectColumn::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<Type> TYPE_FIELD = SdkField.<Type> builder(MarshallingType.SDK_POJO).memberName("Type")
            .getter(getter(SelectColumn::type)).setter(setter(Builder::type)).constructor(Type::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatabaseName").getter(getter(SelectColumn::databaseName)).setter(setter(Builder::databaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()).build();

    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TableName").getter(getter(SelectColumn::tableName)).setter(setter(Builder::tableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()).build();

    private static final SdkField<Boolean> ALIASED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Aliased").getter(getter(SelectColumn::aliased)).setter(setter(Builder::aliased))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Aliased").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, TYPE_FIELD,
            DATABASE_NAME_FIELD, TABLE_NAME_FIELD, ALIASED_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final Type type;

    private final String databaseName;

    private final String tableName;

    private final Boolean aliased;

    private SelectColumn(BuilderImpl builder) {
        this.name = builder.name;
        this.type = builder.type;
        this.databaseName = builder.databaseName;
        this.tableName = builder.tableName;
        this.aliased = builder.aliased;
    }

    /**
     * <p>
     * Name of the column.
     * </p>
     * 
     * @return Name of the column.
     */
    public final String name() {
        return name;
    }

    /**
     * Returns the value of the Type property for this object.
     * 
     * @return The value of the Type property for this object.
     */
    public final Type type() {
        return type;
    }

    /**
     * <p>
     * Database that has this column.
     * </p>
     * 
     * @return Database that has this column.
     */
    public final String databaseName() {
        return databaseName;
    }

    /**
     * <p>
     * Table within the database that has this column.
     * </p>
     * 
     * @return Table within the database that has this column.
     */
    public final String tableName() {
        return tableName;
    }

    /**
     * <p>
     * True, if the column name was aliased by the query. False otherwise.
     * </p>
     * 
     * @return True, if the column name was aliased by the query. False otherwise.
     */
    public final Boolean aliased() {
        return aliased;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(tableName());
        hashCode = 31 * hashCode + Objects.hashCode(aliased());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SelectColumn)) {
            return false;
        }
        SelectColumn other = (SelectColumn) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(type(), other.type())
                && Objects.equals(databaseName(), other.databaseName()) && Objects.equals(tableName(), other.tableName())
                && Objects.equals(aliased(), other.aliased());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SelectColumn").add("Name", name()).add("Type", type()).add("DatabaseName", databaseName())
                .add("TableName", tableName()).add("Aliased", aliased()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        case "DatabaseName":
            return Optional.ofNullable(clazz.cast(databaseName()));
        case "TableName":
            return Optional.ofNullable(clazz.cast(tableName()));
        case "Aliased":
            return Optional.ofNullable(clazz.cast(aliased()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SelectColumn, T> g) {
        return obj -> g.apply((SelectColumn) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SelectColumn> {
        /**
         * <p>
         * Name of the column.
         * </p>
         * 
         * @param name
         *        Name of the column.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * Sets the value of the Type property for this object.
         *
         * @param type
         *        The new value for the Type property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(Type type);

        /**
         * Sets the value of the Type property for this object.
         *
         * This is a convenience that creates an instance of the {@link Type.Builder} avoiding the need to create one
         * manually via {@link Type#builder()}.
         *
         * When the {@link Consumer} completes, {@link Type.Builder#build()} is called immediately and its result is
         * passed to {@link #type(Type)}.
         * 
         * @param type
         *        a consumer that will call methods on {@link Type.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #type(Type)
         */
        default Builder type(Consumer<Type.Builder> type) {
            return type(Type.builder().applyMutation(type).build());
        }

        /**
         * <p>
         * Database that has this column.
         * </p>
         * 
         * @param databaseName
         *        Database that has this column.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseName(String databaseName);

        /**
         * <p>
         * Table within the database that has this column.
         * </p>
         * 
         * @param tableName
         *        Table within the database that has this column.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableName(String tableName);

        /**
         * <p>
         * True, if the column name was aliased by the query. False otherwise.
         * </p>
         * 
         * @param aliased
         *        True, if the column name was aliased by the query. False otherwise.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aliased(Boolean aliased);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private Type type;

        private String databaseName;

        private String tableName;

        private Boolean aliased;

        private BuilderImpl() {
        }

        private BuilderImpl(SelectColumn model) {
            name(model.name);
            type(model.type);
            databaseName(model.databaseName);
            tableName(model.tableName);
            aliased(model.aliased);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Type.Builder getType() {
            return type != null ? type.toBuilder() : null;
        }

        public final void setType(Type.BuilderImpl type) {
            this.type = type != null ? type.build() : null;
        }

        @Override
        @Transient
        public final Builder type(Type type) {
            this.type = type;
            return this;
        }

        public final String getDatabaseName() {
            return databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        @Transient
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getTableName() {
            return tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        @Transient
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final Boolean getAliased() {
            return aliased;
        }

        public final void setAliased(Boolean aliased) {
            this.aliased = aliased;
        }

        @Override
        @Transient
        public final Builder aliased(Boolean aliased) {
            this.aliased = aliased;
            return this;
        }

        @Override
        public SelectColumn build() {
            return new SelectColumn(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
