/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.timestreamquery.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration to write data into Timestream database and table. This configuration allows the user to map the query
 * result select columns into the destination table columns.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TimestreamConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<TimestreamConfiguration.Builder, TimestreamConfiguration> {
    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatabaseName").getter(getter(TimestreamConfiguration::databaseName))
            .setter(setter(Builder::databaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()).build();

    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TableName").getter(getter(TimestreamConfiguration::tableName)).setter(setter(Builder::tableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()).build();

    private static final SdkField<String> TIME_COLUMN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TimeColumn").getter(getter(TimestreamConfiguration::timeColumn)).setter(setter(Builder::timeColumn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeColumn").build()).build();

    private static final SdkField<List<DimensionMapping>> DIMENSION_MAPPINGS_FIELD = SdkField
            .<List<DimensionMapping>> builder(MarshallingType.LIST)
            .memberName("DimensionMappings")
            .getter(getter(TimestreamConfiguration::dimensionMappings))
            .setter(setter(Builder::dimensionMappings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DimensionMappings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DimensionMapping> builder(MarshallingType.SDK_POJO)
                                            .constructor(DimensionMapping::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<MultiMeasureMappings> MULTI_MEASURE_MAPPINGS_FIELD = SdkField
            .<MultiMeasureMappings> builder(MarshallingType.SDK_POJO).memberName("MultiMeasureMappings")
            .getter(getter(TimestreamConfiguration::multiMeasureMappings)).setter(setter(Builder::multiMeasureMappings))
            .constructor(MultiMeasureMappings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiMeasureMappings").build())
            .build();

    private static final SdkField<List<MixedMeasureMapping>> MIXED_MEASURE_MAPPINGS_FIELD = SdkField
            .<List<MixedMeasureMapping>> builder(MarshallingType.LIST)
            .memberName("MixedMeasureMappings")
            .getter(getter(TimestreamConfiguration::mixedMeasureMappings))
            .setter(setter(Builder::mixedMeasureMappings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MixedMeasureMappings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MixedMeasureMapping> builder(MarshallingType.SDK_POJO)
                                            .constructor(MixedMeasureMapping::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> MEASURE_NAME_COLUMN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MeasureNameColumn").getter(getter(TimestreamConfiguration::measureNameColumn))
            .setter(setter(Builder::measureNameColumn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MeasureNameColumn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATABASE_NAME_FIELD,
            TABLE_NAME_FIELD, TIME_COLUMN_FIELD, DIMENSION_MAPPINGS_FIELD, MULTI_MEASURE_MAPPINGS_FIELD,
            MIXED_MEASURE_MAPPINGS_FIELD, MEASURE_NAME_COLUMN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String databaseName;

    private final String tableName;

    private final String timeColumn;

    private final List<DimensionMapping> dimensionMappings;

    private final MultiMeasureMappings multiMeasureMappings;

    private final List<MixedMeasureMapping> mixedMeasureMappings;

    private final String measureNameColumn;

    private TimestreamConfiguration(BuilderImpl builder) {
        this.databaseName = builder.databaseName;
        this.tableName = builder.tableName;
        this.timeColumn = builder.timeColumn;
        this.dimensionMappings = builder.dimensionMappings;
        this.multiMeasureMappings = builder.multiMeasureMappings;
        this.mixedMeasureMappings = builder.mixedMeasureMappings;
        this.measureNameColumn = builder.measureNameColumn;
    }

    /**
     * <p>
     * Name of Timestream database to which the query result will be written.
     * </p>
     * 
     * @return Name of Timestream database to which the query result will be written.
     */
    public final String databaseName() {
        return databaseName;
    }

    /**
     * <p>
     * Name of Timestream table that the query result will be written to. The table should be within the same database
     * that is provided in Timestream configuration.
     * </p>
     * 
     * @return Name of Timestream table that the query result will be written to. The table should be within the same
     *         database that is provided in Timestream configuration.
     */
    public final String tableName() {
        return tableName;
    }

    /**
     * <p>
     * Column from query result that should be used as the time column in destination table. Column type for this should
     * be TIMESTAMP.
     * </p>
     * 
     * @return Column from query result that should be used as the time column in destination table. Column type for
     *         this should be TIMESTAMP.
     */
    public final String timeColumn() {
        return timeColumn;
    }

    /**
     * For responses, this returns true if the service returned a value for the DimensionMappings property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDimensionMappings() {
        return dimensionMappings != null && !(dimensionMappings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * This is to allow mapping column(s) from the query result to the dimension in the destination table.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDimensionMappings} method.
     * </p>
     * 
     * @return This is to allow mapping column(s) from the query result to the dimension in the destination table.
     */
    public final List<DimensionMapping> dimensionMappings() {
        return dimensionMappings;
    }

    /**
     * <p>
     * Multi-measure mappings.
     * </p>
     * 
     * @return Multi-measure mappings.
     */
    public final MultiMeasureMappings multiMeasureMappings() {
        return multiMeasureMappings;
    }

    /**
     * For responses, this returns true if the service returned a value for the MixedMeasureMappings property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMixedMeasureMappings() {
        return mixedMeasureMappings != null && !(mixedMeasureMappings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies how to map measures to multi-measure records.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMixedMeasureMappings} method.
     * </p>
     * 
     * @return Specifies how to map measures to multi-measure records.
     */
    public final List<MixedMeasureMapping> mixedMeasureMappings() {
        return mixedMeasureMappings;
    }

    /**
     * <p>
     * Name of the measure column.
     * </p>
     * 
     * @return Name of the measure column.
     */
    public final String measureNameColumn() {
        return measureNameColumn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(tableName());
        hashCode = 31 * hashCode + Objects.hashCode(timeColumn());
        hashCode = 31 * hashCode + Objects.hashCode(hasDimensionMappings() ? dimensionMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(multiMeasureMappings());
        hashCode = 31 * hashCode + Objects.hashCode(hasMixedMeasureMappings() ? mixedMeasureMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(measureNameColumn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimestreamConfiguration)) {
            return false;
        }
        TimestreamConfiguration other = (TimestreamConfiguration) obj;
        return Objects.equals(databaseName(), other.databaseName()) && Objects.equals(tableName(), other.tableName())
                && Objects.equals(timeColumn(), other.timeColumn()) && hasDimensionMappings() == other.hasDimensionMappings()
                && Objects.equals(dimensionMappings(), other.dimensionMappings())
                && Objects.equals(multiMeasureMappings(), other.multiMeasureMappings())
                && hasMixedMeasureMappings() == other.hasMixedMeasureMappings()
                && Objects.equals(mixedMeasureMappings(), other.mixedMeasureMappings())
                && Objects.equals(measureNameColumn(), other.measureNameColumn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TimestreamConfiguration").add("DatabaseName", databaseName()).add("TableName", tableName())
                .add("TimeColumn", timeColumn()).add("DimensionMappings", hasDimensionMappings() ? dimensionMappings() : null)
                .add("MultiMeasureMappings", multiMeasureMappings())
                .add("MixedMeasureMappings", hasMixedMeasureMappings() ? mixedMeasureMappings() : null)
                .add("MeasureNameColumn", measureNameColumn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DatabaseName":
            return Optional.ofNullable(clazz.cast(databaseName()));
        case "TableName":
            return Optional.ofNullable(clazz.cast(tableName()));
        case "TimeColumn":
            return Optional.ofNullable(clazz.cast(timeColumn()));
        case "DimensionMappings":
            return Optional.ofNullable(clazz.cast(dimensionMappings()));
        case "MultiMeasureMappings":
            return Optional.ofNullable(clazz.cast(multiMeasureMappings()));
        case "MixedMeasureMappings":
            return Optional.ofNullable(clazz.cast(mixedMeasureMappings()));
        case "MeasureNameColumn":
            return Optional.ofNullable(clazz.cast(measureNameColumn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TimestreamConfiguration, T> g) {
        return obj -> g.apply((TimestreamConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TimestreamConfiguration> {
        /**
         * <p>
         * Name of Timestream database to which the query result will be written.
         * </p>
         * 
         * @param databaseName
         *        Name of Timestream database to which the query result will be written.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseName(String databaseName);

        /**
         * <p>
         * Name of Timestream table that the query result will be written to. The table should be within the same
         * database that is provided in Timestream configuration.
         * </p>
         * 
         * @param tableName
         *        Name of Timestream table that the query result will be written to. The table should be within the same
         *        database that is provided in Timestream configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableName(String tableName);

        /**
         * <p>
         * Column from query result that should be used as the time column in destination table. Column type for this
         * should be TIMESTAMP.
         * </p>
         * 
         * @param timeColumn
         *        Column from query result that should be used as the time column in destination table. Column type for
         *        this should be TIMESTAMP.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeColumn(String timeColumn);

        /**
         * <p>
         * This is to allow mapping column(s) from the query result to the dimension in the destination table.
         * </p>
         * 
         * @param dimensionMappings
         *        This is to allow mapping column(s) from the query result to the dimension in the destination table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensionMappings(Collection<DimensionMapping> dimensionMappings);

        /**
         * <p>
         * This is to allow mapping column(s) from the query result to the dimension in the destination table.
         * </p>
         * 
         * @param dimensionMappings
         *        This is to allow mapping column(s) from the query result to the dimension in the destination table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensionMappings(DimensionMapping... dimensionMappings);

        /**
         * <p>
         * This is to allow mapping column(s) from the query result to the dimension in the destination table.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DimensionMapping>.Builder} avoiding the
         * need to create one manually via {@link List<DimensionMapping>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DimensionMapping>.Builder#build()} is called immediately and
         * its result is passed to {@link #dimensionMappings(List<DimensionMapping>)}.
         * 
         * @param dimensionMappings
         *        a consumer that will call methods on {@link List<DimensionMapping>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dimensionMappings(List<DimensionMapping>)
         */
        Builder dimensionMappings(Consumer<DimensionMapping.Builder>... dimensionMappings);

        /**
         * <p>
         * Multi-measure mappings.
         * </p>
         * 
         * @param multiMeasureMappings
         *        Multi-measure mappings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiMeasureMappings(MultiMeasureMappings multiMeasureMappings);

        /**
         * <p>
         * Multi-measure mappings.
         * </p>
         * This is a convenience that creates an instance of the {@link MultiMeasureMappings.Builder} avoiding the need
         * to create one manually via {@link MultiMeasureMappings#builder()}.
         *
         * When the {@link Consumer} completes, {@link MultiMeasureMappings.Builder#build()} is called immediately and
         * its result is passed to {@link #multiMeasureMappings(MultiMeasureMappings)}.
         * 
         * @param multiMeasureMappings
         *        a consumer that will call methods on {@link MultiMeasureMappings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #multiMeasureMappings(MultiMeasureMappings)
         */
        default Builder multiMeasureMappings(Consumer<MultiMeasureMappings.Builder> multiMeasureMappings) {
            return multiMeasureMappings(MultiMeasureMappings.builder().applyMutation(multiMeasureMappings).build());
        }

        /**
         * <p>
         * Specifies how to map measures to multi-measure records.
         * </p>
         * 
         * @param mixedMeasureMappings
         *        Specifies how to map measures to multi-measure records.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mixedMeasureMappings(Collection<MixedMeasureMapping> mixedMeasureMappings);

        /**
         * <p>
         * Specifies how to map measures to multi-measure records.
         * </p>
         * 
         * @param mixedMeasureMappings
         *        Specifies how to map measures to multi-measure records.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mixedMeasureMappings(MixedMeasureMapping... mixedMeasureMappings);

        /**
         * <p>
         * Specifies how to map measures to multi-measure records.
         * </p>
         * This is a convenience that creates an instance of the {@link List<MixedMeasureMapping>.Builder} avoiding the
         * need to create one manually via {@link List<MixedMeasureMapping>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<MixedMeasureMapping>.Builder#build()} is called immediately
         * and its result is passed to {@link #mixedMeasureMappings(List<MixedMeasureMapping>)}.
         * 
         * @param mixedMeasureMappings
         *        a consumer that will call methods on {@link List<MixedMeasureMapping>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mixedMeasureMappings(List<MixedMeasureMapping>)
         */
        Builder mixedMeasureMappings(Consumer<MixedMeasureMapping.Builder>... mixedMeasureMappings);

        /**
         * <p>
         * Name of the measure column.
         * </p>
         * 
         * @param measureNameColumn
         *        Name of the measure column.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder measureNameColumn(String measureNameColumn);
    }

    static final class BuilderImpl implements Builder {
        private String databaseName;

        private String tableName;

        private String timeColumn;

        private List<DimensionMapping> dimensionMappings = DefaultSdkAutoConstructList.getInstance();

        private MultiMeasureMappings multiMeasureMappings;

        private List<MixedMeasureMapping> mixedMeasureMappings = DefaultSdkAutoConstructList.getInstance();

        private String measureNameColumn;

        private BuilderImpl() {
        }

        private BuilderImpl(TimestreamConfiguration model) {
            databaseName(model.databaseName);
            tableName(model.tableName);
            timeColumn(model.timeColumn);
            dimensionMappings(model.dimensionMappings);
            multiMeasureMappings(model.multiMeasureMappings);
            mixedMeasureMappings(model.mixedMeasureMappings);
            measureNameColumn(model.measureNameColumn);
        }

        public final String getDatabaseName() {
            return databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        @Transient
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getTableName() {
            return tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        @Transient
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final String getTimeColumn() {
            return timeColumn;
        }

        public final void setTimeColumn(String timeColumn) {
            this.timeColumn = timeColumn;
        }

        @Override
        @Transient
        public final Builder timeColumn(String timeColumn) {
            this.timeColumn = timeColumn;
            return this;
        }

        public final List<DimensionMapping.Builder> getDimensionMappings() {
            List<DimensionMapping.Builder> result = DimensionMappingListCopier.copyToBuilder(this.dimensionMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDimensionMappings(Collection<DimensionMapping.BuilderImpl> dimensionMappings) {
            this.dimensionMappings = DimensionMappingListCopier.copyFromBuilder(dimensionMappings);
        }

        @Override
        @Transient
        public final Builder dimensionMappings(Collection<DimensionMapping> dimensionMappings) {
            this.dimensionMappings = DimensionMappingListCopier.copy(dimensionMappings);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder dimensionMappings(DimensionMapping... dimensionMappings) {
            dimensionMappings(Arrays.asList(dimensionMappings));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder dimensionMappings(Consumer<DimensionMapping.Builder>... dimensionMappings) {
            dimensionMappings(Stream.of(dimensionMappings).map(c -> DimensionMapping.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final MultiMeasureMappings.Builder getMultiMeasureMappings() {
            return multiMeasureMappings != null ? multiMeasureMappings.toBuilder() : null;
        }

        public final void setMultiMeasureMappings(MultiMeasureMappings.BuilderImpl multiMeasureMappings) {
            this.multiMeasureMappings = multiMeasureMappings != null ? multiMeasureMappings.build() : null;
        }

        @Override
        @Transient
        public final Builder multiMeasureMappings(MultiMeasureMappings multiMeasureMappings) {
            this.multiMeasureMappings = multiMeasureMappings;
            return this;
        }

        public final List<MixedMeasureMapping.Builder> getMixedMeasureMappings() {
            List<MixedMeasureMapping.Builder> result = MixedMeasureMappingListCopier.copyToBuilder(this.mixedMeasureMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMixedMeasureMappings(Collection<MixedMeasureMapping.BuilderImpl> mixedMeasureMappings) {
            this.mixedMeasureMappings = MixedMeasureMappingListCopier.copyFromBuilder(mixedMeasureMappings);
        }

        @Override
        @Transient
        public final Builder mixedMeasureMappings(Collection<MixedMeasureMapping> mixedMeasureMappings) {
            this.mixedMeasureMappings = MixedMeasureMappingListCopier.copy(mixedMeasureMappings);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder mixedMeasureMappings(MixedMeasureMapping... mixedMeasureMappings) {
            mixedMeasureMappings(Arrays.asList(mixedMeasureMappings));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder mixedMeasureMappings(Consumer<MixedMeasureMapping.Builder>... mixedMeasureMappings) {
            mixedMeasureMappings(Stream.of(mixedMeasureMappings).map(c -> MixedMeasureMapping.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getMeasureNameColumn() {
            return measureNameColumn;
        }

        public final void setMeasureNameColumn(String measureNameColumn) {
            this.measureNameColumn = measureNameColumn;
        }

        @Override
        @Transient
        public final Builder measureNameColumn(String measureNameColumn) {
            this.measureNameColumn = measureNameColumn;
            return this;
        }

        @Override
        public TimestreamConfiguration build() {
            return new TimestreamConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
