/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.timestreamquery.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides various insights and metrics related to the query that you executed.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class QueryInsightsResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<QueryInsightsResponse.Builder, QueryInsightsResponse> {
    private static final SdkField<QuerySpatialCoverage> QUERY_SPATIAL_COVERAGE_FIELD = SdkField
            .<QuerySpatialCoverage> builder(MarshallingType.SDK_POJO).memberName("QuerySpatialCoverage")
            .getter(getter(QueryInsightsResponse::querySpatialCoverage)).setter(setter(Builder::querySpatialCoverage))
            .constructor(QuerySpatialCoverage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuerySpatialCoverage").build())
            .build();

    private static final SdkField<QueryTemporalRange> QUERY_TEMPORAL_RANGE_FIELD = SdkField
            .<QueryTemporalRange> builder(MarshallingType.SDK_POJO).memberName("QueryTemporalRange")
            .getter(getter(QueryInsightsResponse::queryTemporalRange)).setter(setter(Builder::queryTemporalRange))
            .constructor(QueryTemporalRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryTemporalRange").build())
            .build();

    private static final SdkField<Long> QUERY_TABLE_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("QueryTableCount").getter(getter(QueryInsightsResponse::queryTableCount))
            .setter(setter(Builder::queryTableCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryTableCount").build()).build();

    private static final SdkField<Long> OUTPUT_ROWS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("OutputRows").getter(getter(QueryInsightsResponse::outputRows)).setter(setter(Builder::outputRows))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputRows").build()).build();

    private static final SdkField<Long> OUTPUT_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("OutputBytes").getter(getter(QueryInsightsResponse::outputBytes)).setter(setter(Builder::outputBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputBytes").build()).build();

    private static final SdkField<Long> UNLOAD_PARTITION_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("UnloadPartitionCount").getter(getter(QueryInsightsResponse::unloadPartitionCount))
            .setter(setter(Builder::unloadPartitionCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnloadPartitionCount").build())
            .build();

    private static final SdkField<Long> UNLOAD_WRITTEN_ROWS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("UnloadWrittenRows").getter(getter(QueryInsightsResponse::unloadWrittenRows))
            .setter(setter(Builder::unloadWrittenRows))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnloadWrittenRows").build()).build();

    private static final SdkField<Long> UNLOAD_WRITTEN_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("UnloadWrittenBytes").getter(getter(QueryInsightsResponse::unloadWrittenBytes))
            .setter(setter(Builder::unloadWrittenBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnloadWrittenBytes").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERY_SPATIAL_COVERAGE_FIELD,
            QUERY_TEMPORAL_RANGE_FIELD, QUERY_TABLE_COUNT_FIELD, OUTPUT_ROWS_FIELD, OUTPUT_BYTES_FIELD,
            UNLOAD_PARTITION_COUNT_FIELD, UNLOAD_WRITTEN_ROWS_FIELD, UNLOAD_WRITTEN_BYTES_FIELD));

    private static final long serialVersionUID = 1L;

    private final QuerySpatialCoverage querySpatialCoverage;

    private final QueryTemporalRange queryTemporalRange;

    private final Long queryTableCount;

    private final Long outputRows;

    private final Long outputBytes;

    private final Long unloadPartitionCount;

    private final Long unloadWrittenRows;

    private final Long unloadWrittenBytes;

    private QueryInsightsResponse(BuilderImpl builder) {
        this.querySpatialCoverage = builder.querySpatialCoverage;
        this.queryTemporalRange = builder.queryTemporalRange;
        this.queryTableCount = builder.queryTableCount;
        this.outputRows = builder.outputRows;
        this.outputBytes = builder.outputBytes;
        this.unloadPartitionCount = builder.unloadPartitionCount;
        this.unloadWrittenRows = builder.unloadWrittenRows;
        this.unloadWrittenBytes = builder.unloadWrittenBytes;
    }

    /**
     * <p>
     * Provides insights into the spatial coverage of the query, including the table with sub-optimal (max) spatial
     * pruning. This information can help you identify areas for improvement in your partitioning strategy to enhance
     * spatial pruning.
     * </p>
     * 
     * @return Provides insights into the spatial coverage of the query, including the table with sub-optimal (max)
     *         spatial pruning. This information can help you identify areas for improvement in your partitioning
     *         strategy to enhance spatial pruning.
     */
    public final QuerySpatialCoverage querySpatialCoverage() {
        return querySpatialCoverage;
    }

    /**
     * <p>
     * Provides insights into the temporal range of the query, including the table with the largest (max) time range.
     * Following are some of the potential options for optimizing time-based pruning:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Add missing time-predicates.
     * </p>
     * </li>
     * <li>
     * <p>
     * Remove functions around the time predicates.
     * </p>
     * </li>
     * <li>
     * <p>
     * Add time predicates to all the sub-queries.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Provides insights into the temporal range of the query, including the table with the largest (max) time
     *         range. Following are some of the potential options for optimizing time-based pruning:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Add missing time-predicates.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Remove functions around the time predicates.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Add time predicates to all the sub-queries.
     *         </p>
     *         </li>
     */
    public final QueryTemporalRange queryTemporalRange() {
        return queryTemporalRange;
    }

    /**
     * <p>
     * Indicates the number of tables in the query.
     * </p>
     * 
     * @return Indicates the number of tables in the query.
     */
    public final Long queryTableCount() {
        return queryTableCount;
    }

    /**
     * <p>
     * Indicates the total number of rows returned as part of the query result set. You can use this data to validate if
     * the number of rows in the result set have changed as part of the query tuning exercise.
     * </p>
     * 
     * @return Indicates the total number of rows returned as part of the query result set. You can use this data to
     *         validate if the number of rows in the result set have changed as part of the query tuning exercise.
     */
    public final Long outputRows() {
        return outputRows;
    }

    /**
     * <p>
     * Indicates the size of query result set in bytes. You can use this data to validate if the result set has changed
     * as part of the query tuning exercise.
     * </p>
     * 
     * @return Indicates the size of query result set in bytes. You can use this data to validate if the result set has
     *         changed as part of the query tuning exercise.
     */
    public final Long outputBytes() {
        return outputBytes;
    }

    /**
     * <p>
     * Indicates the partitions created by the <code>Unload</code> operation.
     * </p>
     * 
     * @return Indicates the partitions created by the <code>Unload</code> operation.
     */
    public final Long unloadPartitionCount() {
        return unloadPartitionCount;
    }

    /**
     * <p>
     * Indicates the rows written by the <code>Unload</code> query.
     * </p>
     * 
     * @return Indicates the rows written by the <code>Unload</code> query.
     */
    public final Long unloadWrittenRows() {
        return unloadWrittenRows;
    }

    /**
     * <p>
     * Indicates the size, in bytes, written by the <code>Unload</code> operation.
     * </p>
     * 
     * @return Indicates the size, in bytes, written by the <code>Unload</code> operation.
     */
    public final Long unloadWrittenBytes() {
        return unloadWrittenBytes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(querySpatialCoverage());
        hashCode = 31 * hashCode + Objects.hashCode(queryTemporalRange());
        hashCode = 31 * hashCode + Objects.hashCode(queryTableCount());
        hashCode = 31 * hashCode + Objects.hashCode(outputRows());
        hashCode = 31 * hashCode + Objects.hashCode(outputBytes());
        hashCode = 31 * hashCode + Objects.hashCode(unloadPartitionCount());
        hashCode = 31 * hashCode + Objects.hashCode(unloadWrittenRows());
        hashCode = 31 * hashCode + Objects.hashCode(unloadWrittenBytes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryInsightsResponse)) {
            return false;
        }
        QueryInsightsResponse other = (QueryInsightsResponse) obj;
        return Objects.equals(querySpatialCoverage(), other.querySpatialCoverage())
                && Objects.equals(queryTemporalRange(), other.queryTemporalRange())
                && Objects.equals(queryTableCount(), other.queryTableCount()) && Objects.equals(outputRows(), other.outputRows())
                && Objects.equals(outputBytes(), other.outputBytes())
                && Objects.equals(unloadPartitionCount(), other.unloadPartitionCount())
                && Objects.equals(unloadWrittenRows(), other.unloadWrittenRows())
                && Objects.equals(unloadWrittenBytes(), other.unloadWrittenBytes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("QueryInsightsResponse").add("QuerySpatialCoverage", querySpatialCoverage())
                .add("QueryTemporalRange", queryTemporalRange()).add("QueryTableCount", queryTableCount())
                .add("OutputRows", outputRows()).add("OutputBytes", outputBytes())
                .add("UnloadPartitionCount", unloadPartitionCount()).add("UnloadWrittenRows", unloadWrittenRows())
                .add("UnloadWrittenBytes", unloadWrittenBytes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "QuerySpatialCoverage":
            return Optional.ofNullable(clazz.cast(querySpatialCoverage()));
        case "QueryTemporalRange":
            return Optional.ofNullable(clazz.cast(queryTemporalRange()));
        case "QueryTableCount":
            return Optional.ofNullable(clazz.cast(queryTableCount()));
        case "OutputRows":
            return Optional.ofNullable(clazz.cast(outputRows()));
        case "OutputBytes":
            return Optional.ofNullable(clazz.cast(outputBytes()));
        case "UnloadPartitionCount":
            return Optional.ofNullable(clazz.cast(unloadPartitionCount()));
        case "UnloadWrittenRows":
            return Optional.ofNullable(clazz.cast(unloadWrittenRows()));
        case "UnloadWrittenBytes":
            return Optional.ofNullable(clazz.cast(unloadWrittenBytes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<QueryInsightsResponse, T> g) {
        return obj -> g.apply((QueryInsightsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, QueryInsightsResponse> {
        /**
         * <p>
         * Provides insights into the spatial coverage of the query, including the table with sub-optimal (max) spatial
         * pruning. This information can help you identify areas for improvement in your partitioning strategy to
         * enhance spatial pruning.
         * </p>
         * 
         * @param querySpatialCoverage
         *        Provides insights into the spatial coverage of the query, including the table with sub-optimal (max)
         *        spatial pruning. This information can help you identify areas for improvement in your partitioning
         *        strategy to enhance spatial pruning.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder querySpatialCoverage(QuerySpatialCoverage querySpatialCoverage);

        /**
         * <p>
         * Provides insights into the spatial coverage of the query, including the table with sub-optimal (max) spatial
         * pruning. This information can help you identify areas for improvement in your partitioning strategy to
         * enhance spatial pruning.
         * </p>
         * This is a convenience method that creates an instance of the {@link QuerySpatialCoverage.Builder} avoiding
         * the need to create one manually via {@link QuerySpatialCoverage#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link QuerySpatialCoverage.Builder#build()} is called immediately and
         * its result is passed to {@link #querySpatialCoverage(QuerySpatialCoverage)}.
         * 
         * @param querySpatialCoverage
         *        a consumer that will call methods on {@link QuerySpatialCoverage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #querySpatialCoverage(QuerySpatialCoverage)
         */
        default Builder querySpatialCoverage(Consumer<QuerySpatialCoverage.Builder> querySpatialCoverage) {
            return querySpatialCoverage(QuerySpatialCoverage.builder().applyMutation(querySpatialCoverage).build());
        }

        /**
         * <p>
         * Provides insights into the temporal range of the query, including the table with the largest (max) time
         * range. Following are some of the potential options for optimizing time-based pruning:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Add missing time-predicates.
         * </p>
         * </li>
         * <li>
         * <p>
         * Remove functions around the time predicates.
         * </p>
         * </li>
         * <li>
         * <p>
         * Add time predicates to all the sub-queries.
         * </p>
         * </li>
         * </ul>
         * 
         * @param queryTemporalRange
         *        Provides insights into the temporal range of the query, including the table with the largest (max)
         *        time range. Following are some of the potential options for optimizing time-based pruning:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Add missing time-predicates.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Remove functions around the time predicates.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Add time predicates to all the sub-queries.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryTemporalRange(QueryTemporalRange queryTemporalRange);

        /**
         * <p>
         * Provides insights into the temporal range of the query, including the table with the largest (max) time
         * range. Following are some of the potential options for optimizing time-based pruning:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Add missing time-predicates.
         * </p>
         * </li>
         * <li>
         * <p>
         * Remove functions around the time predicates.
         * </p>
         * </li>
         * <li>
         * <p>
         * Add time predicates to all the sub-queries.
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the {@link QueryTemporalRange.Builder} avoiding the
         * need to create one manually via {@link QueryTemporalRange#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link QueryTemporalRange.Builder#build()} is called immediately and its
         * result is passed to {@link #queryTemporalRange(QueryTemporalRange)}.
         * 
         * @param queryTemporalRange
         *        a consumer that will call methods on {@link QueryTemporalRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #queryTemporalRange(QueryTemporalRange)
         */
        default Builder queryTemporalRange(Consumer<QueryTemporalRange.Builder> queryTemporalRange) {
            return queryTemporalRange(QueryTemporalRange.builder().applyMutation(queryTemporalRange).build());
        }

        /**
         * <p>
         * Indicates the number of tables in the query.
         * </p>
         * 
         * @param queryTableCount
         *        Indicates the number of tables in the query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryTableCount(Long queryTableCount);

        /**
         * <p>
         * Indicates the total number of rows returned as part of the query result set. You can use this data to
         * validate if the number of rows in the result set have changed as part of the query tuning exercise.
         * </p>
         * 
         * @param outputRows
         *        Indicates the total number of rows returned as part of the query result set. You can use this data to
         *        validate if the number of rows in the result set have changed as part of the query tuning exercise.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputRows(Long outputRows);

        /**
         * <p>
         * Indicates the size of query result set in bytes. You can use this data to validate if the result set has
         * changed as part of the query tuning exercise.
         * </p>
         * 
         * @param outputBytes
         *        Indicates the size of query result set in bytes. You can use this data to validate if the result set
         *        has changed as part of the query tuning exercise.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputBytes(Long outputBytes);

        /**
         * <p>
         * Indicates the partitions created by the <code>Unload</code> operation.
         * </p>
         * 
         * @param unloadPartitionCount
         *        Indicates the partitions created by the <code>Unload</code> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unloadPartitionCount(Long unloadPartitionCount);

        /**
         * <p>
         * Indicates the rows written by the <code>Unload</code> query.
         * </p>
         * 
         * @param unloadWrittenRows
         *        Indicates the rows written by the <code>Unload</code> query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unloadWrittenRows(Long unloadWrittenRows);

        /**
         * <p>
         * Indicates the size, in bytes, written by the <code>Unload</code> operation.
         * </p>
         * 
         * @param unloadWrittenBytes
         *        Indicates the size, in bytes, written by the <code>Unload</code> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unloadWrittenBytes(Long unloadWrittenBytes);
    }

    static final class BuilderImpl implements Builder {
        private QuerySpatialCoverage querySpatialCoverage;

        private QueryTemporalRange queryTemporalRange;

        private Long queryTableCount;

        private Long outputRows;

        private Long outputBytes;

        private Long unloadPartitionCount;

        private Long unloadWrittenRows;

        private Long unloadWrittenBytes;

        private BuilderImpl() {
        }

        private BuilderImpl(QueryInsightsResponse model) {
            querySpatialCoverage(model.querySpatialCoverage);
            queryTemporalRange(model.queryTemporalRange);
            queryTableCount(model.queryTableCount);
            outputRows(model.outputRows);
            outputBytes(model.outputBytes);
            unloadPartitionCount(model.unloadPartitionCount);
            unloadWrittenRows(model.unloadWrittenRows);
            unloadWrittenBytes(model.unloadWrittenBytes);
        }

        public final QuerySpatialCoverage.Builder getQuerySpatialCoverage() {
            return querySpatialCoverage != null ? querySpatialCoverage.toBuilder() : null;
        }

        public final void setQuerySpatialCoverage(QuerySpatialCoverage.BuilderImpl querySpatialCoverage) {
            this.querySpatialCoverage = querySpatialCoverage != null ? querySpatialCoverage.build() : null;
        }

        @Override
        public final Builder querySpatialCoverage(QuerySpatialCoverage querySpatialCoverage) {
            this.querySpatialCoverage = querySpatialCoverage;
            return this;
        }

        public final QueryTemporalRange.Builder getQueryTemporalRange() {
            return queryTemporalRange != null ? queryTemporalRange.toBuilder() : null;
        }

        public final void setQueryTemporalRange(QueryTemporalRange.BuilderImpl queryTemporalRange) {
            this.queryTemporalRange = queryTemporalRange != null ? queryTemporalRange.build() : null;
        }

        @Override
        public final Builder queryTemporalRange(QueryTemporalRange queryTemporalRange) {
            this.queryTemporalRange = queryTemporalRange;
            return this;
        }

        public final Long getQueryTableCount() {
            return queryTableCount;
        }

        public final void setQueryTableCount(Long queryTableCount) {
            this.queryTableCount = queryTableCount;
        }

        @Override
        public final Builder queryTableCount(Long queryTableCount) {
            this.queryTableCount = queryTableCount;
            return this;
        }

        public final Long getOutputRows() {
            return outputRows;
        }

        public final void setOutputRows(Long outputRows) {
            this.outputRows = outputRows;
        }

        @Override
        public final Builder outputRows(Long outputRows) {
            this.outputRows = outputRows;
            return this;
        }

        public final Long getOutputBytes() {
            return outputBytes;
        }

        public final void setOutputBytes(Long outputBytes) {
            this.outputBytes = outputBytes;
        }

        @Override
        public final Builder outputBytes(Long outputBytes) {
            this.outputBytes = outputBytes;
            return this;
        }

        public final Long getUnloadPartitionCount() {
            return unloadPartitionCount;
        }

        public final void setUnloadPartitionCount(Long unloadPartitionCount) {
            this.unloadPartitionCount = unloadPartitionCount;
        }

        @Override
        public final Builder unloadPartitionCount(Long unloadPartitionCount) {
            this.unloadPartitionCount = unloadPartitionCount;
            return this;
        }

        public final Long getUnloadWrittenRows() {
            return unloadWrittenRows;
        }

        public final void setUnloadWrittenRows(Long unloadWrittenRows) {
            this.unloadWrittenRows = unloadWrittenRows;
        }

        @Override
        public final Builder unloadWrittenRows(Long unloadWrittenRows) {
            this.unloadWrittenRows = unloadWrittenRows;
            return this;
        }

        public final Long getUnloadWrittenBytes() {
            return unloadWrittenBytes;
        }

        public final void setUnloadWrittenBytes(Long unloadWrittenBytes) {
            this.unloadWrittenBytes = unloadWrittenBytes;
        }

        @Override
        public final Builder unloadWrittenBytes(Long unloadWrittenBytes) {
            this.unloadWrittenBytes = unloadWrittenBytes;
            return this;
        }

        @Override
        public QueryInsightsResponse build() {
            return new QueryInsightsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
