/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.timestreamquery.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides insights into the spatial coverage of the query, including the table with sub-optimal (max) spatial pruning.
 * This information can help you identify areas for improvement in your partitioning strategy to enhance spatial pruning
 * </p>
 * <p>
 * For example, you can do the following with the <code>QuerySpatialCoverage</code> information:
 * </p>
 * <ul>
 * <li>
 * <p>
 * Add measure_name or use <a
 * href="https://docs.aws.amazon.com/timestream/latest/developerguide/customer-defined-partition-keys.html"
 * >customer-defined partition key</a> (CDPK) predicates.
 * </p>
 * </li>
 * <li>
 * <p>
 * If you've already done the preceding action, remove functions around them or clauses, such as <code>LIKE</code>.
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class QuerySpatialCoverage implements SdkPojo, Serializable,
        ToCopyableBuilder<QuerySpatialCoverage.Builder, QuerySpatialCoverage> {
    private static final SdkField<QuerySpatialCoverageMax> MAX_FIELD = SdkField
            .<QuerySpatialCoverageMax> builder(MarshallingType.SDK_POJO).memberName("Max")
            .getter(getter(QuerySpatialCoverage::max)).setter(setter(Builder::max)).constructor(QuerySpatialCoverageMax::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Max").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_FIELD));

    private static final long serialVersionUID = 1L;

    private final QuerySpatialCoverageMax max;

    private QuerySpatialCoverage(BuilderImpl builder) {
        this.max = builder.max;
    }

    /**
     * <p>
     * Provides insights into the spatial coverage of the executed query and the table with the most inefficient spatial
     * pruning.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Value</code> – The maximum ratio of spatial coverage.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TableArn</code> – The Amazon Resource Name (ARN) of the table with sub-optimal spatial pruning.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PartitionKey</code> – The partition key used for partitioning, which can be a default
     * <code>measure_name</code> or a CDPK.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Provides insights into the spatial coverage of the executed query and the table with the most inefficient
     *         spatial pruning.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Value</code> – The maximum ratio of spatial coverage.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TableArn</code> – The Amazon Resource Name (ARN) of the table with sub-optimal spatial pruning.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PartitionKey</code> – The partition key used for partitioning, which can be a default
     *         <code>measure_name</code> or a CDPK.
     *         </p>
     *         </li>
     */
    public final QuerySpatialCoverageMax max() {
        return max;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(max());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QuerySpatialCoverage)) {
            return false;
        }
        QuerySpatialCoverage other = (QuerySpatialCoverage) obj;
        return Objects.equals(max(), other.max());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("QuerySpatialCoverage").add("Max", max()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Max":
            return Optional.ofNullable(clazz.cast(max()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<QuerySpatialCoverage, T> g) {
        return obj -> g.apply((QuerySpatialCoverage) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, QuerySpatialCoverage> {
        /**
         * <p>
         * Provides insights into the spatial coverage of the executed query and the table with the most inefficient
         * spatial pruning.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Value</code> – The maximum ratio of spatial coverage.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TableArn</code> – The Amazon Resource Name (ARN) of the table with sub-optimal spatial pruning.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PartitionKey</code> – The partition key used for partitioning, which can be a default
         * <code>measure_name</code> or a CDPK.
         * </p>
         * </li>
         * </ul>
         * 
         * @param max
         *        Provides insights into the spatial coverage of the executed query and the table with the most
         *        inefficient spatial pruning.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Value</code> – The maximum ratio of spatial coverage.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TableArn</code> – The Amazon Resource Name (ARN) of the table with sub-optimal spatial pruning.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PartitionKey</code> – The partition key used for partitioning, which can be a default
         *        <code>measure_name</code> or a CDPK.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder max(QuerySpatialCoverageMax max);

        /**
         * <p>
         * Provides insights into the spatial coverage of the executed query and the table with the most inefficient
         * spatial pruning.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Value</code> – The maximum ratio of spatial coverage.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TableArn</code> – The Amazon Resource Name (ARN) of the table with sub-optimal spatial pruning.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PartitionKey</code> – The partition key used for partitioning, which can be a default
         * <code>measure_name</code> or a CDPK.
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the {@link QuerySpatialCoverageMax.Builder} avoiding
         * the need to create one manually via {@link QuerySpatialCoverageMax#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link QuerySpatialCoverageMax.Builder#build()} is called immediately
         * and its result is passed to {@link #max(QuerySpatialCoverageMax)}.
         * 
         * @param max
         *        a consumer that will call methods on {@link QuerySpatialCoverageMax.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #max(QuerySpatialCoverageMax)
         */
        default Builder max(Consumer<QuerySpatialCoverageMax.Builder> max) {
            return max(QuerySpatialCoverageMax.builder().applyMutation(max).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private QuerySpatialCoverageMax max;

        private BuilderImpl() {
        }

        private BuilderImpl(QuerySpatialCoverage model) {
            max(model.max);
        }

        public final QuerySpatialCoverageMax.Builder getMax() {
            return max != null ? max.toBuilder() : null;
        }

        public final void setMax(QuerySpatialCoverageMax.BuilderImpl max) {
            this.max = max != null ? max.build() : null;
        }

        @Override
        public final Builder max(QuerySpatialCoverageMax max) {
            this.max = max;
            return this;
        }

        @Override
        public QuerySpatialCoverage build() {
            return new QuerySpatialCoverage(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
