/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.timestreamquery.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.timestreamquery.model.PartitionKeyListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class QuerySpatialCoverageMax
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, QuerySpatialCoverageMax> {
    private static final SdkField<Double> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Value").getter(QuerySpatialCoverageMax.getter(QuerySpatialCoverageMax::value)).setter(QuerySpatialCoverageMax.setter(Builder::value)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()}).build();
    private static final SdkField<String> TABLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TableArn").getter(QuerySpatialCoverageMax.getter(QuerySpatialCoverageMax::tableArn)).setter(QuerySpatialCoverageMax.setter(Builder::tableArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableArn").build()}).build();
    private static final SdkField<List<String>> PARTITION_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PartitionKey").getter(QuerySpatialCoverageMax.getter(QuerySpatialCoverageMax::partitionKey)).setter(QuerySpatialCoverageMax.setter(Builder::partitionKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartitionKey").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUE_FIELD, TABLE_ARN_FIELD, PARTITION_KEY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Value", VALUE_FIELD);
            this.put("TableArn", TABLE_ARN_FIELD);
            this.put("PartitionKey", PARTITION_KEY_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Double value;
    private final String tableArn;
    private final List<String> partitionKey;

    private QuerySpatialCoverageMax(BuilderImpl builder) {
        this.value = builder.value;
        this.tableArn = builder.tableArn;
        this.partitionKey = builder.partitionKey;
    }

    public final Double value() {
        return this.value;
    }

    public final String tableArn() {
        return this.tableArn;
    }

    public final boolean hasPartitionKey() {
        return this.partitionKey != null && !(this.partitionKey instanceof SdkAutoConstructList);
    }

    public final List<String> partitionKey() {
        return this.partitionKey;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPartitionKey() ? this.partitionKey() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QuerySpatialCoverageMax)) {
            return false;
        }
        QuerySpatialCoverageMax other = (QuerySpatialCoverageMax)obj;
        return Objects.equals(this.value(), other.value()) && Objects.equals(this.tableArn(), other.tableArn()) && this.hasPartitionKey() == other.hasPartitionKey() && Objects.equals(this.partitionKey(), other.partitionKey());
    }

    public final String toString() {
        return ToString.builder((String)"QuerySpatialCoverageMax").add("Value", (Object)this.value()).add("TableArn", (Object)this.tableArn()).add("PartitionKey", this.hasPartitionKey() ? this.partitionKey() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
            case "TableArn": {
                return Optional.ofNullable(clazz.cast(this.tableArn()));
            }
            case "PartitionKey": {
                return Optional.ofNullable(clazz.cast(this.partitionKey()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<QuerySpatialCoverageMax, T> g) {
        return obj -> g.apply((QuerySpatialCoverageMax)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Double value;
        private String tableArn;
        private List<String> partitionKey = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(QuerySpatialCoverageMax model) {
            this.value(model.value);
            this.tableArn(model.tableArn);
            this.partitionKey(model.partitionKey);
        }

        public final Double getValue() {
            return this.value;
        }

        public final void setValue(Double value) {
            this.value = value;
        }

        @Override
        public final Builder value(Double value) {
            this.value = value;
            return this;
        }

        public final String getTableArn() {
            return this.tableArn;
        }

        public final void setTableArn(String tableArn) {
            this.tableArn = tableArn;
        }

        @Override
        public final Builder tableArn(String tableArn) {
            this.tableArn = tableArn;
            return this;
        }

        public final Collection<String> getPartitionKey() {
            if (this.partitionKey instanceof SdkAutoConstructList) {
                return null;
            }
            return this.partitionKey;
        }

        public final void setPartitionKey(Collection<String> partitionKey) {
            this.partitionKey = PartitionKeyListCopier.copy(partitionKey);
        }

        @Override
        public final Builder partitionKey(Collection<String> partitionKey) {
            this.partitionKey = PartitionKeyListCopier.copy(partitionKey);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partitionKey(String ... partitionKey) {
            this.partitionKey(Arrays.asList(partitionKey));
            return this;
        }

        public QuerySpatialCoverageMax build() {
            return new QuerySpatialCoverageMax(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, QuerySpatialCoverageMax> {
        public Builder value(Double var1);

        public Builder tableArn(String var1);

        public Builder partitionKey(Collection<String> var1);

        public Builder partitionKey(String ... var1);
    }
}

