/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.timestreamquery.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PrepareQueryRequest extends TimestreamQueryRequest implements
        ToCopyableBuilder<PrepareQueryRequest.Builder, PrepareQueryRequest> {
    private static final SdkField<String> QUERY_STRING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QueryString").getter(getter(PrepareQueryRequest::queryString)).setter(setter(Builder::queryString))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryString").build()).build();

    private static final SdkField<Boolean> VALIDATE_ONLY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ValidateOnly").getter(getter(PrepareQueryRequest::validateOnly)).setter(setter(Builder::validateOnly))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidateOnly").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERY_STRING_FIELD,
            VALIDATE_ONLY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String queryString;

    private final Boolean validateOnly;

    private PrepareQueryRequest(BuilderImpl builder) {
        super(builder);
        this.queryString = builder.queryString;
        this.validateOnly = builder.validateOnly;
    }

    /**
     * <p>
     * The Timestream query string that you want to use as a prepared statement. Parameter names can be specified in the
     * query string <code>@</code> character followed by an identifier.
     * </p>
     * 
     * @return The Timestream query string that you want to use as a prepared statement. Parameter names can be
     *         specified in the query string <code>@</code> character followed by an identifier.
     */
    public final String queryString() {
        return queryString;
    }

    /**
     * <p>
     * By setting this value to <code>true</code>, Timestream will only validate that the query string is a valid
     * Timestream query, and not store the prepared query for later use.
     * </p>
     * 
     * @return By setting this value to <code>true</code>, Timestream will only validate that the query string is a
     *         valid Timestream query, and not store the prepared query for later use.
     */
    public final Boolean validateOnly() {
        return validateOnly;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(queryString());
        hashCode = 31 * hashCode + Objects.hashCode(validateOnly());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PrepareQueryRequest)) {
            return false;
        }
        PrepareQueryRequest other = (PrepareQueryRequest) obj;
        return Objects.equals(queryString(), other.queryString()) && Objects.equals(validateOnly(), other.validateOnly());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PrepareQueryRequest")
                .add("QueryString", queryString() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ValidateOnly", validateOnly()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "QueryString":
            return Optional.ofNullable(clazz.cast(queryString()));
        case "ValidateOnly":
            return Optional.ofNullable(clazz.cast(validateOnly()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("QueryString", QUERY_STRING_FIELD);
        map.put("ValidateOnly", VALIDATE_ONLY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PrepareQueryRequest, T> g) {
        return obj -> g.apply((PrepareQueryRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TimestreamQueryRequest.Builder, SdkPojo, CopyableBuilder<Builder, PrepareQueryRequest> {
        /**
         * <p>
         * The Timestream query string that you want to use as a prepared statement. Parameter names can be specified in
         * the query string <code>@</code> character followed by an identifier.
         * </p>
         * 
         * @param queryString
         *        The Timestream query string that you want to use as a prepared statement. Parameter names can be
         *        specified in the query string <code>@</code> character followed by an identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryString(String queryString);

        /**
         * <p>
         * By setting this value to <code>true</code>, Timestream will only validate that the query string is a valid
         * Timestream query, and not store the prepared query for later use.
         * </p>
         * 
         * @param validateOnly
         *        By setting this value to <code>true</code>, Timestream will only validate that the query string is a
         *        valid Timestream query, and not store the prepared query for later use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validateOnly(Boolean validateOnly);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends TimestreamQueryRequest.BuilderImpl implements Builder {
        private String queryString;

        private Boolean validateOnly;

        private BuilderImpl() {
        }

        private BuilderImpl(PrepareQueryRequest model) {
            super(model);
            queryString(model.queryString);
            validateOnly(model.validateOnly);
        }

        public final String getQueryString() {
            return queryString;
        }

        public final void setQueryString(String queryString) {
            this.queryString = queryString;
        }

        @Override
        public final Builder queryString(String queryString) {
            this.queryString = queryString;
            return this;
        }

        public final Boolean getValidateOnly() {
            return validateOnly;
        }

        public final void setValidateOnly(Boolean validateOnly) {
            this.validateOnly = validateOnly;
        }

        @Override
        public final Builder validateOnly(Boolean validateOnly) {
            this.validateOnly = validateOnly;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PrepareQueryRequest build() {
            return new PrepareQueryRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
