/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.timestreamquery.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PrepareQueryResponse extends TimestreamQueryResponse implements
        ToCopyableBuilder<PrepareQueryResponse.Builder, PrepareQueryResponse> {
    private static final SdkField<String> QUERY_STRING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QueryString").getter(getter(PrepareQueryResponse::queryString)).setter(setter(Builder::queryString))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryString").build()).build();

    private static final SdkField<List<SelectColumn>> COLUMNS_FIELD = SdkField
            .<List<SelectColumn>> builder(MarshallingType.LIST)
            .memberName("Columns")
            .getter(getter(PrepareQueryResponse::columns))
            .setter(setter(Builder::columns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Columns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SelectColumn> builder(MarshallingType.SDK_POJO)
                                            .constructor(SelectColumn::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ParameterMapping>> PARAMETERS_FIELD = SdkField
            .<List<ParameterMapping>> builder(MarshallingType.LIST)
            .memberName("Parameters")
            .getter(getter(PrepareQueryResponse::parameters))
            .setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ParameterMapping> builder(MarshallingType.SDK_POJO)
                                            .constructor(ParameterMapping::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERY_STRING_FIELD,
            COLUMNS_FIELD, PARAMETERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String queryString;

    private final List<SelectColumn> columns;

    private final List<ParameterMapping> parameters;

    private PrepareQueryResponse(BuilderImpl builder) {
        super(builder);
        this.queryString = builder.queryString;
        this.columns = builder.columns;
        this.parameters = builder.parameters;
    }

    /**
     * <p>
     * The query string that you want prepare.
     * </p>
     * 
     * @return The query string that you want prepare.
     */
    public final String queryString() {
        return queryString;
    }

    /**
     * For responses, this returns true if the service returned a value for the Columns property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasColumns() {
        return columns != null && !(columns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of SELECT clause columns of the submitted query string.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasColumns} method.
     * </p>
     * 
     * @return A list of SELECT clause columns of the submitted query string.
     */
    public final List<SelectColumn> columns() {
        return columns;
    }

    /**
     * For responses, this returns true if the service returned a value for the Parameters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasParameters() {
        return parameters != null && !(parameters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of parameters used in the submitted query string.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParameters} method.
     * </p>
     * 
     * @return A list of parameters used in the submitted query string.
     */
    public final List<ParameterMapping> parameters() {
        return parameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(queryString());
        hashCode = 31 * hashCode + Objects.hashCode(hasColumns() ? columns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasParameters() ? parameters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PrepareQueryResponse)) {
            return false;
        }
        PrepareQueryResponse other = (PrepareQueryResponse) obj;
        return Objects.equals(queryString(), other.queryString()) && hasColumns() == other.hasColumns()
                && Objects.equals(columns(), other.columns()) && hasParameters() == other.hasParameters()
                && Objects.equals(parameters(), other.parameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PrepareQueryResponse")
                .add("QueryString", queryString() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Columns", hasColumns() ? columns() : null).add("Parameters", hasParameters() ? parameters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "QueryString":
            return Optional.ofNullable(clazz.cast(queryString()));
        case "Columns":
            return Optional.ofNullable(clazz.cast(columns()));
        case "Parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("QueryString", QUERY_STRING_FIELD);
        map.put("Columns", COLUMNS_FIELD);
        map.put("Parameters", PARAMETERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PrepareQueryResponse, T> g) {
        return obj -> g.apply((PrepareQueryResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TimestreamQueryResponse.Builder, SdkPojo, CopyableBuilder<Builder, PrepareQueryResponse> {
        /**
         * <p>
         * The query string that you want prepare.
         * </p>
         * 
         * @param queryString
         *        The query string that you want prepare.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryString(String queryString);

        /**
         * <p>
         * A list of SELECT clause columns of the submitted query string.
         * </p>
         * 
         * @param columns
         *        A list of SELECT clause columns of the submitted query string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columns(Collection<SelectColumn> columns);

        /**
         * <p>
         * A list of SELECT clause columns of the submitted query string.
         * </p>
         * 
         * @param columns
         *        A list of SELECT clause columns of the submitted query string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columns(SelectColumn... columns);

        /**
         * <p>
         * A list of SELECT clause columns of the submitted query string.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.timestreamquery.model.SelectColumn.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.timestreamquery.model.SelectColumn#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.timestreamquery.model.SelectColumn.Builder#build()} is called
         * immediately and its result is passed to {@link #columns(List<SelectColumn>)}.
         * 
         * @param columns
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.timestreamquery.model.SelectColumn.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #columns(java.util.Collection<SelectColumn>)
         */
        Builder columns(Consumer<SelectColumn.Builder>... columns);

        /**
         * <p>
         * A list of parameters used in the submitted query string.
         * </p>
         * 
         * @param parameters
         *        A list of parameters used in the submitted query string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Collection<ParameterMapping> parameters);

        /**
         * <p>
         * A list of parameters used in the submitted query string.
         * </p>
         * 
         * @param parameters
         *        A list of parameters used in the submitted query string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(ParameterMapping... parameters);

        /**
         * <p>
         * A list of parameters used in the submitted query string.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.timestreamquery.model.ParameterMapping.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.timestreamquery.model.ParameterMapping#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.timestreamquery.model.ParameterMapping.Builder#build()} is called
         * immediately and its result is passed to {@link #parameters(List<ParameterMapping>)}.
         * 
         * @param parameters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.timestreamquery.model.ParameterMapping.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parameters(java.util.Collection<ParameterMapping>)
         */
        Builder parameters(Consumer<ParameterMapping.Builder>... parameters);
    }

    static final class BuilderImpl extends TimestreamQueryResponse.BuilderImpl implements Builder {
        private String queryString;

        private List<SelectColumn> columns = DefaultSdkAutoConstructList.getInstance();

        private List<ParameterMapping> parameters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PrepareQueryResponse model) {
            super(model);
            queryString(model.queryString);
            columns(model.columns);
            parameters(model.parameters);
        }

        public final String getQueryString() {
            return queryString;
        }

        public final void setQueryString(String queryString) {
            this.queryString = queryString;
        }

        @Override
        public final Builder queryString(String queryString) {
            this.queryString = queryString;
            return this;
        }

        public final List<SelectColumn.Builder> getColumns() {
            List<SelectColumn.Builder> result = SelectColumnListCopier.copyToBuilder(this.columns);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setColumns(Collection<SelectColumn.BuilderImpl> columns) {
            this.columns = SelectColumnListCopier.copyFromBuilder(columns);
        }

        @Override
        public final Builder columns(Collection<SelectColumn> columns) {
            this.columns = SelectColumnListCopier.copy(columns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columns(SelectColumn... columns) {
            columns(Arrays.asList(columns));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columns(Consumer<SelectColumn.Builder>... columns) {
            columns(Stream.of(columns).map(c -> SelectColumn.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ParameterMapping.Builder> getParameters() {
            List<ParameterMapping.Builder> result = ParameterMappingListCopier.copyToBuilder(this.parameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setParameters(Collection<ParameterMapping.BuilderImpl> parameters) {
            this.parameters = ParameterMappingListCopier.copyFromBuilder(parameters);
        }

        @Override
        public final Builder parameters(Collection<ParameterMapping> parameters) {
            this.parameters = ParameterMappingListCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(ParameterMapping... parameters) {
            parameters(Arrays.asList(parameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Consumer<ParameterMapping.Builder>... parameters) {
            parameters(Stream.of(parameters).map(c -> ParameterMapping.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public PrepareQueryResponse build() {
            return new PrepareQueryResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
