/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.timestreamquery.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the status of the query, including progress and bytes scanned.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class QueryStatus implements SdkPojo, Serializable, ToCopyableBuilder<QueryStatus.Builder, QueryStatus> {
    private static final SdkField<Double> PROGRESS_PERCENTAGE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("ProgressPercentage").getter(getter(QueryStatus::progressPercentage))
            .setter(setter(Builder::progressPercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProgressPercentage").build())
            .build();

    private static final SdkField<Long> CUMULATIVE_BYTES_SCANNED_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("CumulativeBytesScanned").getter(getter(QueryStatus::cumulativeBytesScanned))
            .setter(setter(Builder::cumulativeBytesScanned))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CumulativeBytesScanned").build())
            .build();

    private static final SdkField<Long> CUMULATIVE_BYTES_METERED_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("CumulativeBytesMetered").getter(getter(QueryStatus::cumulativeBytesMetered))
            .setter(setter(Builder::cumulativeBytesMetered))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CumulativeBytesMetered").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROGRESS_PERCENTAGE_FIELD,
            CUMULATIVE_BYTES_SCANNED_FIELD, CUMULATIVE_BYTES_METERED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Double progressPercentage;

    private final Long cumulativeBytesScanned;

    private final Long cumulativeBytesMetered;

    private QueryStatus(BuilderImpl builder) {
        this.progressPercentage = builder.progressPercentage;
        this.cumulativeBytesScanned = builder.cumulativeBytesScanned;
        this.cumulativeBytesMetered = builder.cumulativeBytesMetered;
    }

    /**
     * <p>
     * The progress of the query, expressed as a percentage.
     * </p>
     * 
     * @return The progress of the query, expressed as a percentage.
     */
    public final Double progressPercentage() {
        return progressPercentage;
    }

    /**
     * <p>
     * The amount of data scanned by the query in bytes. This is a cumulative sum and represents the total amount of
     * bytes scanned since the query was started.
     * </p>
     * 
     * @return The amount of data scanned by the query in bytes. This is a cumulative sum and represents the total
     *         amount of bytes scanned since the query was started.
     */
    public final Long cumulativeBytesScanned() {
        return cumulativeBytesScanned;
    }

    /**
     * <p>
     * The amount of data scanned by the query in bytes that you will be charged for. This is a cumulative sum and
     * represents the total amount of data that you will be charged for since the query was started. The charge is
     * applied only once and is either applied when the query completes running or when the query is cancelled.
     * </p>
     * 
     * @return The amount of data scanned by the query in bytes that you will be charged for. This is a cumulative sum
     *         and represents the total amount of data that you will be charged for since the query was started. The
     *         charge is applied only once and is either applied when the query completes running or when the query is
     *         cancelled.
     */
    public final Long cumulativeBytesMetered() {
        return cumulativeBytesMetered;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(progressPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(cumulativeBytesScanned());
        hashCode = 31 * hashCode + Objects.hashCode(cumulativeBytesMetered());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryStatus)) {
            return false;
        }
        QueryStatus other = (QueryStatus) obj;
        return Objects.equals(progressPercentage(), other.progressPercentage())
                && Objects.equals(cumulativeBytesScanned(), other.cumulativeBytesScanned())
                && Objects.equals(cumulativeBytesMetered(), other.cumulativeBytesMetered());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("QueryStatus").add("ProgressPercentage", progressPercentage())
                .add("CumulativeBytesScanned", cumulativeBytesScanned()).add("CumulativeBytesMetered", cumulativeBytesMetered())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProgressPercentage":
            return Optional.ofNullable(clazz.cast(progressPercentage()));
        case "CumulativeBytesScanned":
            return Optional.ofNullable(clazz.cast(cumulativeBytesScanned()));
        case "CumulativeBytesMetered":
            return Optional.ofNullable(clazz.cast(cumulativeBytesMetered()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ProgressPercentage", PROGRESS_PERCENTAGE_FIELD);
        map.put("CumulativeBytesScanned", CUMULATIVE_BYTES_SCANNED_FIELD);
        map.put("CumulativeBytesMetered", CUMULATIVE_BYTES_METERED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<QueryStatus, T> g) {
        return obj -> g.apply((QueryStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, QueryStatus> {
        /**
         * <p>
         * The progress of the query, expressed as a percentage.
         * </p>
         * 
         * @param progressPercentage
         *        The progress of the query, expressed as a percentage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder progressPercentage(Double progressPercentage);

        /**
         * <p>
         * The amount of data scanned by the query in bytes. This is a cumulative sum and represents the total amount of
         * bytes scanned since the query was started.
         * </p>
         * 
         * @param cumulativeBytesScanned
         *        The amount of data scanned by the query in bytes. This is a cumulative sum and represents the total
         *        amount of bytes scanned since the query was started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cumulativeBytesScanned(Long cumulativeBytesScanned);

        /**
         * <p>
         * The amount of data scanned by the query in bytes that you will be charged for. This is a cumulative sum and
         * represents the total amount of data that you will be charged for since the query was started. The charge is
         * applied only once and is either applied when the query completes running or when the query is cancelled.
         * </p>
         * 
         * @param cumulativeBytesMetered
         *        The amount of data scanned by the query in bytes that you will be charged for. This is a cumulative
         *        sum and represents the total amount of data that you will be charged for since the query was started.
         *        The charge is applied only once and is either applied when the query completes running or when the
         *        query is cancelled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cumulativeBytesMetered(Long cumulativeBytesMetered);
    }

    static final class BuilderImpl implements Builder {
        private Double progressPercentage;

        private Long cumulativeBytesScanned;

        private Long cumulativeBytesMetered;

        private BuilderImpl() {
        }

        private BuilderImpl(QueryStatus model) {
            progressPercentage(model.progressPercentage);
            cumulativeBytesScanned(model.cumulativeBytesScanned);
            cumulativeBytesMetered(model.cumulativeBytesMetered);
        }

        public final Double getProgressPercentage() {
            return progressPercentage;
        }

        public final void setProgressPercentage(Double progressPercentage) {
            this.progressPercentage = progressPercentage;
        }

        @Override
        public final Builder progressPercentage(Double progressPercentage) {
            this.progressPercentage = progressPercentage;
            return this;
        }

        public final Long getCumulativeBytesScanned() {
            return cumulativeBytesScanned;
        }

        public final void setCumulativeBytesScanned(Long cumulativeBytesScanned) {
            this.cumulativeBytesScanned = cumulativeBytesScanned;
        }

        @Override
        public final Builder cumulativeBytesScanned(Long cumulativeBytesScanned) {
            this.cumulativeBytesScanned = cumulativeBytesScanned;
            return this;
        }

        public final Long getCumulativeBytesMetered() {
            return cumulativeBytesMetered;
        }

        public final void setCumulativeBytesMetered(Long cumulativeBytesMetered) {
            this.cumulativeBytesMetered = cumulativeBytesMetered;
        }

        @Override
        public final Builder cumulativeBytesMetered(Long cumulativeBytesMetered) {
            this.cumulativeBytesMetered = cumulativeBytesMetered;
            return this;
        }

        @Override
        public QueryStatus build() {
            return new QueryStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
