/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.timestreamquery.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Scheduled Query
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ScheduledQuery implements SdkPojo, Serializable, ToCopyableBuilder<ScheduledQuery.Builder, ScheduledQuery> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(ScheduledQuery::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(ScheduledQuery::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(ScheduledQuery::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(ScheduledQuery::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<Instant> PREVIOUS_INVOCATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("PreviousInvocationTime").getter(getter(ScheduledQuery::previousInvocationTime))
            .setter(setter(Builder::previousInvocationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreviousInvocationTime").build())
            .build();

    private static final SdkField<Instant> NEXT_INVOCATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("NextInvocationTime").getter(getter(ScheduledQuery::nextInvocationTime))
            .setter(setter(Builder::nextInvocationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextInvocationTime").build())
            .build();

    private static final SdkField<ErrorReportConfiguration> ERROR_REPORT_CONFIGURATION_FIELD = SdkField
            .<ErrorReportConfiguration> builder(MarshallingType.SDK_POJO).memberName("ErrorReportConfiguration")
            .getter(getter(ScheduledQuery::errorReportConfiguration)).setter(setter(Builder::errorReportConfiguration))
            .constructor(ErrorReportConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorReportConfiguration").build())
            .build();

    private static final SdkField<TargetDestination> TARGET_DESTINATION_FIELD = SdkField
            .<TargetDestination> builder(MarshallingType.SDK_POJO).memberName("TargetDestination")
            .getter(getter(ScheduledQuery::targetDestination)).setter(setter(Builder::targetDestination))
            .constructor(TargetDestination::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetDestination").build()).build();

    private static final SdkField<String> LAST_RUN_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastRunStatus").getter(getter(ScheduledQuery::lastRunStatusAsString))
            .setter(setter(Builder::lastRunStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastRunStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD,
            CREATION_TIME_FIELD, STATE_FIELD, PREVIOUS_INVOCATION_TIME_FIELD, NEXT_INVOCATION_TIME_FIELD,
            ERROR_REPORT_CONFIGURATION_FIELD, TARGET_DESTINATION_FIELD, LAST_RUN_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String name;

    private final Instant creationTime;

    private final String state;

    private final Instant previousInvocationTime;

    private final Instant nextInvocationTime;

    private final ErrorReportConfiguration errorReportConfiguration;

    private final TargetDestination targetDestination;

    private final String lastRunStatus;

    private ScheduledQuery(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.creationTime = builder.creationTime;
        this.state = builder.state;
        this.previousInvocationTime = builder.previousInvocationTime;
        this.nextInvocationTime = builder.nextInvocationTime;
        this.errorReportConfiguration = builder.errorReportConfiguration;
        this.targetDestination = builder.targetDestination;
        this.lastRunStatus = builder.lastRunStatus;
    }

    /**
     * <p>
     * The Amazon Resource Name.
     * </p>
     * 
     * @return The Amazon Resource Name.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of the scheduled query.
     * </p>
     * 
     * @return The name of the scheduled query.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The creation time of the scheduled query.
     * </p>
     * 
     * @return The creation time of the scheduled query.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * State of scheduled query.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ScheduledQueryState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return State of scheduled query.
     * @see ScheduledQueryState
     */
    public final ScheduledQueryState state() {
        return ScheduledQueryState.fromValue(state);
    }

    /**
     * <p>
     * State of scheduled query.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ScheduledQueryState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return State of scheduled query.
     * @see ScheduledQueryState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The last time the scheduled query was run.
     * </p>
     * 
     * @return The last time the scheduled query was run.
     */
    public final Instant previousInvocationTime() {
        return previousInvocationTime;
    }

    /**
     * <p>
     * The next time the scheduled query is to be run.
     * </p>
     * 
     * @return The next time the scheduled query is to be run.
     */
    public final Instant nextInvocationTime() {
        return nextInvocationTime;
    }

    /**
     * <p>
     * Configuration for scheduled query error reporting.
     * </p>
     * 
     * @return Configuration for scheduled query error reporting.
     */
    public final ErrorReportConfiguration errorReportConfiguration() {
        return errorReportConfiguration;
    }

    /**
     * <p>
     * Target data source where final scheduled query result will be written.
     * </p>
     * 
     * @return Target data source where final scheduled query result will be written.
     */
    public final TargetDestination targetDestination() {
        return targetDestination;
    }

    /**
     * <p>
     * Status of the last scheduled query run.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lastRunStatus}
     * will return {@link ScheduledQueryRunStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #lastRunStatusAsString}.
     * </p>
     * 
     * @return Status of the last scheduled query run.
     * @see ScheduledQueryRunStatus
     */
    public final ScheduledQueryRunStatus lastRunStatus() {
        return ScheduledQueryRunStatus.fromValue(lastRunStatus);
    }

    /**
     * <p>
     * Status of the last scheduled query run.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lastRunStatus}
     * will return {@link ScheduledQueryRunStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #lastRunStatusAsString}.
     * </p>
     * 
     * @return Status of the last scheduled query run.
     * @see ScheduledQueryRunStatus
     */
    public final String lastRunStatusAsString() {
        return lastRunStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(previousInvocationTime());
        hashCode = 31 * hashCode + Objects.hashCode(nextInvocationTime());
        hashCode = 31 * hashCode + Objects.hashCode(errorReportConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(targetDestination());
        hashCode = 31 * hashCode + Objects.hashCode(lastRunStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduledQuery)) {
            return false;
        }
        ScheduledQuery other = (ScheduledQuery) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(creationTime(), other.creationTime()) && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(previousInvocationTime(), other.previousInvocationTime())
                && Objects.equals(nextInvocationTime(), other.nextInvocationTime())
                && Objects.equals(errorReportConfiguration(), other.errorReportConfiguration())
                && Objects.equals(targetDestination(), other.targetDestination())
                && Objects.equals(lastRunStatusAsString(), other.lastRunStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ScheduledQuery").add("Arn", arn()).add("Name", name()).add("CreationTime", creationTime())
                .add("State", stateAsString()).add("PreviousInvocationTime", previousInvocationTime())
                .add("NextInvocationTime", nextInvocationTime()).add("ErrorReportConfiguration", errorReportConfiguration())
                .add("TargetDestination", targetDestination()).add("LastRunStatus", lastRunStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "PreviousInvocationTime":
            return Optional.ofNullable(clazz.cast(previousInvocationTime()));
        case "NextInvocationTime":
            return Optional.ofNullable(clazz.cast(nextInvocationTime()));
        case "ErrorReportConfiguration":
            return Optional.ofNullable(clazz.cast(errorReportConfiguration()));
        case "TargetDestination":
            return Optional.ofNullable(clazz.cast(targetDestination()));
        case "LastRunStatus":
            return Optional.ofNullable(clazz.cast(lastRunStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Arn", ARN_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("State", STATE_FIELD);
        map.put("PreviousInvocationTime", PREVIOUS_INVOCATION_TIME_FIELD);
        map.put("NextInvocationTime", NEXT_INVOCATION_TIME_FIELD);
        map.put("ErrorReportConfiguration", ERROR_REPORT_CONFIGURATION_FIELD);
        map.put("TargetDestination", TARGET_DESTINATION_FIELD);
        map.put("LastRunStatus", LAST_RUN_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ScheduledQuery, T> g) {
        return obj -> g.apply((ScheduledQuery) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ScheduledQuery> {
        /**
         * <p>
         * The Amazon Resource Name.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of the scheduled query.
         * </p>
         * 
         * @param name
         *        The name of the scheduled query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The creation time of the scheduled query.
         * </p>
         * 
         * @param creationTime
         *        The creation time of the scheduled query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * State of scheduled query.
         * </p>
         * 
         * @param state
         *        State of scheduled query.
         * @see ScheduledQueryState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScheduledQueryState
         */
        Builder state(String state);

        /**
         * <p>
         * State of scheduled query.
         * </p>
         * 
         * @param state
         *        State of scheduled query.
         * @see ScheduledQueryState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScheduledQueryState
         */
        Builder state(ScheduledQueryState state);

        /**
         * <p>
         * The last time the scheduled query was run.
         * </p>
         * 
         * @param previousInvocationTime
         *        The last time the scheduled query was run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder previousInvocationTime(Instant previousInvocationTime);

        /**
         * <p>
         * The next time the scheduled query is to be run.
         * </p>
         * 
         * @param nextInvocationTime
         *        The next time the scheduled query is to be run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextInvocationTime(Instant nextInvocationTime);

        /**
         * <p>
         * Configuration for scheduled query error reporting.
         * </p>
         * 
         * @param errorReportConfiguration
         *        Configuration for scheduled query error reporting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorReportConfiguration(ErrorReportConfiguration errorReportConfiguration);

        /**
         * <p>
         * Configuration for scheduled query error reporting.
         * </p>
         * This is a convenience method that creates an instance of the {@link ErrorReportConfiguration.Builder}
         * avoiding the need to create one manually via {@link ErrorReportConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ErrorReportConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #errorReportConfiguration(ErrorReportConfiguration)}.
         * 
         * @param errorReportConfiguration
         *        a consumer that will call methods on {@link ErrorReportConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errorReportConfiguration(ErrorReportConfiguration)
         */
        default Builder errorReportConfiguration(Consumer<ErrorReportConfiguration.Builder> errorReportConfiguration) {
            return errorReportConfiguration(ErrorReportConfiguration.builder().applyMutation(errorReportConfiguration).build());
        }

        /**
         * <p>
         * Target data source where final scheduled query result will be written.
         * </p>
         * 
         * @param targetDestination
         *        Target data source where final scheduled query result will be written.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetDestination(TargetDestination targetDestination);

        /**
         * <p>
         * Target data source where final scheduled query result will be written.
         * </p>
         * This is a convenience method that creates an instance of the {@link TargetDestination.Builder} avoiding the
         * need to create one manually via {@link TargetDestination#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TargetDestination.Builder#build()} is called immediately and its
         * result is passed to {@link #targetDestination(TargetDestination)}.
         * 
         * @param targetDestination
         *        a consumer that will call methods on {@link TargetDestination.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetDestination(TargetDestination)
         */
        default Builder targetDestination(Consumer<TargetDestination.Builder> targetDestination) {
            return targetDestination(TargetDestination.builder().applyMutation(targetDestination).build());
        }

        /**
         * <p>
         * Status of the last scheduled query run.
         * </p>
         * 
         * @param lastRunStatus
         *        Status of the last scheduled query run.
         * @see ScheduledQueryRunStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScheduledQueryRunStatus
         */
        Builder lastRunStatus(String lastRunStatus);

        /**
         * <p>
         * Status of the last scheduled query run.
         * </p>
         * 
         * @param lastRunStatus
         *        Status of the last scheduled query run.
         * @see ScheduledQueryRunStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScheduledQueryRunStatus
         */
        Builder lastRunStatus(ScheduledQueryRunStatus lastRunStatus);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String name;

        private Instant creationTime;

        private String state;

        private Instant previousInvocationTime;

        private Instant nextInvocationTime;

        private ErrorReportConfiguration errorReportConfiguration;

        private TargetDestination targetDestination;

        private String lastRunStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduledQuery model) {
            arn(model.arn);
            name(model.name);
            creationTime(model.creationTime);
            state(model.state);
            previousInvocationTime(model.previousInvocationTime);
            nextInvocationTime(model.nextInvocationTime);
            errorReportConfiguration(model.errorReportConfiguration);
            targetDestination(model.targetDestination);
            lastRunStatus(model.lastRunStatus);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ScheduledQueryState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Instant getPreviousInvocationTime() {
            return previousInvocationTime;
        }

        public final void setPreviousInvocationTime(Instant previousInvocationTime) {
            this.previousInvocationTime = previousInvocationTime;
        }

        @Override
        public final Builder previousInvocationTime(Instant previousInvocationTime) {
            this.previousInvocationTime = previousInvocationTime;
            return this;
        }

        public final Instant getNextInvocationTime() {
            return nextInvocationTime;
        }

        public final void setNextInvocationTime(Instant nextInvocationTime) {
            this.nextInvocationTime = nextInvocationTime;
        }

        @Override
        public final Builder nextInvocationTime(Instant nextInvocationTime) {
            this.nextInvocationTime = nextInvocationTime;
            return this;
        }

        public final ErrorReportConfiguration.Builder getErrorReportConfiguration() {
            return errorReportConfiguration != null ? errorReportConfiguration.toBuilder() : null;
        }

        public final void setErrorReportConfiguration(ErrorReportConfiguration.BuilderImpl errorReportConfiguration) {
            this.errorReportConfiguration = errorReportConfiguration != null ? errorReportConfiguration.build() : null;
        }

        @Override
        public final Builder errorReportConfiguration(ErrorReportConfiguration errorReportConfiguration) {
            this.errorReportConfiguration = errorReportConfiguration;
            return this;
        }

        public final TargetDestination.Builder getTargetDestination() {
            return targetDestination != null ? targetDestination.toBuilder() : null;
        }

        public final void setTargetDestination(TargetDestination.BuilderImpl targetDestination) {
            this.targetDestination = targetDestination != null ? targetDestination.build() : null;
        }

        @Override
        public final Builder targetDestination(TargetDestination targetDestination) {
            this.targetDestination = targetDestination;
            return this;
        }

        public final String getLastRunStatus() {
            return lastRunStatus;
        }

        public final void setLastRunStatus(String lastRunStatus) {
            this.lastRunStatus = lastRunStatus;
        }

        @Override
        public final Builder lastRunStatus(String lastRunStatus) {
            this.lastRunStatus = lastRunStatus;
            return this;
        }

        @Override
        public final Builder lastRunStatus(ScheduledQueryRunStatus lastRunStatus) {
            this.lastRunStatus(lastRunStatus == null ? null : lastRunStatus.toString());
            return this;
        }

        @Override
        public ScheduledQuery build() {
            return new ScheduledQuery(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
