/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.timestreamquery.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration used for writing the output of a query.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TargetConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<TargetConfiguration.Builder, TargetConfiguration> {
    private static final SdkField<TimestreamConfiguration> TIMESTREAM_CONFIGURATION_FIELD = SdkField
            .<TimestreamConfiguration> builder(MarshallingType.SDK_POJO).memberName("TimestreamConfiguration")
            .getter(getter(TargetConfiguration::timestreamConfiguration)).setter(setter(Builder::timestreamConfiguration))
            .constructor(TimestreamConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimestreamConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(TIMESTREAM_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final TimestreamConfiguration timestreamConfiguration;

    private TargetConfiguration(BuilderImpl builder) {
        this.timestreamConfiguration = builder.timestreamConfiguration;
    }

    /**
     * <p>
     * Configuration needed to write data into the Timestream database and table.
     * </p>
     * 
     * @return Configuration needed to write data into the Timestream database and table.
     */
    public final TimestreamConfiguration timestreamConfiguration() {
        return timestreamConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(timestreamConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TargetConfiguration)) {
            return false;
        }
        TargetConfiguration other = (TargetConfiguration) obj;
        return Objects.equals(timestreamConfiguration(), other.timestreamConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TargetConfiguration").add("TimestreamConfiguration", timestreamConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TimestreamConfiguration":
            return Optional.ofNullable(clazz.cast(timestreamConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TimestreamConfiguration", TIMESTREAM_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TargetConfiguration, T> g) {
        return obj -> g.apply((TargetConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TargetConfiguration> {
        /**
         * <p>
         * Configuration needed to write data into the Timestream database and table.
         * </p>
         * 
         * @param timestreamConfiguration
         *        Configuration needed to write data into the Timestream database and table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestreamConfiguration(TimestreamConfiguration timestreamConfiguration);

        /**
         * <p>
         * Configuration needed to write data into the Timestream database and table.
         * </p>
         * This is a convenience method that creates an instance of the {@link TimestreamConfiguration.Builder} avoiding
         * the need to create one manually via {@link TimestreamConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TimestreamConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #timestreamConfiguration(TimestreamConfiguration)}.
         * 
         * @param timestreamConfiguration
         *        a consumer that will call methods on {@link TimestreamConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timestreamConfiguration(TimestreamConfiguration)
         */
        default Builder timestreamConfiguration(Consumer<TimestreamConfiguration.Builder> timestreamConfiguration) {
            return timestreamConfiguration(TimestreamConfiguration.builder().applyMutation(timestreamConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private TimestreamConfiguration timestreamConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(TargetConfiguration model) {
            timestreamConfiguration(model.timestreamConfiguration);
        }

        public final TimestreamConfiguration.Builder getTimestreamConfiguration() {
            return timestreamConfiguration != null ? timestreamConfiguration.toBuilder() : null;
        }

        public final void setTimestreamConfiguration(TimestreamConfiguration.BuilderImpl timestreamConfiguration) {
            this.timestreamConfiguration = timestreamConfiguration != null ? timestreamConfiguration.build() : null;
        }

        @Override
        public final Builder timestreamConfiguration(TimestreamConfiguration timestreamConfiguration) {
            this.timestreamConfiguration = timestreamConfiguration;
            return this;
        }

        @Override
        public TargetConfiguration build() {
            return new TargetConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
