/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.timestreamquery.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The timeseries data type represents the values of a measure over time. A time series is an array of rows of
 * timestamps and measure values, with rows sorted in ascending order of time. A TimeSeriesDataPoint is a single data
 * point in the time series. It represents a tuple of (time, measure value) in a time series.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TimeSeriesDataPoint implements SdkPojo, Serializable,
        ToCopyableBuilder<TimeSeriesDataPoint.Builder, TimeSeriesDataPoint> {
    private static final SdkField<String> TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Time")
            .getter(getter(TimeSeriesDataPoint::time)).setter(setter(Builder::time))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Time").build()).build();

    private static final SdkField<Datum> VALUE_FIELD = SdkField.<Datum> builder(MarshallingType.SDK_POJO).memberName("Value")
            .getter(getter(TimeSeriesDataPoint::value)).setter(setter(Builder::value)).constructor(Datum::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIME_FIELD, VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String time;

    private final Datum value;

    private TimeSeriesDataPoint(BuilderImpl builder) {
        this.time = builder.time;
        this.value = builder.value;
    }

    /**
     * <p>
     * The timestamp when the measure value was collected.
     * </p>
     * 
     * @return The timestamp when the measure value was collected.
     */
    public final String time() {
        return time;
    }

    /**
     * <p>
     * The measure value for the data point.
     * </p>
     * 
     * @return The measure value for the data point.
     */
    public final Datum value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(time());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimeSeriesDataPoint)) {
            return false;
        }
        TimeSeriesDataPoint other = (TimeSeriesDataPoint) obj;
        return Objects.equals(time(), other.time()) && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TimeSeriesDataPoint").add("Time", time()).add("Value", value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Time":
            return Optional.ofNullable(clazz.cast(time()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Time", TIME_FIELD);
        map.put("Value", VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TimeSeriesDataPoint, T> g) {
        return obj -> g.apply((TimeSeriesDataPoint) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TimeSeriesDataPoint> {
        /**
         * <p>
         * The timestamp when the measure value was collected.
         * </p>
         * 
         * @param time
         *        The timestamp when the measure value was collected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder time(String time);

        /**
         * <p>
         * The measure value for the data point.
         * </p>
         * 
         * @param value
         *        The measure value for the data point.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(Datum value);

        /**
         * <p>
         * The measure value for the data point.
         * </p>
         * This is a convenience method that creates an instance of the {@link Datum.Builder} avoiding the need to
         * create one manually via {@link Datum#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Datum.Builder#build()} is called immediately and its result is
         * passed to {@link #value(Datum)}.
         * 
         * @param value
         *        a consumer that will call methods on {@link Datum.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #value(Datum)
         */
        default Builder value(Consumer<Datum.Builder> value) {
            return value(Datum.builder().applyMutation(value).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String time;

        private Datum value;

        private BuilderImpl() {
        }

        private BuilderImpl(TimeSeriesDataPoint model) {
            time(model.time);
            value(model.value);
        }

        public final String getTime() {
            return time;
        }

        public final void setTime(String time) {
            this.time = time;
        }

        @Override
        public final Builder time(String time) {
            this.time = time;
            return this;
        }

        public final Datum.Builder getValue() {
            return value != null ? value.toBuilder() : null;
        }

        public final void setValue(Datum.BuilderImpl value) {
            this.value = value != null ? value.build() : null;
        }

        @Override
        public final Builder value(Datum value) {
            this.value = value;
            return this;
        }

        @Override
        public TimeSeriesDataPoint build() {
            return new TimeSeriesDataPoint(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
