/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.timestreamquery.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CancelQueryResponse extends TimestreamQueryResponse implements
        ToCopyableBuilder<CancelQueryResponse.Builder, CancelQueryResponse> {
    private static final SdkField<String> CANCELLATION_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CancellationMessage").getter(getter(CancelQueryResponse::cancellationMessage))
            .setter(setter(Builder::cancellationMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CancellationMessage").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CANCELLATION_MESSAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String cancellationMessage;

    private CancelQueryResponse(BuilderImpl builder) {
        super(builder);
        this.cancellationMessage = builder.cancellationMessage;
    }

    /**
     * <p>
     * A <code>CancellationMessage</code> is returned when a <code>CancelQuery</code> request for the query specified by
     * <code>QueryId</code> has already been issued.
     * </p>
     * 
     * @return A <code>CancellationMessage</code> is returned when a <code>CancelQuery</code> request for the query
     *         specified by <code>QueryId</code> has already been issued.
     */
    public final String cancellationMessage() {
        return cancellationMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(cancellationMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelQueryResponse)) {
            return false;
        }
        CancelQueryResponse other = (CancelQueryResponse) obj;
        return Objects.equals(cancellationMessage(), other.cancellationMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CancelQueryResponse").add("CancellationMessage", cancellationMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CancellationMessage":
            return Optional.ofNullable(clazz.cast(cancellationMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CancellationMessage", CANCELLATION_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CancelQueryResponse, T> g) {
        return obj -> g.apply((CancelQueryResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TimestreamQueryResponse.Builder, SdkPojo, CopyableBuilder<Builder, CancelQueryResponse> {
        /**
         * <p>
         * A <code>CancellationMessage</code> is returned when a <code>CancelQuery</code> request for the query
         * specified by <code>QueryId</code> has already been issued.
         * </p>
         * 
         * @param cancellationMessage
         *        A <code>CancellationMessage</code> is returned when a <code>CancelQuery</code> request for the query
         *        specified by <code>QueryId</code> has already been issued.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cancellationMessage(String cancellationMessage);
    }

    static final class BuilderImpl extends TimestreamQueryResponse.BuilderImpl implements Builder {
        private String cancellationMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(CancelQueryResponse model) {
            super(model);
            cancellationMessage(model.cancellationMessage);
        }

        public final String getCancellationMessage() {
            return cancellationMessage;
        }

        public final void setCancellationMessage(String cancellationMessage) {
            this.cancellationMessage = cancellationMessage;
        }

        @Override
        public final Builder cancellationMessage(String cancellationMessage) {
            this.cancellationMessage = cancellationMessage;
            return this;
        }

        @Override
        public CancelQueryResponse build() {
            return new CancelQueryResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
