/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.timestreamquery.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Only one of MixedMeasureMappings or MultiMeasureMappings is to be provided. MultiMeasureMappings can be used to
 * ingest data as multi measures in the derived table.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MultiMeasureMappings implements SdkPojo, Serializable,
        ToCopyableBuilder<MultiMeasureMappings.Builder, MultiMeasureMappings> {
    private static final SdkField<String> TARGET_MULTI_MEASURE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetMultiMeasureName").getter(getter(MultiMeasureMappings::targetMultiMeasureName))
            .setter(setter(Builder::targetMultiMeasureName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetMultiMeasureName").build())
            .build();

    private static final SdkField<List<MultiMeasureAttributeMapping>> MULTI_MEASURE_ATTRIBUTE_MAPPINGS_FIELD = SdkField
            .<List<MultiMeasureAttributeMapping>> builder(MarshallingType.LIST)
            .memberName("MultiMeasureAttributeMappings")
            .getter(getter(MultiMeasureMappings::multiMeasureAttributeMappings))
            .setter(setter(Builder::multiMeasureAttributeMappings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiMeasureAttributeMappings")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MultiMeasureAttributeMapping> builder(MarshallingType.SDK_POJO)
                                            .constructor(MultiMeasureAttributeMapping::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            TARGET_MULTI_MEASURE_NAME_FIELD, MULTI_MEASURE_ATTRIBUTE_MAPPINGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String targetMultiMeasureName;

    private final List<MultiMeasureAttributeMapping> multiMeasureAttributeMappings;

    private MultiMeasureMappings(BuilderImpl builder) {
        this.targetMultiMeasureName = builder.targetMultiMeasureName;
        this.multiMeasureAttributeMappings = builder.multiMeasureAttributeMappings;
    }

    /**
     * <p>
     * The name of the target multi-measure name in the derived table. This input is required when measureNameColumn is
     * not provided. If MeasureNameColumn is provided, then value from that column will be used as multi-measure name.
     * </p>
     * 
     * @return The name of the target multi-measure name in the derived table. This input is required when
     *         measureNameColumn is not provided. If MeasureNameColumn is provided, then value from that column will be
     *         used as multi-measure name.
     */
    public final String targetMultiMeasureName() {
        return targetMultiMeasureName;
    }

    /**
     * For responses, this returns true if the service returned a value for the MultiMeasureAttributeMappings property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasMultiMeasureAttributeMappings() {
        return multiMeasureAttributeMappings != null && !(multiMeasureAttributeMappings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Required. Attribute mappings to be used for mapping query results to ingest data for multi-measure attributes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMultiMeasureAttributeMappings} method.
     * </p>
     * 
     * @return Required. Attribute mappings to be used for mapping query results to ingest data for multi-measure
     *         attributes.
     */
    public final List<MultiMeasureAttributeMapping> multiMeasureAttributeMappings() {
        return multiMeasureAttributeMappings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(targetMultiMeasureName());
        hashCode = 31 * hashCode + Objects.hashCode(hasMultiMeasureAttributeMappings() ? multiMeasureAttributeMappings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MultiMeasureMappings)) {
            return false;
        }
        MultiMeasureMappings other = (MultiMeasureMappings) obj;
        return Objects.equals(targetMultiMeasureName(), other.targetMultiMeasureName())
                && hasMultiMeasureAttributeMappings() == other.hasMultiMeasureAttributeMappings()
                && Objects.equals(multiMeasureAttributeMappings(), other.multiMeasureAttributeMappings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("MultiMeasureMappings")
                .add("TargetMultiMeasureName", targetMultiMeasureName())
                .add("MultiMeasureAttributeMappings", hasMultiMeasureAttributeMappings() ? multiMeasureAttributeMappings() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TargetMultiMeasureName":
            return Optional.ofNullable(clazz.cast(targetMultiMeasureName()));
        case "MultiMeasureAttributeMappings":
            return Optional.ofNullable(clazz.cast(multiMeasureAttributeMappings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TargetMultiMeasureName", TARGET_MULTI_MEASURE_NAME_FIELD);
        map.put("MultiMeasureAttributeMappings", MULTI_MEASURE_ATTRIBUTE_MAPPINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MultiMeasureMappings, T> g) {
        return obj -> g.apply((MultiMeasureMappings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MultiMeasureMappings> {
        /**
         * <p>
         * The name of the target multi-measure name in the derived table. This input is required when measureNameColumn
         * is not provided. If MeasureNameColumn is provided, then value from that column will be used as multi-measure
         * name.
         * </p>
         * 
         * @param targetMultiMeasureName
         *        The name of the target multi-measure name in the derived table. This input is required when
         *        measureNameColumn is not provided. If MeasureNameColumn is provided, then value from that column will
         *        be used as multi-measure name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetMultiMeasureName(String targetMultiMeasureName);

        /**
         * <p>
         * Required. Attribute mappings to be used for mapping query results to ingest data for multi-measure
         * attributes.
         * </p>
         * 
         * @param multiMeasureAttributeMappings
         *        Required. Attribute mappings to be used for mapping query results to ingest data for multi-measure
         *        attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiMeasureAttributeMappings(Collection<MultiMeasureAttributeMapping> multiMeasureAttributeMappings);

        /**
         * <p>
         * Required. Attribute mappings to be used for mapping query results to ingest data for multi-measure
         * attributes.
         * </p>
         * 
         * @param multiMeasureAttributeMappings
         *        Required. Attribute mappings to be used for mapping query results to ingest data for multi-measure
         *        attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiMeasureAttributeMappings(MultiMeasureAttributeMapping... multiMeasureAttributeMappings);

        /**
         * <p>
         * Required. Attribute mappings to be used for mapping query results to ingest data for multi-measure
         * attributes.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.timestreamquery.model.MultiMeasureAttributeMapping.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.timestreamquery.model.MultiMeasureAttributeMapping#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.timestreamquery.model.MultiMeasureAttributeMapping.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #multiMeasureAttributeMappings(List<MultiMeasureAttributeMapping>)}.
         * 
         * @param multiMeasureAttributeMappings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.timestreamquery.model.MultiMeasureAttributeMapping.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #multiMeasureAttributeMappings(java.util.Collection<MultiMeasureAttributeMapping>)
         */
        Builder multiMeasureAttributeMappings(Consumer<MultiMeasureAttributeMapping.Builder>... multiMeasureAttributeMappings);
    }

    static final class BuilderImpl implements Builder {
        private String targetMultiMeasureName;

        private List<MultiMeasureAttributeMapping> multiMeasureAttributeMappings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MultiMeasureMappings model) {
            targetMultiMeasureName(model.targetMultiMeasureName);
            multiMeasureAttributeMappings(model.multiMeasureAttributeMappings);
        }

        public final String getTargetMultiMeasureName() {
            return targetMultiMeasureName;
        }

        public final void setTargetMultiMeasureName(String targetMultiMeasureName) {
            this.targetMultiMeasureName = targetMultiMeasureName;
        }

        @Override
        public final Builder targetMultiMeasureName(String targetMultiMeasureName) {
            this.targetMultiMeasureName = targetMultiMeasureName;
            return this;
        }

        public final List<MultiMeasureAttributeMapping.Builder> getMultiMeasureAttributeMappings() {
            List<MultiMeasureAttributeMapping.Builder> result = MultiMeasureAttributeMappingListCopier
                    .copyToBuilder(this.multiMeasureAttributeMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMultiMeasureAttributeMappings(
                Collection<MultiMeasureAttributeMapping.BuilderImpl> multiMeasureAttributeMappings) {
            this.multiMeasureAttributeMappings = MultiMeasureAttributeMappingListCopier
                    .copyFromBuilder(multiMeasureAttributeMappings);
        }

        @Override
        public final Builder multiMeasureAttributeMappings(Collection<MultiMeasureAttributeMapping> multiMeasureAttributeMappings) {
            this.multiMeasureAttributeMappings = MultiMeasureAttributeMappingListCopier.copy(multiMeasureAttributeMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder multiMeasureAttributeMappings(MultiMeasureAttributeMapping... multiMeasureAttributeMappings) {
            multiMeasureAttributeMappings(Arrays.asList(multiMeasureAttributeMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder multiMeasureAttributeMappings(
                Consumer<MultiMeasureAttributeMapping.Builder>... multiMeasureAttributeMappings) {
            multiMeasureAttributeMappings(Stream.of(multiMeasureAttributeMappings)
                    .map(c -> MultiMeasureAttributeMapping.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public MultiMeasureMappings build() {
            return new MultiMeasureMappings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
