/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.timestreamquery.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides insights into the table with the most sub-optimal spatial range scanned by your query.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class QuerySpatialCoverageMax implements SdkPojo, Serializable,
        ToCopyableBuilder<QuerySpatialCoverageMax.Builder, QuerySpatialCoverageMax> {
    private static final SdkField<Double> VALUE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("Value")
            .getter(getter(QuerySpatialCoverageMax::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final SdkField<String> TABLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TableArn").getter(getter(QuerySpatialCoverageMax::tableArn)).setter(setter(Builder::tableArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableArn").build()).build();

    private static final SdkField<List<String>> PARTITION_KEY_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("PartitionKey")
            .getter(getter(QuerySpatialCoverageMax::partitionKey))
            .setter(setter(Builder::partitionKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartitionKey").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUE_FIELD, TABLE_ARN_FIELD,
            PARTITION_KEY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Double value;

    private final String tableArn;

    private final List<String> partitionKey;

    private QuerySpatialCoverageMax(BuilderImpl builder) {
        this.value = builder.value;
        this.tableArn = builder.tableArn;
        this.partitionKey = builder.partitionKey;
    }

    /**
     * <p>
     * The maximum ratio of spatial coverage.
     * </p>
     * 
     * @return The maximum ratio of spatial coverage.
     */
    public final Double value() {
        return value;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the table with the most sub-optimal spatial pruning.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the table with the most sub-optimal spatial pruning.
     */
    public final String tableArn() {
        return tableArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the PartitionKey property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPartitionKey() {
        return partitionKey != null && !(partitionKey instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The partition key used for partitioning, which can be a default <code>measure_name</code> or a <a
     * href="https://docs.aws.amazon.com/timestream/latest/developerguide/customer-defined-partition-keys.html">customer
     * defined partition key</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPartitionKey} method.
     * </p>
     * 
     * @return The partition key used for partitioning, which can be a default <code>measure_name</code> or a <a
     *         href="https://docs.aws.amazon.com/timestream/latest/developerguide/customer-defined-partition-keys.html"
     *         >customer defined partition key</a>.
     */
    public final List<String> partitionKey() {
        return partitionKey;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(tableArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasPartitionKey() ? partitionKey() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QuerySpatialCoverageMax)) {
            return false;
        }
        QuerySpatialCoverageMax other = (QuerySpatialCoverageMax) obj;
        return Objects.equals(value(), other.value()) && Objects.equals(tableArn(), other.tableArn())
                && hasPartitionKey() == other.hasPartitionKey() && Objects.equals(partitionKey(), other.partitionKey());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("QuerySpatialCoverageMax").add("Value", value()).add("TableArn", tableArn())
                .add("PartitionKey", hasPartitionKey() ? partitionKey() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        case "TableArn":
            return Optional.ofNullable(clazz.cast(tableArn()));
        case "PartitionKey":
            return Optional.ofNullable(clazz.cast(partitionKey()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Value", VALUE_FIELD);
        map.put("TableArn", TABLE_ARN_FIELD);
        map.put("PartitionKey", PARTITION_KEY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<QuerySpatialCoverageMax, T> g) {
        return obj -> g.apply((QuerySpatialCoverageMax) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, QuerySpatialCoverageMax> {
        /**
         * <p>
         * The maximum ratio of spatial coverage.
         * </p>
         * 
         * @param value
         *        The maximum ratio of spatial coverage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(Double value);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the table with the most sub-optimal spatial pruning.
         * </p>
         * 
         * @param tableArn
         *        The Amazon Resource Name (ARN) of the table with the most sub-optimal spatial pruning.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableArn(String tableArn);

        /**
         * <p>
         * The partition key used for partitioning, which can be a default <code>measure_name</code> or a <a
         * href="https://docs.aws.amazon.com/timestream/latest/developerguide/customer-defined-partition-keys.html"
         * >customer defined partition key</a>.
         * </p>
         * 
         * @param partitionKey
         *        The partition key used for partitioning, which can be a default <code>measure_name</code> or a <a
         *        href=
         *        "https://docs.aws.amazon.com/timestream/latest/developerguide/customer-defined-partition-keys.html"
         *        >customer defined partition key</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partitionKey(Collection<String> partitionKey);

        /**
         * <p>
         * The partition key used for partitioning, which can be a default <code>measure_name</code> or a <a
         * href="https://docs.aws.amazon.com/timestream/latest/developerguide/customer-defined-partition-keys.html"
         * >customer defined partition key</a>.
         * </p>
         * 
         * @param partitionKey
         *        The partition key used for partitioning, which can be a default <code>measure_name</code> or a <a
         *        href=
         *        "https://docs.aws.amazon.com/timestream/latest/developerguide/customer-defined-partition-keys.html"
         *        >customer defined partition key</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partitionKey(String... partitionKey);
    }

    static final class BuilderImpl implements Builder {
        private Double value;

        private String tableArn;

        private List<String> partitionKey = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(QuerySpatialCoverageMax model) {
            value(model.value);
            tableArn(model.tableArn);
            partitionKey(model.partitionKey);
        }

        public final Double getValue() {
            return value;
        }

        public final void setValue(Double value) {
            this.value = value;
        }

        @Override
        public final Builder value(Double value) {
            this.value = value;
            return this;
        }

        public final String getTableArn() {
            return tableArn;
        }

        public final void setTableArn(String tableArn) {
            this.tableArn = tableArn;
        }

        @Override
        public final Builder tableArn(String tableArn) {
            this.tableArn = tableArn;
            return this;
        }

        public final Collection<String> getPartitionKey() {
            if (partitionKey instanceof SdkAutoConstructList) {
                return null;
            }
            return partitionKey;
        }

        public final void setPartitionKey(Collection<String> partitionKey) {
            this.partitionKey = PartitionKeyListCopier.copy(partitionKey);
        }

        @Override
        public final Builder partitionKey(Collection<String> partitionKey) {
            this.partitionKey = PartitionKeyListCopier.copy(partitionKey);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder partitionKey(String... partitionKey) {
            partitionKey(Arrays.asList(partitionKey));
            return this;
        }

        @Override
        public QuerySpatialCoverageMax build() {
            return new QuerySpatialCoverageMax(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
