/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.timestreamquery.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration object that contains the most recent account settings update, visible only if settings have been
 * updated previously.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LastUpdate implements SdkPojo, Serializable, ToCopyableBuilder<LastUpdate.Builder, LastUpdate> {
    private static final SdkField<Integer> TARGET_QUERY_TCU_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TargetQueryTCU").getter(getter(LastUpdate::targetQueryTCU)).setter(setter(Builder::targetQueryTCU))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetQueryTCU").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(LastUpdate::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusMessage").getter(getter(LastUpdate::statusMessage)).setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_QUERY_TCU_FIELD,
            STATUS_FIELD, STATUS_MESSAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer targetQueryTCU;

    private final String status;

    private final String statusMessage;

    private LastUpdate(BuilderImpl builder) {
        this.targetQueryTCU = builder.targetQueryTCU;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
    }

    /**
     * <p>
     * The number of TimeStream Compute Units (TCUs) requested in the last account settings update.
     * </p>
     * 
     * @return The number of TimeStream Compute Units (TCUs) requested in the last account settings update.
     */
    public final Integer targetQueryTCU() {
        return targetQueryTCU;
    }

    /**
     * <p>
     * The status of the last update. Can be either <code>PENDING</code>, <code>FAILED</code>, or <code>SUCCEEDED</code>
     * .
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link LastUpdateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the last update. Can be either <code>PENDING</code>, <code>FAILED</code>, or
     *         <code>SUCCEEDED</code>.
     * @see LastUpdateStatus
     */
    public final LastUpdateStatus status() {
        return LastUpdateStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the last update. Can be either <code>PENDING</code>, <code>FAILED</code>, or <code>SUCCEEDED</code>
     * .
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link LastUpdateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the last update. Can be either <code>PENDING</code>, <code>FAILED</code>, or
     *         <code>SUCCEEDED</code>.
     * @see LastUpdateStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Error message describing the last account settings update status, visible only if an error occurred.
     * </p>
     * 
     * @return Error message describing the last account settings update status, visible only if an error occurred.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(targetQueryTCU());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LastUpdate)) {
            return false;
        }
        LastUpdate other = (LastUpdate) obj;
        return Objects.equals(targetQueryTCU(), other.targetQueryTCU())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusMessage(), other.statusMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LastUpdate").add("TargetQueryTCU", targetQueryTCU()).add("Status", statusAsString())
                .add("StatusMessage", statusMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TargetQueryTCU":
            return Optional.ofNullable(clazz.cast(targetQueryTCU()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TargetQueryTCU", TARGET_QUERY_TCU_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatusMessage", STATUS_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LastUpdate, T> g) {
        return obj -> g.apply((LastUpdate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LastUpdate> {
        /**
         * <p>
         * The number of TimeStream Compute Units (TCUs) requested in the last account settings update.
         * </p>
         * 
         * @param targetQueryTCU
         *        The number of TimeStream Compute Units (TCUs) requested in the last account settings update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetQueryTCU(Integer targetQueryTCU);

        /**
         * <p>
         * The status of the last update. Can be either <code>PENDING</code>, <code>FAILED</code>, or
         * <code>SUCCEEDED</code>.
         * </p>
         * 
         * @param status
         *        The status of the last update. Can be either <code>PENDING</code>, <code>FAILED</code>, or
         *        <code>SUCCEEDED</code>.
         * @see LastUpdateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LastUpdateStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the last update. Can be either <code>PENDING</code>, <code>FAILED</code>, or
         * <code>SUCCEEDED</code>.
         * </p>
         * 
         * @param status
         *        The status of the last update. Can be either <code>PENDING</code>, <code>FAILED</code>, or
         *        <code>SUCCEEDED</code>.
         * @see LastUpdateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LastUpdateStatus
         */
        Builder status(LastUpdateStatus status);

        /**
         * <p>
         * Error message describing the last account settings update status, visible only if an error occurred.
         * </p>
         * 
         * @param statusMessage
         *        Error message describing the last account settings update status, visible only if an error occurred.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);
    }

    static final class BuilderImpl implements Builder {
        private Integer targetQueryTCU;

        private String status;

        private String statusMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(LastUpdate model) {
            targetQueryTCU(model.targetQueryTCU);
            status(model.status);
            statusMessage(model.statusMessage);
        }

        public final Integer getTargetQueryTCU() {
            return targetQueryTCU;
        }

        public final void setTargetQueryTCU(Integer targetQueryTCU) {
            this.targetQueryTCU = targetQueryTCU;
        }

        @Override
        public final Builder targetQueryTCU(Integer targetQueryTCU) {
            this.targetQueryTCU = targetQueryTCU;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(LastUpdateStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        @Override
        public LastUpdate build() {
            return new LastUpdate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
