/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.timestreamquery.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Datum represents a single data point in a query result.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Datum implements SdkPojo, Serializable, ToCopyableBuilder<Datum.Builder, Datum> {
    private static final SdkField<String> SCALAR_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ScalarValue").getter(getter(Datum::scalarValue)).setter(setter(Builder::scalarValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalarValue").build()).build();

    private static final SdkField<List<TimeSeriesDataPoint>> TIME_SERIES_VALUE_FIELD = SdkField
            .<List<TimeSeriesDataPoint>> builder(MarshallingType.LIST)
            .memberName("TimeSeriesValue")
            .getter(getter(Datum::timeSeriesValue))
            .setter(setter(Builder::timeSeriesValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeSeriesValue").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TimeSeriesDataPoint> builder(MarshallingType.SDK_POJO)
                                            .constructor(TimeSeriesDataPoint::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Datum>> ARRAY_VALUE_FIELD = SdkField
            .<List<Datum>> builder(MarshallingType.LIST)
            .memberName("ArrayValue")
            .getter(getter(Datum::arrayValue))
            .setter(setter(Builder::arrayValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArrayValue").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Datum> builder(MarshallingType.SDK_POJO)
                                            .constructor(Datum::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Row> ROW_VALUE_FIELD = SdkField.<Row> builder(MarshallingType.SDK_POJO).memberName("RowValue")
            .getter(getter(Datum::rowValue)).setter(setter(Builder::rowValue)).constructor(Row::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RowValue").build()).build();

    private static final SdkField<Boolean> NULL_VALUE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("NullValue").getter(getter(Datum::nullValue)).setter(setter(Builder::nullValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NullValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCALAR_VALUE_FIELD,
            TIME_SERIES_VALUE_FIELD, ARRAY_VALUE_FIELD, ROW_VALUE_FIELD, NULL_VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String scalarValue;

    private final List<TimeSeriesDataPoint> timeSeriesValue;

    private final List<Datum> arrayValue;

    private final Row rowValue;

    private final Boolean nullValue;

    private Datum(BuilderImpl builder) {
        this.scalarValue = builder.scalarValue;
        this.timeSeriesValue = builder.timeSeriesValue;
        this.arrayValue = builder.arrayValue;
        this.rowValue = builder.rowValue;
        this.nullValue = builder.nullValue;
    }

    /**
     * <p>
     * Indicates if the data point is a scalar value such as integer, string, double, or Boolean.
     * </p>
     * 
     * @return Indicates if the data point is a scalar value such as integer, string, double, or Boolean.
     */
    public final String scalarValue() {
        return scalarValue;
    }

    /**
     * For responses, this returns true if the service returned a value for the TimeSeriesValue property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTimeSeriesValue() {
        return timeSeriesValue != null && !(timeSeriesValue instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Indicates if the data point is a timeseries data type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTimeSeriesValue} method.
     * </p>
     * 
     * @return Indicates if the data point is a timeseries data type.
     */
    public final List<TimeSeriesDataPoint> timeSeriesValue() {
        return timeSeriesValue;
    }

    /**
     * For responses, this returns true if the service returned a value for the ArrayValue property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasArrayValue() {
        return arrayValue != null && !(arrayValue instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Indicates if the data point is an array.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasArrayValue} method.
     * </p>
     * 
     * @return Indicates if the data point is an array.
     */
    public final List<Datum> arrayValue() {
        return arrayValue;
    }

    /**
     * <p>
     * Indicates if the data point is a row.
     * </p>
     * 
     * @return Indicates if the data point is a row.
     */
    public final Row rowValue() {
        return rowValue;
    }

    /**
     * <p>
     * Indicates if the data point is null.
     * </p>
     * 
     * @return Indicates if the data point is null.
     */
    public final Boolean nullValue() {
        return nullValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(scalarValue());
        hashCode = 31 * hashCode + Objects.hashCode(hasTimeSeriesValue() ? timeSeriesValue() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasArrayValue() ? arrayValue() : null);
        hashCode = 31 * hashCode + Objects.hashCode(rowValue());
        hashCode = 31 * hashCode + Objects.hashCode(nullValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Datum)) {
            return false;
        }
        Datum other = (Datum) obj;
        return Objects.equals(scalarValue(), other.scalarValue()) && hasTimeSeriesValue() == other.hasTimeSeriesValue()
                && Objects.equals(timeSeriesValue(), other.timeSeriesValue()) && hasArrayValue() == other.hasArrayValue()
                && Objects.equals(arrayValue(), other.arrayValue()) && Objects.equals(rowValue(), other.rowValue())
                && Objects.equals(nullValue(), other.nullValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Datum").add("ScalarValue", scalarValue())
                .add("TimeSeriesValue", hasTimeSeriesValue() ? timeSeriesValue() : null)
                .add("ArrayValue", hasArrayValue() ? arrayValue() : null).add("RowValue", rowValue())
                .add("NullValue", nullValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ScalarValue":
            return Optional.ofNullable(clazz.cast(scalarValue()));
        case "TimeSeriesValue":
            return Optional.ofNullable(clazz.cast(timeSeriesValue()));
        case "ArrayValue":
            return Optional.ofNullable(clazz.cast(arrayValue()));
        case "RowValue":
            return Optional.ofNullable(clazz.cast(rowValue()));
        case "NullValue":
            return Optional.ofNullable(clazz.cast(nullValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ScalarValue", SCALAR_VALUE_FIELD);
        map.put("TimeSeriesValue", TIME_SERIES_VALUE_FIELD);
        map.put("ArrayValue", ARRAY_VALUE_FIELD);
        map.put("RowValue", ROW_VALUE_FIELD);
        map.put("NullValue", NULL_VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Datum, T> g) {
        return obj -> g.apply((Datum) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Datum> {
        /**
         * <p>
         * Indicates if the data point is a scalar value such as integer, string, double, or Boolean.
         * </p>
         * 
         * @param scalarValue
         *        Indicates if the data point is a scalar value such as integer, string, double, or Boolean.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scalarValue(String scalarValue);

        /**
         * <p>
         * Indicates if the data point is a timeseries data type.
         * </p>
         * 
         * @param timeSeriesValue
         *        Indicates if the data point is a timeseries data type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeSeriesValue(Collection<TimeSeriesDataPoint> timeSeriesValue);

        /**
         * <p>
         * Indicates if the data point is a timeseries data type.
         * </p>
         * 
         * @param timeSeriesValue
         *        Indicates if the data point is a timeseries data type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeSeriesValue(TimeSeriesDataPoint... timeSeriesValue);

        /**
         * <p>
         * Indicates if the data point is a timeseries data type.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.timestreamquery.model.TimeSeriesDataPoint.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.timestreamquery.model.TimeSeriesDataPoint#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.timestreamquery.model.TimeSeriesDataPoint.Builder#build()} is called
         * immediately and its result is passed to {@link #timeSeriesValue(List<TimeSeriesDataPoint>)}.
         * 
         * @param timeSeriesValue
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.timestreamquery.model.TimeSeriesDataPoint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timeSeriesValue(java.util.Collection<TimeSeriesDataPoint>)
         */
        Builder timeSeriesValue(Consumer<TimeSeriesDataPoint.Builder>... timeSeriesValue);

        /**
         * <p>
         * Indicates if the data point is an array.
         * </p>
         * 
         * @param arrayValue
         *        Indicates if the data point is an array.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arrayValue(Collection<Datum> arrayValue);

        /**
         * <p>
         * Indicates if the data point is an array.
         * </p>
         * 
         * @param arrayValue
         *        Indicates if the data point is an array.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arrayValue(Datum... arrayValue);

        /**
         * <p>
         * Indicates if the data point is an array.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.timestreamquery.model.Datum.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.timestreamquery.model.Datum#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.timestreamquery.model.Datum.Builder#build()} is called immediately and
         * its result is passed to {@link #arrayValue(List<Datum>)}.
         * 
         * @param arrayValue
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.timestreamquery.model.Datum.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #arrayValue(java.util.Collection<Datum>)
         */
        Builder arrayValue(Consumer<Builder>... arrayValue);

        /**
         * <p>
         * Indicates if the data point is a row.
         * </p>
         * 
         * @param rowValue
         *        Indicates if the data point is a row.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rowValue(Row rowValue);

        /**
         * <p>
         * Indicates if the data point is a row.
         * </p>
         * This is a convenience method that creates an instance of the {@link Row.Builder} avoiding the need to create
         * one manually via {@link Row#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Row.Builder#build()} is called immediately and its result is
         * passed to {@link #rowValue(Row)}.
         * 
         * @param rowValue
         *        a consumer that will call methods on {@link Row.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rowValue(Row)
         */
        default Builder rowValue(Consumer<Row.Builder> rowValue) {
            return rowValue(Row.builder().applyMutation(rowValue).build());
        }

        /**
         * <p>
         * Indicates if the data point is null.
         * </p>
         * 
         * @param nullValue
         *        Indicates if the data point is null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nullValue(Boolean nullValue);
    }

    static final class BuilderImpl implements Builder {
        private String scalarValue;

        private List<TimeSeriesDataPoint> timeSeriesValue = DefaultSdkAutoConstructList.getInstance();

        private List<Datum> arrayValue = DefaultSdkAutoConstructList.getInstance();

        private Row rowValue;

        private Boolean nullValue;

        private BuilderImpl() {
        }

        private BuilderImpl(Datum model) {
            scalarValue(model.scalarValue);
            timeSeriesValue(model.timeSeriesValue);
            arrayValue(model.arrayValue);
            rowValue(model.rowValue);
            nullValue(model.nullValue);
        }

        public final String getScalarValue() {
            return scalarValue;
        }

        public final void setScalarValue(String scalarValue) {
            this.scalarValue = scalarValue;
        }

        @Override
        public final Builder scalarValue(String scalarValue) {
            this.scalarValue = scalarValue;
            return this;
        }

        public final List<TimeSeriesDataPoint.Builder> getTimeSeriesValue() {
            List<TimeSeriesDataPoint.Builder> result = TimeSeriesDataPointListCopier.copyToBuilder(this.timeSeriesValue);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTimeSeriesValue(Collection<TimeSeriesDataPoint.BuilderImpl> timeSeriesValue) {
            this.timeSeriesValue = TimeSeriesDataPointListCopier.copyFromBuilder(timeSeriesValue);
        }

        @Override
        public final Builder timeSeriesValue(Collection<TimeSeriesDataPoint> timeSeriesValue) {
            this.timeSeriesValue = TimeSeriesDataPointListCopier.copy(timeSeriesValue);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder timeSeriesValue(TimeSeriesDataPoint... timeSeriesValue) {
            timeSeriesValue(Arrays.asList(timeSeriesValue));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder timeSeriesValue(Consumer<TimeSeriesDataPoint.Builder>... timeSeriesValue) {
            timeSeriesValue(Stream.of(timeSeriesValue).map(c -> TimeSeriesDataPoint.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<Builder> getArrayValue() {
            List<Builder> result = DatumListCopier.copyToBuilder(this.arrayValue);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setArrayValue(Collection<BuilderImpl> arrayValue) {
            this.arrayValue = DatumListCopier.copyFromBuilder(arrayValue);
        }

        @Override
        public final Builder arrayValue(Collection<Datum> arrayValue) {
            this.arrayValue = DatumListCopier.copy(arrayValue);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder arrayValue(Datum... arrayValue) {
            arrayValue(Arrays.asList(arrayValue));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder arrayValue(Consumer<Builder>... arrayValue) {
            arrayValue(Stream.of(arrayValue).map(c -> Datum.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Row.Builder getRowValue() {
            return rowValue != null ? rowValue.toBuilder() : null;
        }

        public final void setRowValue(Row.BuilderImpl rowValue) {
            this.rowValue = rowValue != null ? rowValue.build() : null;
        }

        @Override
        public final Builder rowValue(Row rowValue) {
            this.rowValue = rowValue;
            return this;
        }

        public final Boolean getNullValue() {
            return nullValue;
        }

        public final void setNullValue(Boolean nullValue) {
            this.nullValue = nullValue;
        }

        @Override
        public final Builder nullValue(Boolean nullValue) {
            this.nullValue = nullValue;
            return this;
        }

        @Override
        public Datum build() {
            return new Datum(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
