/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.timestreamquery;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.ClientEndpointProvider;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.endpointdiscovery.EndpointDiscoveryCacheLoader;
import software.amazon.awssdk.core.endpointdiscovery.EndpointDiscoveryRefreshCache;
import software.amazon.awssdk.core.endpointdiscovery.EndpointDiscoveryRequest;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.identity.spi.AwsCredentialsIdentity;
import software.amazon.awssdk.identity.spi.IdentityProvider;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.timestreamquery.TimestreamQueryClient;
import software.amazon.awssdk.services.timestreamquery.TimestreamQueryEndpointDiscoveryCacheLoader;
import software.amazon.awssdk.services.timestreamquery.TimestreamQueryServiceClientConfiguration;
import software.amazon.awssdk.services.timestreamquery.internal.TimestreamQueryServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.timestreamquery.model.AccessDeniedException;
import software.amazon.awssdk.services.timestreamquery.model.CancelQueryRequest;
import software.amazon.awssdk.services.timestreamquery.model.CancelQueryResponse;
import software.amazon.awssdk.services.timestreamquery.model.ConflictException;
import software.amazon.awssdk.services.timestreamquery.model.CreateScheduledQueryRequest;
import software.amazon.awssdk.services.timestreamquery.model.CreateScheduledQueryResponse;
import software.amazon.awssdk.services.timestreamquery.model.DeleteScheduledQueryRequest;
import software.amazon.awssdk.services.timestreamquery.model.DeleteScheduledQueryResponse;
import software.amazon.awssdk.services.timestreamquery.model.DescribeAccountSettingsRequest;
import software.amazon.awssdk.services.timestreamquery.model.DescribeAccountSettingsResponse;
import software.amazon.awssdk.services.timestreamquery.model.DescribeEndpointsRequest;
import software.amazon.awssdk.services.timestreamquery.model.DescribeEndpointsResponse;
import software.amazon.awssdk.services.timestreamquery.model.DescribeScheduledQueryRequest;
import software.amazon.awssdk.services.timestreamquery.model.DescribeScheduledQueryResponse;
import software.amazon.awssdk.services.timestreamquery.model.ExecuteScheduledQueryRequest;
import software.amazon.awssdk.services.timestreamquery.model.ExecuteScheduledQueryResponse;
import software.amazon.awssdk.services.timestreamquery.model.InternalServerException;
import software.amazon.awssdk.services.timestreamquery.model.InvalidEndpointException;
import software.amazon.awssdk.services.timestreamquery.model.ListScheduledQueriesRequest;
import software.amazon.awssdk.services.timestreamquery.model.ListScheduledQueriesResponse;
import software.amazon.awssdk.services.timestreamquery.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.timestreamquery.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.timestreamquery.model.PrepareQueryRequest;
import software.amazon.awssdk.services.timestreamquery.model.PrepareQueryResponse;
import software.amazon.awssdk.services.timestreamquery.model.QueryExecutionException;
import software.amazon.awssdk.services.timestreamquery.model.QueryRequest;
import software.amazon.awssdk.services.timestreamquery.model.QueryResponse;
import software.amazon.awssdk.services.timestreamquery.model.ResourceNotFoundException;
import software.amazon.awssdk.services.timestreamquery.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.timestreamquery.model.TagResourceRequest;
import software.amazon.awssdk.services.timestreamquery.model.TagResourceResponse;
import software.amazon.awssdk.services.timestreamquery.model.ThrottlingException;
import software.amazon.awssdk.services.timestreamquery.model.TimestreamQueryException;
import software.amazon.awssdk.services.timestreamquery.model.UntagResourceRequest;
import software.amazon.awssdk.services.timestreamquery.model.UntagResourceResponse;
import software.amazon.awssdk.services.timestreamquery.model.UpdateAccountSettingsRequest;
import software.amazon.awssdk.services.timestreamquery.model.UpdateAccountSettingsResponse;
import software.amazon.awssdk.services.timestreamquery.model.UpdateScheduledQueryRequest;
import software.amazon.awssdk.services.timestreamquery.model.UpdateScheduledQueryResponse;
import software.amazon.awssdk.services.timestreamquery.model.ValidationException;
import software.amazon.awssdk.services.timestreamquery.transform.CancelQueryRequestMarshaller;
import software.amazon.awssdk.services.timestreamquery.transform.CreateScheduledQueryRequestMarshaller;
import software.amazon.awssdk.services.timestreamquery.transform.DeleteScheduledQueryRequestMarshaller;
import software.amazon.awssdk.services.timestreamquery.transform.DescribeAccountSettingsRequestMarshaller;
import software.amazon.awssdk.services.timestreamquery.transform.DescribeEndpointsRequestMarshaller;
import software.amazon.awssdk.services.timestreamquery.transform.DescribeScheduledQueryRequestMarshaller;
import software.amazon.awssdk.services.timestreamquery.transform.ExecuteScheduledQueryRequestMarshaller;
import software.amazon.awssdk.services.timestreamquery.transform.ListScheduledQueriesRequestMarshaller;
import software.amazon.awssdk.services.timestreamquery.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.timestreamquery.transform.PrepareQueryRequestMarshaller;
import software.amazon.awssdk.services.timestreamquery.transform.QueryRequestMarshaller;
import software.amazon.awssdk.services.timestreamquery.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.timestreamquery.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.timestreamquery.transform.UpdateAccountSettingsRequestMarshaller;
import software.amazon.awssdk.services.timestreamquery.transform.UpdateScheduledQueryRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultTimestreamQueryClient
implements TimestreamQueryClient {
    private static final Logger log = Logger.loggerFor(DefaultTimestreamQueryClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.AWS_JSON).build();
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;
    private EndpointDiscoveryRefreshCache endpointDiscoveryCache;

    protected DefaultTimestreamQueryClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"Timestream_Query#2.33.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
        if (((Boolean)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED)).booleanValue()) {
            this.endpointDiscoveryCache = EndpointDiscoveryRefreshCache.create((EndpointDiscoveryCacheLoader)TimestreamQueryEndpointDiscoveryCacheLoader.create(this));
            if (((ClientEndpointProvider)clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden()) {
                log.warn(() -> "Endpoint discovery is enabled for this client, and an endpoint override was also specified. This will disable endpoint discovery for methods that require it, instead using the specified endpoint override. This may or may not be what you intended.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CancelQueryResponse cancelQuery(CancelQueryRequest cancelQueryRequest) throws AccessDeniedException, InternalServerException, ThrottlingException, ValidationException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamQueryException {
        SdkClientConfiguration clientConfiguration;
        List<MetricPublisher> metricPublishers;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CancelQueryResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidEndpointException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEndpointException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEndpointException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "QueryExecutionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("QueryExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueryExecutionException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean endpointOverridden = ((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
        if (endpointOverridden) {
            endpointDiscoveryEnabled = false;
        } else if (!endpointDiscoveryEnabled) {
            throw new IllegalStateException("This operation requires endpoint discovery to be enabled, or for you to specify an endpoint override when the client is created.");
        }
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            CompletableFuture identityFuture = cancelQueryRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
            String key = ((AwsCredentialsIdentity)CompletableFutureUtils.joinLikeSync((CompletableFuture)identityFuture)).accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(true).defaultEndpoint(((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)cancelQueryRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultTimestreamQueryClient.resolveMetricPublishers(clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)cancelQueryRequest, this.clientConfiguration), cancelQueryRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Timestream Query");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CancelQuery");
            CancelQueryResponse cancelQueryResponse = (CancelQueryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CancelQuery").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)cancelQueryRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CancelQueryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return cancelQueryResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTimestreamQueryClient.lambda$cancelQuery$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateScheduledQueryResponse createScheduledQuery(CreateScheduledQueryRequest createScheduledQueryRequest) throws AccessDeniedException, ConflictException, InternalServerException, ServiceQuotaExceededException, ThrottlingException, ValidationException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamQueryException {
        SdkClientConfiguration clientConfiguration;
        List<MetricPublisher> metricPublishers;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateScheduledQueryResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidEndpointException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEndpointException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEndpointException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "QueryExecutionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("QueryExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueryExecutionException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean endpointOverridden = ((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
        if (endpointOverridden) {
            endpointDiscoveryEnabled = false;
        } else if (!endpointDiscoveryEnabled) {
            throw new IllegalStateException("This operation requires endpoint discovery to be enabled, or for you to specify an endpoint override when the client is created.");
        }
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            CompletableFuture identityFuture = createScheduledQueryRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
            String key = ((AwsCredentialsIdentity)CompletableFutureUtils.joinLikeSync((CompletableFuture)identityFuture)).accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(true).defaultEndpoint(((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)createScheduledQueryRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultTimestreamQueryClient.resolveMetricPublishers(clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createScheduledQueryRequest, this.clientConfiguration), createScheduledQueryRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Timestream Query");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateScheduledQuery");
            CreateScheduledQueryResponse createScheduledQueryResponse = (CreateScheduledQueryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateScheduledQuery").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createScheduledQueryRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateScheduledQueryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createScheduledQueryResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTimestreamQueryClient.lambda$createScheduledQuery$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteScheduledQueryResponse deleteScheduledQuery(DeleteScheduledQueryRequest deleteScheduledQueryRequest) throws AccessDeniedException, InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamQueryException {
        SdkClientConfiguration clientConfiguration;
        List<MetricPublisher> metricPublishers;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteScheduledQueryResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidEndpointException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEndpointException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEndpointException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "QueryExecutionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("QueryExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueryExecutionException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean endpointOverridden = ((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
        if (endpointOverridden) {
            endpointDiscoveryEnabled = false;
        } else if (!endpointDiscoveryEnabled) {
            throw new IllegalStateException("This operation requires endpoint discovery to be enabled, or for you to specify an endpoint override when the client is created.");
        }
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            CompletableFuture identityFuture = deleteScheduledQueryRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
            String key = ((AwsCredentialsIdentity)CompletableFutureUtils.joinLikeSync((CompletableFuture)identityFuture)).accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(true).defaultEndpoint(((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)deleteScheduledQueryRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultTimestreamQueryClient.resolveMetricPublishers(clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteScheduledQueryRequest, this.clientConfiguration), deleteScheduledQueryRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Timestream Query");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteScheduledQuery");
            DeleteScheduledQueryResponse deleteScheduledQueryResponse = (DeleteScheduledQueryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteScheduledQuery").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteScheduledQueryRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteScheduledQueryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteScheduledQueryResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTimestreamQueryClient.lambda$deleteScheduledQuery$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeAccountSettingsResponse describeAccountSettings(DescribeAccountSettingsRequest describeAccountSettingsRequest) throws AccessDeniedException, InternalServerException, ThrottlingException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamQueryException {
        SdkClientConfiguration clientConfiguration;
        List<MetricPublisher> metricPublishers;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeAccountSettingsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidEndpointException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEndpointException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEndpointException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "QueryExecutionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("QueryExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueryExecutionException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean endpointOverridden = ((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
        if (endpointOverridden) {
            endpointDiscoveryEnabled = false;
        } else if (!endpointDiscoveryEnabled) {
            throw new IllegalStateException("This operation requires endpoint discovery to be enabled, or for you to specify an endpoint override when the client is created.");
        }
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            CompletableFuture identityFuture = describeAccountSettingsRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
            String key = ((AwsCredentialsIdentity)CompletableFutureUtils.joinLikeSync((CompletableFuture)identityFuture)).accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(true).defaultEndpoint(((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)describeAccountSettingsRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultTimestreamQueryClient.resolveMetricPublishers(clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeAccountSettingsRequest, this.clientConfiguration), describeAccountSettingsRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Timestream Query");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeAccountSettings");
            DescribeAccountSettingsResponse describeAccountSettingsResponse = (DescribeAccountSettingsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAccountSettings").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeAccountSettingsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeAccountSettingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeAccountSettingsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTimestreamQueryClient.lambda$describeAccountSettings$12((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeEndpointsResponse describeEndpoints(DescribeEndpointsRequest describeEndpointsRequest) throws InternalServerException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException, TimestreamQueryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeEndpointsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidEndpointException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEndpointException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEndpointException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "QueryExecutionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("QueryExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueryExecutionException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeEndpointsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTimestreamQueryClient.resolveMetricPublishers(clientConfiguration, describeEndpointsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Timestream Query");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeEndpoints");
            DescribeEndpointsResponse describeEndpointsResponse = (DescribeEndpointsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEndpoints").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeEndpointsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeEndpointsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeEndpointsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTimestreamQueryClient.lambda$describeEndpoints$14((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeScheduledQueryResponse describeScheduledQuery(DescribeScheduledQueryRequest describeScheduledQueryRequest) throws AccessDeniedException, InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamQueryException {
        SdkClientConfiguration clientConfiguration;
        List<MetricPublisher> metricPublishers;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeScheduledQueryResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidEndpointException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEndpointException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEndpointException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "QueryExecutionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("QueryExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueryExecutionException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean endpointOverridden = ((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
        if (endpointOverridden) {
            endpointDiscoveryEnabled = false;
        } else if (!endpointDiscoveryEnabled) {
            throw new IllegalStateException("This operation requires endpoint discovery to be enabled, or for you to specify an endpoint override when the client is created.");
        }
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            CompletableFuture identityFuture = describeScheduledQueryRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
            String key = ((AwsCredentialsIdentity)CompletableFutureUtils.joinLikeSync((CompletableFuture)identityFuture)).accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(true).defaultEndpoint(((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)describeScheduledQueryRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultTimestreamQueryClient.resolveMetricPublishers(clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeScheduledQueryRequest, this.clientConfiguration), describeScheduledQueryRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Timestream Query");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeScheduledQuery");
            DescribeScheduledQueryResponse describeScheduledQueryResponse = (DescribeScheduledQueryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeScheduledQuery").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeScheduledQueryRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeScheduledQueryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeScheduledQueryResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTimestreamQueryClient.lambda$describeScheduledQuery$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecuteScheduledQueryResponse executeScheduledQuery(ExecuteScheduledQueryRequest executeScheduledQueryRequest) throws AccessDeniedException, InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamQueryException {
        SdkClientConfiguration clientConfiguration;
        List<MetricPublisher> metricPublishers;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ExecuteScheduledQueryResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidEndpointException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEndpointException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEndpointException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "QueryExecutionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("QueryExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueryExecutionException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean endpointOverridden = ((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
        if (endpointOverridden) {
            endpointDiscoveryEnabled = false;
        } else if (!endpointDiscoveryEnabled) {
            throw new IllegalStateException("This operation requires endpoint discovery to be enabled, or for you to specify an endpoint override when the client is created.");
        }
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            CompletableFuture identityFuture = executeScheduledQueryRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
            String key = ((AwsCredentialsIdentity)CompletableFutureUtils.joinLikeSync((CompletableFuture)identityFuture)).accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(true).defaultEndpoint(((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)executeScheduledQueryRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultTimestreamQueryClient.resolveMetricPublishers(clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)executeScheduledQueryRequest, this.clientConfiguration), executeScheduledQueryRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Timestream Query");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ExecuteScheduledQuery");
            ExecuteScheduledQueryResponse executeScheduledQueryResponse = (ExecuteScheduledQueryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ExecuteScheduledQuery").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)executeScheduledQueryRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ExecuteScheduledQueryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return executeScheduledQueryResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTimestreamQueryClient.lambda$executeScheduledQuery$20((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListScheduledQueriesResponse listScheduledQueries(ListScheduledQueriesRequest listScheduledQueriesRequest) throws AccessDeniedException, InternalServerException, ThrottlingException, ValidationException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamQueryException {
        SdkClientConfiguration clientConfiguration;
        List<MetricPublisher> metricPublishers;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListScheduledQueriesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidEndpointException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEndpointException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEndpointException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "QueryExecutionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("QueryExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueryExecutionException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean endpointOverridden = ((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
        if (endpointOverridden) {
            endpointDiscoveryEnabled = false;
        } else if (!endpointDiscoveryEnabled) {
            throw new IllegalStateException("This operation requires endpoint discovery to be enabled, or for you to specify an endpoint override when the client is created.");
        }
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            CompletableFuture identityFuture = listScheduledQueriesRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
            String key = ((AwsCredentialsIdentity)CompletableFutureUtils.joinLikeSync((CompletableFuture)identityFuture)).accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(true).defaultEndpoint(((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)listScheduledQueriesRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultTimestreamQueryClient.resolveMetricPublishers(clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listScheduledQueriesRequest, this.clientConfiguration), listScheduledQueriesRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Timestream Query");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListScheduledQueries");
            ListScheduledQueriesResponse listScheduledQueriesResponse = (ListScheduledQueriesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListScheduledQueries").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listScheduledQueriesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListScheduledQueriesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listScheduledQueriesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTimestreamQueryClient.lambda$listScheduledQueries$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws ResourceNotFoundException, ThrottlingException, ValidationException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamQueryException {
        SdkClientConfiguration clientConfiguration;
        List<MetricPublisher> metricPublishers;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidEndpointException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEndpointException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEndpointException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "QueryExecutionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("QueryExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueryExecutionException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean endpointOverridden = ((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
        if (endpointOverridden) {
            endpointDiscoveryEnabled = false;
        } else if (!endpointDiscoveryEnabled) {
            throw new IllegalStateException("This operation requires endpoint discovery to be enabled, or for you to specify an endpoint override when the client is created.");
        }
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            CompletableFuture identityFuture = listTagsForResourceRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
            String key = ((AwsCredentialsIdentity)CompletableFutureUtils.joinLikeSync((CompletableFuture)identityFuture)).accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(true).defaultEndpoint(((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)listTagsForResourceRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultTimestreamQueryClient.resolveMetricPublishers(clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTagsForResourceRequest, this.clientConfiguration), listTagsForResourceRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Timestream Query");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTimestreamQueryClient.lambda$listTagsForResource$26((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PrepareQueryResponse prepareQuery(PrepareQueryRequest prepareQueryRequest) throws AccessDeniedException, InternalServerException, ThrottlingException, ValidationException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamQueryException {
        SdkClientConfiguration clientConfiguration;
        List<MetricPublisher> metricPublishers;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PrepareQueryResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidEndpointException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEndpointException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEndpointException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "QueryExecutionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("QueryExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueryExecutionException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean endpointOverridden = ((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
        if (endpointOverridden) {
            endpointDiscoveryEnabled = false;
        } else if (!endpointDiscoveryEnabled) {
            throw new IllegalStateException("This operation requires endpoint discovery to be enabled, or for you to specify an endpoint override when the client is created.");
        }
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            CompletableFuture identityFuture = prepareQueryRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
            String key = ((AwsCredentialsIdentity)CompletableFutureUtils.joinLikeSync((CompletableFuture)identityFuture)).accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(true).defaultEndpoint(((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)prepareQueryRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultTimestreamQueryClient.resolveMetricPublishers(clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)prepareQueryRequest, this.clientConfiguration), prepareQueryRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Timestream Query");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PrepareQuery");
            PrepareQueryResponse prepareQueryResponse = (PrepareQueryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PrepareQuery").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)prepareQueryRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PrepareQueryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return prepareQueryResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTimestreamQueryClient.lambda$prepareQuery$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QueryResponse query(QueryRequest queryRequest) throws AccessDeniedException, ConflictException, InternalServerException, QueryExecutionException, ThrottlingException, ValidationException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamQueryException {
        SdkClientConfiguration clientConfiguration;
        List<MetricPublisher> metricPublishers;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, QueryResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidEndpointException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEndpointException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEndpointException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "QueryExecutionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("QueryExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueryExecutionException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean endpointOverridden = ((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
        if (endpointOverridden) {
            endpointDiscoveryEnabled = false;
        } else if (!endpointDiscoveryEnabled) {
            throw new IllegalStateException("This operation requires endpoint discovery to be enabled, or for you to specify an endpoint override when the client is created.");
        }
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            CompletableFuture identityFuture = queryRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
            String key = ((AwsCredentialsIdentity)CompletableFutureUtils.joinLikeSync((CompletableFuture)identityFuture)).accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(true).defaultEndpoint(((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)queryRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultTimestreamQueryClient.resolveMetricPublishers(clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)queryRequest, this.clientConfiguration), queryRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Timestream Query");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"Query");
            QueryResponse queryResponse = (QueryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("Query").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)queryRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new QueryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return queryResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTimestreamQueryClient.lambda$query$32((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ResourceNotFoundException, ServiceQuotaExceededException, ThrottlingException, ValidationException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamQueryException {
        SdkClientConfiguration clientConfiguration;
        List<MetricPublisher> metricPublishers;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidEndpointException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEndpointException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEndpointException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "QueryExecutionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("QueryExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueryExecutionException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean endpointOverridden = ((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
        if (endpointOverridden) {
            endpointDiscoveryEnabled = false;
        } else if (!endpointDiscoveryEnabled) {
            throw new IllegalStateException("This operation requires endpoint discovery to be enabled, or for you to specify an endpoint override when the client is created.");
        }
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            CompletableFuture identityFuture = tagResourceRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
            String key = ((AwsCredentialsIdentity)CompletableFutureUtils.joinLikeSync((CompletableFuture)identityFuture)).accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(true).defaultEndpoint(((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)tagResourceRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultTimestreamQueryClient.resolveMetricPublishers(clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)tagResourceRequest, this.clientConfiguration), tagResourceRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Timestream Query");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTimestreamQueryClient.lambda$tagResource$35((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ValidationException, ThrottlingException, ResourceNotFoundException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamQueryException {
        SdkClientConfiguration clientConfiguration;
        List<MetricPublisher> metricPublishers;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidEndpointException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEndpointException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEndpointException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "QueryExecutionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("QueryExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueryExecutionException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean endpointOverridden = ((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
        if (endpointOverridden) {
            endpointDiscoveryEnabled = false;
        } else if (!endpointDiscoveryEnabled) {
            throw new IllegalStateException("This operation requires endpoint discovery to be enabled, or for you to specify an endpoint override when the client is created.");
        }
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            CompletableFuture identityFuture = untagResourceRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
            String key = ((AwsCredentialsIdentity)CompletableFutureUtils.joinLikeSync((CompletableFuture)identityFuture)).accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(true).defaultEndpoint(((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)untagResourceRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultTimestreamQueryClient.resolveMetricPublishers(clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)untagResourceRequest, this.clientConfiguration), untagResourceRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Timestream Query");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTimestreamQueryClient.lambda$untagResource$38((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateAccountSettingsResponse updateAccountSettings(UpdateAccountSettingsRequest updateAccountSettingsRequest) throws AccessDeniedException, InternalServerException, ThrottlingException, ValidationException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamQueryException {
        SdkClientConfiguration clientConfiguration;
        List<MetricPublisher> metricPublishers;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateAccountSettingsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidEndpointException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEndpointException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEndpointException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "QueryExecutionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("QueryExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueryExecutionException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean endpointOverridden = ((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
        if (endpointOverridden) {
            endpointDiscoveryEnabled = false;
        } else if (!endpointDiscoveryEnabled) {
            throw new IllegalStateException("This operation requires endpoint discovery to be enabled, or for you to specify an endpoint override when the client is created.");
        }
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            CompletableFuture identityFuture = updateAccountSettingsRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
            String key = ((AwsCredentialsIdentity)CompletableFutureUtils.joinLikeSync((CompletableFuture)identityFuture)).accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(true).defaultEndpoint(((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)updateAccountSettingsRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultTimestreamQueryClient.resolveMetricPublishers(clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateAccountSettingsRequest, this.clientConfiguration), updateAccountSettingsRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Timestream Query");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateAccountSettings");
            UpdateAccountSettingsResponse updateAccountSettingsResponse = (UpdateAccountSettingsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateAccountSettings").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateAccountSettingsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateAccountSettingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateAccountSettingsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTimestreamQueryClient.lambda$updateAccountSettings$41((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateScheduledQueryResponse updateScheduledQuery(UpdateScheduledQueryRequest updateScheduledQueryRequest) throws AccessDeniedException, InternalServerException, ResourceNotFoundException, ThrottlingException, ValidationException, InvalidEndpointException, AwsServiceException, SdkClientException, TimestreamQueryException {
        SdkClientConfiguration clientConfiguration;
        List<MetricPublisher> metricPublishers;
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateScheduledQueryResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidEndpointException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEndpointException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEndpointException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "QueryExecutionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("QueryExecutionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueryExecutionException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
        boolean endpointOverridden = ((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).isEndpointOverridden();
        if (endpointOverridden) {
            endpointDiscoveryEnabled = false;
        } else if (!endpointDiscoveryEnabled) {
            throw new IllegalStateException("This operation requires endpoint discovery to be enabled, or for you to specify an endpoint override when the client is created.");
        }
        URI cachedEndpoint = null;
        if (endpointDiscoveryEnabled) {
            CompletableFuture identityFuture = updateScheduledQueryRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsIdentityProvider).orElseGet(() -> (IdentityProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER)).resolveIdentity();
            String key = ((AwsCredentialsIdentity)CompletableFutureUtils.joinLikeSync((CompletableFuture)identityFuture)).accessKeyId();
            EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(true).defaultEndpoint(((ClientEndpointProvider)this.clientConfiguration.option((ClientOption)SdkClientOption.CLIENT_ENDPOINT_PROVIDER)).clientEndpoint()).overrideConfiguration((RequestOverrideConfiguration)updateScheduledQueryRequest.overrideConfiguration().orElse(null)).build();
            cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
        }
        NoOpMetricCollector apiCallMetricCollector = (metricPublishers = DefaultTimestreamQueryClient.resolveMetricPublishers(clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateScheduledQueryRequest, this.clientConfiguration), updateScheduledQueryRequest.overrideConfiguration().orElse(null))).isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Timestream Query");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateScheduledQuery");
            UpdateScheduledQueryResponse updateScheduledQueryResponse = (UpdateScheduledQueryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateScheduledQuery").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).discoveredEndpoint(cachedEndpoint).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateScheduledQueryRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateScheduledQueryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateScheduledQueryResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTimestreamQueryClient.lambda$updateScheduledQuery$44((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    public final String serviceName() {
        return "timestream";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        TimestreamQueryServiceClientConfigurationBuilder serviceConfigBuilder = new TimestreamQueryServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(TimestreamQueryException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.0");
    }

    @Override
    public final TimestreamQueryServiceClientConfiguration serviceClientConfiguration() {
        return new TimestreamQueryServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateScheduledQuery$44(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateAccountSettings$41(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$38(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$query$32(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$prepareQuery$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$26(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listScheduledQueries$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$executeScheduledQuery$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeScheduledQuery$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeEndpoints$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeAccountSettings$12(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteScheduledQuery$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createScheduledQuery$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$cancelQuery$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

