/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.timestreamquery.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.timestreamquery.model.MultiMeasureAttributeMapping;
import software.amazon.awssdk.services.timestreamquery.model.MultiMeasureAttributeMappingListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MultiMeasureMappings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MultiMeasureMappings> {
    private static final SdkField<String> TARGET_MULTI_MEASURE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetMultiMeasureName").getter(MultiMeasureMappings.getter(MultiMeasureMappings::targetMultiMeasureName)).setter(MultiMeasureMappings.setter(Builder::targetMultiMeasureName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetMultiMeasureName").build()}).build();
    private static final SdkField<List<MultiMeasureAttributeMapping>> MULTI_MEASURE_ATTRIBUTE_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MultiMeasureAttributeMappings").getter(MultiMeasureMappings.getter(MultiMeasureMappings::multiMeasureAttributeMappings)).setter(MultiMeasureMappings.setter(Builder::multiMeasureAttributeMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiMeasureAttributeMappings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MultiMeasureAttributeMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_MULTI_MEASURE_NAME_FIELD, MULTI_MEASURE_ATTRIBUTE_MAPPINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MultiMeasureMappings.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String targetMultiMeasureName;
    private final List<MultiMeasureAttributeMapping> multiMeasureAttributeMappings;

    private MultiMeasureMappings(BuilderImpl builder) {
        this.targetMultiMeasureName = builder.targetMultiMeasureName;
        this.multiMeasureAttributeMappings = builder.multiMeasureAttributeMappings;
    }

    public final String targetMultiMeasureName() {
        return this.targetMultiMeasureName;
    }

    public final boolean hasMultiMeasureAttributeMappings() {
        return this.multiMeasureAttributeMappings != null && !(this.multiMeasureAttributeMappings instanceof SdkAutoConstructList);
    }

    public final List<MultiMeasureAttributeMapping> multiMeasureAttributeMappings() {
        return this.multiMeasureAttributeMappings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.targetMultiMeasureName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMultiMeasureAttributeMappings() ? this.multiMeasureAttributeMappings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MultiMeasureMappings)) {
            return false;
        }
        MultiMeasureMappings other = (MultiMeasureMappings)obj;
        return Objects.equals(this.targetMultiMeasureName(), other.targetMultiMeasureName()) && this.hasMultiMeasureAttributeMappings() == other.hasMultiMeasureAttributeMappings() && Objects.equals(this.multiMeasureAttributeMappings(), other.multiMeasureAttributeMappings());
    }

    public final String toString() {
        return ToString.builder((String)"MultiMeasureMappings").add("TargetMultiMeasureName", (Object)this.targetMultiMeasureName()).add("MultiMeasureAttributeMappings", this.hasMultiMeasureAttributeMappings() ? this.multiMeasureAttributeMappings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TargetMultiMeasureName": {
                return Optional.ofNullable(clazz.cast(this.targetMultiMeasureName()));
            }
            case "MultiMeasureAttributeMappings": {
                return Optional.ofNullable(clazz.cast(this.multiMeasureAttributeMappings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TargetMultiMeasureName", TARGET_MULTI_MEASURE_NAME_FIELD);
        map.put("MultiMeasureAttributeMappings", MULTI_MEASURE_ATTRIBUTE_MAPPINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MultiMeasureMappings, T> g) {
        return obj -> g.apply((MultiMeasureMappings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String targetMultiMeasureName;
        private List<MultiMeasureAttributeMapping> multiMeasureAttributeMappings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MultiMeasureMappings model) {
            this.targetMultiMeasureName(model.targetMultiMeasureName);
            this.multiMeasureAttributeMappings(model.multiMeasureAttributeMappings);
        }

        public final String getTargetMultiMeasureName() {
            return this.targetMultiMeasureName;
        }

        public final void setTargetMultiMeasureName(String targetMultiMeasureName) {
            this.targetMultiMeasureName = targetMultiMeasureName;
        }

        @Override
        public final Builder targetMultiMeasureName(String targetMultiMeasureName) {
            this.targetMultiMeasureName = targetMultiMeasureName;
            return this;
        }

        public final List<MultiMeasureAttributeMapping.Builder> getMultiMeasureAttributeMappings() {
            List<MultiMeasureAttributeMapping.Builder> result = MultiMeasureAttributeMappingListCopier.copyToBuilder(this.multiMeasureAttributeMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMultiMeasureAttributeMappings(Collection<MultiMeasureAttributeMapping.BuilderImpl> multiMeasureAttributeMappings) {
            this.multiMeasureAttributeMappings = MultiMeasureAttributeMappingListCopier.copyFromBuilder(multiMeasureAttributeMappings);
        }

        @Override
        public final Builder multiMeasureAttributeMappings(Collection<MultiMeasureAttributeMapping> multiMeasureAttributeMappings) {
            this.multiMeasureAttributeMappings = MultiMeasureAttributeMappingListCopier.copy(multiMeasureAttributeMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder multiMeasureAttributeMappings(MultiMeasureAttributeMapping ... multiMeasureAttributeMappings) {
            this.multiMeasureAttributeMappings(Arrays.asList(multiMeasureAttributeMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder multiMeasureAttributeMappings(Consumer<MultiMeasureAttributeMapping.Builder> ... multiMeasureAttributeMappings) {
            this.multiMeasureAttributeMappings(Stream.of(multiMeasureAttributeMappings).map(c -> (MultiMeasureAttributeMapping)((MultiMeasureAttributeMapping.Builder)MultiMeasureAttributeMapping.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public MultiMeasureMappings build() {
            return new MultiMeasureMappings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MultiMeasureMappings> {
        public Builder targetMultiMeasureName(String var1);

        public Builder multiMeasureAttributeMappings(Collection<MultiMeasureAttributeMapping> var1);

        public Builder multiMeasureAttributeMappings(MultiMeasureAttributeMapping ... var1);

        public Builder multiMeasureAttributeMappings(Consumer<MultiMeasureAttributeMapping.Builder> ... var1);
    }
}

