/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.timestreamquery.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeScheduledQueryResponse extends TimestreamQueryResponse implements
        ToCopyableBuilder<DescribeScheduledQueryResponse.Builder, DescribeScheduledQueryResponse> {
    private static final SdkField<ScheduledQueryDescription> SCHEDULED_QUERY_FIELD = SdkField
            .<ScheduledQueryDescription> builder(MarshallingType.SDK_POJO).memberName("ScheduledQuery")
            .getter(getter(DescribeScheduledQueryResponse::scheduledQuery)).setter(setter(Builder::scheduledQuery))
            .constructor(ScheduledQueryDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduledQuery").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEDULED_QUERY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final ScheduledQueryDescription scheduledQuery;

    private DescribeScheduledQueryResponse(BuilderImpl builder) {
        super(builder);
        this.scheduledQuery = builder.scheduledQuery;
    }

    /**
     * <p>
     * The scheduled query.
     * </p>
     * 
     * @return The scheduled query.
     */
    public final ScheduledQueryDescription scheduledQuery() {
        return scheduledQuery;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(scheduledQuery());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeScheduledQueryResponse)) {
            return false;
        }
        DescribeScheduledQueryResponse other = (DescribeScheduledQueryResponse) obj;
        return Objects.equals(scheduledQuery(), other.scheduledQuery());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeScheduledQueryResponse").add("ScheduledQuery", scheduledQuery()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ScheduledQuery":
            return Optional.ofNullable(clazz.cast(scheduledQuery()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ScheduledQuery", SCHEDULED_QUERY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeScheduledQueryResponse, T> g) {
        return obj -> g.apply((DescribeScheduledQueryResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends TimestreamQueryResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeScheduledQueryResponse> {
        /**
         * <p>
         * The scheduled query.
         * </p>
         * 
         * @param scheduledQuery
         *        The scheduled query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledQuery(ScheduledQueryDescription scheduledQuery);

        /**
         * <p>
         * The scheduled query.
         * </p>
         * This is a convenience method that creates an instance of the {@link ScheduledQueryDescription.Builder}
         * avoiding the need to create one manually via {@link ScheduledQueryDescription#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ScheduledQueryDescription.Builder#build()} is called immediately
         * and its result is passed to {@link #scheduledQuery(ScheduledQueryDescription)}.
         * 
         * @param scheduledQuery
         *        a consumer that will call methods on {@link ScheduledQueryDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scheduledQuery(ScheduledQueryDescription)
         */
        default Builder scheduledQuery(Consumer<ScheduledQueryDescription.Builder> scheduledQuery) {
            return scheduledQuery(ScheduledQueryDescription.builder().applyMutation(scheduledQuery).build());
        }
    }

    static final class BuilderImpl extends TimestreamQueryResponse.BuilderImpl implements Builder {
        private ScheduledQueryDescription scheduledQuery;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeScheduledQueryResponse model) {
            super(model);
            scheduledQuery(model.scheduledQuery);
        }

        public final ScheduledQueryDescription.Builder getScheduledQuery() {
            return scheduledQuery != null ? scheduledQuery.toBuilder() : null;
        }

        public final void setScheduledQuery(ScheduledQueryDescription.BuilderImpl scheduledQuery) {
            this.scheduledQuery = scheduledQuery != null ? scheduledQuery.build() : null;
        }

        @Override
        public final Builder scheduledQuery(ScheduledQueryDescription scheduledQuery) {
            this.scheduledQuery = scheduledQuery;
            return this;
        }

        @Override
        public DescribeScheduledQueryResponse build() {
            return new DescribeScheduledQueryResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
