/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.timestreamquery.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Statistics for a single scheduled query run.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExecutionStats implements SdkPojo, Serializable, ToCopyableBuilder<ExecutionStats.Builder, ExecutionStats> {
    private static final SdkField<Long> EXECUTION_TIME_IN_MILLIS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("ExecutionTimeInMillis").getter(getter(ExecutionStats::executionTimeInMillis))
            .setter(setter(Builder::executionTimeInMillis))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionTimeInMillis").build())
            .build();

    private static final SdkField<Long> DATA_WRITES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("DataWrites").getter(getter(ExecutionStats::dataWrites)).setter(setter(Builder::dataWrites))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataWrites").build()).build();

    private static final SdkField<Long> BYTES_METERED_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("BytesMetered").getter(getter(ExecutionStats::bytesMetered)).setter(setter(Builder::bytesMetered))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BytesMetered").build()).build();

    private static final SdkField<Long> CUMULATIVE_BYTES_SCANNED_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("CumulativeBytesScanned").getter(getter(ExecutionStats::cumulativeBytesScanned))
            .setter(setter(Builder::cumulativeBytesScanned))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CumulativeBytesScanned").build())
            .build();

    private static final SdkField<Long> RECORDS_INGESTED_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("RecordsIngested").getter(getter(ExecutionStats::recordsIngested))
            .setter(setter(Builder::recordsIngested))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecordsIngested").build()).build();

    private static final SdkField<Long> QUERY_RESULT_ROWS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("QueryResultRows").getter(getter(ExecutionStats::queryResultRows))
            .setter(setter(Builder::queryResultRows))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryResultRows").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            EXECUTION_TIME_IN_MILLIS_FIELD, DATA_WRITES_FIELD, BYTES_METERED_FIELD, CUMULATIVE_BYTES_SCANNED_FIELD,
            RECORDS_INGESTED_FIELD, QUERY_RESULT_ROWS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Long executionTimeInMillis;

    private final Long dataWrites;

    private final Long bytesMetered;

    private final Long cumulativeBytesScanned;

    private final Long recordsIngested;

    private final Long queryResultRows;

    private ExecutionStats(BuilderImpl builder) {
        this.executionTimeInMillis = builder.executionTimeInMillis;
        this.dataWrites = builder.dataWrites;
        this.bytesMetered = builder.bytesMetered;
        this.cumulativeBytesScanned = builder.cumulativeBytesScanned;
        this.recordsIngested = builder.recordsIngested;
        this.queryResultRows = builder.queryResultRows;
    }

    /**
     * <p>
     * Total time, measured in milliseconds, that was needed for the scheduled query run to complete.
     * </p>
     * 
     * @return Total time, measured in milliseconds, that was needed for the scheduled query run to complete.
     */
    public final Long executionTimeInMillis() {
        return executionTimeInMillis;
    }

    /**
     * <p>
     * Data writes metered for records ingested in a single scheduled query run.
     * </p>
     * 
     * @return Data writes metered for records ingested in a single scheduled query run.
     */
    public final Long dataWrites() {
        return dataWrites;
    }

    /**
     * <p>
     * Bytes metered for a single scheduled query run.
     * </p>
     * 
     * @return Bytes metered for a single scheduled query run.
     */
    public final Long bytesMetered() {
        return bytesMetered;
    }

    /**
     * <p>
     * Bytes scanned for a single scheduled query run.
     * </p>
     * 
     * @return Bytes scanned for a single scheduled query run.
     */
    public final Long cumulativeBytesScanned() {
        return cumulativeBytesScanned;
    }

    /**
     * <p>
     * The number of records ingested for a single scheduled query run.
     * </p>
     * 
     * @return The number of records ingested for a single scheduled query run.
     */
    public final Long recordsIngested() {
        return recordsIngested;
    }

    /**
     * <p>
     * Number of rows present in the output from running a query before ingestion to destination data source.
     * </p>
     * 
     * @return Number of rows present in the output from running a query before ingestion to destination data source.
     */
    public final Long queryResultRows() {
        return queryResultRows;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(executionTimeInMillis());
        hashCode = 31 * hashCode + Objects.hashCode(dataWrites());
        hashCode = 31 * hashCode + Objects.hashCode(bytesMetered());
        hashCode = 31 * hashCode + Objects.hashCode(cumulativeBytesScanned());
        hashCode = 31 * hashCode + Objects.hashCode(recordsIngested());
        hashCode = 31 * hashCode + Objects.hashCode(queryResultRows());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecutionStats)) {
            return false;
        }
        ExecutionStats other = (ExecutionStats) obj;
        return Objects.equals(executionTimeInMillis(), other.executionTimeInMillis())
                && Objects.equals(dataWrites(), other.dataWrites()) && Objects.equals(bytesMetered(), other.bytesMetered())
                && Objects.equals(cumulativeBytesScanned(), other.cumulativeBytesScanned())
                && Objects.equals(recordsIngested(), other.recordsIngested())
                && Objects.equals(queryResultRows(), other.queryResultRows());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExecutionStats").add("ExecutionTimeInMillis", executionTimeInMillis())
                .add("DataWrites", dataWrites()).add("BytesMetered", bytesMetered())
                .add("CumulativeBytesScanned", cumulativeBytesScanned()).add("RecordsIngested", recordsIngested())
                .add("QueryResultRows", queryResultRows()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ExecutionTimeInMillis":
            return Optional.ofNullable(clazz.cast(executionTimeInMillis()));
        case "DataWrites":
            return Optional.ofNullable(clazz.cast(dataWrites()));
        case "BytesMetered":
            return Optional.ofNullable(clazz.cast(bytesMetered()));
        case "CumulativeBytesScanned":
            return Optional.ofNullable(clazz.cast(cumulativeBytesScanned()));
        case "RecordsIngested":
            return Optional.ofNullable(clazz.cast(recordsIngested()));
        case "QueryResultRows":
            return Optional.ofNullable(clazz.cast(queryResultRows()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ExecutionTimeInMillis", EXECUTION_TIME_IN_MILLIS_FIELD);
        map.put("DataWrites", DATA_WRITES_FIELD);
        map.put("BytesMetered", BYTES_METERED_FIELD);
        map.put("CumulativeBytesScanned", CUMULATIVE_BYTES_SCANNED_FIELD);
        map.put("RecordsIngested", RECORDS_INGESTED_FIELD);
        map.put("QueryResultRows", QUERY_RESULT_ROWS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExecutionStats, T> g) {
        return obj -> g.apply((ExecutionStats) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExecutionStats> {
        /**
         * <p>
         * Total time, measured in milliseconds, that was needed for the scheduled query run to complete.
         * </p>
         * 
         * @param executionTimeInMillis
         *        Total time, measured in milliseconds, that was needed for the scheduled query run to complete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionTimeInMillis(Long executionTimeInMillis);

        /**
         * <p>
         * Data writes metered for records ingested in a single scheduled query run.
         * </p>
         * 
         * @param dataWrites
         *        Data writes metered for records ingested in a single scheduled query run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataWrites(Long dataWrites);

        /**
         * <p>
         * Bytes metered for a single scheduled query run.
         * </p>
         * 
         * @param bytesMetered
         *        Bytes metered for a single scheduled query run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bytesMetered(Long bytesMetered);

        /**
         * <p>
         * Bytes scanned for a single scheduled query run.
         * </p>
         * 
         * @param cumulativeBytesScanned
         *        Bytes scanned for a single scheduled query run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cumulativeBytesScanned(Long cumulativeBytesScanned);

        /**
         * <p>
         * The number of records ingested for a single scheduled query run.
         * </p>
         * 
         * @param recordsIngested
         *        The number of records ingested for a single scheduled query run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordsIngested(Long recordsIngested);

        /**
         * <p>
         * Number of rows present in the output from running a query before ingestion to destination data source.
         * </p>
         * 
         * @param queryResultRows
         *        Number of rows present in the output from running a query before ingestion to destination data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryResultRows(Long queryResultRows);
    }

    static final class BuilderImpl implements Builder {
        private Long executionTimeInMillis;

        private Long dataWrites;

        private Long bytesMetered;

        private Long cumulativeBytesScanned;

        private Long recordsIngested;

        private Long queryResultRows;

        private BuilderImpl() {
        }

        private BuilderImpl(ExecutionStats model) {
            executionTimeInMillis(model.executionTimeInMillis);
            dataWrites(model.dataWrites);
            bytesMetered(model.bytesMetered);
            cumulativeBytesScanned(model.cumulativeBytesScanned);
            recordsIngested(model.recordsIngested);
            queryResultRows(model.queryResultRows);
        }

        public final Long getExecutionTimeInMillis() {
            return executionTimeInMillis;
        }

        public final void setExecutionTimeInMillis(Long executionTimeInMillis) {
            this.executionTimeInMillis = executionTimeInMillis;
        }

        @Override
        public final Builder executionTimeInMillis(Long executionTimeInMillis) {
            this.executionTimeInMillis = executionTimeInMillis;
            return this;
        }

        public final Long getDataWrites() {
            return dataWrites;
        }

        public final void setDataWrites(Long dataWrites) {
            this.dataWrites = dataWrites;
        }

        @Override
        public final Builder dataWrites(Long dataWrites) {
            this.dataWrites = dataWrites;
            return this;
        }

        public final Long getBytesMetered() {
            return bytesMetered;
        }

        public final void setBytesMetered(Long bytesMetered) {
            this.bytesMetered = bytesMetered;
        }

        @Override
        public final Builder bytesMetered(Long bytesMetered) {
            this.bytesMetered = bytesMetered;
            return this;
        }

        public final Long getCumulativeBytesScanned() {
            return cumulativeBytesScanned;
        }

        public final void setCumulativeBytesScanned(Long cumulativeBytesScanned) {
            this.cumulativeBytesScanned = cumulativeBytesScanned;
        }

        @Override
        public final Builder cumulativeBytesScanned(Long cumulativeBytesScanned) {
            this.cumulativeBytesScanned = cumulativeBytesScanned;
            return this;
        }

        public final Long getRecordsIngested() {
            return recordsIngested;
        }

        public final void setRecordsIngested(Long recordsIngested) {
            this.recordsIngested = recordsIngested;
        }

        @Override
        public final Builder recordsIngested(Long recordsIngested) {
            this.recordsIngested = recordsIngested;
            return this;
        }

        public final Long getQueryResultRows() {
            return queryResultRows;
        }

        public final void setQueryResultRows(Long queryResultRows) {
            this.queryResultRows = queryResultRows;
        }

        @Override
        public final Builder queryResultRows(Long queryResultRows) {
            this.queryResultRows = queryResultRows;
            return this;
        }

        @Override
        public ExecutionStats build() {
            return new ExecutionStats(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
