/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.timestreamquery.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListScheduledQueriesResponse extends TimestreamQueryResponse implements
        ToCopyableBuilder<ListScheduledQueriesResponse.Builder, ListScheduledQueriesResponse> {
    private static final SdkField<List<ScheduledQuery>> SCHEDULED_QUERIES_FIELD = SdkField
            .<List<ScheduledQuery>> builder(MarshallingType.LIST)
            .memberName("ScheduledQueries")
            .getter(getter(ListScheduledQueriesResponse::scheduledQueries))
            .setter(setter(Builder::scheduledQueries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduledQueries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ScheduledQuery> builder(MarshallingType.SDK_POJO)
                                            .constructor(ScheduledQuery::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListScheduledQueriesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEDULED_QUERIES_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<ScheduledQuery> scheduledQueries;

    private final String nextToken;

    private ListScheduledQueriesResponse(BuilderImpl builder) {
        super(builder);
        this.scheduledQueries = builder.scheduledQueries;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ScheduledQueries property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasScheduledQueries() {
        return scheduledQueries != null && !(scheduledQueries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of scheduled queries.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasScheduledQueries} method.
     * </p>
     * 
     * @return A list of scheduled queries.
     */
    public final List<ScheduledQuery> scheduledQueries() {
        return scheduledQueries;
    }

    /**
     * <p>
     * A token to specify where to start paginating. This is the NextToken from a previously truncated response.
     * </p>
     * 
     * @return A token to specify where to start paginating. This is the NextToken from a previously truncated response.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasScheduledQueries() ? scheduledQueries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListScheduledQueriesResponse)) {
            return false;
        }
        ListScheduledQueriesResponse other = (ListScheduledQueriesResponse) obj;
        return hasScheduledQueries() == other.hasScheduledQueries()
                && Objects.equals(scheduledQueries(), other.scheduledQueries()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListScheduledQueriesResponse")
                .add("ScheduledQueries", hasScheduledQueries() ? scheduledQueries() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ScheduledQueries":
            return Optional.ofNullable(clazz.cast(scheduledQueries()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ScheduledQueries", SCHEDULED_QUERIES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListScheduledQueriesResponse, T> g) {
        return obj -> g.apply((ListScheduledQueriesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends TimestreamQueryResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListScheduledQueriesResponse> {
        /**
         * <p>
         * A list of scheduled queries.
         * </p>
         * 
         * @param scheduledQueries
         *        A list of scheduled queries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledQueries(Collection<ScheduledQuery> scheduledQueries);

        /**
         * <p>
         * A list of scheduled queries.
         * </p>
         * 
         * @param scheduledQueries
         *        A list of scheduled queries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledQueries(ScheduledQuery... scheduledQueries);

        /**
         * <p>
         * A list of scheduled queries.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.timestreamquery.model.ScheduledQuery.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.timestreamquery.model.ScheduledQuery#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.timestreamquery.model.ScheduledQuery.Builder#build()} is called
         * immediately and its result is passed to {@link #scheduledQueries(List<ScheduledQuery>)}.
         * 
         * @param scheduledQueries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.timestreamquery.model.ScheduledQuery.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scheduledQueries(java.util.Collection<ScheduledQuery>)
         */
        Builder scheduledQueries(Consumer<ScheduledQuery.Builder>... scheduledQueries);

        /**
         * <p>
         * A token to specify where to start paginating. This is the NextToken from a previously truncated response.
         * </p>
         * 
         * @param nextToken
         *        A token to specify where to start paginating. This is the NextToken from a previously truncated
         *        response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends TimestreamQueryResponse.BuilderImpl implements Builder {
        private List<ScheduledQuery> scheduledQueries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListScheduledQueriesResponse model) {
            super(model);
            scheduledQueries(model.scheduledQueries);
            nextToken(model.nextToken);
        }

        public final List<ScheduledQuery.Builder> getScheduledQueries() {
            List<ScheduledQuery.Builder> result = ScheduledQueryListCopier.copyToBuilder(this.scheduledQueries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setScheduledQueries(Collection<ScheduledQuery.BuilderImpl> scheduledQueries) {
            this.scheduledQueries = ScheduledQueryListCopier.copyFromBuilder(scheduledQueries);
        }

        @Override
        public final Builder scheduledQueries(Collection<ScheduledQuery> scheduledQueries) {
            this.scheduledQueries = ScheduledQueryListCopier.copy(scheduledQueries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scheduledQueries(ScheduledQuery... scheduledQueries) {
            scheduledQueries(Arrays.asList(scheduledQueries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scheduledQueries(Consumer<ScheduledQuery.Builder>... scheduledQueries) {
            scheduledQueries(Stream.of(scheduledQueries).map(c -> ScheduledQuery.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListScheduledQueriesResponse build() {
            return new ListScheduledQueriesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
