/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.timestreamquery.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A request to retrieve or update the compute capacity settings for querying data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class QueryComputeRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<QueryComputeRequest.Builder, QueryComputeRequest> {
    private static final SdkField<String> COMPUTE_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ComputeMode").getter(getter(QueryComputeRequest::computeModeAsString))
            .setter(setter(Builder::computeMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputeMode").build()).build();

    private static final SdkField<ProvisionedCapacityRequest> PROVISIONED_CAPACITY_FIELD = SdkField
            .<ProvisionedCapacityRequest> builder(MarshallingType.SDK_POJO).memberName("ProvisionedCapacity")
            .getter(getter(QueryComputeRequest::provisionedCapacity)).setter(setter(Builder::provisionedCapacity))
            .constructor(ProvisionedCapacityRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedCapacity").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPUTE_MODE_FIELD,
            PROVISIONED_CAPACITY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String computeMode;

    private final ProvisionedCapacityRequest provisionedCapacity;

    private QueryComputeRequest(BuilderImpl builder) {
        this.computeMode = builder.computeMode;
        this.provisionedCapacity = builder.provisionedCapacity;
    }

    /**
     * <p>
     * The mode in which Timestream Compute Units (TCUs) are allocated and utilized within an account. Note that in the
     * Asia Pacific (Mumbai) region, the API operation only recognizes the value <code>PROVISIONED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #computeMode} will
     * return {@link ComputeMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #computeModeAsString}.
     * </p>
     * 
     * @return The mode in which Timestream Compute Units (TCUs) are allocated and utilized within an account. Note that
     *         in the Asia Pacific (Mumbai) region, the API operation only recognizes the value <code>PROVISIONED</code>
     *         .
     * @see ComputeMode
     */
    public final ComputeMode computeMode() {
        return ComputeMode.fromValue(computeMode);
    }

    /**
     * <p>
     * The mode in which Timestream Compute Units (TCUs) are allocated and utilized within an account. Note that in the
     * Asia Pacific (Mumbai) region, the API operation only recognizes the value <code>PROVISIONED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #computeMode} will
     * return {@link ComputeMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #computeModeAsString}.
     * </p>
     * 
     * @return The mode in which Timestream Compute Units (TCUs) are allocated and utilized within an account. Note that
     *         in the Asia Pacific (Mumbai) region, the API operation only recognizes the value <code>PROVISIONED</code>
     *         .
     * @see ComputeMode
     */
    public final String computeModeAsString() {
        return computeMode;
    }

    /**
     * <p>
     * Configuration object that contains settings for provisioned Timestream Compute Units (TCUs) in your account.
     * </p>
     * 
     * @return Configuration object that contains settings for provisioned Timestream Compute Units (TCUs) in your
     *         account.
     */
    public final ProvisionedCapacityRequest provisionedCapacity() {
        return provisionedCapacity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(computeModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(provisionedCapacity());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryComputeRequest)) {
            return false;
        }
        QueryComputeRequest other = (QueryComputeRequest) obj;
        return Objects.equals(computeModeAsString(), other.computeModeAsString())
                && Objects.equals(provisionedCapacity(), other.provisionedCapacity());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("QueryComputeRequest").add("ComputeMode", computeModeAsString())
                .add("ProvisionedCapacity", provisionedCapacity()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ComputeMode":
            return Optional.ofNullable(clazz.cast(computeModeAsString()));
        case "ProvisionedCapacity":
            return Optional.ofNullable(clazz.cast(provisionedCapacity()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ComputeMode", COMPUTE_MODE_FIELD);
        map.put("ProvisionedCapacity", PROVISIONED_CAPACITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<QueryComputeRequest, T> g) {
        return obj -> g.apply((QueryComputeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, QueryComputeRequest> {
        /**
         * <p>
         * The mode in which Timestream Compute Units (TCUs) are allocated and utilized within an account. Note that in
         * the Asia Pacific (Mumbai) region, the API operation only recognizes the value <code>PROVISIONED</code>.
         * </p>
         * 
         * @param computeMode
         *        The mode in which Timestream Compute Units (TCUs) are allocated and utilized within an account. Note
         *        that in the Asia Pacific (Mumbai) region, the API operation only recognizes the value
         *        <code>PROVISIONED</code>.
         * @see ComputeMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComputeMode
         */
        Builder computeMode(String computeMode);

        /**
         * <p>
         * The mode in which Timestream Compute Units (TCUs) are allocated and utilized within an account. Note that in
         * the Asia Pacific (Mumbai) region, the API operation only recognizes the value <code>PROVISIONED</code>.
         * </p>
         * 
         * @param computeMode
         *        The mode in which Timestream Compute Units (TCUs) are allocated and utilized within an account. Note
         *        that in the Asia Pacific (Mumbai) region, the API operation only recognizes the value
         *        <code>PROVISIONED</code>.
         * @see ComputeMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComputeMode
         */
        Builder computeMode(ComputeMode computeMode);

        /**
         * <p>
         * Configuration object that contains settings for provisioned Timestream Compute Units (TCUs) in your account.
         * </p>
         * 
         * @param provisionedCapacity
         *        Configuration object that contains settings for provisioned Timestream Compute Units (TCUs) in your
         *        account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionedCapacity(ProvisionedCapacityRequest provisionedCapacity);

        /**
         * <p>
         * Configuration object that contains settings for provisioned Timestream Compute Units (TCUs) in your account.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProvisionedCapacityRequest.Builder}
         * avoiding the need to create one manually via {@link ProvisionedCapacityRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProvisionedCapacityRequest.Builder#build()} is called immediately
         * and its result is passed to {@link #provisionedCapacity(ProvisionedCapacityRequest)}.
         * 
         * @param provisionedCapacity
         *        a consumer that will call methods on {@link ProvisionedCapacityRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #provisionedCapacity(ProvisionedCapacityRequest)
         */
        default Builder provisionedCapacity(Consumer<ProvisionedCapacityRequest.Builder> provisionedCapacity) {
            return provisionedCapacity(ProvisionedCapacityRequest.builder().applyMutation(provisionedCapacity).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String computeMode;

        private ProvisionedCapacityRequest provisionedCapacity;

        private BuilderImpl() {
        }

        private BuilderImpl(QueryComputeRequest model) {
            computeMode(model.computeMode);
            provisionedCapacity(model.provisionedCapacity);
        }

        public final String getComputeMode() {
            return computeMode;
        }

        public final void setComputeMode(String computeMode) {
            this.computeMode = computeMode;
        }

        @Override
        public final Builder computeMode(String computeMode) {
            this.computeMode = computeMode;
            return this;
        }

        @Override
        public final Builder computeMode(ComputeMode computeMode) {
            this.computeMode(computeMode == null ? null : computeMode.toString());
            return this;
        }

        public final ProvisionedCapacityRequest.Builder getProvisionedCapacity() {
            return provisionedCapacity != null ? provisionedCapacity.toBuilder() : null;
        }

        public final void setProvisionedCapacity(ProvisionedCapacityRequest.BuilderImpl provisionedCapacity) {
            this.provisionedCapacity = provisionedCapacity != null ? provisionedCapacity.build() : null;
        }

        @Override
        public final Builder provisionedCapacity(ProvisionedCapacityRequest provisionedCapacity) {
            this.provisionedCapacity = provisionedCapacity;
            return this;
        }

        @Override
        public QueryComputeRequest build() {
            return new QueryComputeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
