/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.timestreamquery.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * <code>QueryInsights</code> is a performance tuning feature that helps you optimize your queries, reducing costs and
 * improving performance. With <code>QueryInsights</code>, you can assess the pruning efficiency of your queries and
 * identify areas for improvement to enhance query performance. With <code>QueryInsights</code>, you can also analyze
 * the effectiveness of your queries in terms of temporal and spatial pruning, and identify opportunities to improve
 * performance. Specifically, you can evaluate how well your queries use time-based and partition key-based indexing
 * strategies to optimize data retrieval. To optimize query performance, it's essential that you fine-tune both the
 * temporal and spatial parameters that govern query execution.
 * </p>
 * <p>
 * The key metrics provided by <code>QueryInsights</code> are <code>QuerySpatialCoverage</code> and
 * <code>QueryTemporalRange</code>. <code>QuerySpatialCoverage</code> indicates how much of the spatial axis the query
 * scans, with lower values being more efficient. <code>QueryTemporalRange</code> shows the time range scanned, with
 * narrower ranges being more performant.
 * </p>
 * <p>
 * <b>Benefits of QueryInsights</b>
 * </p>
 * <p>
 * The following are the key benefits of using <code>QueryInsights</code>:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <b>Identifying inefficient queries</b> – <code>QueryInsights</code> provides information on the time-based and
 * attribute-based pruning of the tables accessed by the query. This information helps you identify the tables that are
 * sub-optimally accessed.
 * </p>
 * </li>
 * <li>
 * <p>
 * <b>Optimizing your data model and partitioning</b> – You can use the <code>QueryInsights</code> information to access
 * and fine-tune your data model and partitioning strategy.
 * </p>
 * </li>
 * <li>
 * <p>
 * <b>Tuning queries</b> – <code>QueryInsights</code> highlights opportunities to use indexes more effectively.
 * </p>
 * </li>
 * </ul>
 * <note>
 * <p>
 * The maximum number of <code>Query</code> API requests you're allowed to make with <code>QueryInsights</code> enabled
 * is 1 query per second (QPS). If you exceed this query rate, it might result in throttling.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
public final class QueryInsights implements SdkPojo, Serializable, ToCopyableBuilder<QueryInsights.Builder, QueryInsights> {
    private static final SdkField<String> MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Mode")
            .getter(getter(QueryInsights::modeAsString)).setter(setter(Builder::mode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String mode;

    private QueryInsights(BuilderImpl builder) {
        this.mode = builder.mode;
    }

    /**
     * <p>
     * Provides the following modes to enable <code>QueryInsights</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ENABLED_WITH_RATE_CONTROL</code> – Enables <code>QueryInsights</code> for the queries being processed. This
     * mode also includes a rate control mechanism, which limits the <code>QueryInsights</code> feature to 1 query per
     * second (QPS).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DISABLED</code> – Disables <code>QueryInsights</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link QueryInsightsMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modeAsString}.
     * </p>
     * 
     * @return Provides the following modes to enable <code>QueryInsights</code>:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ENABLED_WITH_RATE_CONTROL</code> – Enables <code>QueryInsights</code> for the queries being
     *         processed. This mode also includes a rate control mechanism, which limits the <code>QueryInsights</code>
     *         feature to 1 query per second (QPS).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DISABLED</code> – Disables <code>QueryInsights</code>.
     *         </p>
     *         </li>
     * @see QueryInsightsMode
     */
    public final QueryInsightsMode mode() {
        return QueryInsightsMode.fromValue(mode);
    }

    /**
     * <p>
     * Provides the following modes to enable <code>QueryInsights</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ENABLED_WITH_RATE_CONTROL</code> – Enables <code>QueryInsights</code> for the queries being processed. This
     * mode also includes a rate control mechanism, which limits the <code>QueryInsights</code> feature to 1 query per
     * second (QPS).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DISABLED</code> – Disables <code>QueryInsights</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link QueryInsightsMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modeAsString}.
     * </p>
     * 
     * @return Provides the following modes to enable <code>QueryInsights</code>:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ENABLED_WITH_RATE_CONTROL</code> – Enables <code>QueryInsights</code> for the queries being
     *         processed. This mode also includes a rate control mechanism, which limits the <code>QueryInsights</code>
     *         feature to 1 query per second (QPS).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DISABLED</code> – Disables <code>QueryInsights</code>.
     *         </p>
     *         </li>
     * @see QueryInsightsMode
     */
    public final String modeAsString() {
        return mode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(modeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryInsights)) {
            return false;
        }
        QueryInsights other = (QueryInsights) obj;
        return Objects.equals(modeAsString(), other.modeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("QueryInsights").add("Mode", modeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Mode":
            return Optional.ofNullable(clazz.cast(modeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Mode", MODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<QueryInsights, T> g) {
        return obj -> g.apply((QueryInsights) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, QueryInsights> {
        /**
         * <p>
         * Provides the following modes to enable <code>QueryInsights</code>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ENABLED_WITH_RATE_CONTROL</code> – Enables <code>QueryInsights</code> for the queries being processed.
         * This mode also includes a rate control mechanism, which limits the <code>QueryInsights</code> feature to 1
         * query per second (QPS).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DISABLED</code> – Disables <code>QueryInsights</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param mode
         *        Provides the following modes to enable <code>QueryInsights</code>:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ENABLED_WITH_RATE_CONTROL</code> – Enables <code>QueryInsights</code> for the queries being
         *        processed. This mode also includes a rate control mechanism, which limits the
         *        <code>QueryInsights</code> feature to 1 query per second (QPS).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DISABLED</code> – Disables <code>QueryInsights</code>.
         *        </p>
         *        </li>
         * @see QueryInsightsMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueryInsightsMode
         */
        Builder mode(String mode);

        /**
         * <p>
         * Provides the following modes to enable <code>QueryInsights</code>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ENABLED_WITH_RATE_CONTROL</code> – Enables <code>QueryInsights</code> for the queries being processed.
         * This mode also includes a rate control mechanism, which limits the <code>QueryInsights</code> feature to 1
         * query per second (QPS).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DISABLED</code> – Disables <code>QueryInsights</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param mode
         *        Provides the following modes to enable <code>QueryInsights</code>:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ENABLED_WITH_RATE_CONTROL</code> – Enables <code>QueryInsights</code> for the queries being
         *        processed. This mode also includes a rate control mechanism, which limits the
         *        <code>QueryInsights</code> feature to 1 query per second (QPS).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DISABLED</code> – Disables <code>QueryInsights</code>.
         *        </p>
         *        </li>
         * @see QueryInsightsMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueryInsightsMode
         */
        Builder mode(QueryInsightsMode mode);
    }

    static final class BuilderImpl implements Builder {
        private String mode;

        private BuilderImpl() {
        }

        private BuilderImpl(QueryInsights model) {
            mode(model.mode);
        }

        public final String getMode() {
            return mode;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(QueryInsightsMode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        @Override
        public QueryInsights build() {
            return new QueryInsights(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
