/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.timestreamquery.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateScheduledQueryRequest extends TimestreamQueryRequest implements
        ToCopyableBuilder<CreateScheduledQueryRequest.Builder, CreateScheduledQueryRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateScheduledQueryRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> QUERY_STRING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QueryString").getter(getter(CreateScheduledQueryRequest::queryString))
            .setter(setter(Builder::queryString))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryString").build()).build();

    private static final SdkField<ScheduleConfiguration> SCHEDULE_CONFIGURATION_FIELD = SdkField
            .<ScheduleConfiguration> builder(MarshallingType.SDK_POJO).memberName("ScheduleConfiguration")
            .getter(getter(CreateScheduledQueryRequest::scheduleConfiguration)).setter(setter(Builder::scheduleConfiguration))
            .constructor(ScheduleConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleConfiguration").build())
            .build();

    private static final SdkField<NotificationConfiguration> NOTIFICATION_CONFIGURATION_FIELD = SdkField
            .<NotificationConfiguration> builder(MarshallingType.SDK_POJO).memberName("NotificationConfiguration")
            .getter(getter(CreateScheduledQueryRequest::notificationConfiguration))
            .setter(setter(Builder::notificationConfiguration)).constructor(NotificationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationConfiguration").build())
            .build();

    private static final SdkField<TargetConfiguration> TARGET_CONFIGURATION_FIELD = SdkField
            .<TargetConfiguration> builder(MarshallingType.SDK_POJO).memberName("TargetConfiguration")
            .getter(getter(CreateScheduledQueryRequest::targetConfiguration)).setter(setter(Builder::targetConfiguration))
            .constructor(TargetConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetConfiguration").build())
            .build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreateScheduledQueryRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> SCHEDULED_QUERY_EXECUTION_ROLE_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ScheduledQueryExecutionRoleArn")
            .getter(getter(CreateScheduledQueryRequest::scheduledQueryExecutionRoleArn))
            .setter(setter(Builder::scheduledQueryExecutionRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduledQueryExecutionRoleArn")
                    .build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateScheduledQueryRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(CreateScheduledQueryRequest::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final SdkField<ErrorReportConfiguration> ERROR_REPORT_CONFIGURATION_FIELD = SdkField
            .<ErrorReportConfiguration> builder(MarshallingType.SDK_POJO).memberName("ErrorReportConfiguration")
            .getter(getter(CreateScheduledQueryRequest::errorReportConfiguration))
            .setter(setter(Builder::errorReportConfiguration)).constructor(ErrorReportConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorReportConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            QUERY_STRING_FIELD, SCHEDULE_CONFIGURATION_FIELD, NOTIFICATION_CONFIGURATION_FIELD, TARGET_CONFIGURATION_FIELD,
            CLIENT_TOKEN_FIELD, SCHEDULED_QUERY_EXECUTION_ROLE_ARN_FIELD, TAGS_FIELD, KMS_KEY_ID_FIELD,
            ERROR_REPORT_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final String queryString;

    private final ScheduleConfiguration scheduleConfiguration;

    private final NotificationConfiguration notificationConfiguration;

    private final TargetConfiguration targetConfiguration;

    private final String clientToken;

    private final String scheduledQueryExecutionRoleArn;

    private final List<Tag> tags;

    private final String kmsKeyId;

    private final ErrorReportConfiguration errorReportConfiguration;

    private CreateScheduledQueryRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.queryString = builder.queryString;
        this.scheduleConfiguration = builder.scheduleConfiguration;
        this.notificationConfiguration = builder.notificationConfiguration;
        this.targetConfiguration = builder.targetConfiguration;
        this.clientToken = builder.clientToken;
        this.scheduledQueryExecutionRoleArn = builder.scheduledQueryExecutionRoleArn;
        this.tags = builder.tags;
        this.kmsKeyId = builder.kmsKeyId;
        this.errorReportConfiguration = builder.errorReportConfiguration;
    }

    /**
     * <p>
     * Name of the scheduled query.
     * </p>
     * 
     * @return Name of the scheduled query.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The query string to run. Parameter names can be specified in the query string <code>@</code> character followed
     * by an identifier. The named Parameter <code>@scheduled_runtime</code> is reserved and can be used in the query to
     * get the time at which the query is scheduled to run.
     * </p>
     * <p>
     * The timestamp calculated according to the ScheduleConfiguration parameter, will be the value of
     * <code>@scheduled_runtime</code> paramater for each query run. For example, consider an instance of a scheduled
     * query executing on 2021-12-01 00:00:00. For this instance, the <code>@scheduled_runtime</code> parameter is
     * initialized to the timestamp 2021-12-01 00:00:00 when invoking the query.
     * </p>
     * 
     * @return The query string to run. Parameter names can be specified in the query string <code>@</code> character
     *         followed by an identifier. The named Parameter <code>@scheduled_runtime</code> is reserved and can be
     *         used in the query to get the time at which the query is scheduled to run.</p>
     *         <p>
     *         The timestamp calculated according to the ScheduleConfiguration parameter, will be the value of
     *         <code>@scheduled_runtime</code> paramater for each query run. For example, consider an instance of a
     *         scheduled query executing on 2021-12-01 00:00:00. For this instance, the <code>@scheduled_runtime</code>
     *         parameter is initialized to the timestamp 2021-12-01 00:00:00 when invoking the query.
     */
    public final String queryString() {
        return queryString;
    }

    /**
     * <p>
     * The schedule configuration for the query.
     * </p>
     * 
     * @return The schedule configuration for the query.
     */
    public final ScheduleConfiguration scheduleConfiguration() {
        return scheduleConfiguration;
    }

    /**
     * <p>
     * Notification configuration for the scheduled query. A notification is sent by Timestream when a query run
     * finishes, when the state is updated or when you delete it.
     * </p>
     * 
     * @return Notification configuration for the scheduled query. A notification is sent by Timestream when a query run
     *         finishes, when the state is updated or when you delete it.
     */
    public final NotificationConfiguration notificationConfiguration() {
        return notificationConfiguration;
    }

    /**
     * <p>
     * Configuration used for writing the result of a query.
     * </p>
     * 
     * @return Configuration used for writing the result of a query.
     */
    public final TargetConfiguration targetConfiguration() {
        return targetConfiguration;
    }

    /**
     * <p>
     * Using a ClientToken makes the call to CreateScheduledQuery idempotent, in other words, making the same request
     * repeatedly will produce the same result. Making multiple identical CreateScheduledQuery requests has the same
     * effect as making a single request.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If CreateScheduledQuery is called without a <code>ClientToken</code>, the Query SDK generates a
     * <code>ClientToken</code> on your behalf.
     * </p>
     * </li>
     * <li>
     * <p>
     * After 8 hours, any request with the same <code>ClientToken</code> is treated as a new request.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Using a ClientToken makes the call to CreateScheduledQuery idempotent, in other words, making the same
     *         request repeatedly will produce the same result. Making multiple identical CreateScheduledQuery requests
     *         has the same effect as making a single request. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If CreateScheduledQuery is called without a <code>ClientToken</code>, the Query SDK generates a
     *         <code>ClientToken</code> on your behalf.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         After 8 hours, any request with the same <code>ClientToken</code> is treated as a new request.
     *         </p>
     *         </li>
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The ARN for the IAM role that Timestream will assume when running the scheduled query.
     * </p>
     * 
     * @return The ARN for the IAM role that Timestream will assume when running the scheduled query.
     */
    public final String scheduledQueryExecutionRoleArn() {
        return scheduledQueryExecutionRoleArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of key-value pairs to label the scheduled query.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of key-value pairs to label the scheduled query.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The Amazon KMS key used to encrypt the scheduled query resource, at-rest. If the Amazon KMS key is not specified,
     * the scheduled query resource will be encrypted with a Timestream owned Amazon KMS key. To specify a KMS key, use
     * the key ID, key ARN, alias name, or alias ARN. When using an alias name, prefix the name with <i>alias/</i>
     * </p>
     * <p>
     * If ErrorReportConfiguration uses <code>SSE_KMS</code> as encryption type, the same KmsKeyId is used to encrypt
     * the error report at rest.
     * </p>
     * 
     * @return The Amazon KMS key used to encrypt the scheduled query resource, at-rest. If the Amazon KMS key is not
     *         specified, the scheduled query resource will be encrypted with a Timestream owned Amazon KMS key. To
     *         specify a KMS key, use the key ID, key ARN, alias name, or alias ARN. When using an alias name, prefix
     *         the name with <i>alias/</i> </p>
     *         <p>
     *         If ErrorReportConfiguration uses <code>SSE_KMS</code> as encryption type, the same KmsKeyId is used to
     *         encrypt the error report at rest.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * Configuration for error reporting. Error reports will be generated when a problem is encountered when writing the
     * query results.
     * </p>
     * 
     * @return Configuration for error reporting. Error reports will be generated when a problem is encountered when
     *         writing the query results.
     */
    public final ErrorReportConfiguration errorReportConfiguration() {
        return errorReportConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(queryString());
        hashCode = 31 * hashCode + Objects.hashCode(scheduleConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(notificationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(targetConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(scheduledQueryExecutionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(errorReportConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateScheduledQueryRequest)) {
            return false;
        }
        CreateScheduledQueryRequest other = (CreateScheduledQueryRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(queryString(), other.queryString())
                && Objects.equals(scheduleConfiguration(), other.scheduleConfiguration())
                && Objects.equals(notificationConfiguration(), other.notificationConfiguration())
                && Objects.equals(targetConfiguration(), other.targetConfiguration())
                && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(scheduledQueryExecutionRoleArn(), other.scheduledQueryExecutionRoleArn())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(kmsKeyId(), other.kmsKeyId())
                && Objects.equals(errorReportConfiguration(), other.errorReportConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateScheduledQueryRequest").add("Name", name())
                .add("QueryString", queryString() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ScheduleConfiguration", scheduleConfiguration())
                .add("NotificationConfiguration", notificationConfiguration()).add("TargetConfiguration", targetConfiguration())
                .add("ClientToken", clientToken() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ScheduledQueryExecutionRoleArn", scheduledQueryExecutionRoleArn()).add("Tags", hasTags() ? tags() : null)
                .add("KmsKeyId", kmsKeyId()).add("ErrorReportConfiguration", errorReportConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "QueryString":
            return Optional.ofNullable(clazz.cast(queryString()));
        case "ScheduleConfiguration":
            return Optional.ofNullable(clazz.cast(scheduleConfiguration()));
        case "NotificationConfiguration":
            return Optional.ofNullable(clazz.cast(notificationConfiguration()));
        case "TargetConfiguration":
            return Optional.ofNullable(clazz.cast(targetConfiguration()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "ScheduledQueryExecutionRoleArn":
            return Optional.ofNullable(clazz.cast(scheduledQueryExecutionRoleArn()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "ErrorReportConfiguration":
            return Optional.ofNullable(clazz.cast(errorReportConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("QueryString", QUERY_STRING_FIELD);
        map.put("ScheduleConfiguration", SCHEDULE_CONFIGURATION_FIELD);
        map.put("NotificationConfiguration", NOTIFICATION_CONFIGURATION_FIELD);
        map.put("TargetConfiguration", TARGET_CONFIGURATION_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("ScheduledQueryExecutionRoleArn", SCHEDULED_QUERY_EXECUTION_ROLE_ARN_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("KmsKeyId", KMS_KEY_ID_FIELD);
        map.put("ErrorReportConfiguration", ERROR_REPORT_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateScheduledQueryRequest, T> g) {
        return obj -> g.apply((CreateScheduledQueryRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends TimestreamQueryRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateScheduledQueryRequest> {
        /**
         * <p>
         * Name of the scheduled query.
         * </p>
         * 
         * @param name
         *        Name of the scheduled query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The query string to run. Parameter names can be specified in the query string <code>@</code> character
         * followed by an identifier. The named Parameter <code>@scheduled_runtime</code> is reserved and can be used in
         * the query to get the time at which the query is scheduled to run.
         * </p>
         * <p>
         * The timestamp calculated according to the ScheduleConfiguration parameter, will be the value of
         * <code>@scheduled_runtime</code> paramater for each query run. For example, consider an instance of a
         * scheduled query executing on 2021-12-01 00:00:00. For this instance, the <code>@scheduled_runtime</code>
         * parameter is initialized to the timestamp 2021-12-01 00:00:00 when invoking the query.
         * </p>
         * 
         * @param queryString
         *        The query string to run. Parameter names can be specified in the query string <code>@</code> character
         *        followed by an identifier. The named Parameter <code>@scheduled_runtime</code> is reserved and can be
         *        used in the query to get the time at which the query is scheduled to run.</p>
         *        <p>
         *        The timestamp calculated according to the ScheduleConfiguration parameter, will be the value of
         *        <code>@scheduled_runtime</code> paramater for each query run. For example, consider an instance of a
         *        scheduled query executing on 2021-12-01 00:00:00. For this instance, the
         *        <code>@scheduled_runtime</code> parameter is initialized to the timestamp 2021-12-01 00:00:00 when
         *        invoking the query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryString(String queryString);

        /**
         * <p>
         * The schedule configuration for the query.
         * </p>
         * 
         * @param scheduleConfiguration
         *        The schedule configuration for the query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduleConfiguration(ScheduleConfiguration scheduleConfiguration);

        /**
         * <p>
         * The schedule configuration for the query.
         * </p>
         * This is a convenience method that creates an instance of the {@link ScheduleConfiguration.Builder} avoiding
         * the need to create one manually via {@link ScheduleConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ScheduleConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #scheduleConfiguration(ScheduleConfiguration)}.
         * 
         * @param scheduleConfiguration
         *        a consumer that will call methods on {@link ScheduleConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scheduleConfiguration(ScheduleConfiguration)
         */
        default Builder scheduleConfiguration(Consumer<ScheduleConfiguration.Builder> scheduleConfiguration) {
            return scheduleConfiguration(ScheduleConfiguration.builder().applyMutation(scheduleConfiguration).build());
        }

        /**
         * <p>
         * Notification configuration for the scheduled query. A notification is sent by Timestream when a query run
         * finishes, when the state is updated or when you delete it.
         * </p>
         * 
         * @param notificationConfiguration
         *        Notification configuration for the scheduled query. A notification is sent by Timestream when a query
         *        run finishes, when the state is updated or when you delete it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationConfiguration(NotificationConfiguration notificationConfiguration);

        /**
         * <p>
         * Notification configuration for the scheduled query. A notification is sent by Timestream when a query run
         * finishes, when the state is updated or when you delete it.
         * </p>
         * This is a convenience method that creates an instance of the {@link NotificationConfiguration.Builder}
         * avoiding the need to create one manually via {@link NotificationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NotificationConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #notificationConfiguration(NotificationConfiguration)}.
         * 
         * @param notificationConfiguration
         *        a consumer that will call methods on {@link NotificationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #notificationConfiguration(NotificationConfiguration)
         */
        default Builder notificationConfiguration(Consumer<NotificationConfiguration.Builder> notificationConfiguration) {
            return notificationConfiguration(NotificationConfiguration.builder().applyMutation(notificationConfiguration).build());
        }

        /**
         * <p>
         * Configuration used for writing the result of a query.
         * </p>
         * 
         * @param targetConfiguration
         *        Configuration used for writing the result of a query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetConfiguration(TargetConfiguration targetConfiguration);

        /**
         * <p>
         * Configuration used for writing the result of a query.
         * </p>
         * This is a convenience method that creates an instance of the {@link TargetConfiguration.Builder} avoiding the
         * need to create one manually via {@link TargetConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TargetConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #targetConfiguration(TargetConfiguration)}.
         * 
         * @param targetConfiguration
         *        a consumer that will call methods on {@link TargetConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetConfiguration(TargetConfiguration)
         */
        default Builder targetConfiguration(Consumer<TargetConfiguration.Builder> targetConfiguration) {
            return targetConfiguration(TargetConfiguration.builder().applyMutation(targetConfiguration).build());
        }

        /**
         * <p>
         * Using a ClientToken makes the call to CreateScheduledQuery idempotent, in other words, making the same
         * request repeatedly will produce the same result. Making multiple identical CreateScheduledQuery requests has
         * the same effect as making a single request.
         * </p>
         * <ul>
         * <li>
         * <p>
         * If CreateScheduledQuery is called without a <code>ClientToken</code>, the Query SDK generates a
         * <code>ClientToken</code> on your behalf.
         * </p>
         * </li>
         * <li>
         * <p>
         * After 8 hours, any request with the same <code>ClientToken</code> is treated as a new request.
         * </p>
         * </li>
         * </ul>
         * 
         * @param clientToken
         *        Using a ClientToken makes the call to CreateScheduledQuery idempotent, in other words, making the same
         *        request repeatedly will produce the same result. Making multiple identical CreateScheduledQuery
         *        requests has the same effect as making a single request. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If CreateScheduledQuery is called without a <code>ClientToken</code>, the Query SDK generates a
         *        <code>ClientToken</code> on your behalf.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        After 8 hours, any request with the same <code>ClientToken</code> is treated as a new request.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The ARN for the IAM role that Timestream will assume when running the scheduled query.
         * </p>
         * 
         * @param scheduledQueryExecutionRoleArn
         *        The ARN for the IAM role that Timestream will assume when running the scheduled query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledQueryExecutionRoleArn(String scheduledQueryExecutionRoleArn);

        /**
         * <p>
         * A list of key-value pairs to label the scheduled query.
         * </p>
         * 
         * @param tags
         *        A list of key-value pairs to label the scheduled query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of key-value pairs to label the scheduled query.
         * </p>
         * 
         * @param tags
         *        A list of key-value pairs to label the scheduled query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of key-value pairs to label the scheduled query.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.timestreamquery.model.Tag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.timestreamquery.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.timestreamquery.model.Tag.Builder#build()} is called immediately and
         * its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.timestreamquery.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The Amazon KMS key used to encrypt the scheduled query resource, at-rest. If the Amazon KMS key is not
         * specified, the scheduled query resource will be encrypted with a Timestream owned Amazon KMS key. To specify
         * a KMS key, use the key ID, key ARN, alias name, or alias ARN. When using an alias name, prefix the name with
         * <i>alias/</i>
         * </p>
         * <p>
         * If ErrorReportConfiguration uses <code>SSE_KMS</code> as encryption type, the same KmsKeyId is used to
         * encrypt the error report at rest.
         * </p>
         * 
         * @param kmsKeyId
         *        The Amazon KMS key used to encrypt the scheduled query resource, at-rest. If the Amazon KMS key is not
         *        specified, the scheduled query resource will be encrypted with a Timestream owned Amazon KMS key. To
         *        specify a KMS key, use the key ID, key ARN, alias name, or alias ARN. When using an alias name, prefix
         *        the name with <i>alias/</i> </p>
         *        <p>
         *        If ErrorReportConfiguration uses <code>SSE_KMS</code> as encryption type, the same KmsKeyId is used to
         *        encrypt the error report at rest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * Configuration for error reporting. Error reports will be generated when a problem is encountered when writing
         * the query results.
         * </p>
         * 
         * @param errorReportConfiguration
         *        Configuration for error reporting. Error reports will be generated when a problem is encountered when
         *        writing the query results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorReportConfiguration(ErrorReportConfiguration errorReportConfiguration);

        /**
         * <p>
         * Configuration for error reporting. Error reports will be generated when a problem is encountered when writing
         * the query results.
         * </p>
         * This is a convenience method that creates an instance of the {@link ErrorReportConfiguration.Builder}
         * avoiding the need to create one manually via {@link ErrorReportConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ErrorReportConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #errorReportConfiguration(ErrorReportConfiguration)}.
         * 
         * @param errorReportConfiguration
         *        a consumer that will call methods on {@link ErrorReportConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errorReportConfiguration(ErrorReportConfiguration)
         */
        default Builder errorReportConfiguration(Consumer<ErrorReportConfiguration.Builder> errorReportConfiguration) {
            return errorReportConfiguration(ErrorReportConfiguration.builder().applyMutation(errorReportConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends TimestreamQueryRequest.BuilderImpl implements Builder {
        private String name;

        private String queryString;

        private ScheduleConfiguration scheduleConfiguration;

        private NotificationConfiguration notificationConfiguration;

        private TargetConfiguration targetConfiguration;

        private String clientToken;

        private String scheduledQueryExecutionRoleArn;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String kmsKeyId;

        private ErrorReportConfiguration errorReportConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateScheduledQueryRequest model) {
            super(model);
            name(model.name);
            queryString(model.queryString);
            scheduleConfiguration(model.scheduleConfiguration);
            notificationConfiguration(model.notificationConfiguration);
            targetConfiguration(model.targetConfiguration);
            clientToken(model.clientToken);
            scheduledQueryExecutionRoleArn(model.scheduledQueryExecutionRoleArn);
            tags(model.tags);
            kmsKeyId(model.kmsKeyId);
            errorReportConfiguration(model.errorReportConfiguration);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getQueryString() {
            return queryString;
        }

        public final void setQueryString(String queryString) {
            this.queryString = queryString;
        }

        @Override
        public final Builder queryString(String queryString) {
            this.queryString = queryString;
            return this;
        }

        public final ScheduleConfiguration.Builder getScheduleConfiguration() {
            return scheduleConfiguration != null ? scheduleConfiguration.toBuilder() : null;
        }

        public final void setScheduleConfiguration(ScheduleConfiguration.BuilderImpl scheduleConfiguration) {
            this.scheduleConfiguration = scheduleConfiguration != null ? scheduleConfiguration.build() : null;
        }

        @Override
        public final Builder scheduleConfiguration(ScheduleConfiguration scheduleConfiguration) {
            this.scheduleConfiguration = scheduleConfiguration;
            return this;
        }

        public final NotificationConfiguration.Builder getNotificationConfiguration() {
            return notificationConfiguration != null ? notificationConfiguration.toBuilder() : null;
        }

        public final void setNotificationConfiguration(NotificationConfiguration.BuilderImpl notificationConfiguration) {
            this.notificationConfiguration = notificationConfiguration != null ? notificationConfiguration.build() : null;
        }

        @Override
        public final Builder notificationConfiguration(NotificationConfiguration notificationConfiguration) {
            this.notificationConfiguration = notificationConfiguration;
            return this;
        }

        public final TargetConfiguration.Builder getTargetConfiguration() {
            return targetConfiguration != null ? targetConfiguration.toBuilder() : null;
        }

        public final void setTargetConfiguration(TargetConfiguration.BuilderImpl targetConfiguration) {
            this.targetConfiguration = targetConfiguration != null ? targetConfiguration.build() : null;
        }

        @Override
        public final Builder targetConfiguration(TargetConfiguration targetConfiguration) {
            this.targetConfiguration = targetConfiguration;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getScheduledQueryExecutionRoleArn() {
            return scheduledQueryExecutionRoleArn;
        }

        public final void setScheduledQueryExecutionRoleArn(String scheduledQueryExecutionRoleArn) {
            this.scheduledQueryExecutionRoleArn = scheduledQueryExecutionRoleArn;
        }

        @Override
        public final Builder scheduledQueryExecutionRoleArn(String scheduledQueryExecutionRoleArn) {
            this.scheduledQueryExecutionRoleArn = scheduledQueryExecutionRoleArn;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final ErrorReportConfiguration.Builder getErrorReportConfiguration() {
            return errorReportConfiguration != null ? errorReportConfiguration.toBuilder() : null;
        }

        public final void setErrorReportConfiguration(ErrorReportConfiguration.BuilderImpl errorReportConfiguration) {
            this.errorReportConfiguration = errorReportConfiguration != null ? errorReportConfiguration.build() : null;
        }

        @Override
        public final Builder errorReportConfiguration(ErrorReportConfiguration errorReportConfiguration) {
            this.errorReportConfiguration = errorReportConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateScheduledQueryRequest build() {
            return new CreateScheduledQueryRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
