/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.timestreamquery.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This contains the location of the error report for a single scheduled query call.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ErrorReportLocation implements SdkPojo, Serializable,
        ToCopyableBuilder<ErrorReportLocation.Builder, ErrorReportLocation> {
    private static final SdkField<S3ReportLocation> S3_REPORT_LOCATION_FIELD = SdkField
            .<S3ReportLocation> builder(MarshallingType.SDK_POJO).memberName("S3ReportLocation")
            .getter(getter(ErrorReportLocation::s3ReportLocation)).setter(setter(Builder::s3ReportLocation))
            .constructor(S3ReportLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3ReportLocation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_REPORT_LOCATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final S3ReportLocation s3ReportLocation;

    private ErrorReportLocation(BuilderImpl builder) {
        this.s3ReportLocation = builder.s3ReportLocation;
    }

    /**
     * <p>
     * The S3 location where error reports are written.
     * </p>
     * 
     * @return The S3 location where error reports are written.
     */
    public final S3ReportLocation s3ReportLocation() {
        return s3ReportLocation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3ReportLocation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ErrorReportLocation)) {
            return false;
        }
        ErrorReportLocation other = (ErrorReportLocation) obj;
        return Objects.equals(s3ReportLocation(), other.s3ReportLocation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ErrorReportLocation").add("S3ReportLocation", s3ReportLocation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3ReportLocation":
            return Optional.ofNullable(clazz.cast(s3ReportLocation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("S3ReportLocation", S3_REPORT_LOCATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ErrorReportLocation, T> g) {
        return obj -> g.apply((ErrorReportLocation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ErrorReportLocation> {
        /**
         * <p>
         * The S3 location where error reports are written.
         * </p>
         * 
         * @param s3ReportLocation
         *        The S3 location where error reports are written.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3ReportLocation(S3ReportLocation s3ReportLocation);

        /**
         * <p>
         * The S3 location where error reports are written.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3ReportLocation.Builder} avoiding the
         * need to create one manually via {@link S3ReportLocation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3ReportLocation.Builder#build()} is called immediately and its
         * result is passed to {@link #s3ReportLocation(S3ReportLocation)}.
         * 
         * @param s3ReportLocation
         *        a consumer that will call methods on {@link S3ReportLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3ReportLocation(S3ReportLocation)
         */
        default Builder s3ReportLocation(Consumer<S3ReportLocation.Builder> s3ReportLocation) {
            return s3ReportLocation(S3ReportLocation.builder().applyMutation(s3ReportLocation).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private S3ReportLocation s3ReportLocation;

        private BuilderImpl() {
        }

        private BuilderImpl(ErrorReportLocation model) {
            s3ReportLocation(model.s3ReportLocation);
        }

        public final S3ReportLocation.Builder getS3ReportLocation() {
            return s3ReportLocation != null ? s3ReportLocation.toBuilder() : null;
        }

        public final void setS3ReportLocation(S3ReportLocation.BuilderImpl s3ReportLocation) {
            this.s3ReportLocation = s3ReportLocation != null ? s3ReportLocation.build() : null;
        }

        @Override
        public final Builder s3ReportLocation(S3ReportLocation s3ReportLocation) {
            this.s3ReportLocation = s3ReportLocation;
            return this;
        }

        @Override
        public ErrorReportLocation build() {
            return new ErrorReportLocation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
