/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.timestreamquery.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides insights into the table with the most sub-optimal temporal pruning scanned by your query.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class QueryTemporalRangeMax implements SdkPojo, Serializable,
        ToCopyableBuilder<QueryTemporalRangeMax.Builder, QueryTemporalRangeMax> {
    private static final SdkField<Long> VALUE_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Value")
            .getter(getter(QueryTemporalRangeMax::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final SdkField<String> TABLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TableArn").getter(getter(QueryTemporalRangeMax::tableArn)).setter(setter(Builder::tableArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUE_FIELD, TABLE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Long value;

    private final String tableArn;

    private QueryTemporalRangeMax(BuilderImpl builder) {
        this.value = builder.value;
        this.tableArn = builder.tableArn;
    }

    /**
     * <p>
     * The maximum duration in nanoseconds between the start and end of the query.
     * </p>
     * 
     * @return The maximum duration in nanoseconds between the start and end of the query.
     */
    public final Long value() {
        return value;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the table which is queried with the largest time range.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the table which is queried with the largest time range.
     */
    public final String tableArn() {
        return tableArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(tableArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryTemporalRangeMax)) {
            return false;
        }
        QueryTemporalRangeMax other = (QueryTemporalRangeMax) obj;
        return Objects.equals(value(), other.value()) && Objects.equals(tableArn(), other.tableArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("QueryTemporalRangeMax").add("Value", value()).add("TableArn", tableArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        case "TableArn":
            return Optional.ofNullable(clazz.cast(tableArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Value", VALUE_FIELD);
        map.put("TableArn", TABLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<QueryTemporalRangeMax, T> g) {
        return obj -> g.apply((QueryTemporalRangeMax) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, QueryTemporalRangeMax> {
        /**
         * <p>
         * The maximum duration in nanoseconds between the start and end of the query.
         * </p>
         * 
         * @param value
         *        The maximum duration in nanoseconds between the start and end of the query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(Long value);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the table which is queried with the largest time range.
         * </p>
         * 
         * @param tableArn
         *        The Amazon Resource Name (ARN) of the table which is queried with the largest time range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableArn(String tableArn);
    }

    static final class BuilderImpl implements Builder {
        private Long value;

        private String tableArn;

        private BuilderImpl() {
        }

        private BuilderImpl(QueryTemporalRangeMax model) {
            value(model.value);
            tableArn(model.tableArn);
        }

        public final Long getValue() {
            return value;
        }

        public final void setValue(Long value) {
            this.value = value;
        }

        @Override
        public final Builder value(Long value) {
            this.value = value;
            return this;
        }

        public final String getTableArn() {
            return tableArn;
        }

        public final void setTableArn(String tableArn) {
            this.tableArn = tableArn;
        }

        @Override
        public final Builder tableArn(String tableArn) {
            this.tableArn = tableArn;
            return this;
        }

        @Override
        public QueryTemporalRangeMax build() {
            return new QueryTemporalRangeMax(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
