/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.timestreamwrite.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * WriteRecords would throw this exception in the following cases:
 * </p>
 * <ul>
 * <li>
 * <p>
 * Records with duplicate data where there are multiple records with the same dimensions, timestamps, and measure names
 * but:
 * </p>
 * <ul>
 * <li>
 * <p>
 * Measure values are different
 * </p>
 * </li>
 * <li>
 * <p>
 * Version is not present in the request <i>or</i> the value of version in the new record is equal to or lower than the
 * existing value
 * </p>
 * </li>
 * </ul>
 * <p>
 * In this case, if Timestream rejects data, the <code>ExistingVersion</code> field in the <code>RejectedRecords</code>
 * response will indicate the current record’s version. To force an update, you can resend the request with a version
 * for the record set to a value greater than the <code>ExistingVersion</code>.
 * </p>
 * </li>
 * <li>
 * <p>
 * Records with timestamps that lie outside the retention duration of the memory store
 * </p>
 * </li>
 * <li>
 * <p>
 * Records with dimensions or measures that exceed the Timestream defined limits.
 * </p>
 * </li>
 * </ul>
 * <p>
 * For more information, see <a
 * href="https://docs.aws.amazon.com/timestream/latest/developerguide/ts-limits.html">Quotas</a> in the Timestream
 * Developer Guide.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RejectedRecordsException extends TimestreamWriteException implements
        ToCopyableBuilder<RejectedRecordsException.Builder, RejectedRecordsException> {
    private static final SdkField<List<RejectedRecord>> REJECTED_RECORDS_FIELD = SdkField
            .<List<RejectedRecord>> builder(MarshallingType.LIST)
            .memberName("RejectedRecords")
            .getter(getter(RejectedRecordsException::rejectedRecords))
            .setter(setter(Builder::rejectedRecords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RejectedRecords").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RejectedRecord> builder(MarshallingType.SDK_POJO)
                                            .constructor(RejectedRecord::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REJECTED_RECORDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<RejectedRecord> rejectedRecords;

    private RejectedRecordsException(BuilderImpl builder) {
        super(builder);
        this.rejectedRecords = builder.rejectedRecords;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * For responses, this returns true if the service returned a value for the RejectedRecords property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public boolean hasRejectedRecords() {
        return rejectedRecords != null && !(rejectedRecords instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the RejectedRecords property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRejectedRecords} method.
     * </p>
     * 
     * @return The value of the RejectedRecords property for this object.
     */
    public List<RejectedRecord> rejectedRecords() {
        return rejectedRecords;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RejectedRecordsException, T> g) {
        return obj -> g.apply((RejectedRecordsException) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RejectedRecordsException>,
            TimestreamWriteException.Builder {
        /**
         * Sets the value of the RejectedRecords property for this object.
         *
         * @param rejectedRecords
         *        The new value for the RejectedRecords property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rejectedRecords(Collection<RejectedRecord> rejectedRecords);

        /**
         * Sets the value of the RejectedRecords property for this object.
         *
         * @param rejectedRecords
         *        The new value for the RejectedRecords property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rejectedRecords(RejectedRecord... rejectedRecords);

        /**
         * Sets the value of the RejectedRecords property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.timestreamwrite.model.RejectedRecord.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.timestreamwrite.model.RejectedRecord#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.timestreamwrite.model.RejectedRecord.Builder#build()} is called
         * immediately and its result is passed to {@link #rejectedRecords(List<RejectedRecord>)}.
         * 
         * @param rejectedRecords
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.timestreamwrite.model.RejectedRecord.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rejectedRecords(java.util.Collection<RejectedRecord>)
         */
        Builder rejectedRecords(Consumer<RejectedRecord.Builder>... rejectedRecords);

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);
    }

    static final class BuilderImpl extends TimestreamWriteException.BuilderImpl implements Builder {
        private List<RejectedRecord> rejectedRecords = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RejectedRecordsException model) {
            super(model);
            rejectedRecords(model.rejectedRecords);
        }

        public final List<RejectedRecord.Builder> getRejectedRecords() {
            List<RejectedRecord.Builder> result = RejectedRecordsCopier.copyToBuilder(this.rejectedRecords);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRejectedRecords(Collection<RejectedRecord.BuilderImpl> rejectedRecords) {
            this.rejectedRecords = RejectedRecordsCopier.copyFromBuilder(rejectedRecords);
        }

        @Override
        public final Builder rejectedRecords(Collection<RejectedRecord> rejectedRecords) {
            this.rejectedRecords = RejectedRecordsCopier.copy(rejectedRecords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rejectedRecords(RejectedRecord... rejectedRecords) {
            rejectedRecords(Arrays.asList(rejectedRecords));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rejectedRecords(Consumer<RejectedRecord.Builder>... rejectedRecords) {
            rejectedRecords(Stream.of(rejectedRecords).map(c -> RejectedRecord.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public RejectedRecordsException build() {
            return new RejectedRecordsException(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
