/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.timestreamwrite.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Retention properties contain the duration for which your time series data must be stored in the magnetic store and
 * the memory store.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RetentionProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<RetentionProperties.Builder, RetentionProperties> {
    private static final SdkField<Long> MEMORY_STORE_RETENTION_PERIOD_IN_HOURS_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("MemoryStoreRetentionPeriodInHours")
            .getter(getter(RetentionProperties::memoryStoreRetentionPeriodInHours))
            .setter(setter(Builder::memoryStoreRetentionPeriodInHours))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemoryStoreRetentionPeriodInHours")
                    .build()).build();

    private static final SdkField<Long> MAGNETIC_STORE_RETENTION_PERIOD_IN_DAYS_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("MagneticStoreRetentionPeriodInDays")
            .getter(getter(RetentionProperties::magneticStoreRetentionPeriodInDays))
            .setter(setter(Builder::magneticStoreRetentionPeriodInDays))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MagneticStoreRetentionPeriodInDays")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            MEMORY_STORE_RETENTION_PERIOD_IN_HOURS_FIELD, MAGNETIC_STORE_RETENTION_PERIOD_IN_DAYS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long memoryStoreRetentionPeriodInHours;

    private final Long magneticStoreRetentionPeriodInDays;

    private RetentionProperties(BuilderImpl builder) {
        this.memoryStoreRetentionPeriodInHours = builder.memoryStoreRetentionPeriodInHours;
        this.magneticStoreRetentionPeriodInDays = builder.magneticStoreRetentionPeriodInDays;
    }

    /**
     * <p>
     * The duration for which data must be stored in the memory store.
     * </p>
     * 
     * @return The duration for which data must be stored in the memory store.
     */
    public final Long memoryStoreRetentionPeriodInHours() {
        return memoryStoreRetentionPeriodInHours;
    }

    /**
     * <p>
     * The duration for which data must be stored in the magnetic store.
     * </p>
     * 
     * @return The duration for which data must be stored in the magnetic store.
     */
    public final Long magneticStoreRetentionPeriodInDays() {
        return magneticStoreRetentionPeriodInDays;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(memoryStoreRetentionPeriodInHours());
        hashCode = 31 * hashCode + Objects.hashCode(magneticStoreRetentionPeriodInDays());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RetentionProperties)) {
            return false;
        }
        RetentionProperties other = (RetentionProperties) obj;
        return Objects.equals(memoryStoreRetentionPeriodInHours(), other.memoryStoreRetentionPeriodInHours())
                && Objects.equals(magneticStoreRetentionPeriodInDays(), other.magneticStoreRetentionPeriodInDays());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RetentionProperties")
                .add("MemoryStoreRetentionPeriodInHours", memoryStoreRetentionPeriodInHours())
                .add("MagneticStoreRetentionPeriodInDays", magneticStoreRetentionPeriodInDays()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MemoryStoreRetentionPeriodInHours":
            return Optional.ofNullable(clazz.cast(memoryStoreRetentionPeriodInHours()));
        case "MagneticStoreRetentionPeriodInDays":
            return Optional.ofNullable(clazz.cast(magneticStoreRetentionPeriodInDays()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RetentionProperties, T> g) {
        return obj -> g.apply((RetentionProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RetentionProperties> {
        /**
         * <p>
         * The duration for which data must be stored in the memory store.
         * </p>
         * 
         * @param memoryStoreRetentionPeriodInHours
         *        The duration for which data must be stored in the memory store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memoryStoreRetentionPeriodInHours(Long memoryStoreRetentionPeriodInHours);

        /**
         * <p>
         * The duration for which data must be stored in the magnetic store.
         * </p>
         * 
         * @param magneticStoreRetentionPeriodInDays
         *        The duration for which data must be stored in the magnetic store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder magneticStoreRetentionPeriodInDays(Long magneticStoreRetentionPeriodInDays);
    }

    static final class BuilderImpl implements Builder {
        private Long memoryStoreRetentionPeriodInHours;

        private Long magneticStoreRetentionPeriodInDays;

        private BuilderImpl() {
        }

        private BuilderImpl(RetentionProperties model) {
            memoryStoreRetentionPeriodInHours(model.memoryStoreRetentionPeriodInHours);
            magneticStoreRetentionPeriodInDays(model.magneticStoreRetentionPeriodInDays);
        }

        public final Long getMemoryStoreRetentionPeriodInHours() {
            return memoryStoreRetentionPeriodInHours;
        }

        public final void setMemoryStoreRetentionPeriodInHours(Long memoryStoreRetentionPeriodInHours) {
            this.memoryStoreRetentionPeriodInHours = memoryStoreRetentionPeriodInHours;
        }

        @Override
        public final Builder memoryStoreRetentionPeriodInHours(Long memoryStoreRetentionPeriodInHours) {
            this.memoryStoreRetentionPeriodInHours = memoryStoreRetentionPeriodInHours;
            return this;
        }

        public final Long getMagneticStoreRetentionPeriodInDays() {
            return magneticStoreRetentionPeriodInDays;
        }

        public final void setMagneticStoreRetentionPeriodInDays(Long magneticStoreRetentionPeriodInDays) {
            this.magneticStoreRetentionPeriodInDays = magneticStoreRetentionPeriodInDays;
        }

        @Override
        public final Builder magneticStoreRetentionPeriodInDays(Long magneticStoreRetentionPeriodInDays) {
            this.magneticStoreRetentionPeriodInDays = magneticStoreRetentionPeriodInDays;
            return this;
        }

        @Override
        public RetentionProperties build() {
            return new RetentionProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
