/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.timestreamwrite.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class WriteRecordsResponse extends TimestreamWriteResponse implements
        ToCopyableBuilder<WriteRecordsResponse.Builder, WriteRecordsResponse> {
    private static final SdkField<RecordsIngested> RECORDS_INGESTED_FIELD = SdkField
            .<RecordsIngested> builder(MarshallingType.SDK_POJO).memberName("RecordsIngested")
            .getter(getter(WriteRecordsResponse::recordsIngested)).setter(setter(Builder::recordsIngested))
            .constructor(RecordsIngested::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecordsIngested").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECORDS_INGESTED_FIELD));

    private final RecordsIngested recordsIngested;

    private WriteRecordsResponse(BuilderImpl builder) {
        super(builder);
        this.recordsIngested = builder.recordsIngested;
    }

    /**
     * <p>
     * Information on the records ingested by this request.
     * </p>
     * 
     * @return Information on the records ingested by this request.
     */
    public final RecordsIngested recordsIngested() {
        return recordsIngested;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(recordsIngested());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WriteRecordsResponse)) {
            return false;
        }
        WriteRecordsResponse other = (WriteRecordsResponse) obj;
        return Objects.equals(recordsIngested(), other.recordsIngested());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WriteRecordsResponse").add("RecordsIngested", recordsIngested()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RecordsIngested":
            return Optional.ofNullable(clazz.cast(recordsIngested()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WriteRecordsResponse, T> g) {
        return obj -> g.apply((WriteRecordsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TimestreamWriteResponse.Builder, SdkPojo, CopyableBuilder<Builder, WriteRecordsResponse> {
        /**
         * <p>
         * Information on the records ingested by this request.
         * </p>
         * 
         * @param recordsIngested
         *        Information on the records ingested by this request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordsIngested(RecordsIngested recordsIngested);

        /**
         * <p>
         * Information on the records ingested by this request.
         * </p>
         * This is a convenience method that creates an instance of the {@link RecordsIngested.Builder} avoiding the
         * need to create one manually via {@link RecordsIngested#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RecordsIngested.Builder#build()} is called immediately and its
         * result is passed to {@link #recordsIngested(RecordsIngested)}.
         * 
         * @param recordsIngested
         *        a consumer that will call methods on {@link RecordsIngested.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recordsIngested(RecordsIngested)
         */
        default Builder recordsIngested(Consumer<RecordsIngested.Builder> recordsIngested) {
            return recordsIngested(RecordsIngested.builder().applyMutation(recordsIngested).build());
        }
    }

    static final class BuilderImpl extends TimestreamWriteResponse.BuilderImpl implements Builder {
        private RecordsIngested recordsIngested;

        private BuilderImpl() {
        }

        private BuilderImpl(WriteRecordsResponse model) {
            super(model);
            recordsIngested(model.recordsIngested);
        }

        public final RecordsIngested.Builder getRecordsIngested() {
            return recordsIngested != null ? recordsIngested.toBuilder() : null;
        }

        public final void setRecordsIngested(RecordsIngested.BuilderImpl recordsIngested) {
            this.recordsIngested = recordsIngested != null ? recordsIngested.build() : null;
        }

        @Override
        public final Builder recordsIngested(RecordsIngested recordsIngested) {
            this.recordsIngested = recordsIngested;
            return this;
        }

        @Override
        public WriteRecordsResponse build() {
            return new WriteRecordsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
