/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.timestreamwrite.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The location to write error reports for records rejected, asynchronously, during magnetic store writes.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MagneticStoreRejectedDataLocation implements SdkPojo, Serializable,
        ToCopyableBuilder<MagneticStoreRejectedDataLocation.Builder, MagneticStoreRejectedDataLocation> {
    private static final SdkField<S3Configuration> S3_CONFIGURATION_FIELD = SdkField
            .<S3Configuration> builder(MarshallingType.SDK_POJO).memberName("S3Configuration")
            .getter(getter(MagneticStoreRejectedDataLocation::s3Configuration)).setter(setter(Builder::s3Configuration))
            .constructor(S3Configuration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Configuration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final S3Configuration s3Configuration;

    private MagneticStoreRejectedDataLocation(BuilderImpl builder) {
        this.s3Configuration = builder.s3Configuration;
    }

    /**
     * <p>
     * Configuration of an S3 location to write error reports for records rejected, asynchronously, during magnetic
     * store writes.
     * </p>
     * 
     * @return Configuration of an S3 location to write error reports for records rejected, asynchronously, during
     *         magnetic store writes.
     */
    public final S3Configuration s3Configuration() {
        return s3Configuration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3Configuration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MagneticStoreRejectedDataLocation)) {
            return false;
        }
        MagneticStoreRejectedDataLocation other = (MagneticStoreRejectedDataLocation) obj;
        return Objects.equals(s3Configuration(), other.s3Configuration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MagneticStoreRejectedDataLocation").add("S3Configuration", s3Configuration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3Configuration":
            return Optional.ofNullable(clazz.cast(s3Configuration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MagneticStoreRejectedDataLocation, T> g) {
        return obj -> g.apply((MagneticStoreRejectedDataLocation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MagneticStoreRejectedDataLocation> {
        /**
         * <p>
         * Configuration of an S3 location to write error reports for records rejected, asynchronously, during magnetic
         * store writes.
         * </p>
         * 
         * @param s3Configuration
         *        Configuration of an S3 location to write error reports for records rejected, asynchronously, during
         *        magnetic store writes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Configuration(S3Configuration s3Configuration);

        /**
         * <p>
         * Configuration of an S3 location to write error reports for records rejected, asynchronously, during magnetic
         * store writes.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3Configuration.Builder} avoiding the
         * need to create one manually via {@link S3Configuration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3Configuration.Builder#build()} is called immediately and its
         * result is passed to {@link #s3Configuration(S3Configuration)}.
         * 
         * @param s3Configuration
         *        a consumer that will call methods on {@link S3Configuration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Configuration(S3Configuration)
         */
        default Builder s3Configuration(Consumer<S3Configuration.Builder> s3Configuration) {
            return s3Configuration(S3Configuration.builder().applyMutation(s3Configuration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private S3Configuration s3Configuration;

        private BuilderImpl() {
        }

        private BuilderImpl(MagneticStoreRejectedDataLocation model) {
            s3Configuration(model.s3Configuration);
        }

        public final S3Configuration.Builder getS3Configuration() {
            return s3Configuration != null ? s3Configuration.toBuilder() : null;
        }

        public final void setS3Configuration(S3Configuration.BuilderImpl s3Configuration) {
            this.s3Configuration = s3Configuration != null ? s3Configuration.build() : null;
        }

        @Override
        public final Builder s3Configuration(S3Configuration s3Configuration) {
            this.s3Configuration = s3Configuration;
            return this;
        }

        @Override
        public MagneticStoreRejectedDataLocation build() {
            return new MagneticStoreRejectedDataLocation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
