/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.timestreamwrite.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeBatchLoadTaskResponse extends TimestreamWriteResponse implements
        ToCopyableBuilder<DescribeBatchLoadTaskResponse.Builder, DescribeBatchLoadTaskResponse> {
    private static final SdkField<BatchLoadTaskDescription> BATCH_LOAD_TASK_DESCRIPTION_FIELD = SdkField
            .<BatchLoadTaskDescription> builder(MarshallingType.SDK_POJO).memberName("BatchLoadTaskDescription")
            .getter(getter(DescribeBatchLoadTaskResponse::batchLoadTaskDescription))
            .setter(setter(Builder::batchLoadTaskDescription)).constructor(BatchLoadTaskDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BatchLoadTaskDescription").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(BATCH_LOAD_TASK_DESCRIPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final BatchLoadTaskDescription batchLoadTaskDescription;

    private DescribeBatchLoadTaskResponse(BuilderImpl builder) {
        super(builder);
        this.batchLoadTaskDescription = builder.batchLoadTaskDescription;
    }

    /**
     * <p>
     * Description of the batch load task.
     * </p>
     * 
     * @return Description of the batch load task.
     */
    public final BatchLoadTaskDescription batchLoadTaskDescription() {
        return batchLoadTaskDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(batchLoadTaskDescription());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeBatchLoadTaskResponse)) {
            return false;
        }
        DescribeBatchLoadTaskResponse other = (DescribeBatchLoadTaskResponse) obj;
        return Objects.equals(batchLoadTaskDescription(), other.batchLoadTaskDescription());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeBatchLoadTaskResponse").add("BatchLoadTaskDescription", batchLoadTaskDescription())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BatchLoadTaskDescription":
            return Optional.ofNullable(clazz.cast(batchLoadTaskDescription()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("BatchLoadTaskDescription", BATCH_LOAD_TASK_DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeBatchLoadTaskResponse, T> g) {
        return obj -> g.apply((DescribeBatchLoadTaskResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TimestreamWriteResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeBatchLoadTaskResponse> {
        /**
         * <p>
         * Description of the batch load task.
         * </p>
         * 
         * @param batchLoadTaskDescription
         *        Description of the batch load task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder batchLoadTaskDescription(BatchLoadTaskDescription batchLoadTaskDescription);

        /**
         * <p>
         * Description of the batch load task.
         * </p>
         * This is a convenience method that creates an instance of the {@link BatchLoadTaskDescription.Builder}
         * avoiding the need to create one manually via {@link BatchLoadTaskDescription#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BatchLoadTaskDescription.Builder#build()} is called immediately
         * and its result is passed to {@link #batchLoadTaskDescription(BatchLoadTaskDescription)}.
         * 
         * @param batchLoadTaskDescription
         *        a consumer that will call methods on {@link BatchLoadTaskDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #batchLoadTaskDescription(BatchLoadTaskDescription)
         */
        default Builder batchLoadTaskDescription(Consumer<BatchLoadTaskDescription.Builder> batchLoadTaskDescription) {
            return batchLoadTaskDescription(BatchLoadTaskDescription.builder().applyMutation(batchLoadTaskDescription).build());
        }
    }

    static final class BuilderImpl extends TimestreamWriteResponse.BuilderImpl implements Builder {
        private BatchLoadTaskDescription batchLoadTaskDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeBatchLoadTaskResponse model) {
            super(model);
            batchLoadTaskDescription(model.batchLoadTaskDescription);
        }

        public final BatchLoadTaskDescription.Builder getBatchLoadTaskDescription() {
            return batchLoadTaskDescription != null ? batchLoadTaskDescription.toBuilder() : null;
        }

        public final void setBatchLoadTaskDescription(BatchLoadTaskDescription.BuilderImpl batchLoadTaskDescription) {
            this.batchLoadTaskDescription = batchLoadTaskDescription != null ? batchLoadTaskDescription.build() : null;
        }

        @Override
        public final Builder batchLoadTaskDescription(BatchLoadTaskDescription batchLoadTaskDescription) {
            this.batchLoadTaskDescription = batchLoadTaskDescription;
            return this;
        }

        @Override
        public DescribeBatchLoadTaskResponse build() {
            return new DescribeBatchLoadTaskResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
