/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.timestreamwrite.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListBatchLoadTasksResponse extends TimestreamWriteResponse implements
        ToCopyableBuilder<ListBatchLoadTasksResponse.Builder, ListBatchLoadTasksResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListBatchLoadTasksResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<BatchLoadTask>> BATCH_LOAD_TASKS_FIELD = SdkField
            .<List<BatchLoadTask>> builder(MarshallingType.LIST)
            .memberName("BatchLoadTasks")
            .getter(getter(ListBatchLoadTasksResponse::batchLoadTasks))
            .setter(setter(Builder::batchLoadTasks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BatchLoadTasks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BatchLoadTask> builder(MarshallingType.SDK_POJO)
                                            .constructor(BatchLoadTask::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            BATCH_LOAD_TASKS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<BatchLoadTask> batchLoadTasks;

    private ListBatchLoadTasksResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.batchLoadTasks = builder.batchLoadTasks;
    }

    /**
     * <p>
     * A token to specify where to start paginating. Provide the next ListBatchLoadTasksRequest.
     * </p>
     * 
     * @return A token to specify where to start paginating. Provide the next ListBatchLoadTasksRequest.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the BatchLoadTasks property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBatchLoadTasks() {
        return batchLoadTasks != null && !(batchLoadTasks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of batch load task details.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBatchLoadTasks} method.
     * </p>
     * 
     * @return A list of batch load task details.
     */
    public final List<BatchLoadTask> batchLoadTasks() {
        return batchLoadTasks;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasBatchLoadTasks() ? batchLoadTasks() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBatchLoadTasksResponse)) {
            return false;
        }
        ListBatchLoadTasksResponse other = (ListBatchLoadTasksResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasBatchLoadTasks() == other.hasBatchLoadTasks()
                && Objects.equals(batchLoadTasks(), other.batchLoadTasks());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListBatchLoadTasksResponse").add("NextToken", nextToken())
                .add("BatchLoadTasks", hasBatchLoadTasks() ? batchLoadTasks() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "BatchLoadTasks":
            return Optional.ofNullable(clazz.cast(batchLoadTasks()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("BatchLoadTasks", BATCH_LOAD_TASKS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListBatchLoadTasksResponse, T> g) {
        return obj -> g.apply((ListBatchLoadTasksResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TimestreamWriteResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListBatchLoadTasksResponse> {
        /**
         * <p>
         * A token to specify where to start paginating. Provide the next ListBatchLoadTasksRequest.
         * </p>
         * 
         * @param nextToken
         *        A token to specify where to start paginating. Provide the next ListBatchLoadTasksRequest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A list of batch load task details.
         * </p>
         * 
         * @param batchLoadTasks
         *        A list of batch load task details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder batchLoadTasks(Collection<BatchLoadTask> batchLoadTasks);

        /**
         * <p>
         * A list of batch load task details.
         * </p>
         * 
         * @param batchLoadTasks
         *        A list of batch load task details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder batchLoadTasks(BatchLoadTask... batchLoadTasks);

        /**
         * <p>
         * A list of batch load task details.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.timestreamwrite.model.BatchLoadTask.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.timestreamwrite.model.BatchLoadTask#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.timestreamwrite.model.BatchLoadTask.Builder#build()} is called
         * immediately and its result is passed to {@link #batchLoadTasks(List<BatchLoadTask>)}.
         * 
         * @param batchLoadTasks
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.timestreamwrite.model.BatchLoadTask.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #batchLoadTasks(java.util.Collection<BatchLoadTask>)
         */
        Builder batchLoadTasks(Consumer<BatchLoadTask.Builder>... batchLoadTasks);
    }

    static final class BuilderImpl extends TimestreamWriteResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<BatchLoadTask> batchLoadTasks = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListBatchLoadTasksResponse model) {
            super(model);
            nextToken(model.nextToken);
            batchLoadTasks(model.batchLoadTasks);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<BatchLoadTask.Builder> getBatchLoadTasks() {
            List<BatchLoadTask.Builder> result = BatchLoadTaskListCopier.copyToBuilder(this.batchLoadTasks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBatchLoadTasks(Collection<BatchLoadTask.BuilderImpl> batchLoadTasks) {
            this.batchLoadTasks = BatchLoadTaskListCopier.copyFromBuilder(batchLoadTasks);
        }

        @Override
        public final Builder batchLoadTasks(Collection<BatchLoadTask> batchLoadTasks) {
            this.batchLoadTasks = BatchLoadTaskListCopier.copy(batchLoadTasks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder batchLoadTasks(BatchLoadTask... batchLoadTasks) {
            batchLoadTasks(Arrays.asList(batchLoadTasks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder batchLoadTasks(Consumer<BatchLoadTask.Builder>... batchLoadTasks) {
            batchLoadTasks(Stream.of(batchLoadTasks).map(c -> BatchLoadTask.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListBatchLoadTasksResponse build() {
            return new ListBatchLoadTasksResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
