/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.timestreamwrite.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateTableRequest extends TimestreamWriteRequest implements
        ToCopyableBuilder<UpdateTableRequest.Builder, UpdateTableRequest> {
    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatabaseName").getter(getter(UpdateTableRequest::databaseName)).setter(setter(Builder::databaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()).build();

    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TableName").getter(getter(UpdateTableRequest::tableName)).setter(setter(Builder::tableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()).build();

    private static final SdkField<RetentionProperties> RETENTION_PROPERTIES_FIELD = SdkField
            .<RetentionProperties> builder(MarshallingType.SDK_POJO).memberName("RetentionProperties")
            .getter(getter(UpdateTableRequest::retentionProperties)).setter(setter(Builder::retentionProperties))
            .constructor(RetentionProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetentionProperties").build())
            .build();

    private static final SdkField<MagneticStoreWriteProperties> MAGNETIC_STORE_WRITE_PROPERTIES_FIELD = SdkField
            .<MagneticStoreWriteProperties> builder(MarshallingType.SDK_POJO)
            .memberName("MagneticStoreWriteProperties")
            .getter(getter(UpdateTableRequest::magneticStoreWriteProperties))
            .setter(setter(Builder::magneticStoreWriteProperties))
            .constructor(MagneticStoreWriteProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MagneticStoreWriteProperties")
                    .build()).build();

    private static final SdkField<Schema> SCHEMA_FIELD = SdkField.<Schema> builder(MarshallingType.SDK_POJO).memberName("Schema")
            .getter(getter(UpdateTableRequest::schema)).setter(setter(Builder::schema)).constructor(Schema::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schema").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATABASE_NAME_FIELD,
            TABLE_NAME_FIELD, RETENTION_PROPERTIES_FIELD, MAGNETIC_STORE_WRITE_PROPERTIES_FIELD, SCHEMA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String databaseName;

    private final String tableName;

    private final RetentionProperties retentionProperties;

    private final MagneticStoreWriteProperties magneticStoreWriteProperties;

    private final Schema schema;

    private UpdateTableRequest(BuilderImpl builder) {
        super(builder);
        this.databaseName = builder.databaseName;
        this.tableName = builder.tableName;
        this.retentionProperties = builder.retentionProperties;
        this.magneticStoreWriteProperties = builder.magneticStoreWriteProperties;
        this.schema = builder.schema;
    }

    /**
     * <p>
     * The name of the Timestream database.
     * </p>
     * 
     * @return The name of the Timestream database.
     */
    public final String databaseName() {
        return databaseName;
    }

    /**
     * <p>
     * The name of the Timestream table.
     * </p>
     * 
     * @return The name of the Timestream table.
     */
    public final String tableName() {
        return tableName;
    }

    /**
     * <p>
     * The retention duration of the memory store and the magnetic store.
     * </p>
     * 
     * @return The retention duration of the memory store and the magnetic store.
     */
    public final RetentionProperties retentionProperties() {
        return retentionProperties;
    }

    /**
     * <p>
     * Contains properties to set on the table when enabling magnetic store writes.
     * </p>
     * 
     * @return Contains properties to set on the table when enabling magnetic store writes.
     */
    public final MagneticStoreWriteProperties magneticStoreWriteProperties() {
        return magneticStoreWriteProperties;
    }

    /**
     * <p>
     * The schema of the table.
     * </p>
     * 
     * @return The schema of the table.
     */
    public final Schema schema() {
        return schema;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(tableName());
        hashCode = 31 * hashCode + Objects.hashCode(retentionProperties());
        hashCode = 31 * hashCode + Objects.hashCode(magneticStoreWriteProperties());
        hashCode = 31 * hashCode + Objects.hashCode(schema());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTableRequest)) {
            return false;
        }
        UpdateTableRequest other = (UpdateTableRequest) obj;
        return Objects.equals(databaseName(), other.databaseName()) && Objects.equals(tableName(), other.tableName())
                && Objects.equals(retentionProperties(), other.retentionProperties())
                && Objects.equals(magneticStoreWriteProperties(), other.magneticStoreWriteProperties())
                && Objects.equals(schema(), other.schema());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateTableRequest").add("DatabaseName", databaseName()).add("TableName", tableName())
                .add("RetentionProperties", retentionProperties())
                .add("MagneticStoreWriteProperties", magneticStoreWriteProperties()).add("Schema", schema()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DatabaseName":
            return Optional.ofNullable(clazz.cast(databaseName()));
        case "TableName":
            return Optional.ofNullable(clazz.cast(tableName()));
        case "RetentionProperties":
            return Optional.ofNullable(clazz.cast(retentionProperties()));
        case "MagneticStoreWriteProperties":
            return Optional.ofNullable(clazz.cast(magneticStoreWriteProperties()));
        case "Schema":
            return Optional.ofNullable(clazz.cast(schema()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DatabaseName", DATABASE_NAME_FIELD);
        map.put("TableName", TABLE_NAME_FIELD);
        map.put("RetentionProperties", RETENTION_PROPERTIES_FIELD);
        map.put("MagneticStoreWriteProperties", MAGNETIC_STORE_WRITE_PROPERTIES_FIELD);
        map.put("Schema", SCHEMA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateTableRequest, T> g) {
        return obj -> g.apply((UpdateTableRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TimestreamWriteRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateTableRequest> {
        /**
         * <p>
         * The name of the Timestream database.
         * </p>
         * 
         * @param databaseName
         *        The name of the Timestream database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseName(String databaseName);

        /**
         * <p>
         * The name of the Timestream table.
         * </p>
         * 
         * @param tableName
         *        The name of the Timestream table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableName(String tableName);

        /**
         * <p>
         * The retention duration of the memory store and the magnetic store.
         * </p>
         * 
         * @param retentionProperties
         *        The retention duration of the memory store and the magnetic store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retentionProperties(RetentionProperties retentionProperties);

        /**
         * <p>
         * The retention duration of the memory store and the magnetic store.
         * </p>
         * This is a convenience method that creates an instance of the {@link RetentionProperties.Builder} avoiding the
         * need to create one manually via {@link RetentionProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RetentionProperties.Builder#build()} is called immediately and
         * its result is passed to {@link #retentionProperties(RetentionProperties)}.
         * 
         * @param retentionProperties
         *        a consumer that will call methods on {@link RetentionProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #retentionProperties(RetentionProperties)
         */
        default Builder retentionProperties(Consumer<RetentionProperties.Builder> retentionProperties) {
            return retentionProperties(RetentionProperties.builder().applyMutation(retentionProperties).build());
        }

        /**
         * <p>
         * Contains properties to set on the table when enabling magnetic store writes.
         * </p>
         * 
         * @param magneticStoreWriteProperties
         *        Contains properties to set on the table when enabling magnetic store writes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder magneticStoreWriteProperties(MagneticStoreWriteProperties magneticStoreWriteProperties);

        /**
         * <p>
         * Contains properties to set on the table when enabling magnetic store writes.
         * </p>
         * This is a convenience method that creates an instance of the {@link MagneticStoreWriteProperties.Builder}
         * avoiding the need to create one manually via {@link MagneticStoreWriteProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MagneticStoreWriteProperties.Builder#build()} is called
         * immediately and its result is passed to {@link #magneticStoreWriteProperties(MagneticStoreWriteProperties)}.
         * 
         * @param magneticStoreWriteProperties
         *        a consumer that will call methods on {@link MagneticStoreWriteProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #magneticStoreWriteProperties(MagneticStoreWriteProperties)
         */
        default Builder magneticStoreWriteProperties(Consumer<MagneticStoreWriteProperties.Builder> magneticStoreWriteProperties) {
            return magneticStoreWriteProperties(MagneticStoreWriteProperties.builder()
                    .applyMutation(magneticStoreWriteProperties).build());
        }

        /**
         * <p>
         * The schema of the table.
         * </p>
         * 
         * @param schema
         *        The schema of the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schema(Schema schema);

        /**
         * <p>
         * The schema of the table.
         * </p>
         * This is a convenience method that creates an instance of the {@link Schema.Builder} avoiding the need to
         * create one manually via {@link Schema#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Schema.Builder#build()} is called immediately and its result is
         * passed to {@link #schema(Schema)}.
         * 
         * @param schema
         *        a consumer that will call methods on {@link Schema.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schema(Schema)
         */
        default Builder schema(Consumer<Schema.Builder> schema) {
            return schema(Schema.builder().applyMutation(schema).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends TimestreamWriteRequest.BuilderImpl implements Builder {
        private String databaseName;

        private String tableName;

        private RetentionProperties retentionProperties;

        private MagneticStoreWriteProperties magneticStoreWriteProperties;

        private Schema schema;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTableRequest model) {
            super(model);
            databaseName(model.databaseName);
            tableName(model.tableName);
            retentionProperties(model.retentionProperties);
            magneticStoreWriteProperties(model.magneticStoreWriteProperties);
            schema(model.schema);
        }

        public final String getDatabaseName() {
            return databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getTableName() {
            return tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final RetentionProperties.Builder getRetentionProperties() {
            return retentionProperties != null ? retentionProperties.toBuilder() : null;
        }

        public final void setRetentionProperties(RetentionProperties.BuilderImpl retentionProperties) {
            this.retentionProperties = retentionProperties != null ? retentionProperties.build() : null;
        }

        @Override
        public final Builder retentionProperties(RetentionProperties retentionProperties) {
            this.retentionProperties = retentionProperties;
            return this;
        }

        public final MagneticStoreWriteProperties.Builder getMagneticStoreWriteProperties() {
            return magneticStoreWriteProperties != null ? magneticStoreWriteProperties.toBuilder() : null;
        }

        public final void setMagneticStoreWriteProperties(MagneticStoreWriteProperties.BuilderImpl magneticStoreWriteProperties) {
            this.magneticStoreWriteProperties = magneticStoreWriteProperties != null ? magneticStoreWriteProperties.build()
                    : null;
        }

        @Override
        public final Builder magneticStoreWriteProperties(MagneticStoreWriteProperties magneticStoreWriteProperties) {
            this.magneticStoreWriteProperties = magneticStoreWriteProperties;
            return this;
        }

        public final Schema.Builder getSchema() {
            return schema != null ? schema.toBuilder() : null;
        }

        public final void setSchema(Schema.BuilderImpl schema) {
            this.schema = schema != null ? schema.build() : null;
        }

        @Override
        public final Builder schema(Schema schema) {
            this.schema = schema;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateTableRequest build() {
            return new UpdateTableRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
