/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.timestreamwrite.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about the progress of a batch load task.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchLoadProgressReport implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchLoadProgressReport.Builder, BatchLoadProgressReport> {
    private static final SdkField<Long> RECORDS_PROCESSED_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("RecordsProcessed").getter(getter(BatchLoadProgressReport::recordsProcessed))
            .setter(setter(Builder::recordsProcessed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecordsProcessed").build()).build();

    private static final SdkField<Long> RECORDS_INGESTED_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("RecordsIngested").getter(getter(BatchLoadProgressReport::recordsIngested))
            .setter(setter(Builder::recordsIngested))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecordsIngested").build()).build();

    private static final SdkField<Long> PARSE_FAILURES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("ParseFailures").getter(getter(BatchLoadProgressReport::parseFailures))
            .setter(setter(Builder::parseFailures))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParseFailures").build()).build();

    private static final SdkField<Long> RECORD_INGESTION_FAILURES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("RecordIngestionFailures").getter(getter(BatchLoadProgressReport::recordIngestionFailures))
            .setter(setter(Builder::recordIngestionFailures))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecordIngestionFailures").build())
            .build();

    private static final SdkField<Long> FILE_FAILURES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("FileFailures").getter(getter(BatchLoadProgressReport::fileFailures))
            .setter(setter(Builder::fileFailures))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileFailures").build()).build();

    private static final SdkField<Long> BYTES_METERED_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("BytesMetered").getter(getter(BatchLoadProgressReport::bytesMetered))
            .setter(setter(Builder::bytesMetered))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BytesMetered").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECORDS_PROCESSED_FIELD,
            RECORDS_INGESTED_FIELD, PARSE_FAILURES_FIELD, RECORD_INGESTION_FAILURES_FIELD, FILE_FAILURES_FIELD,
            BYTES_METERED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Long recordsProcessed;

    private final Long recordsIngested;

    private final Long parseFailures;

    private final Long recordIngestionFailures;

    private final Long fileFailures;

    private final Long bytesMetered;

    private BatchLoadProgressReport(BuilderImpl builder) {
        this.recordsProcessed = builder.recordsProcessed;
        this.recordsIngested = builder.recordsIngested;
        this.parseFailures = builder.parseFailures;
        this.recordIngestionFailures = builder.recordIngestionFailures;
        this.fileFailures = builder.fileFailures;
        this.bytesMetered = builder.bytesMetered;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final Long recordsProcessed() {
        return recordsProcessed;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final Long recordsIngested() {
        return recordsIngested;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final Long parseFailures() {
        return parseFailures;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final Long recordIngestionFailures() {
        return recordIngestionFailures;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final Long fileFailures() {
        return fileFailures;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final Long bytesMetered() {
        return bytesMetered;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(recordsProcessed());
        hashCode = 31 * hashCode + Objects.hashCode(recordsIngested());
        hashCode = 31 * hashCode + Objects.hashCode(parseFailures());
        hashCode = 31 * hashCode + Objects.hashCode(recordIngestionFailures());
        hashCode = 31 * hashCode + Objects.hashCode(fileFailures());
        hashCode = 31 * hashCode + Objects.hashCode(bytesMetered());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchLoadProgressReport)) {
            return false;
        }
        BatchLoadProgressReport other = (BatchLoadProgressReport) obj;
        return Objects.equals(recordsProcessed(), other.recordsProcessed())
                && Objects.equals(recordsIngested(), other.recordsIngested())
                && Objects.equals(parseFailures(), other.parseFailures())
                && Objects.equals(recordIngestionFailures(), other.recordIngestionFailures())
                && Objects.equals(fileFailures(), other.fileFailures()) && Objects.equals(bytesMetered(), other.bytesMetered());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchLoadProgressReport").add("RecordsProcessed", recordsProcessed())
                .add("RecordsIngested", recordsIngested()).add("ParseFailures", parseFailures())
                .add("RecordIngestionFailures", recordIngestionFailures()).add("FileFailures", fileFailures())
                .add("BytesMetered", bytesMetered()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RecordsProcessed":
            return Optional.ofNullable(clazz.cast(recordsProcessed()));
        case "RecordsIngested":
            return Optional.ofNullable(clazz.cast(recordsIngested()));
        case "ParseFailures":
            return Optional.ofNullable(clazz.cast(parseFailures()));
        case "RecordIngestionFailures":
            return Optional.ofNullable(clazz.cast(recordIngestionFailures()));
        case "FileFailures":
            return Optional.ofNullable(clazz.cast(fileFailures()));
        case "BytesMetered":
            return Optional.ofNullable(clazz.cast(bytesMetered()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RecordsProcessed", RECORDS_PROCESSED_FIELD);
        map.put("RecordsIngested", RECORDS_INGESTED_FIELD);
        map.put("ParseFailures", PARSE_FAILURES_FIELD);
        map.put("RecordIngestionFailures", RECORD_INGESTION_FAILURES_FIELD);
        map.put("FileFailures", FILE_FAILURES_FIELD);
        map.put("BytesMetered", BYTES_METERED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchLoadProgressReport, T> g) {
        return obj -> g.apply((BatchLoadProgressReport) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchLoadProgressReport> {
        /**
         * <p/>
         * 
         * @param recordsProcessed
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordsProcessed(Long recordsProcessed);

        /**
         * <p/>
         * 
         * @param recordsIngested
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordsIngested(Long recordsIngested);

        /**
         * <p/>
         * 
         * @param parseFailures
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parseFailures(Long parseFailures);

        /**
         * <p/>
         * 
         * @param recordIngestionFailures
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordIngestionFailures(Long recordIngestionFailures);

        /**
         * <p/>
         * 
         * @param fileFailures
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileFailures(Long fileFailures);

        /**
         * <p/>
         * 
         * @param bytesMetered
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bytesMetered(Long bytesMetered);
    }

    static final class BuilderImpl implements Builder {
        private Long recordsProcessed;

        private Long recordsIngested;

        private Long parseFailures;

        private Long recordIngestionFailures;

        private Long fileFailures;

        private Long bytesMetered;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchLoadProgressReport model) {
            recordsProcessed(model.recordsProcessed);
            recordsIngested(model.recordsIngested);
            parseFailures(model.parseFailures);
            recordIngestionFailures(model.recordIngestionFailures);
            fileFailures(model.fileFailures);
            bytesMetered(model.bytesMetered);
        }

        public final Long getRecordsProcessed() {
            return recordsProcessed;
        }

        public final void setRecordsProcessed(Long recordsProcessed) {
            this.recordsProcessed = recordsProcessed;
        }

        @Override
        public final Builder recordsProcessed(Long recordsProcessed) {
            this.recordsProcessed = recordsProcessed;
            return this;
        }

        public final Long getRecordsIngested() {
            return recordsIngested;
        }

        public final void setRecordsIngested(Long recordsIngested) {
            this.recordsIngested = recordsIngested;
        }

        @Override
        public final Builder recordsIngested(Long recordsIngested) {
            this.recordsIngested = recordsIngested;
            return this;
        }

        public final Long getParseFailures() {
            return parseFailures;
        }

        public final void setParseFailures(Long parseFailures) {
            this.parseFailures = parseFailures;
        }

        @Override
        public final Builder parseFailures(Long parseFailures) {
            this.parseFailures = parseFailures;
            return this;
        }

        public final Long getRecordIngestionFailures() {
            return recordIngestionFailures;
        }

        public final void setRecordIngestionFailures(Long recordIngestionFailures) {
            this.recordIngestionFailures = recordIngestionFailures;
        }

        @Override
        public final Builder recordIngestionFailures(Long recordIngestionFailures) {
            this.recordIngestionFailures = recordIngestionFailures;
            return this;
        }

        public final Long getFileFailures() {
            return fileFailures;
        }

        public final void setFileFailures(Long fileFailures) {
            this.fileFailures = fileFailures;
        }

        @Override
        public final Builder fileFailures(Long fileFailures) {
            this.fileFailures = fileFailures;
            return this;
        }

        public final Long getBytesMetered() {
            return bytesMetered;
        }

        public final void setBytesMetered(Long bytesMetered) {
            this.bytesMetered = bytesMetered;
        }

        @Override
        public final Builder bytesMetered(Long bytesMetered) {
            this.bytesMetered = bytesMetered;
            return this;
        }

        @Override
        public BatchLoadProgressReport build() {
            return new BatchLoadProgressReport(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
