/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.timestreamwrite.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.timestreamwrite.model.MeasureValueType;
import software.amazon.awssdk.services.timestreamwrite.model.MultiMeasureAttributeMapping;
import software.amazon.awssdk.services.timestreamwrite.model.MultiMeasureAttributeMappingListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MixedMeasureMapping
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MixedMeasureMapping> {
    private static final SdkField<String> MEASURE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MeasureName").getter(MixedMeasureMapping.getter(MixedMeasureMapping::measureName)).setter(MixedMeasureMapping.setter(Builder::measureName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MeasureName").build()}).build();
    private static final SdkField<String> SOURCE_COLUMN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceColumn").getter(MixedMeasureMapping.getter(MixedMeasureMapping::sourceColumn)).setter(MixedMeasureMapping.setter(Builder::sourceColumn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceColumn").build()}).build();
    private static final SdkField<String> TARGET_MEASURE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetMeasureName").getter(MixedMeasureMapping.getter(MixedMeasureMapping::targetMeasureName)).setter(MixedMeasureMapping.setter(Builder::targetMeasureName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetMeasureName").build()}).build();
    private static final SdkField<String> MEASURE_VALUE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MeasureValueType").getter(MixedMeasureMapping.getter(MixedMeasureMapping::measureValueTypeAsString)).setter(MixedMeasureMapping.setter(Builder::measureValueType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MeasureValueType").build()}).build();
    private static final SdkField<List<MultiMeasureAttributeMapping>> MULTI_MEASURE_ATTRIBUTE_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MultiMeasureAttributeMappings").getter(MixedMeasureMapping.getter(MixedMeasureMapping::multiMeasureAttributeMappings)).setter(MixedMeasureMapping.setter(Builder::multiMeasureAttributeMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiMeasureAttributeMappings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MultiMeasureAttributeMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEASURE_NAME_FIELD, SOURCE_COLUMN_FIELD, TARGET_MEASURE_NAME_FIELD, MEASURE_VALUE_TYPE_FIELD, MULTI_MEASURE_ATTRIBUTE_MAPPINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MixedMeasureMapping.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String measureName;
    private final String sourceColumn;
    private final String targetMeasureName;
    private final String measureValueType;
    private final List<MultiMeasureAttributeMapping> multiMeasureAttributeMappings;

    private MixedMeasureMapping(BuilderImpl builder) {
        this.measureName = builder.measureName;
        this.sourceColumn = builder.sourceColumn;
        this.targetMeasureName = builder.targetMeasureName;
        this.measureValueType = builder.measureValueType;
        this.multiMeasureAttributeMappings = builder.multiMeasureAttributeMappings;
    }

    public final String measureName() {
        return this.measureName;
    }

    public final String sourceColumn() {
        return this.sourceColumn;
    }

    public final String targetMeasureName() {
        return this.targetMeasureName;
    }

    public final MeasureValueType measureValueType() {
        return MeasureValueType.fromValue(this.measureValueType);
    }

    public final String measureValueTypeAsString() {
        return this.measureValueType;
    }

    public final boolean hasMultiMeasureAttributeMappings() {
        return this.multiMeasureAttributeMappings != null && !(this.multiMeasureAttributeMappings instanceof SdkAutoConstructList);
    }

    public final List<MultiMeasureAttributeMapping> multiMeasureAttributeMappings() {
        return this.multiMeasureAttributeMappings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.measureName());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceColumn());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetMeasureName());
        hashCode = 31 * hashCode + Objects.hashCode(this.measureValueTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMultiMeasureAttributeMappings() ? this.multiMeasureAttributeMappings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MixedMeasureMapping)) {
            return false;
        }
        MixedMeasureMapping other = (MixedMeasureMapping)obj;
        return Objects.equals(this.measureName(), other.measureName()) && Objects.equals(this.sourceColumn(), other.sourceColumn()) && Objects.equals(this.targetMeasureName(), other.targetMeasureName()) && Objects.equals(this.measureValueTypeAsString(), other.measureValueTypeAsString()) && this.hasMultiMeasureAttributeMappings() == other.hasMultiMeasureAttributeMappings() && Objects.equals(this.multiMeasureAttributeMappings(), other.multiMeasureAttributeMappings());
    }

    public final String toString() {
        return ToString.builder((String)"MixedMeasureMapping").add("MeasureName", (Object)this.measureName()).add("SourceColumn", (Object)this.sourceColumn()).add("TargetMeasureName", (Object)this.targetMeasureName()).add("MeasureValueType", (Object)this.measureValueTypeAsString()).add("MultiMeasureAttributeMappings", this.hasMultiMeasureAttributeMappings() ? this.multiMeasureAttributeMappings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MeasureName": {
                return Optional.ofNullable(clazz.cast(this.measureName()));
            }
            case "SourceColumn": {
                return Optional.ofNullable(clazz.cast(this.sourceColumn()));
            }
            case "TargetMeasureName": {
                return Optional.ofNullable(clazz.cast(this.targetMeasureName()));
            }
            case "MeasureValueType": {
                return Optional.ofNullable(clazz.cast(this.measureValueTypeAsString()));
            }
            case "MultiMeasureAttributeMappings": {
                return Optional.ofNullable(clazz.cast(this.multiMeasureAttributeMappings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("MeasureName", MEASURE_NAME_FIELD);
        map.put("SourceColumn", SOURCE_COLUMN_FIELD);
        map.put("TargetMeasureName", TARGET_MEASURE_NAME_FIELD);
        map.put("MeasureValueType", MEASURE_VALUE_TYPE_FIELD);
        map.put("MultiMeasureAttributeMappings", MULTI_MEASURE_ATTRIBUTE_MAPPINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MixedMeasureMapping, T> g) {
        return obj -> g.apply((MixedMeasureMapping)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String measureName;
        private String sourceColumn;
        private String targetMeasureName;
        private String measureValueType;
        private List<MultiMeasureAttributeMapping> multiMeasureAttributeMappings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MixedMeasureMapping model) {
            this.measureName(model.measureName);
            this.sourceColumn(model.sourceColumn);
            this.targetMeasureName(model.targetMeasureName);
            this.measureValueType(model.measureValueType);
            this.multiMeasureAttributeMappings(model.multiMeasureAttributeMappings);
        }

        public final String getMeasureName() {
            return this.measureName;
        }

        public final void setMeasureName(String measureName) {
            this.measureName = measureName;
        }

        @Override
        public final Builder measureName(String measureName) {
            this.measureName = measureName;
            return this;
        }

        public final String getSourceColumn() {
            return this.sourceColumn;
        }

        public final void setSourceColumn(String sourceColumn) {
            this.sourceColumn = sourceColumn;
        }

        @Override
        public final Builder sourceColumn(String sourceColumn) {
            this.sourceColumn = sourceColumn;
            return this;
        }

        public final String getTargetMeasureName() {
            return this.targetMeasureName;
        }

        public final void setTargetMeasureName(String targetMeasureName) {
            this.targetMeasureName = targetMeasureName;
        }

        @Override
        public final Builder targetMeasureName(String targetMeasureName) {
            this.targetMeasureName = targetMeasureName;
            return this;
        }

        public final String getMeasureValueType() {
            return this.measureValueType;
        }

        public final void setMeasureValueType(String measureValueType) {
            this.measureValueType = measureValueType;
        }

        @Override
        public final Builder measureValueType(String measureValueType) {
            this.measureValueType = measureValueType;
            return this;
        }

        @Override
        public final Builder measureValueType(MeasureValueType measureValueType) {
            this.measureValueType(measureValueType == null ? null : measureValueType.toString());
            return this;
        }

        public final List<MultiMeasureAttributeMapping.Builder> getMultiMeasureAttributeMappings() {
            List<MultiMeasureAttributeMapping.Builder> result = MultiMeasureAttributeMappingListCopier.copyToBuilder(this.multiMeasureAttributeMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMultiMeasureAttributeMappings(Collection<MultiMeasureAttributeMapping.BuilderImpl> multiMeasureAttributeMappings) {
            this.multiMeasureAttributeMappings = MultiMeasureAttributeMappingListCopier.copyFromBuilder(multiMeasureAttributeMappings);
        }

        @Override
        public final Builder multiMeasureAttributeMappings(Collection<MultiMeasureAttributeMapping> multiMeasureAttributeMappings) {
            this.multiMeasureAttributeMappings = MultiMeasureAttributeMappingListCopier.copy(multiMeasureAttributeMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder multiMeasureAttributeMappings(MultiMeasureAttributeMapping ... multiMeasureAttributeMappings) {
            this.multiMeasureAttributeMappings(Arrays.asList(multiMeasureAttributeMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder multiMeasureAttributeMappings(Consumer<MultiMeasureAttributeMapping.Builder> ... multiMeasureAttributeMappings) {
            this.multiMeasureAttributeMappings(Stream.of(multiMeasureAttributeMappings).map(c -> (MultiMeasureAttributeMapping)((MultiMeasureAttributeMapping.Builder)MultiMeasureAttributeMapping.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public MixedMeasureMapping build() {
            return new MixedMeasureMapping(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MixedMeasureMapping> {
        public Builder measureName(String var1);

        public Builder sourceColumn(String var1);

        public Builder targetMeasureName(String var1);

        public Builder measureValueType(String var1);

        public Builder measureValueType(MeasureValueType var1);

        public Builder multiMeasureAttributeMappings(Collection<MultiMeasureAttributeMapping> var1);

        public Builder multiMeasureAttributeMappings(MultiMeasureAttributeMapping ... var1);

        public Builder multiMeasureAttributeMappings(Consumer<MultiMeasureAttributeMapping.Builder> ... var1);
    }
}

