/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.timestreamwrite.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.timestreamwrite.TimestreamWriteAsyncClient;
import software.amazon.awssdk.services.timestreamwrite.internal.UserAgentUtils;
import software.amazon.awssdk.services.timestreamwrite.model.ListTablesRequest;
import software.amazon.awssdk.services.timestreamwrite.model.ListTablesResponse;

public class ListTablesPublisher
implements SdkPublisher<ListTablesResponse> {
    private final TimestreamWriteAsyncClient client;
    private final ListTablesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListTablesPublisher(TimestreamWriteAsyncClient client, ListTablesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListTablesPublisher(TimestreamWriteAsyncClient client, ListTablesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListTablesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListTablesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListTablesResponseFetcher
    implements AsyncPageFetcher<ListTablesResponse> {
        private ListTablesResponseFetcher() {
        }

        public boolean hasNextPage(ListTablesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListTablesResponse> nextPage(ListTablesResponse previousPage) {
            if (previousPage == null) {
                return ListTablesPublisher.this.client.listTables(ListTablesPublisher.this.firstRequest);
            }
            return ListTablesPublisher.this.client.listTables((ListTablesRequest)((Object)ListTablesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

