/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.timestreamwrite.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MultiMeasureAttributeMapping implements SdkPojo, Serializable,
        ToCopyableBuilder<MultiMeasureAttributeMapping.Builder, MultiMeasureAttributeMapping> {
    private static final SdkField<String> SOURCE_COLUMN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceColumn").getter(getter(MultiMeasureAttributeMapping::sourceColumn))
            .setter(setter(Builder::sourceColumn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceColumn").build()).build();

    private static final SdkField<String> TARGET_MULTI_MEASURE_ATTRIBUTE_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TargetMultiMeasureAttributeName")
            .getter(getter(MultiMeasureAttributeMapping::targetMultiMeasureAttributeName))
            .setter(setter(Builder::targetMultiMeasureAttributeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetMultiMeasureAttributeName")
                    .build()).build();

    private static final SdkField<String> MEASURE_VALUE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MeasureValueType").getter(getter(MultiMeasureAttributeMapping::measureValueTypeAsString))
            .setter(setter(Builder::measureValueType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MeasureValueType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_COLUMN_FIELD,
            TARGET_MULTI_MEASURE_ATTRIBUTE_NAME_FIELD, MEASURE_VALUE_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String sourceColumn;

    private final String targetMultiMeasureAttributeName;

    private final String measureValueType;

    private MultiMeasureAttributeMapping(BuilderImpl builder) {
        this.sourceColumn = builder.sourceColumn;
        this.targetMultiMeasureAttributeName = builder.targetMultiMeasureAttributeName;
        this.measureValueType = builder.measureValueType;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final String sourceColumn() {
        return sourceColumn;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final String targetMultiMeasureAttributeName() {
        return targetMultiMeasureAttributeName;
    }

    /**
     * <p/>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #measureValueType}
     * will return {@link ScalarMeasureValueType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #measureValueTypeAsString}.
     * </p>
     * 
     * @return
     * @see ScalarMeasureValueType
     */
    public final ScalarMeasureValueType measureValueType() {
        return ScalarMeasureValueType.fromValue(measureValueType);
    }

    /**
     * <p/>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #measureValueType}
     * will return {@link ScalarMeasureValueType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #measureValueTypeAsString}.
     * </p>
     * 
     * @return
     * @see ScalarMeasureValueType
     */
    public final String measureValueTypeAsString() {
        return measureValueType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourceColumn());
        hashCode = 31 * hashCode + Objects.hashCode(targetMultiMeasureAttributeName());
        hashCode = 31 * hashCode + Objects.hashCode(measureValueTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MultiMeasureAttributeMapping)) {
            return false;
        }
        MultiMeasureAttributeMapping other = (MultiMeasureAttributeMapping) obj;
        return Objects.equals(sourceColumn(), other.sourceColumn())
                && Objects.equals(targetMultiMeasureAttributeName(), other.targetMultiMeasureAttributeName())
                && Objects.equals(measureValueTypeAsString(), other.measureValueTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MultiMeasureAttributeMapping").add("SourceColumn", sourceColumn())
                .add("TargetMultiMeasureAttributeName", targetMultiMeasureAttributeName())
                .add("MeasureValueType", measureValueTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceColumn":
            return Optional.ofNullable(clazz.cast(sourceColumn()));
        case "TargetMultiMeasureAttributeName":
            return Optional.ofNullable(clazz.cast(targetMultiMeasureAttributeName()));
        case "MeasureValueType":
            return Optional.ofNullable(clazz.cast(measureValueTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SourceColumn", SOURCE_COLUMN_FIELD);
        map.put("TargetMultiMeasureAttributeName", TARGET_MULTI_MEASURE_ATTRIBUTE_NAME_FIELD);
        map.put("MeasureValueType", MEASURE_VALUE_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MultiMeasureAttributeMapping, T> g) {
        return obj -> g.apply((MultiMeasureAttributeMapping) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MultiMeasureAttributeMapping> {
        /**
         * <p/>
         * 
         * @param sourceColumn
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceColumn(String sourceColumn);

        /**
         * <p/>
         * 
         * @param targetMultiMeasureAttributeName
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetMultiMeasureAttributeName(String targetMultiMeasureAttributeName);

        /**
         * <p/>
         * 
         * @param measureValueType
         * @see ScalarMeasureValueType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScalarMeasureValueType
         */
        Builder measureValueType(String measureValueType);

        /**
         * <p/>
         * 
         * @param measureValueType
         * @see ScalarMeasureValueType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScalarMeasureValueType
         */
        Builder measureValueType(ScalarMeasureValueType measureValueType);
    }

    static final class BuilderImpl implements Builder {
        private String sourceColumn;

        private String targetMultiMeasureAttributeName;

        private String measureValueType;

        private BuilderImpl() {
        }

        private BuilderImpl(MultiMeasureAttributeMapping model) {
            sourceColumn(model.sourceColumn);
            targetMultiMeasureAttributeName(model.targetMultiMeasureAttributeName);
            measureValueType(model.measureValueType);
        }

        public final String getSourceColumn() {
            return sourceColumn;
        }

        public final void setSourceColumn(String sourceColumn) {
            this.sourceColumn = sourceColumn;
        }

        @Override
        public final Builder sourceColumn(String sourceColumn) {
            this.sourceColumn = sourceColumn;
            return this;
        }

        public final String getTargetMultiMeasureAttributeName() {
            return targetMultiMeasureAttributeName;
        }

        public final void setTargetMultiMeasureAttributeName(String targetMultiMeasureAttributeName) {
            this.targetMultiMeasureAttributeName = targetMultiMeasureAttributeName;
        }

        @Override
        public final Builder targetMultiMeasureAttributeName(String targetMultiMeasureAttributeName) {
            this.targetMultiMeasureAttributeName = targetMultiMeasureAttributeName;
            return this;
        }

        public final String getMeasureValueType() {
            return measureValueType;
        }

        public final void setMeasureValueType(String measureValueType) {
            this.measureValueType = measureValueType;
        }

        @Override
        public final Builder measureValueType(String measureValueType) {
            this.measureValueType = measureValueType;
            return this;
        }

        @Override
        public final Builder measureValueType(ScalarMeasureValueType measureValueType) {
            this.measureValueType(measureValueType == null ? null : measureValueType.toString());
            return this;
        }

        @Override
        public MultiMeasureAttributeMapping build() {
            return new MultiMeasureAttributeMapping(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
