/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.tnb;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.tnb.DefaultTnbBaseClientBuilder;
import software.amazon.awssdk.services.tnb.DefaultTnbClient;
import software.amazon.awssdk.services.tnb.TnbClient;
import software.amazon.awssdk.services.tnb.TnbClientBuilder;
import software.amazon.awssdk.services.tnb.TnbServiceClientConfiguration;
import software.amazon.awssdk.services.tnb.endpoints.TnbEndpointProvider;

@SdkInternalApi
final class DefaultTnbClientBuilder
extends DefaultTnbBaseClientBuilder<TnbClientBuilder, TnbClient>
implements TnbClientBuilder {
    DefaultTnbClientBuilder() {
    }

    @Override
    public DefaultTnbClientBuilder endpointProvider(TnbEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final TnbClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultTnbClientBuilder.validateClientOptions(clientConfiguration);
        TnbServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultTnbClient client = new DefaultTnbClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private TnbServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return TnbServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

