/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.tnb.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.tnb.TnbClient;
import software.amazon.awssdk.services.tnb.model.ListSolNetworkOperationsInfo;
import software.amazon.awssdk.services.tnb.model.ListSolNetworkOperationsRequest;
import software.amazon.awssdk.services.tnb.model.ListSolNetworkOperationsResponse;

public class ListSolNetworkOperationsIterable
implements SdkIterable<ListSolNetworkOperationsResponse> {
    private final TnbClient client;
    private final ListSolNetworkOperationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSolNetworkOperationsIterable(TnbClient client, ListSolNetworkOperationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListSolNetworkOperationsResponseFetcher();
    }

    public Iterator<ListSolNetworkOperationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ListSolNetworkOperationsInfo> networkOperations() {
        Function<ListSolNetworkOperationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.networkOperations() != null) {
                return response.networkOperations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListSolNetworkOperationsResponseFetcher
    implements SyncPageFetcher<ListSolNetworkOperationsResponse> {
        private ListSolNetworkOperationsResponseFetcher() {
        }

        public boolean hasNextPage(ListSolNetworkOperationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSolNetworkOperationsResponse nextPage(ListSolNetworkOperationsResponse previousPage) {
            if (previousPage == null) {
                return ListSolNetworkOperationsIterable.this.client.listSolNetworkOperations(ListSolNetworkOperationsIterable.this.firstRequest);
            }
            return ListSolNetworkOperationsIterable.this.client.listSolNetworkOperations((ListSolNetworkOperationsRequest)((Object)ListSolNetworkOperationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

