/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.tnb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.tnb.model.TagMapCopier;
import software.amazon.awssdk.services.tnb.model.TnbResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateSolNetworkInstanceResponse
extends TnbResponse
implements ToCopyableBuilder<Builder, CreateSolNetworkInstanceResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(CreateSolNetworkInstanceResponse.getter(CreateSolNetworkInstanceResponse::arn)).setter(CreateSolNetworkInstanceResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(CreateSolNetworkInstanceResponse.getter(CreateSolNetworkInstanceResponse::id)).setter(CreateSolNetworkInstanceResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> NS_INSTANCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nsInstanceName").getter(CreateSolNetworkInstanceResponse.getter(CreateSolNetworkInstanceResponse::nsInstanceName)).setter(CreateSolNetworkInstanceResponse.setter(Builder::nsInstanceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nsInstanceName").build()}).build();
    private static final SdkField<String> NSD_INFO_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nsdInfoId").getter(CreateSolNetworkInstanceResponse.getter(CreateSolNetworkInstanceResponse::nsdInfoId)).setter(CreateSolNetworkInstanceResponse.setter(Builder::nsdInfoId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nsdInfoId").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateSolNetworkInstanceResponse.getter(CreateSolNetworkInstanceResponse::tags)).setter(CreateSolNetworkInstanceResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ID_FIELD, NS_INSTANCE_NAME_FIELD, NSD_INFO_ID_FIELD, TAGS_FIELD));
    private final String arn;
    private final String id;
    private final String nsInstanceName;
    private final String nsdInfoId;
    private final Map<String, String> tags;

    private CreateSolNetworkInstanceResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.id = builder.id;
        this.nsInstanceName = builder.nsInstanceName;
        this.nsdInfoId = builder.nsdInfoId;
        this.tags = builder.tags;
    }

    public final String arn() {
        return this.arn;
    }

    public final String id() {
        return this.id;
    }

    public final String nsInstanceName() {
        return this.nsInstanceName;
    }

    public final String nsdInfoId() {
        return this.nsdInfoId;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.nsInstanceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.nsdInfoId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSolNetworkInstanceResponse)) {
            return false;
        }
        CreateSolNetworkInstanceResponse other = (CreateSolNetworkInstanceResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.nsInstanceName(), other.nsInstanceName()) && Objects.equals(this.nsdInfoId(), other.nsdInfoId()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateSolNetworkInstanceResponse").add("Arn", (Object)this.arn()).add("Id", (Object)this.id()).add("NsInstanceName", (Object)this.nsInstanceName()).add("NsdInfoId", (Object)this.nsdInfoId()).add("Tags", (Object)(this.tags() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "nsInstanceName": {
                return Optional.ofNullable(clazz.cast(this.nsInstanceName()));
            }
            case "nsdInfoId": {
                return Optional.ofNullable(clazz.cast(this.nsdInfoId()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateSolNetworkInstanceResponse, T> g) {
        return obj -> g.apply((CreateSolNetworkInstanceResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TnbResponse.BuilderImpl
    implements Builder {
        private String arn;
        private String id;
        private String nsInstanceName;
        private String nsdInfoId;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSolNetworkInstanceResponse model) {
            super(model);
            this.arn(model.arn);
            this.id(model.id);
            this.nsInstanceName(model.nsInstanceName);
            this.nsdInfoId(model.nsdInfoId);
            this.tags(model.tags);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getNsInstanceName() {
            return this.nsInstanceName;
        }

        public final void setNsInstanceName(String nsInstanceName) {
            this.nsInstanceName = nsInstanceName;
        }

        @Override
        public final Builder nsInstanceName(String nsInstanceName) {
            this.nsInstanceName = nsInstanceName;
            return this;
        }

        public final String getNsdInfoId() {
            return this.nsdInfoId;
        }

        public final void setNsdInfoId(String nsdInfoId) {
            this.nsdInfoId = nsdInfoId;
        }

        @Override
        public final Builder nsdInfoId(String nsdInfoId) {
            this.nsdInfoId = nsdInfoId;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public CreateSolNetworkInstanceResponse build() {
            return new CreateSolNetworkInstanceResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends TnbResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateSolNetworkInstanceResponse> {
        public Builder arn(String var1);

        public Builder id(String var1);

        public Builder nsInstanceName(String var1);

        public Builder nsdInfoId(String var1);

        public Builder tags(Map<String, String> var1);
    }
}

