/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.tnb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.tnb.model.ListSolNetworkInstanceInfo;
import software.amazon.awssdk.services.tnb.model.ListSolNetworkInstanceResourcesCopier;
import software.amazon.awssdk.services.tnb.model.TnbResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSolNetworkInstancesResponse
extends TnbResponse
implements ToCopyableBuilder<Builder, ListSolNetworkInstancesResponse> {
    private static final SdkField<List<ListSolNetworkInstanceInfo>> NETWORK_INSTANCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("networkInstances").getter(ListSolNetworkInstancesResponse.getter(ListSolNetworkInstancesResponse::networkInstances)).setter(ListSolNetworkInstancesResponse.setter(Builder::networkInstances)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkInstances").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ListSolNetworkInstanceInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListSolNetworkInstancesResponse.getter(ListSolNetworkInstancesResponse::nextToken)).setter(ListSolNetworkInstancesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_INSTANCES_FIELD, NEXT_TOKEN_FIELD));
    private final List<ListSolNetworkInstanceInfo> networkInstances;
    private final String nextToken;

    private ListSolNetworkInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.networkInstances = builder.networkInstances;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasNetworkInstances() {
        return this.networkInstances != null && !(this.networkInstances instanceof SdkAutoConstructList);
    }

    public final List<ListSolNetworkInstanceInfo> networkInstances() {
        return this.networkInstances;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNetworkInstances() ? this.networkInstances() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSolNetworkInstancesResponse)) {
            return false;
        }
        ListSolNetworkInstancesResponse other = (ListSolNetworkInstancesResponse)((Object)obj);
        return this.hasNetworkInstances() == other.hasNetworkInstances() && Objects.equals(this.networkInstances(), other.networkInstances()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListSolNetworkInstancesResponse").add("NetworkInstances", this.hasNetworkInstances() ? this.networkInstances() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "networkInstances": {
                return Optional.ofNullable(clazz.cast(this.networkInstances()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSolNetworkInstancesResponse, T> g) {
        return obj -> g.apply((ListSolNetworkInstancesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TnbResponse.BuilderImpl
    implements Builder {
        private List<ListSolNetworkInstanceInfo> networkInstances = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSolNetworkInstancesResponse model) {
            super(model);
            this.networkInstances(model.networkInstances);
            this.nextToken(model.nextToken);
        }

        public final List<ListSolNetworkInstanceInfo.Builder> getNetworkInstances() {
            List<ListSolNetworkInstanceInfo.Builder> result = ListSolNetworkInstanceResourcesCopier.copyToBuilder(this.networkInstances);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNetworkInstances(Collection<ListSolNetworkInstanceInfo.BuilderImpl> networkInstances) {
            this.networkInstances = ListSolNetworkInstanceResourcesCopier.copyFromBuilder(networkInstances);
        }

        @Override
        public final Builder networkInstances(Collection<ListSolNetworkInstanceInfo> networkInstances) {
            this.networkInstances = ListSolNetworkInstanceResourcesCopier.copy(networkInstances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInstances(ListSolNetworkInstanceInfo ... networkInstances) {
            this.networkInstances(Arrays.asList(networkInstances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInstances(Consumer<ListSolNetworkInstanceInfo.Builder> ... networkInstances) {
            this.networkInstances(Stream.of(networkInstances).map(c -> (ListSolNetworkInstanceInfo)((ListSolNetworkInstanceInfo.Builder)ListSolNetworkInstanceInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListSolNetworkInstancesResponse build() {
            return new ListSolNetworkInstancesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends TnbResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSolNetworkInstancesResponse> {
        public Builder networkInstances(Collection<ListSolNetworkInstanceInfo> var1);

        public Builder networkInstances(ListSolNetworkInstanceInfo ... var1);

        public Builder networkInstances(Consumer<ListSolNetworkInstanceInfo.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

